<?php

class Ksiegowosc extends Controller {

	var $user_logged = false;
	
	function Ksiegowosc()
	{
		parent::Controller();
		$this->load->library('session');	
		$this->load->helper(array('form', 'url','html'));
		$this->load->model('baza','',TRUE);
		$this->load->model('baza_payments','',TRUE);
		
		$this->config->load('global_settings');	
		$this->global_settings = $this->config->item('global_settings');
		$this->user_logged = $this->_check_if_logged();
	}
	
	function _check_if_logged()
	{
		if($this->uri->segment('2')!='' and $this->uri->segment('2')!='index')
		{
			if(empty($this->session->userdata['ksiegowosc_id']) and empty($this->session->userdata['user_ksiegowosc_zalogowany']))
			{				
				$this->session->sess_destroy();
				redirect('/ksiegowosc', 'location');
			}
			else
			{			
				$data_login = $this->baza->superadmin_get_user_login($this->session->userdata['user_ksiegowosc_zalogowany'], $this->session->userdata['ksiegowosc_id']); 
											
				if(!empty($data_login))
				{	
					return true;						
				}
				else 
				{					
					$this->session->sess_destroy();
					redirect('/ksiegowosc', 'location');			
				}
			}
		}		
	}
	
	function index($ticket_id=null)
	{
		if(isset($this->session->userdata['user_ksiegowosc_zalogowany']) and isset($this->session->userdata['ksiegowosc_id']))
		{	
			$user_data = $this->baza->superadmin_get_user_login($this->session->userdata['user_ksiegowosc_zalogowany'], $this->session->userdata['ksiegowosc_id']);
			
			if($user_data==null)	
			{
				redirect('/ksiegowosc/logout','location');
			}
			else
			{
				redirect('/ksiegowosc/start','location');
			}
		}
		else
		{
			$this->load->library('validation');
			$this->validation->set_error_delimiters('<span style="color:red;">', '<br /></span>');
			$fields['login_form'] = 'login_form';
			$fields['pass'] = 'pass';
			$this->validation->set_fields($fields);
			
			$login_form = $this->validation->login_form;
			$pass_form = $this->validation->pass;
			$rules['login_form'] = "callback_login_form_check|required";
			$rules['pass'] = "callback_pass_check[$login_form]|required";
			$this->validation->set_rules($rules);
			
			//reset sesji
			$this->session->sess_destroy();
					
			if ($this->validation->run() == FALSE)
			{
				$this->load->view('/layout/home');
			}
			else
			{	
				$haslo_md5 = md5($pass_form);
				$uzyt = $this->baza->superadmin_user($login_form);
				$di = $uzyt[0]['id'];
				$this->session->set_userdata('user_ksiegowosc_zalogowany',$haslo_md5);
				$this->session->set_userdata('ksiegowosc_id',$di);
				
				if($ticket_id != null)
					redirect('/tickets/show/'.$ticket_id,'location');
				else
					redirect('/ksiegowosc/start','location');					
			}
		}
	}
	
	function login_form_check($str)
	{
		$user = $this->baza->superadmin_user($str); 
		
		if ($user==null or $str==null)
		{
				$this->validation->set_message('login_form_check', 'Błędny login');
				return FALSE;
		}
		else
		{
			if($user[0]['type']==3 and $user[0]['active']==1)
			{	
				return TRUE;
			}
			else
			{
				$this->validation->set_message('login_form_check', 'Błędny login');
				return FALSE;
			}
		}
	}

	function pass_check($pass,$login)
	{
		if($pass==null or $login==null)
		{
			$password = null; 	
		}
		else	
		{
			$haslo = md5($pass);
			$password = $this->baza->superadmin_check_user_pass($haslo, $login); 	
		}
		
		if ($password == null)
		{
			$this->validation->set_message('pass_check', 'Błędne hasło');
			return FALSE;
		}
		else
		{	
			if($password[0]['type']==3 and $password[0]['active']==1)
			{	
				return TRUE;
			}
			else
			{
				$this->validation->set_message('pass_check', 'Błędne hasło');
				return FALSE;
			}
		}
	}
	
	function start()
	{
		if(isset($this->session->userdata['user_ksiegowosc_zalogowany']) and isset($this->session->userdata['ksiegowosc_id']))
		{	
			$user_data = $this->baza->superadmin_get_user_login($this->session->userdata['user_ksiegowosc_zalogowany'], $this->session->userdata['ksiegowosc_id']);
			
			if($user_data!=null)	
			{
				$data['user']  = $user_data[0]['name'];
				$this->session->set_userdata('login',$user_data[0]['name']);				
				$this->load->view('/layout/start_page_ksiegowosc',$data);
				
			}
			else
			{
				redirect('/ksiegowosc/logout','refresh');	
			}		
		}
		else
		{
			redirect('/ksiegowosc/','refresh');		
		}
	}
	
	function clients($client_id = null)
	{				
		// zatwierdzenie faktury seo
		if(!empty($_POST['seo_id'])) $this->baza_payments->potwierdz_fakture_seo($_POST['seo_id']);
		//zatwierdzenie proformy sem i wygenerowanie faktury vat sem
		if(!empty($_POST['sem_pro_id']) and !empty($_POST['data']))	$this->baza_payments->potwierdz_fakture_proforma_sem($_POST['sem_pro_id'],$_POST['data']);
		
		$dane['clients'] = $this->baza->get_users();		
		$content['switch_client'] = $this->load->view('/ksiegowosc/switch_client',$dane,true);
		$content['client'] = $this->baza_payments->user_get_data($client_id);
		$content['faktury_seo'] = $this->baza_payments->get_factures($client_id);
		$content['faktury_sem'] = $this->baza_payments->get_factures_sem($client_id);
		$content['faktury_sem_proforma'] = $this->baza_payments->get_factures_sem_proforma($client_id);
		
		$data['content'] = $this->load->view('/ksiegowosc/clients',$content,true);		
		$data['user'] = $this->session->userdata('login');		
		$this->load->view('/layout/default',$data);	
	}
	
	//funckaja sprawdzająca date przelewu za proforme
	function check_data_proforma($data)
	{		
		$dane = $this->baza_payments->check_proforma_data($data);	
		
		if(!empty($dane['0']['data_wystawienia']))
			echo $dane['0']['data_wystawienia'];
		else
			echo 'ok';			
	}
		
	function afiliants($afiliant_id = null)
	{						
		//// zatwierdzenie faktury/rachunku sem 
		if(!empty($_POST['afilianci_rolziczenia_id'])) $this->baza_payments->potwierdz_wyplate_afilianta($_POST['afilianci_rolziczenia_id'],$_POST);
		//zatwierdzanie dokumentow firma
		if(!empty($_POST['dok_firma'])) $this->baza_payments->potwierdz_dok_firmowe_afilianta($_POST['dok_firma']);
		//zatwierdzanie dokumentow rachunek
		if(!empty($_POST['dok_rachunek'])) $this->baza_payments->potwierdz_dok_rachunek_afilianta($_POST['dok_rachunek']);
		
		$dane['afiliants'] = $this->baza_payments->get_afiliants();		
		$content['switch_afiliant'] = $this->load->view('/ksiegowosc/switch_afiliant',$dane,true);
		$content['afiliant'] = $this->baza_payments->afiliant_get_data($afiliant_id);
		$content['faktury'] = $this->baza_payments->afiliant_get_factures($afiliant_id);		
		$content['dokumenty'] = $this->baza_payments->get_factures_sem_proforma($afiliant_id);
		
		$data['content'] = $this->load->view('/ksiegowosc/afiliants',$content,true);		
		$data['user'] = $this->session->userdata('login');		
		$this->load->view('/layout/default',$data);	
	}
	
	function all_payments_seo()
	{
		// zatwierdzenie faktury seo
		if(!empty($_POST['seo_id'])) $this->baza_payments->potwierdz_fakture_seo($_POST['seo_id']);
		
		$content['faktury_seo'] = $this->baza_payments->get_all_seo_factures();
		$data['content'] = $this->load->view('/ksiegowosc/all_payments_seo',$content,true);		
		$data['user'] = $this->session->userdata('login');		
		$this->load->view('/layout/default',$data);	
	}
	
	function all_payments_sem()
	{		
		//zatwierdzenie proformy sem i wygenerowanie faktury vat sem
		if(!empty($_POST['sem_pro_id']) and !empty($_POST['data']))	$this->baza_payments->potwierdz_fakture_proforma_sem($_POST['sem_pro_id'],$_POST['data']);
		
		$content['faktury_sem'] = $this->baza_payments->get_all_factures_sem_proforma();
		$data['content'] = $this->load->view('/ksiegowosc/all_payments_sem',$content,true);		
		$data['user'] = $this->session->userdata('login');		
		$this->load->view('/layout/default',$data);	
	}
	
	function all_payments_afiliant()
	{
		
	}
	
	function logout()
	{
		$this->session->sess_destroy();
		redirect('/ksiegowosc','refresh');
	}
}

?>