<?php

class Charts extends Controller {

	public $colors;
	private $pzFactor = 1.5; //wspolczynnik ile wynosci wartosc poza zakresem wzgledem max y 
	
	function Charts()
	{
		parent::Controller();
		$this->load->helper('url');
		$this->load->library('session');	
		//$this->_check_domain_owner();
		//$this->colors = array('#6431ed','#f08080','#32cd32','#d7d700','#836fff', '#90ee90','#468bb4','#f4a460','#8b795e','#bebebe');
		$this->config->load('global_settings');	
		$this->global_settings = $this->config->item('global_settings');
		$this->colors   = $this->global_settings['chart_line_colors'];

	}
	
	function _check_domain_owner()
	{
		if(isset($_SERVER['HTTP_REFERER']))
		{	
			$link = explode('/', $_SERVER['HTTP_REFERER']);
			
			$this->load->model('baza','',TRUE);
			$domain = null;
			
			if ($link[3]=='admin')
			{	
				$domain = $this->baza->check_domain_owner($this->session->userdata['di'], $this->uri->segment(3));
			}
			elseif ($link[3]=='superadmin')
			{		
				$user_data = $this->baza->superadmin_get_user_login($this->session->userdata['user_sa_zalogowany'], $this->session->userdata['di_sa']);
				
				if($user_data[0]['name']=='admin')
				{
					$domain = 'admin';
				}
				else
				{
					$domain = $this->baza->superadmin_check_domain_owner($this->session->userdata['di_sa'], $this->uri->segment(3));
				}
			}
			
			if($domain!=null)
			{
				return true;
			}
			else
			{
				return redirect('/admin','location');
				//return true;	
			}
		}
		else 
		{
			return redirect('/admin','location');
			//return true;
		}
	}
	
	function index()
	{	
		redirect('/admin/start','refresh');
	}
	
	function postgtres()
	{
		
		$zapytanko2 = $this->bazapg->post();
		echo '<br /><br />!!!!!!!!!!!!!!!!!!!!!!!!!<br /><br /><br />';
		print_r($zapytanko2);
		
	}
	
	
	function insert_data_pg()
	{
		ini_set("memory_limit","356M");
		$uchwyt = fopen("http://admin.networds.mariusz.jrchosting.com/files/dump.sql", "r");
		
		$this->load->model('bazapg', '', 'pg');
		$i=0;
		
		while (!feof($uchwyt)) {
    		$buffer = fgets($uchwyt, 16096);
			$tab = explode(',',$buffer);
			
			$md = md5($tab['2'].$tab['3'].$tab['4']);
			$md = str_replace('a','1',$md);
			$md = str_replace('b','2',$md);
			$md = str_replace('c','3',$md);
			$md = str_replace('d','4',$md);
			$md = str_replace('e','5',$md);
			$md = str_replace('f','6',$md);
			$md = substr($md,0,15);
			
			$ile = count($tab);
		
			$data = str_replace('-','',$tab[($ile-1)]);
			$data = str_replace("'",'',$data);
				
			$insert_tmp = trim(substr($buffer,0,(strlen($buffer)-3)));
			
			
			
			$insert = $insert_tmp.", ".$md.", ".$data;
			
			
			$pos_nawias = strpos($insert, '(');
			$pos_przecinek = strpos($insert, ',');
			$ile_liter =  ($pos_przecinek - $pos_nawias);
			
			$xx = substr($insert, 0, ($pos_nawias + 1));
			$yy = substr($insert, ($pos_przecinek + 1), -1);
			
			
			//$insert = str_ireplace($xx,'default, ',$insert, 1);
			
			//echo $xx."<br /><br />";
			//echo $yy."<br /><br />";
			//echo $insert."<br /><br /><br />";
			
			$gotowe = $xx."default, ".$yy;
			
			//$i++;
			//if($i==20) break;
			
			
			$this->bazapg->wsadz($gotowe);
			
    	}
		
		fclose($uchwyt);
			
	}
	
	/*function dupa()
	{
		ini_set("memory_limit","356M");
		$this->load->model('bazapg', '', 'pg');
		
		$dane = $this->bazapg->get_data();
		
		foreach($dane as $dana)
		{
			$md = md5($dana['ip'].''.$dana['user_agent'].''.$dana['resolution']);
			$md = str_replace('a','1',$md);
			$md = str_replace('b','2',$md);
			$md = str_replace('c','3',$md);
			$md = str_replace('d','4',$md);
			$md = str_replace('e','5',$md);
			$md = str_replace('f','6',$md);
			$md = substr($md,0,15);

			$this->bazapg->update_wsadz($dana['id'],$md,str_replace('-','',$dana['data']));
			echo $dana['id'].",";
			
    	}	
	}*/
//--------------------------------------------------------------------------------------------------------------------------
	function getBarChart($elemy,$elemx,$ymax,$main_title="",$x_title="",$y_title="")
	{
		include 'files/php-ofc-library/open-flash-chart.php';
		$xvalues = $elemx;
		$yvalues = array();
				
				
		
		//$bar = new bar_filled( '#E2D66A', '#577261' );
		//$bar->set_values( array(9,8,7,6,5,4,3,2,1) );
		
		//OY
		
			$y_array_labels = $this->ArrStrToInt($elemy);
			/*
			$y = new y_axis();
			$y->set_range( 0, array(9,8,7,6,5,4,3,2,1), 1); 
			//echo ceil($ymax*$this->pzFactor)."<br/>";
			
			

			$y_labels = new y_axis_labels();
			$y_labels->set_labels(array(9,8,7,6,5,4,3,2,1));
			// visible labels steps:
			$y_labels->set_steps(1);
			$y->set_labels($y_labels);
			*/
			
			$y = new y_axis(); 
			$y->set_range( 0, $ymax, ($ymax*0.25) );
			
			$bar = new bar();
			$bar->set_values( array(9,8,7,6,5,4,3,2,1) );
					
		
		//OX
			$x_labels = new x_axis_labels();
			$x_labels->set_steps( 1 );
			$x_labels->set_vertical();
			$x_labels->set_colour( '#000000' );
			
			$newx = array();
			foreach($xvalues as $k=>$v)
			{
				if($k<7)
					$newx[] = $v;	
			}
			
			$x_labels->set_labels( $newx );
			$x = new x_axis();
			$x->set_steps(1);
			$x->set_labels( $x_labels );
							
		
		$chart = new open_flash_chart();
			//$title = new title($domain_name.' - wykres pozycji w google');
			$title = new title($main_title);
			$title->set_style( "{font-size: 12px; font-family: Verdana; font-weight: bold; color: #000000; text-align: center; margin-bottom:20px;}" );
		$chart->set_title($title);
		$bar = new bar_filled( '#E2D66A', '#577261' );
		$bar->set_values($this->ArrStrToInt($elemy));
		
		$y_legend = new y_legend($y_title);
		$y_legend->set_style( '{font-size: 12px; color: #000000;}' );
		$chart->set_y_legend( $y_legend );		

		$x_legend = new x_legend($x_title);
		$x_legend->set_style('{font-size: 12px; color: #000000;}');
		$chart->set_x_legend($x_legend);
				
		$chart->set_y_axis( $y );
		$chart->set_x_axis( $x );
		
		$chart->add_element( $bar );
		$chart->set_bg_colour( '#FFFFFF' );
		
		return $chart;		
		
	}
//--------------------------------------------------------------------------------------------------------------------------
	function getLineChart($elemy,$elemx,$ymax,$main_title="",$x_title="",$y_title="")
	{
		
				include 'files/php-ofc-library/open-flash-chart.php';
		
				$xvalues = array();
				$yvalues = array();
				$pz 	= $this->getPZ($ymax);
				

				
				foreach ($elemy as $k => $v)
				{
						foreach ($v as $kk => $vv)
						{
					    	$g->xValue[$k][] = $elemx[$k][$kk];
							$xvalues[] = $elemx[$k][$kk];
							$yvalues[] = $vv;
						}
				}
									

				$i=0;
				$lines = array();
				
				$chart = new open_flash_chart();
					
					
					for($i=0;$i<count($elemy);$i++)
					{
						$default_dot = new solid_dot();
						$default_dot->size(4)->halo_size(1)->colour($this->colors[$i]);
						
						$line_dot = new line();
						//$line_dot->line_style( new line_style(0, 1) );
						
						$line_dot->set_default_dot_style($default_dot);
						$line_dot->set_width( 2 );
						$line_dot->set_colour( $this->colors[$i] );
						$line_dot->set_values($this->ArrToInt($elemy[$i],ceil($ymax)) );
						$lines[] = $line_dot;												
					}
					
					$y = new y_axis();
					$y->set_range( 0, ceil($ymax*$this->pzFactor), 2); 
					
					$y_array_labels = array();
					for($i=0;$i<=$pz;$i++)
					{
						if(($i) == $pz)
							$y_array_labels[] = 'PZ';
						else
							$y_array_labels[] = (string)$i;
													
					}
					$y_labels = new y_axis_labels();
					$y_labels->set_labels($y_array_labels);
					// visible labels steps:
					$y_labels->set_steps(2);
					$y->set_labels($y_labels);
										
					
					
					$x_labels = new x_axis_labels();
					$x_labels->set_steps( 1 );
					$x_labels->set_vertical();
					$x_labels->set_colour( '#000000' );
					
					$newx = array();
					foreach($xvalues as $k=>$v)
					{
						if($k<7)
							$newx[] = $v;	
					}
					
					$x_labels->set_labels( $newx );
					

					$x = new x_axis();
					$x->set_steps(1);
					$x->set_labels( $x_labels );
					
					$chart = new open_flash_chart();
						//$domain_name.' - wykres pozycji w google'
						//$chart_main_title = $domain_name.' - wykres pozycji w google';
						
						$title = new title($main_title);
						$title->set_style( "{font-size: 12px; font-family: Verdana; font-weight: bold; color: #000000; text-align: center; margin-bottom:20px;}" );
					$chart->set_title($title);
					$chart->set_y_axis( $y );
					$chart->set_x_axis( $x );
					
					//'Pozycja w google, im mniejsza tym lepiej'
					$chart_y_title = 'Pozycja w google, im mniejsza tym lepiej'; 
					
					$y_legend = new y_legend($y_title);
					$y_legend->set_style('{font-size: 12px; color: #000000;}');
					$chart->set_y_legend($y_legend);
					
					$x_legend = new x_legend($x_title);
					$x_legend->set_style('{font-size: 12px; color: #000000;}');
					$chart->set_x_legend($x_legend);					
					
					for($i=0;$i<count($elemy);$i++)
					{
						$chart->add_element( $lines[$i] );
					}
					
					$chart->set_bg_colour('#FFFFFF');
					
					//SETUP tootip
					$tooltip = new tooltip();
					$tooltip->set_hover();
					$tooltip->set_stroke( 4 );
					
					$tooltip->set_colour( "#000000" );
					$tooltip->set_background_colour( "#ffffff" ); 
					$chart->set_tooltip( $tooltip );
					
			return $chart;		
		
	}
//--------------------------------------------------------------------------------------------------------------------------		
	function chart_line($id=null,$keywordId=null)
	{
		if($id!=null)
		{
			include_once('files/charts.class.php');
			
				$this->load->model('baza','',TRUE);
				$keywords = $this->baza->get_keyword_position($id);
				$domain_name = $this->baza->get_doamin_name($id);
				$lines = count($keywords);
				
				$day = date('d');
				$month = date('m');
				$year = date('Y');
				$elemx_tmp = Array();
			
				for($i=6;$i>=0;$i--)
				{
					$start_tmp = mktime (0,0,0,$month,($day-$i),$year);
					$start = strftime("20%y-%m-%d", $start_tmp);	
					$elemx_tmp[] = $start;
				}
				//$elemx_tmp = array_reverse($elemx_tmp);
					
			//	print_r($elemx_tmp);
				$i=0;
				$elemx = array();
				$elemy = array();
				
				//print_r($keywords);
				
				
				foreach($keywords as $keyword)
				{		
					foreach($elemx_tmp as $key => $value)
					{				
						$dane = $this->baza->get_keyword_position_data_daily($id, $keyword['keyword_id'],$value);
					//print_r($dane);
						$elemx[$i][$key] = $value;
						@$elemy[$i][$key] = $dane[0]['position'];	
					} 
					$i++;
				}
					
				
				/*
				foreach($keywords as $keyword)
				{
					$dane = $this->baza->get_keyword_position_data($id, $keyword['keyword_id']);
					//print_r($dane);
					$dane = array_reverse($dane);
					
					foreach($dane as $d)
					{
						$elemx[$i][] = $d['date'];
						$elemy[$i][] = $d['position'];
					}
					$i++;
				}*/
														
				// #FINDING THE MAX NUMBER OF X ELEMENTS
				$xcount = 0;
				foreach ($elemx as $v)
					$xcount = max($xcount, count($v));
												
				// #BIGGEST Y ELEMENT
				$ymax = 0;
				foreach ($elemy as $v)
					$ymax = max($ymax,ceil(max($v)));
				
				// #CALCULATING THE DIFFERENCE
				//$dif = array_sum($elemy[0]) - array_sum($elemy[1]) - array_sum($elemy[2]);
				
				$data['domain_name'] = $domain_name[0]['domain'];
				$data['lines'] = $lines;
				$data['elemx'] = $elemx;				
				$data['elemy'] = $elemy;
				$data['ymax'] = $ymax;				
				$data['xcount'] = $xcount;
				$data['dif'] = 0;				
				$this->load->view('charts/chart',$data);
			}
	}
	//------------------------------------------------------------------------------------------------------------------
	//zwroc wartosc poza zakresem
	function getPZ($max)
	{
		$max = ceil($max*$this->pzFactor);
		if($max%2 != 0)
		{
			$max++;				
		}
		return $max;
	}
	//------------------------------------------------------------------------------------------------------------------
	function ArrToInt($arr,$max=0)
	{
		for($z=0;$z<count($arr);$z++)
		{
			if($arr[$z] != null)
				$arr[$z] = (int)$arr[$z];
			if($arr[$z] == 0)
			{
				$arr[$z] = $this->getPZ($max);
			}
		}	
		return $arr;	
	}		
	//------------------------------------------------------------------------------------------------------------------
	//zamiana tablicy stringow na tablice intow
	function ArrStrToInt($arr)
	{
		for($z=0;$z<count($arr);$z++)
		{
			$arr[$z] = (int)$arr[$z];
		}	
		return $arr;		
	}
	//------------------------------------------------------------------------------------------------------------------
	function flash_chart_line($id=null,$year = null, $month = null, $day = null)
	{
		if($id!=null)
		{
			include_once('files/charts.class.php');
			
				$this->load->model('baza','',TRUE);
				$keywords = $this->baza->get_keyword_position($id);
				$domain_name = $this->baza->get_doamin_name($id);
				$lines = count($keywords);
				
				$day    = (empty($day) ? date('d'):$day);
				$month  = (empty($month) ? date('m'):$month);
				$year   = (empty($year) ? date('Y'):$year);


				$elemx_tmp = Array();
			
				for($i=6;$i>=0;$i--)
				{
					$start_tmp = mktime (0,0,0,$month,($day-$i),$year);
					$start = strftime("20%y-%m-%d", $start_tmp);	
					$elemx_tmp[] = $start;
				}
				//$elemx_tmp = array_reverse($elemx_tmp);
					
				$elemx = array();
				$elemy = array();
				
				//print_r($keywords);
				
				$i=0;
				
				foreach($keywords as $keyword)
				{		
					foreach($elemx_tmp as $key => $value)
					{				
						$dane = $this->baza->get_keyword_position_data_daily($id, $keyword['keyword_id'],$value);
					//print_r($dane);
						$elemx[$i][$key] = $value;
						@$elemy[$i][$key] = $dane[0]['position'];	
					} 
					$i++;
				}
													
				// #FINDING THE MAX NUMBER OF X ELEMENTS
				$xcount = 0;
				foreach ($elemx as $v)
					$xcount = max($xcount, count($v));
												
				// #BIGGEST Y ELEMENT
				$ymax = 0;
				foreach ($elemy as $v)
					$ymax = max($ymax,ceil(max($v)));
				

				if(isset($domain_name[0]['domain']))
					$data['domain_name'] = $domain_name[0]['domain'];
				$data['lines'] = $lines;
				$data['elemx'] = $elemx;				
				$data['elemy'] = $elemy;
				$data['ymax'] = $ymax;				
				$data['xcount'] = $xcount;
				$data['dif'] = 0;	
				
				$main_title = $data['domain_name']." - wykres pozycji w google";
				$x_title    = "";
				$y_title    = "pozycja w google (im mniejsza tym lepiej)";
											
				$data['chart'] = $this->getLineChart($elemy,$elemx,$ymax,$main_title,$x_title,$y_title);			
				$this->load->view('charts/chart_flash',$data);			
			}
	}	

	function chart_line_weekly($id=null)
	{
		if($id!=null)
		{
			include_once('files/charts.class.php');
		
			$this->load->model('baza','',TRUE);
			$keywords = $this->baza->get_keyword_position($id);
			$domain_name = $this->baza->get_doamin_name($id);
			$lines = count($keywords);
			
			$elemx = array();
			$elemy = array();
			$elem_tmp = array();
			$day = date('d');
			$month = date('m');
			$year = date('Y');
			$week = date('W',mktime(0,0,0,$month,$day,$year));	
			
			$elemx_tmp = Array();
			
			for($i=7;$i>0;$i--)
			{
				if($week<1)
				{
					$year = $year-1; 
					$week = strftime("%W",strtotime("12/31/".$year)) - 1;
				}
					$first = $this->getFirstDayOfWeek($year, ($week--));		
				
				$day = substr($first,3,2);
				$month = substr($first,0,2);
				$w = date('w',mktime(0,0,0,$month,$day,$year));
				$start_date = mktime(0, 0, 0, $month, $day-$w+1, $year); 
				$end_date = mktime(0, 0, 0, $month, $day-$w+8 , $year); 
		
				$go =  strftime("20%y-%m-%d",$start_date);
				$end = strftime("20%y-%m-%d",$end_date);			
				
				$elemx_tmp[] = $go.' | '.$end;
			}
			$elemx_tmp = array_reverse($elemx_tmp);
					
			$i = 0;
			
			
			foreach($keywords as $keyword)
			{		
				foreach($elemx_tmp as $key => $value)
				{
					 
				 	$go = substr($value, 0, 10);
				 	$end = substr($value, 13, 10);
					//echo $go.'----'.$end;
				
					$dane = $this->baza->get_keyword_position_data_weekly($id, $keyword['keyword_id'],$go, $end);
				
					$dane = array_reverse($dane);
					//print_r($dane);
					$elemx[$i][$key] = $value;
					$elemy[$i][$key] = round($dane[0]['position']);	
				} 
				$i++;
			}
			
			//print_r($elemx);
			//print_r($elemy);
													
			// #FINDING THE MAX NUMBER OF X ELEMENTS
			$xcount = 0;
			foreach ($elemx as $v)
				$xcount = max($xcount, count($v));
											
			// #BIGGEST Y ELEMENT
			$ymax = 0;
			foreach ($elemy as $v)
				$ymax = max($ymax,ceil(max($v)));
			
			// #CALCULATING THE DIFFERENCE
			//$dif = array_sum($elemy[0]) - array_sum($elemy[1]) - array_sum($elemy[2]);
			
			$data['domain_name'] = $domain_name[0]['domain'];
			$data['lines'] = $lines;
			$data['elemx'] = $elemx;				
			$data['elemy'] = $elemy;
			$data['ymax'] = $ymax;				
			$data['xcount'] = $xcount;
			$data['dif'] = 0;				
			$this->load->view('charts/chart',$data);
			}
}

	function flash_chart_line_weekly($id=null,$week = null, $year = null)
	{
		if($id!=null)
		{
			include_once('files/charts.class.php');
		
			$this->load->model('baza','',TRUE);
			$keywords = $this->baza->get_keyword_position($id);
			$domain_name = $this->baza->get_doamin_name($id);
			$lines = count($keywords);
			
			$elemx = array();
			$elemy = array();
			$elem_tmp = array();

			$day = date('d');
			$month = date('m');
			$year = (empty($year) ? date('Y') : $year);
			$week = (empty($week) ? date('W',mktime(0,0,0,$month,$day,$year)) : $week);
			
			$elemx_tmp = Array();
			
			for($i=7;$i>0;$i--)
			{
				if($week<1)
				{
					$year = $year-1; 
					$week = strftime("%W",strtotime("12/31/".$year)) - 1;
				}
					$first = $this->getFirstDayOfWeek($year, ($week--));		
				
				$day = substr($first,3,2);
				$month = substr($first,0,2);
				$w = date('w',mktime(0,0,0,$month,$day,$year));
				$start_date = mktime(0, 0, 0, $month, $day-$w+1, $year); 
				$end_date = mktime(0, 0, 0, $month, $day-$w+8 , $year); 
		
				$go =  strftime("20%y-%m-%d",$start_date);
				$end = strftime("20%y-%m-%d",$end_date);			
				
				$elemx_tmp[] = $go.' | '.$end;
			}
			$elemx_tmp = array_reverse($elemx_tmp);
					
			$i = 0;
			
			
			foreach($keywords as $keyword)
			{		
				foreach($elemx_tmp as $key => $value)
				{
					 
				 	$go = substr($value, 0, 10);
				 	$end = substr($value, 13, 10);
					//echo $go.'----'.$end;
				
					$dane = $this->baza->get_keyword_position_data_weekly($id, $keyword['keyword_id'],$go, $end);
				
					$dane = array_reverse($dane);
					//print_r($dane);
					$elemx[$i][$key] = $value;
					$elemy[$i][$key] = round($dane[0]['position']);	
				} 
				$i++;
			}
			
			//print_r($elemx);
			//print_r($elemy);
													
			// #FINDING THE MAX NUMBER OF X ELEMENTS
			$xcount = 0;
			foreach ($elemx as $v)
				$xcount = max($xcount, count($v));
											
			// #BIGGEST Y ELEMENT
			$ymax = 0;
			foreach ($elemy as $v)
				$ymax = max($ymax,ceil(max($v)));
			
			// #CALCULATING THE DIFFERENCE
			//$dif = array_sum($elemy[0]) - array_sum($elemy[1]) - array_sum($elemy[2]);
			
			$data['domain_name'] = $domain_name[0]['domain'];
			$data['lines'] = $lines;
			$data['elemx'] = $elemx;				
			$data['elemy'] = $elemy;
			$data['ymax'] = $ymax;				
			$data['xcount'] = $xcount;
			$data['dif'] = 0;				
			
			
			$main_title = $data['domain_name']." - wykres pozycji w google";
			$x_title    = "";
			$y_title    = "pozycja w google (im mniejsza tym lepiej)";
			
			
			$data['chart'] = $this->getLineChart($elemy,$elemx,$ymax,$main_title,$x_title,$y_title);			
			$this->load->view('charts/chart_flash',$data);				
			}
		}


function chart_line_monthly($id=null)
	{
		if($id!=null)
		{
			include_once('files/charts.class.php');
		
			$this->load->model('baza','',TRUE);
			$keywords = $this->baza->get_keyword_position($id);
			$domain_name = $this->baza->get_doamin_name($id);
			$lines = count($keywords);
			
			$elemx = array();
			$elemy = array();
			$elem_tmp = array();
			$day = date('d');
			$month = date('m');
			$year = date('Y');
			$week = date('W',mktime(0,0,0,$month,$day,$year));	
			
			$elemx_tmp = Array();
			
			for($i=6;$i>=0;$i--)
			{
				$start_date = mktime (0,0,0,($month-$i),$day,$year);
				$elemx_tmp[] = strftime("20%y-%m", $start_date);	
			}
					
			$i = 0;
			
			foreach($keywords as $keyword)
			{		
				foreach($elemx_tmp as $key => $value)
				{				
					$dane = $this->baza->get_keyword_position_data_monthly($id, $keyword['keyword_id'],$value);				
					//$dane = array_reverse($dane);

					$elemx[$i][$key] = $value;
					$elemy[$i][$key] = round($dane[0]['position']);	
				} 
				$i++;
			}
			
			//print_r($elemx);
			//print_r($elemy);
													
			// #FINDING THE MAX NUMBER OF X ELEMENTS
			$xcount = 0;
			foreach ($elemx as $v)
				$xcount = max($xcount, count($v));
											
			// #BIGGEST Y ELEMENT
			$ymax = 0;
			foreach ($elemy as $v)
				$ymax = max($ymax,ceil(max($v)));
			
			// #CALCULATING THE DIFFERENCE
			//$dif = array_sum($elemy[0]) - array_sum($elemy[1]) - array_sum($elemy[2]);
			
			$data['domain_name'] = $domain_name[0]['domain'];
			$data['lines'] = $lines;
			$data['elemx'] = $elemx;				
			$data['elemy'] = $elemy;
			$data['ymax'] = $ymax;				
			$data['xcount'] = $xcount;
			$data['dif'] = 0;				
			$this->load->view('charts/chart',$data);
			}
}		

function flash_chart_line_monthly($id=null,$month = null, $year = null)
	{
		if($id!=null)
		{
			include_once('files/charts.class.php');
		
			$this->load->model('baza','',TRUE);
			$keywords = $this->baza->get_keyword_position($id);
			$domain_name = $this->baza->get_doamin_name($id);
			$lines = count($keywords);
			
			$elemx = array();
			$elemy = array();
			$elem_tmp = array();
			$day = date('d');
			$month = (empty($month) ? date('m') : $month);
			$year = (empty($year) ? date('Y') : $year);
			$week = date('W',mktime(0,0,0,$month,$day,$year));	
			
			$elemx_tmp = Array();
			
			for($i=6;$i>=0;$i--)
			{
				$start_date = mktime (0,0,0,($month-$i),$day,$year);
				$elemx_tmp[] = strftime("20%y-%m", $start_date);	
			}
					
			$i = 0;
			
			foreach($keywords as $keyword)
			{		
				foreach($elemx_tmp as $key => $value)
				{				
					$dane = $this->baza->get_keyword_position_data_monthly($id, $keyword['keyword_id'],$value);				
					//$dane = array_reverse($dane);

					$elemx[$i][$key] = $value;
					$elemy[$i][$key] = round($dane[0]['position']);	
				} 
				$i++;
			}
			
			//print_r($elemx);
			//print_r($elemy);
													
			// #FINDING THE MAX NUMBER OF X ELEMENTS
			$xcount = 0;
			foreach ($elemx as $v)
				$xcount = max($xcount, count($v));
											
			// #BIGGEST Y ELEMENT
			$ymax = 0;
			foreach ($elemy as $v)
				$ymax = max($ymax,ceil(max($v)));
			
			// #CALCULATING THE DIFFERENCE
			//$dif = array_sum($elemy[0]) - array_sum($elemy[1]) - array_sum($elemy[2]);
			
			$data['domain_name'] = $domain_name[0]['domain'];
			$data['lines'] = $lines;
			$data['elemx'] = $elemx;				
			$data['elemy'] = $elemy;
			$data['ymax'] = $ymax;				
			$data['xcount'] = $xcount;
			$data['dif'] = 0;				
			//$this->load->view('charts/chart',$data);
			
			$main_title = $data['domain_name']." - wykres pozycji w google";
			$x_title    = "";
			$y_title    = "pozycja w google (im mniejsza tym lepiej)";
			
			$data['chart'] = $this->getLineChart($elemy,$elemx,$ymax,$main_title,$x_title,$y_title);			
			$this->load->view('charts/chart_flash',$data);
		
			
	}
}		

function chart_line_quartely($id=null)
	{
		if($id!=null)
		{
			include_once('files/charts.class.php');
		
			$this->load->model('baza','',TRUE);
			$keywords = $this->baza->get_keyword_position($id);
			$domain_name = $this->baza->get_doamin_name($id);
			$lines = count($keywords);
			
			$elemx = array();
			$elemy = array();
			$elem_tmp = array();
			$day = date('d');
			$month = date('m');
			$year = date('Y');
			$week = date('W',mktime(0,0,0,$month,$day,$year));	
			
			
			$q1 = ($year-1).'-04-01 | '.($year-1).'-06-30';
			$q2 = ($year-1).'-07-01 | '.($year-1).'-09-30';
			$q3 = ($year-1).'-10-01 | '.($year-1).'-12-31';
			$q4 = $year.'-01-01 | '.$year.'-03-31';
			$q5 = $year.'-04-01 | '.$year.'-06-30';
			$q6 = $year.'-07-01 | '.$year.'-09-30';
			$q7 = $year.'-10-01 | '.$year.'-12-31';
			$elemx_tmp = array($q1, $q2, $q3, $q4, $q5, $q6, $q7);
			
			//print_r($elemx_tmp);
					
			$i = 0;
			
			foreach($keywords as $keyword)
			{		
				foreach($elemx_tmp as $key => $value)
				{				
					$dane = $this->baza->get_keyword_position_data_quartely($id, $keyword['keyword_id'],substr($value,0,10),substr($value,13,10));				
					$elemx[$i][$key] = $value;
					$elemy[$i][$key] = round($dane[0]['position']);	
				} 
				$i++;
			}
			
			//print_r($elemx);
			//print_r($elemy);
													
			// #FINDING THE MAX NUMBER OF X ELEMENTS
			$xcount = 0;
			foreach ($elemx as $v)
				$xcount = max($xcount, count($v));
											
			// #BIGGEST Y ELEMENT
			$ymax = 0;
			foreach ($elemy as $v)
				$ymax = max($ymax,ceil(max($v)));
			
			// #CALCULATING THE DIFFERENCE
			//$dif = array_sum($elemy[0]) - array_sum($elemy[1]) - array_sum($elemy[2]);
			
			$data['domain_name'] = $domain_name[0]['domain'];
			$data['lines'] = $lines;
			$data['elemx'] = $elemx;				
			$data['elemy'] = $elemy;
			$data['ymax'] = $ymax;				
			$data['xcount'] = $xcount;
			$data['dif'] = 0;				
			$this->load->view('charts/chart',$data);
			}
}


function flash_chart_line_quartely($id=null)
	{
		if($id!=null)
		{
			include_once('files/charts.class.php');
		
			$this->load->model('baza','',TRUE);
			$keywords = $this->baza->get_keyword_position($id);
			$domain_name = $this->baza->get_doamin_name($id);
			$lines = count($keywords);
			
			$elemx = array();
			$elemy = array();
			$elem_tmp = array();
			$day = date('d');
			$month = date('m');
			$year = date('Y');
			$week = date('W',mktime(0,0,0,$month,$day,$year));	
			
			
			$q1 = ($year-1).'-04-01 | '.($year-1).'-06-30';
			$q2 = ($year-1).'-07-01 | '.($year-1).'-09-30';
			$q3 = ($year-1).'-10-01 | '.($year-1).'-12-31';
			$q4 = $year.'-01-01 | '.$year.'-03-31';
			$q5 = $year.'-04-01 | '.$year.'-06-30';
			$q6 = $year.'-07-01 | '.$year.'-09-30';
			$q7 = $year.'-10-01 | '.$year.'-12-31';
			$elemx_tmp = array($q1, $q2, $q3, $q4, $q5, $q6, $q7);
			
			//print_r($elemx_tmp);
					
			$i = 0;
			
			foreach($keywords as $keyword)
			{		
				foreach($elemx_tmp as $key => $value)
				{				
					$dane = $this->baza->get_keyword_position_data_quartely($id, $keyword['keyword_id'],substr($value,0,10),substr($value,13,10));				
					$elemx[$i][$key] = $value;
					$elemy[$i][$key] = round($dane[0]['position']);	
				} 
				$i++;
			}
			
			//print_r($elemx);
			//print_r($elemy);
													
			// #FINDING THE MAX NUMBER OF X ELEMENTS
			$xcount = 0;
			foreach ($elemx as $v)
				$xcount = max($xcount, count($v));
											
			// #BIGGEST Y ELEMENT
			$ymax = 0;
			foreach ($elemy as $v)
				$ymax = max($ymax,ceil(max($v)));
			
			// #CALCULATING THE DIFFERENCE
			//$dif = array_sum($elemy[0]) - array_sum($elemy[1]) - array_sum($elemy[2]);
			
			$data['domain_name'] = $domain_name[0]['domain'];
			$data['lines'] = $lines;
			$data['elemx'] = $elemx;				
			$data['elemy'] = $elemy;
			$data['ymax'] = $ymax;				
			$data['xcount'] = $xcount;
			$data['dif'] = 0;				
			//$this->load->view('charts/chart',$data);
			//----------------------------------------------------------
			//----------------------------------------------------------
			$main_title = $data['domain_name']." - wykres pozycji w google";
			$x_title 	= "";
			$y_title 	= "pozycja w google (im mniejsza tym lepiej)";
			
			$data['chart'] = $this->getLineChart($elemy,$elemx,$ymax,$main_title,$x_title,$y_title);			
			$this->load->view('charts/chart_flash',$data);				
		}
}

function chart_line_yearly($id=null)
	{
		if($id!=null)
		{
			include_once('files/charts.class.php');
		
			$this->load->model('baza','',TRUE);
			$keywords = $this->baza->get_keyword_position($id);
			$domain_name = $this->baza->get_doamin_name($id);
			$lines = count($keywords);
			
			$elemx = array();
			$elemy = array();
			$elem_tmp = array();
			$day = date('d');
			$month = date('m');
			$year = date('Y');
			$week = date('W',mktime(0,0,0,$month,$day,$year));	
			
			
			$elemx_tmp = Array();
			
			for($i=6;$i>=0;$i--)
			{
				$start_date = mktime (0,0,0,$month,$day,($year-$i));
				$elemx_tmp[] = strftime("20%y", $start_date);	
			}
			
			//print_r($elemx_tmp);
					
			$i = 0;
			
			foreach($keywords as $keyword)
			{		
				foreach($elemx_tmp as $key => $value)
				{				
					$dane = $this->baza->get_keyword_position_data_yearly($id, $keyword['keyword_id'],$value);				
					$elemx[$i][$key] = $value;
					$elemy[$i][$key] = round($dane[0]['position']);	
				} 
				$i++;
			}
			
			//print_r($elemx);
			//print_r($elemy);
													
			// #FINDING THE MAX NUMBER OF X ELEMENTS
			$xcount = 0;
			foreach ($elemx as $v)
				$xcount = max($xcount, count($v));
											
			// #BIGGEST Y ELEMENT
			$ymax = 0;
			foreach ($elemy as $v)
				$ymax = max($ymax,ceil(max($v)));
			
			// #CALCULATING THE DIFFERENCE
			//$dif = array_sum($elemy[0]) - array_sum($elemy[1]) - array_sum($elemy[2]);
			
			$data['domain_name'] = $domain_name[0]['domain'];
			$data['lines'] = $lines;
			$data['elemx'] = $elemx;				
			$data['elemy'] = $elemy;
			$data['ymax'] = $ymax;				
			$data['xcount'] = $xcount;
			$data['dif'] = 0;				
			$this->load->view('charts/chart',$data);
			}
}				
	
function flash_chart_line_yearly($id=null,$year=null)
	{
		if($id!=null)
		{
			include_once('files/charts.class.php');
		
			$this->load->model('baza','',TRUE);
			$keywords = $this->baza->get_keyword_position($id);
			$domain_name = $this->baza->get_doamin_name($id);
			$lines = count($keywords);
			
			$elemx = array();
			$elemy = array();
			$elem_tmp = array();
			$day = date('d');
			$month = date('m');
			$year = (empty($year) ? date('Y') : $year);
			$week = date('W',mktime(0,0,0,$month,$day,$year));	
			
			
			$elemx_tmp = Array();
			
			for($i=6;$i>=0;$i--)
			{
				$start_date = mktime (0,0,0,$month,$day,($year-$i));
				$elemx_tmp[] = strftime("20%y", $start_date);	
			}
			
			//print_r($elemx_tmp);
					
			$i = 0;
			
			foreach($keywords as $keyword)
			{		
				foreach($elemx_tmp as $key => $value)
				{				
					$dane = $this->baza->get_keyword_position_data_yearly($id, $keyword['keyword_id'],$value);				
					$elemx[$i][$key] = $value;
					$elemy[$i][$key] = round($dane[0]['position']);	
				} 
				$i++;
			}
			
			//print_r($elemx);
			//print_r($elemy);
													
			// #FINDING THE MAX NUMBER OF X ELEMENTS
			$xcount = 0;
			foreach ($elemx as $v)
				$xcount = max($xcount, count($v));
											
			// #BIGGEST Y ELEMENT
			$ymax = 0;
			foreach ($elemy as $v)
				$ymax = max($ymax,ceil(max($v)));
			
			// #CALCULATING THE DIFFERENCE
			//$dif = array_sum($elemy[0]) - array_sum($elemy[1]) - array_sum($elemy[2]);
			
			$data['domain_name'] = $domain_name[0]['domain'];
			$data['lines'] = $lines;
			$data['elemx'] = $elemx;				
			$data['elemy'] = $elemy;
			$data['ymax'] = $ymax;				
			$data['xcount'] = $xcount;
			$data['dif'] = 0;				
			//$this->load->view('charts/chart',$data);
			//----------------------------------------------------------
			$main_title = $data['domain_name']." - wykres pozycji w google";
			$x_title 	= "";
			$y_title 	= "pozycja w google (im mniejsza tym lepiej)";
			
			$data['chart'] = $this->getLineChart($elemy,$elemx,$ymax,$main_title,$x_title,$y_title);			
			$this->load->view('charts/chart_flash',$data);			
			}
}				
	
	// funkcje użyuwane do generowania słópkowych
	function factors($n)
	{
		$div = Array(1);
	
		for ($i=1; $i<= ($n/2); $i++)
			if ($n % $i == 0)
				$div[] = $i;
	
		$div[] = $n;
	
		return $div;
	}
	
	function hasAconvenientDiv($div)
	{
	    $divs = Array(8,7,6,5,4);
	    foreach ($divs as $k => $v)
		if (in_array($v,$div))
		    return $v;
	    return 0;
	}
	
	function getFirstDayOfWeek($year, $weeknr)
    {
	      $offset = date('%w', mktime(0,0,0,1,1,$year));
	      $offset = ($offset < 5) ? 1-$offset : 8-$offset;
	      $monday = mktime(0,0,0,1,1+$offset,$year);
	      $date = strtotime('+' . ($weeknr - 1) . ' weeks', $monday);
	      return date('m/d/Y',$date);								
	}	
	// koniec funkcji do wykresow słupkowych
	
	function chart_stat($id=null, $type=1,  $year = null, $month = null, $day = null)
	{
		//dzienne
		include_once('files/charts.class.php');
		if($id!=null and $day != null and $month != null and $year != null)
		{
			
			$this->load->model('bazapg', '', 'pg');
						
			$start_tmp = mktime (0,0,0,$month,($day-6),$year);
			$start = strftime("20%y-%m-%d", $start_tmp);	
			$start = str_replace('-','',$start);
			
			$end_tmp = mktime (0,0,0,$month,($day),$year);
			$end = strftime("20%y-%m-%d", $end_tmp);
			$end = str_replace('-','',$end);
			
			
			$stats = $this->bazapg->get_stats_wykres($id,$start,$end);
			//print_r($stats);
			
			// #X ELEMENTS
			// #Y ELEMENTS
			
			$elemx = Array();
			
			for($i=6;$i>=0;$i--)
			{
				$start_date = mktime (0,0,0,$month,($day-$i),$year);
				$elemx[] = strftime("20%y-%m-%d", $start_date);
				
			}
		
			$elemy = Array(0,0,0,0,0,0,0);
			
			
			foreach($stats as $key => $stat)
			{
				for($i=0; $i<7; $i++)
				{
					if($elemx[$i] == $stat['data'])
						$elemy[$i] = $stat['ilosc'];
				}
			}
			
			$ymax = ceil(max($elemy));
			if($ymax==0)
			{
				$ymax = 1;			
			}
			// #FINDING A CONVENIENT SCALE FOR Y AXIS
			if ($ymax > 8)
			{
			    do
			    {
			        $div = $this->factors($ymax);
					$ymax++;
			    } while (!($scale = $this->hasAconvenientDiv($div)));
			
			    $ymax--;
			}else $scale=5;
	
			$data['domain_name'] = ' ';
			$data['elemx'] = $elemx;				
			$data['elemy'] = $elemy;
			$data['scale'] = $scale;
			$data['ymax'] = $ymax;				
			$this->load->view('charts/chart_stat',$data);
		}
	}
	//
	function flash_chart_stat($id=null, $type=1,  $year = null, $month = null, $day = null)
	{
		//dzienne
		include_once('files/charts.class.php');
		if($id!=null and $day != null and $month != null and $year != null)
		{
			$this->load->model('baza','','default');
			$this->load->model('bazapg', '', 'pg');
			$domain_name = $this->baza->get_doamin_name($id);	
			$domain_name = $domain_name['0']['domain'];
			 					
			$start_tmp = mktime (0,0,0,$month,($day-6),$year);
			$start = strftime("20%y-%m-%d", $start_tmp);	
			$start = str_replace('-','',$start);
			
			$end_tmp = mktime (0,0,0,$month,($day),$year);
			$end = strftime("20%y-%m-%d", $end_tmp);
			$end = str_replace('-','',$end);
			
			
			$stats = $this->bazapg->get_stats_wykres($id,$start,$end);
			//print_r($stats);
			
			// #X ELEMENTS
			// #Y ELEMENTS
			
			$elemx = Array();
			
			for($i=6;$i>=0;$i--)
			{
				$start_date = mktime (0,0,0,$month,($day-$i),$year);
				$elemx[] = strftime("20%y-%m-%d", $start_date);
				
			}
		
			$elemy = Array(0,0,0,0,0,0,0);
			
			
			foreach($stats as $key => $stat)
			{
				for($i=0; $i<7; $i++)
				{
					if($elemx[$i] == $stat['data'])
						$elemy[$i] = $stat['ilosc'];
				}
			}
			
			$ymax = ceil(max($elemy));
			if($ymax==0)
			{
				$ymax = 1;			
			}
			// #FINDING A CONVENIENT SCALE FOR Y AXIS
			if ($ymax > 8)
			{
			    do
			    {
			        $div = $this->factors($ymax);
					$ymax++;
			    } while (!($scale = $this->hasAconvenientDiv($div)));
			
			    $ymax--;
			}else $scale=5;
	
			$data['domain_name'] = ' ';
			$data['elemx'] = $elemx;				
			$data['elemy'] = $elemy;
			$data['scale'] = $scale;
			$data['ymax'] = $ymax;				
			//$this->load->view('charts/chart_stat',$data);
			
			$main_title = $domain_name;
			$x_title    = "";
			$y_title    = "";
			
			$data['chart'] = $this->getBarChart($elemy,$elemx,$ymax,$main_title,$x_title,$y_title);			
			$this->load->view('charts/chart_flash',$data);
		}
	}	
	
	function chart_stat_uniq($id=null, $type=1,  $year = null, $month = null, $day = null)
	{
		if($id!=null and $day != null and $month != null and $year != null)
		{
			include_once('files/charts.class.php');
			$this->load->model('bazapg', '', 'pg');
			$start = mktime (0,0,0,$month,($day-6),$year);
			
			$daty = '';
			
			for($i=6;$i>=0;$i--)
			{
				$start_date = mktime (0,0,0,$month,($day-$i),$year);
				$daty .= str_replace('-','',strftime("20%y-%m-%d", $start_date));
				if($i!=0) $daty .= ',';
			}

			
			// #X ELEMENTS
			$elemx = Array();
			
			for($i=6;$i>=0;$i--)
			{
				$start_date = mktime (0,0,0,$month,($day-$i),$year);
				$elemx[] = strftime("20%y-%m-%d", $start_date);
				
			}
			
			// #Y ELEMENTS
			$elemy = Array(0,0,0,0,0,0,0);
			
			$stats = $this->bazapg->get_stats_wykres_unig($id,$daty);			
			
			
			foreach($stats as $key => $stat)
			{
				for($i=0; $i<7; $i++)
				{
					if($elemx[$i] == $stat['data'])
						$elemy[$i] = $stat['ilosc'];
				}
			}
			
			$ymax = ceil(max($elemy));
			if($ymax==0)
			{
				$ymax = 1;			
			}
			// #FINDING A CONVENIENT SCALE FOR Y AXIS
			if ($ymax > 8)
			{
			    do
			    {
			        $div = $this->factors($ymax);
					$ymax++;
			    } while (!($scale = $this->hasAconvenientDiv($div)));
			
			    $ymax--;
			}else $scale=5;
	
			$data['domain_name'] = ' ';
			$data['elemx'] = $elemx;				
			$data['elemy'] = $elemy;
			$data['scale'] = $scale;
			$data['ymax'] = $ymax;				
			$this->load->view('charts/chart_stat_uniq',$data);
		}
	}
	
//----------------------------------------------------------------------------------------------------------------
	function flash_chart_stat_uniq($id=null, $type=1,  $year = null, $month = null, $day = null)
	{
		if($id!=null and $day != null and $month != null and $year != null)
		{
			include_once('files/charts.class.php');
			$this->load->model('baza','','default');
			$this->load->model('bazapg', '', 'pg');
			
			$domain_name = $this->baza->get_doamin_name($id);	
			$domain_name = $domain_name['0']['domain'];
			$start = mktime (0,0,0,$month,($day-6),$year);
			
			$daty = '';
			
			for($i=6;$i>=0;$i--)
			{
				$start_date = mktime (0,0,0,$month,($day-$i),$year);
				$daty .= str_replace('-','',strftime("20%y-%m-%d", $start_date));
				if($i!=0) $daty .= ',';
			}

			
			// #X ELEMENTS
			$elemx = Array();
			
			for($i=6;$i>=0;$i--)
			{
				$start_date = mktime (0,0,0,$month,($day-$i),$year);
				$elemx[] = strftime("20%y-%m-%d", $start_date);
				
			}
			
			// #Y ELEMENTS
			$elemy = Array(0,0,0,0,0,0,0);
			
			$stats = $this->bazapg->get_stats_wykres_unig($id,$daty);			
			
			
			foreach($stats as $key => $stat)
			{
				for($i=0; $i<7; $i++)
				{
					if($elemx[$i] == $stat['data'])
						$elemy[$i] = $stat['ilosc'];
				}
			}
			
			$ymax = ceil(max($elemy));
			if($ymax==0)
			{
				$ymax = 1;			
			}
			// #FINDING A CONVENIENT SCALE FOR Y AXIS
			if ($ymax > 8)
			{
			    do
			    {
			        $div = $this->factors($ymax);
					$ymax++;
			    } while (!($scale = $this->hasAconvenientDiv($div)));
			
			    $ymax--;
			}else $scale=5;
	
			$data['domain_name'] = ' ';
			$data['elemx'] = $elemx;				
			$data['elemy'] = $elemy;
			$data['scale'] = $scale;
			$data['ymax'] = $ymax;				
			
			$main_title = $domain_name." - ilość unikatowych odsłon";
			$x_title = "Liczba unikatowych odsłon z 7 dni: ".array_sum($elemy);
			$y_title = "Liczba unikatowych odsłon";
			
			$data['chart'] = $this->getBarChart($elemy,$elemx,$ymax,$main_title,$x_title,$y_title);			
			$this->load->view('charts/chart_flash',$data);			
		}
	}	
//----------------------------------------------------------------------------------------------------------------
	function flash_chart_stat_returning($id=null, $type=1,  $year = null, $month = null, $day = null)
	{
		if($id!=null and $day != null and $month != null and $year != null)
		{
			include_once('files/charts.class.php');
			$this->load->model('baza','','default');
			$this->load->model('bazapg', '', 'pg');
			
			$domain_name = $this->baza->get_doamin_name($id);	
			$domain_name = $domain_name['0']['domain'];

			$start = mktime (0,0,0,$month,($day-6),$year);			
			$daty = Array();
			
			for($i=6;$i>=0;$i--)
			{
				$start_date = mktime (0,0,0,$month,($day-$i),$year);
				$daty[] = strftime("20%y-%m-%d", $start_date);
			}
			
			$dni_uniq = '';
			$dni_ret_max = '';
			$dni_ret_min = '';
				
			foreach($daty as $key => $value)
			{	
				$day_ret = substr($value,8,2);
				$month_ret = substr($value,5,2);
				$year_ret = substr($value,0,4);
				$data_tmp = mktime (0,0,0,$month_ret,($day_ret-1),$year_ret);
				$data_tmp2 = mktime (0,0,0,$month_ret,($day_ret-7),$year_ret);
				$data_returning_max = str_replace('-','',strftime("20%y-%m-%d", $data_tmp));
				$data_returning_min = str_replace('-','',strftime("20%y-%m-%d", $data_tmp2));
				
				$dni_uniq .=str_replace('-','',$value).',';
				$dni_ret_min .= $data_returning_min.',';
				$dni_ret_max .= $data_returning_max.',';
			}
			
			$dni_u = substr($dni_uniq, 0, -1);
			$dni_r_min = substr($dni_ret_min, 0, -1);
			$dni_r_max = substr($dni_ret_max, 0, -1);
			
			// #X ELEMENTS
			$elemx = Array();
			
			for($i=6;$i>=0;$i--)
			{
				$start_date = mktime (0,0,0,$month,($day-$i),$year);
				$elemx[] = strftime("20%y-%m-%d", $start_date);
				
			}
			
			// #Y ELEMENTS
			$elemy = Array(0,0,0,0,0,0,0);
			
			
			$stats = $this->bazapg->get_stats_wykres_returning($id, $dni_u, $dni_r_min, $dni_r_max);
			
			foreach($stats as $key => $stat)
			{
				for($i=0; $i<7; $i++)
				{
					if($elemx[$i] == $stat['data'])
						$elemy[$i] = $stat['ilosc'];
				}
			}
			
			$ymax = ceil(max($elemy));
			if($ymax==0)
			{
				$ymax = 1;			
			}
	
			// #FINDING A CONVENIENT SCALE FOR Y AXIS
			if ($ymax > 8)
			{
			    do
			    {
			        $div = $this->factors($ymax);
					$ymax++;
			    } while (!($scale = $this->hasAconvenientDiv($div)));
			
			    $ymax--;
			}else $scale=5;
	
			$data['domain_name'] = ' ';
			$data['elemx'] = $elemx;				
			$data['elemy'] = $elemy;
			$data['scale'] = $scale;
			$data['ymax'] = $ymax;				
			//$this->load->view('charts/chart_stat_returning',$data);
			
			$main_title = $domain_name." - ilość powracających użytkowników";
			$x_title = "Liczba powracających użytkowników  z 7 dni: ".array_sum($elemy);
			$y_title = "Liczba powracających użytkowników";
						
			$data['chart'] = $this->getBarChart($elemy,$elemx,$ymax,$main_title,$x_title,$y_title);			
			$this->load->view('charts/chart_flash',$data);				
		}
	}	
//----------------------------------------------------------------------------------------------------------------	
	function chart_stat_returning($id=null, $type=1,  $year = null, $month = null, $day = null)
	{
		if($id!=null and $day != null and $month != null and $year != null)
		{
			include_once('files/charts.class.php');
			$this->load->model('bazapg', '', 'pg');

			$start = mktime (0,0,0,$month,($day-6),$year);			
			$daty = Array();
			
			for($i=6;$i>=0;$i--)
			{
				$start_date = mktime (0,0,0,$month,($day-$i),$year);
				$daty[] = strftime("20%y-%m-%d", $start_date);
			}
			
			$dni_uniq = '';
			$dni_ret_max = '';
			$dni_ret_min = '';
				
			foreach($daty as $key => $value)
			{	
				$day_ret = substr($value,8,2);
				$month_ret = substr($value,5,2);
				$year_ret = substr($value,0,4);
				$data_tmp = mktime (0,0,0,$month_ret,($day_ret-1),$year_ret);
				$data_tmp2 = mktime (0,0,0,$month_ret,($day_ret-7),$year_ret);
				$data_returning_max = str_replace('-','',strftime("20%y-%m-%d", $data_tmp));
				$data_returning_min = str_replace('-','',strftime("20%y-%m-%d", $data_tmp2));
				
				$dni_uniq .=str_replace('-','',$value).',';
				$dni_ret_min .= $data_returning_min.',';
				$dni_ret_max .= $data_returning_max.',';
			}
			
			$dni_u = substr($dni_uniq, 0, -1);
			$dni_r_min = substr($dni_ret_min, 0, -1);
			$dni_r_max = substr($dni_ret_max, 0, -1);
			
			// #X ELEMENTS
			$elemx = Array();
			
			for($i=6;$i>=0;$i--)
			{
				$start_date = mktime (0,0,0,$month,($day-$i),$year);
				$elemx[] = strftime("20%y-%m-%d", $start_date);
				
			}
			
			// #Y ELEMENTS
			$elemy = Array(0,0,0,0,0,0,0);
			
			
			$stats = $this->bazapg->get_stats_wykres_returning($id, $dni_u, $dni_r_min, $dni_r_max);
			
			foreach($stats as $key => $stat)
			{
				for($i=0; $i<7; $i++)
				{
					if($elemx[$i] == $stat['data'])
						$elemy[$i] = $stat['ilosc'];
				}
			}
			
			$ymax = ceil(max($elemy));
			if($ymax==0)
			{
				$ymax = 1;			
			}
	
			// #FINDING A CONVENIENT SCALE FOR Y AXIS
			if ($ymax > 8)
			{
			    do
			    {
			        $div = $this->factors($ymax);
					$ymax++;
			    } while (!($scale = $this->hasAconvenientDiv($div)));
			
			    $ymax--;
			}else $scale=5;
	
			$data['domain_name'] = ' ';
			$data['elemx'] = $elemx;				
			$data['elemy'] = $elemy;
			$data['scale'] = $scale;
			$data['ymax'] = $ymax;				
			$this->load->view('charts/chart_stat_returning',$data);
		}
	}
	
	function chart_stat_all_returning($id=null, $type=1,  $year = null, $month = null, $day = null)
	{
		if($id!=null and $day != null and $month != null and $year != null)
		{
			include_once('files/charts.class.php');
			$this->load->model('bazapg', '', 'pg');
			$start = mktime (0,0,0,$month,($day-6),$year);
			
			$daty = '';
			
			for($i=6;$i>=0;$i--)
			{
				$start_date = mktime (0,0,0,$month,($day-$i),$year);
				$daty .= strftime("20%y-%m-%d", $start_date);
				if($i!=0) $daty .= ',';
			}

			// #X ELEMENTS
			// #Y ELEMENTS
		//	$stats = $this->bazapg->get_stats_wykres_all_returning($id,$daty);			
			
			foreach($stats as $key => $stat)
			{
				$elemx[$key+1] = $stat['data'];
				$elemy[$key+1] = $stat['ilosc'];
			}
			
			$ymax = ceil(max($elemy));
			if($ymax==0)
			{
				$ymax = 1;			
			}
			
			// #FINDING A CONVENIENT SCALE FOR Y AXIS
			if ($ymax > 8)
			{
			    do
			    {
			        $div = $this->factors($ymax);
					$ymax++;
			    } while (!($scale = $this->hasAconvenientDiv($div)));
			
			    $ymax--;
			}else $scale=5;
	
			$data['domain_name'] = ' ';
			$data['elemx'] = $elemx;				
			$data['elemy'] = $elemy;
			$data['scale'] = $scale;
			$data['ymax'] = $ymax;				
			$this->load->view('charts/chart_stat_all_returning',$data);
		}
	}
//---------------------------------------------------------------------------------------------------------------------------------
	function flash_chart_stat_weekly($id=null, $type=2, $week = 1, $year = 2008)
	{
		// "Tygodniowe"; 
		if($id!=null)
		{	
			include_once('files/charts.class.php');
			$this->load->model('baza','','default');
			$this->load->model('bazapg', '', 'pg');
			
			$domain_name = $this->baza->get_doamin_name($id);	
			$domain_name = $domain_name['0']['domain'];
		
			// #X ELEMENTS
			$elemx_tmp = Array();
			for($i=7;$i>0;$i--)
			{
				if($week<1)
				{
					$year = $year-1; 
					$week = strftime("%W",strtotime("12/31/".$year)) - 1;
				}
					$first = $this->getFirstDayOfWeek($year, ($week--));		
				
				$day = substr($first,3,2);
				$month = substr($first,0,2);
				$w = date('w',mktime(0,0,0,$month,$day,$year));
				$start_date = mktime(0, 0, 0, $month, $day-$w+1, $year); 
				$end_date = mktime(0, 0, 0, $month, $day-$w+8 , $year); 
		
				$go =  strftime("20%y-%m-%d",$start_date);
				$end = strftime("20%y-%m-%d",$end_date);			
				
				$elemx_tmp[] = $go.' | '.$end;
			}
			
			$elemx = array_reverse($elemx_tmp);

			//$domain_name = $this->baza->get_doamin_name($id);
			
			// #Y ELEMENTS
			$elemy = Array();
			$elemy[]=0;
			$elemy[]=0;
			$elemy[]=0;
			$elemy[]=0;
			$elemy[]=0;
			$elemy[]=0;
			$elemy[]=0;
				
			foreach($elemx as $key => $value)
			{
				 
				 $go = str_replace('-','',substr($value, 0, 10));
				 $end = str_replace('-','',substr($value, 13, 10));
				 //$go .= ' 00:00:00';
				 //$end .= ' 00:00:00';
				 
				
				$stats = $this->bazapg->get_stats_wykres_weekly($id,$go, $end);
				if (isset($stats[0]['rows']))
					$elemy[$key] = $stats[0]['rows'];
				else $elemy[$key] = 0;
				
			}	
			
			$ymax = ceil(max($elemy));
			if($ymax==0)
			{
				$ymax = 1;			
			}
			// #FINDING A CONVENIENT SCALE FOR Y AXIS
			if ($ymax > 8)
			{
			    do
			    {
			        $div = $this->factors($ymax);
					$ymax++;
			    } while (!($scale = $this->hasAconvenientDiv($div)));
			
			    $ymax--;
			}else $scale=5;
	
			$data['domain_name'] = ' ';
			$data['elemx'] = $elemx;				
			$data['elemy'] = $elemy;
			$data['scale'] = $scale;
			$data['ymax'] = $ymax;
							
			$main_title = $domain_name." - ilość odsłon strony z 7 tygodni";
			$x_title	= "Liczba odsłon z 7 dni: ".array_sum($elemy);
			$y_title 	= "Liczba odsłon";				
							
			$data['chart'] = $this->getBarChart($elemy,$elemx,$ymax,$main_title,$x_title,$y_title);			
			$this->load->view('charts/chart_flash',$data);				
		}
	}
//---------------------------------------------------------------------------------------------------------------------------------	
	function chart_stat_weekly($id=null, $type=2, $week = 1, $year = 2008)
	{
		// "Tygodniowe"; 
		if($id!=null)
		{	
			include_once('files/charts.class.php');
			$this->load->model('bazapg', '', 'pg');
		
			// #X ELEMENTS
			$elemx_tmp = Array();
			for($i=7;$i>0;$i--)
			{
				if($week<1)
				{
					$year = $year-1; 
					$week = strftime("%W",strtotime("12/31/".$year)) - 1;
				}
					$first = $this->getFirstDayOfWeek($year, ($week--));		
				
				$day = substr($first,3,2);
				$month = substr($first,0,2);
				$w = date('w',mktime(0,0,0,$month,$day,$year));
				$start_date = mktime(0, 0, 0, $month, $day-$w+1, $year); 
				$end_date = mktime(0, 0, 0, $month, $day-$w+8 , $year); 
		
				$go =  strftime("20%y-%m-%d",$start_date);
				$end = strftime("20%y-%m-%d",$end_date);			
				
				$elemx_tmp[] = $go.' | '.$end;
			}
			
			$elemx = array_reverse($elemx_tmp);

			//$domain_name = $this->baza->get_doamin_name($id);
			
			// #Y ELEMENTS
			$elemy = Array();
			$elemy[]=0;
			$elemy[]=0;
			$elemy[]=0;
			$elemy[]=0;
			$elemy[]=0;
			$elemy[]=0;
			$elemy[]=0;
				
			foreach($elemx as $key => $value)
			{
				 
				 $go = str_replace('-','',substr($value, 0, 10));
				 $end = str_replace('-','',substr($value, 13, 10));
				 //$go .= ' 00:00:00';
				 //$end .= ' 00:00:00';
				 
				
				$stats = $this->bazapg->get_stats_wykres_weekly($id,$go, $end);
				if (isset($stats[0]['rows']))
					$elemy[$key] = $stats[0]['rows'];
				else $elemy[$key] = 0;
				
			}	
			
			$ymax = ceil(max($elemy));
			if($ymax==0)
			{
				$ymax = 1;			
			}
			// #FINDING A CONVENIENT SCALE FOR Y AXIS
			if ($ymax > 8)
			{
			    do
			    {
			        $div = $this->factors($ymax);
					$ymax++;
			    } while (!($scale = $this->hasAconvenientDiv($div)));
			
			    $ymax--;
			}else $scale=5;
	
			$data['domain_name'] = ' ';
			$data['elemx'] = $elemx;				
			$data['elemy'] = $elemy;
			$data['scale'] = $scale;
			$data['ymax'] = $ymax;				
			$this->load->view('charts/chart_stat_weekly',$data);	
		}
	}
//----------------------------------------------------------------------------------------------------------------------------------
	function flash_chart_stat_uniq_weekly($id=null, $type=2, $week = 1, $year = 2008)
	{
		// "Tygodniowe"; 
		if($id!=null)
		{	
			include_once('files/charts.class.php');
			$this->load->model('baza','','default');
			$this->load->model('bazapg', '', 'pg');
			
			$domain_name = $this->baza->get_doamin_name($id);	
			$domain_name = $domain_name['0']['domain'];
				
			// #X ELEMENTS
			$elemx_tmp = Array();
			for($i=7;$i>0;$i--)
			{
				if($week<1)
				{
					$year = $year-1; 
					$week = strftime("%W",strtotime("12/31/".$year)) - 1;
				}
					$first = $this->getFirstDayOfWeek($year, ($week--));		
				
				$day = substr($first,3,2);
				$month = substr($first,0,2);
				$w = date('w',mktime(0,0,0,$month,$day,$year));
				$start_date = mktime(0, 0, 0, $month, $day-$w+1, $year); 
				$end_date = mktime(0, 0, 0, $month, $day-$w+8 , $year); 
		
				$go =  strftime("20%y-%m-%d",$start_date);
				$end = strftime("20%y-%m-%d",$end_date);			
				
				$elemx_tmp[] = $go.' | '.$end;
			}
			
			$elemx = array_reverse($elemx_tmp);

			//$domain_name = $this->bazapg->get_doamin_name($id);
			
			// #Y ELEMENTS
			$elemy = Array();
			$elemy[]=0;
			$elemy[]=0;
			$elemy[]=0;
			$elemy[]=0;
			$elemy[]=0;
			$elemy[]=0;
			$elemy[]=0;
				
			foreach($elemx as $key => $value)
			{
				 
				 $go = str_replace('-','',substr($value, 0, 10));
				 $end = str_replace('-','',substr($value, 13, 10));
				// $go .= ' 00:00:00';
				// $end .= ' 00:00:00';
				 
				
				$stats = $this->bazapg->get_stats_wykres_unig_weekly($id,$go, $end);
				
				$elemy[$key] = $stats[0]['rows'];
				
			}	
			
			$ymax = ceil(max($elemy));
			if($ymax==0)
			{
				$ymax = 1;			
			}
			// #FINDING A CONVENIENT SCALE FOR Y AXIS
			if ($ymax > 8)
			{
			    do
			    {
			        $div = $this->factors($ymax);
					$ymax++;
			    } while (!($scale = $this->hasAconvenientDiv($div)));
			
			    $ymax--;
			}else $scale=5;
	
			$data['domain_name'] = ' ';
			$data['elemx'] = $elemx;				
			$data['elemy'] = $elemy;
			$data['scale'] = $scale;
			$data['ymax'] = $ymax;
			
			
			$main_title = $domain_name." - liczba unikatowych odsłon strony z 7 tygodni";
			$x_title = "Liczba unikatowych odsłon z 7 dni: ".array_sum($elemy);
			$y_title = "Liczba unikatowych odsłon";				
							
							
			$data['chart'] = $this->getBarChart($elemy,$elemx,$ymax,$main_title,$x_title,$y_title);			
			$this->load->view('charts/chart_flash',$data);		
		}
	}
//----------------------------------------------------------------------------------------------------------------------------------	
	function chart_stat_uniq_weekly($id=null, $type=2, $week = 1, $year = 2008)
	{
		// "Tygodniowe"; 
		if($id!=null)
		{	
			include_once('files/charts.class.php');
			$this->load->model('bazapg', '', 'pg');
				
			// #X ELEMENTS
			$elemx_tmp = Array();
			for($i=7;$i>0;$i--)
			{
				if($week<1)
				{
					$year = $year-1; 
					$week = strftime("%W",strtotime("12/31/".$year)) - 1;
				}
					$first = $this->getFirstDayOfWeek($year, ($week--));		
				
				$day = substr($first,3,2);
				$month = substr($first,0,2);
				$w = date('w',mktime(0,0,0,$month,$day,$year));
				$start_date = mktime(0, 0, 0, $month, $day-$w+1, $year); 
				$end_date = mktime(0, 0, 0, $month, $day-$w+8 , $year); 
		
				$go =  strftime("20%y-%m-%d",$start_date);
				$end = strftime("20%y-%m-%d",$end_date);			
				
				$elemx_tmp[] = $go.' | '.$end;
			}
			
			$elemx = array_reverse($elemx_tmp);

			//$domain_name = $this->bazapg->get_doamin_name($id);
			
			// #Y ELEMENTS
			$elemy = Array();
			$elemy[]=0;
			$elemy[]=0;
			$elemy[]=0;
			$elemy[]=0;
			$elemy[]=0;
			$elemy[]=0;
			$elemy[]=0;
				
			foreach($elemx as $key => $value)
			{
				 
				 $go = str_replace('-','',substr($value, 0, 10));
				 $end = str_replace('-','',substr($value, 13, 10));
				// $go .= ' 00:00:00';
				// $end .= ' 00:00:00';
				 
				
				$stats = $this->bazapg->get_stats_wykres_unig_weekly($id,$go, $end);
				
				$elemy[$key] = $stats[0]['rows'];
				
			}	
			
			$ymax = ceil(max($elemy));
			if($ymax==0)
			{
				$ymax = 1;			
			}
			// #FINDING A CONVENIENT SCALE FOR Y AXIS
			if ($ymax > 8)
			{
			    do
			    {
			        $div = $this->factors($ymax);
					$ymax++;
			    } while (!($scale = $this->hasAconvenientDiv($div)));
			
			    $ymax--;
			}else $scale=5;
	
			$data['domain_name'] = ' ';
			$data['elemx'] = $elemx;				
			$data['elemy'] = $elemy;
			$data['scale'] = $scale;
			$data['ymax'] = $ymax;				
			$this->load->view('charts/chart_stat_uniq_weekly',$data);	
		}
	}
//---------------------------------------------------------------------------------------------------------------------------------
	function flash_chart_stat_returning_weekly($id=null, $type=2, $week = 1, $year = 2008)
	{
		// "Tygodniowe"; 
		if($id!=null)
		{	
			include_once('files/charts.class.php');
			$this->load->model('baza','','default');
			$this->load->model('bazapg', '', 'pg');
			
			$domain_name = $this->baza->get_doamin_name($id);	
			$domain_name = $domain_name['0']['domain'];
				
			// #X ELEMENTS
			$elemx_tmp = Array();
			for($i=7;$i>0;$i--)
			{
				if($week<1)
				{
					$year = $year-1; 
					$week = strftime("%W",strtotime("12/31/".$year)) - 1;
				}
					$first = $this->getFirstDayOfWeek($year, ($week--));		
				
				$day = substr($first,3,2);
				$month = substr($first,0,2);
				$w = date('w',mktime(0,0,0,$month,$day,$year));
				$start_date = mktime(0, 0, 0, $month, $day-$w+1, $year); 
				$end_date = mktime(0, 0, 0, $month, $day-$w+8 , $year); 
		
				$go =  strftime("20%y-%m-%d",$start_date);
				$end = strftime("20%y-%m-%d",$end_date);			
				
				$elemx_tmp[] = $go.' | '.$end;
			}
			
			$elemx = array_reverse($elemx_tmp);

			//$domain_name = $this->baza->get_doamin_name($id);
			
			// #Y ELEMENTS
			$elemy = Array();
			$elemy[]=0;
			$elemy[]=0;
			$elemy[]=0;
			$elemy[]=0;
			$elemy[]=0;
			$elemy[]=0;
			$elemy[]=0;
				
			foreach($elemx as $key => $value)
			{
				 
				 $go = substr($value, 0, 10);
				 $end = substr($value, 13, 10);
				 $go .= ' 00:00:00';
				 $end .= ' 00:00:00';
				  
				 $day_tmp = substr($end, 8, 2);
				 $month_tmp = substr($end, 5, 2);
				 $year_tmp = substr($end, 0, 4);
				 
				// echo $day_tmp.'-'.$month_tmp.'-'.$year_tmp;
				 
				$elemx_simple = Array();
				for($i=7;$i>0;$i--)
				{
					$start_date = mktime (0,0,0,$month_tmp,($day_tmp-$i),$year_tmp);
					$elemx_simple[] = strftime("20%y-%m-%d", $start_date);
				}
				
				$licznik=0;				
				foreach($elemx_simple as $k => $v)
				{
	     			
					$day_ret = substr($v,8,2);
					$month_ret = substr($v,5,2);
					$year_ret = substr($v,0,4);
					$data_tmp = mktime (0,0,0,$month_ret,($day_ret-1),$year_ret);
					$data_returning = strftime("20%y-%m-%d", $data_tmp);
					$data_tmp2 = mktime (0,0,0,$month_ret,($day_ret-7),$year_ret);
					$data_returning_min = str_replace('-','',strftime("20%y-%m-%d", $data_tmp2));
					
					$stats_simple = $this->bazapg->get_stats_wykres_returning_wekly2($id,str_replace('-','',$v),str_replace('-','',$data_returning_min), str_replace('-','',$data_returning));
					//echo $v.'<br /><br />';
					//echo $data_returning.'<br /><br />';
					$licznik += $stats_simple[0]['rows'];
	
				}	 
				
				$elemy[$key] = $licznik;
			}	
			
			$ymax = ceil(max($elemy));
			if($ymax==0)
			{
				$ymax = 1;			
			}
			// #FINDING A CONVENIENT SCALE FOR Y AXIS
			if ($ymax > 8)
			{
			    do
			    {
			        $div = $this->factors($ymax);
					$ymax++;
			    } while (!($scale = $this->hasAconvenientDiv($div)));
			
			    $ymax--;
			}else $scale=5;
	
			$data['domain_name'] = ' ';
			$data['elemx'] = $elemx;				
			$data['elemy'] = $elemy;
			$data['scale'] = $scale;
			$data['ymax'] = $ymax;	
						
			$main_title = $domain_name." - ilość powracających użytkowników z 7 tygodni";
			$x_title = "Liczba powracajacych uzytkowników z 7 dni: ".array_sum($elemy);
			$y_title = "Liczba powracajacych uzytkowników";			
						
			$data['chart'] = $this->getBarChart($elemy,$elemx,$ymax,$main_title,$x_title,$y_title);			
			$this->load->view('charts/chart_flash',$data);		
		}
	}
//---------------------------------------------------------------------------------------------------------------------------------	
	function chart_stat_returning_weekly($id=null, $type=2, $week = 1, $year = 2008)
	{
		// "Tygodniowe"; 
		if($id!=null)
		{	
			include_once('files/charts.class.php');
			$this->load->model('bazapg', '', 'pg');
				
			// #X ELEMENTS
			$elemx_tmp = Array();
			for($i=7;$i>0;$i--)
			{
				if($week<1)
				{
					$year = $year-1; 
					$week = strftime("%W",strtotime("12/31/".$year)) - 1;
				}
					$first = $this->getFirstDayOfWeek($year, ($week--));		
				
				$day = substr($first,3,2);
				$month = substr($first,0,2);
				$w = date('w',mktime(0,0,0,$month,$day,$year));
				$start_date = mktime(0, 0, 0, $month, $day-$w+1, $year); 
				$end_date = mktime(0, 0, 0, $month, $day-$w+8 , $year); 
		
				$go =  strftime("20%y-%m-%d",$start_date);
				$end = strftime("20%y-%m-%d",$end_date);			
				
				$elemx_tmp[] = $go.' | '.$end;
			}
			
			$elemx = array_reverse($elemx_tmp);

			//$domain_name = $this->baza->get_doamin_name($id);
			
			// #Y ELEMENTS
			$elemy = Array();
			$elemy[]=0;
			$elemy[]=0;
			$elemy[]=0;
			$elemy[]=0;
			$elemy[]=0;
			$elemy[]=0;
			$elemy[]=0;
				
			foreach($elemx as $key => $value)
			{
				 
				 $go = substr($value, 0, 10);
				 $end = substr($value, 13, 10);
				 $go .= ' 00:00:00';
				 $end .= ' 00:00:00';
				  
				 $day_tmp = substr($end, 8, 2);
				 $month_tmp = substr($end, 5, 2);
				 $year_tmp = substr($end, 0, 4);
				 
				// echo $day_tmp.'-'.$month_tmp.'-'.$year_tmp;
				 
				$elemx_simple = Array();
				for($i=7;$i>0;$i--)
				{
					$start_date = mktime (0,0,0,$month_tmp,($day_tmp-$i),$year_tmp);
					$elemx_simple[] = strftime("20%y-%m-%d", $start_date);
				}
				
				$licznik=0;				
				foreach($elemx_simple as $k => $v)
				{
	     			
					$day_ret = substr($v,8,2);
					$month_ret = substr($v,5,2);
					$year_ret = substr($v,0,4);
					$data_tmp = mktime (0,0,0,$month_ret,($day_ret-1),$year_ret);
					$data_returning = strftime("20%y-%m-%d", $data_tmp);
					$data_tmp2 = mktime (0,0,0,$month_ret,($day_ret-7),$year_ret);
					$data_returning_min = str_replace('-','',strftime("20%y-%m-%d", $data_tmp2));
					
					$stats_simple = $this->bazapg->get_stats_wykres_returning_wekly2($id,str_replace('-','',$v),str_replace('-','',$data_returning_min), str_replace('-','',$data_returning));
					//echo $v.'<br /><br />';
					//echo $data_returning.'<br /><br />';
					$licznik += $stats_simple[0]['rows'];
	
				}	 
				
				$elemy[$key] = $licznik;
			}	
			
			$ymax = ceil(max($elemy));
			if($ymax==0)
			{
				$ymax = 1;			
			}
			// #FINDING A CONVENIENT SCALE FOR Y AXIS
			if ($ymax > 8)
			{
			    do
			    {
			        $div = $this->factors($ymax);
					$ymax++;
			    } while (!($scale = $this->hasAconvenientDiv($div)));
			
			    $ymax--;
			}else $scale=5;
	
			$data['domain_name'] = ' ';
			$data['elemx'] = $elemx;				
			$data['elemy'] = $elemy;
			$data['scale'] = $scale;
			$data['ymax'] = $ymax;				
			$this->load->view('charts/chart_stat_returning_weekly',$data);	
		}
	}
//---------------------------------------------------------------------------------------------------------------------------------
	function flash_chart_stat_monthly($id=null, $type=3, $month = 1, $year = 2008)
	{
		//miesieczne
		include_once('files/charts.class.php');

		if($id!=null)
		{
			include_once('files/charts.class.php');
			$this->load->model('baza','','default');
			$this->load->model('bazapg', '', 'pg');
			
			$domain_name = $this->baza->get_doamin_name($id);	
			$domain_name = $domain_name['0']['domain'];
						
			for($i=6;$i>=0;$i--)
			{
				$start_date = mktime (0,0,0,($month-$i),1,$year);
				$elemx[] = strftime("20%y-%m", $start_date);
			}
			
			// #X ELEMENTS
			// #Y ELEMENTS
		
			$elemy = Array(0,0,0,0,0,0,0);
			
			foreach($elemx as $key => $value)
			{
				$stats = $this->bazapg->get_stats_wykres_monthly($id,str_replace('-','',$value));
				//print_r($stats);
				$elemy[$key] = @$stats[0]['rows'];	
			}
			
			$ymax = ceil(max($elemy));
			if($ymax==0)
			{
				$ymax = 1;			
			}
			// #FINDING A CONVENIENT SCALE FOR Y AXIS
			if ($ymax > 8)
			{
			    do
			    {
			        $div = $this->factors($ymax);
					$ymax++;
			    } while (!($scale = $this->hasAconvenientDiv($div)));
			
			    $ymax--;
			}else $scale=5;
	
			$data['domain_name'] = ' ';
			$data['elemx'] = $elemx;				
			$data['elemy'] = $elemy;
			$data['scale'] = $scale;
			$data['ymax'] = $ymax;				
			
			$main_title = $domain_name." - ilość odsłon strony";
			$x_title = "Liczba odsłon z 7 miesięcy: ".array_sum($elemy);
			$y_title = "Liczba odsłon";
			
			$data['chart'] = $this->getBarChart($elemy,$elemx,$ymax,$main_title,$x_title,$y_title);			
			$this->load->view('charts/chart_flash',$data);
		}
	}
//---------------------------------------------------------------------------------------------------------------------------------	
	function chart_stat_monthly($id=null, $type=3, $month = 1, $year = 2008)
	{
		//miesieczne
		include_once('files/charts.class.php');
		
		if($id!=null)
		{
			$this->load->model('bazapg', '', 'pg');
			
			for($i=6;$i>=0;$i--)
			{
				$start_date = mktime (0,0,0,($month-$i),1,$year);
				$elemx[] = strftime("20%y-%m", $start_date);
			}
			
			// #X ELEMENTS
			// #Y ELEMENTS
		
			$elemy = Array(0,0,0,0,0,0,0);
			
			foreach($elemx as $key => $value)
			{
				$stats = $this->bazapg->get_stats_wykres_monthly($id,str_replace('-','',$value));
				//print_r($stats);
				$elemy[$key] = @$stats[0]['rows'];	
			}
			
			$ymax = ceil(max($elemy));
			if($ymax==0)
			{
				$ymax = 1;			
			}
			// #FINDING A CONVENIENT SCALE FOR Y AXIS
			if ($ymax > 8)
			{
			    do
			    {
			        $div = $this->factors($ymax);
					$ymax++;
			    } while (!($scale = $this->hasAconvenientDiv($div)));
			
			    $ymax--;
			}else $scale=5;
	
			$data['domain_name'] = ' ';
			$data['elemx'] = $elemx;				
			$data['elemy'] = $elemy;
			$data['scale'] = $scale;
			$data['ymax'] = $ymax;

			$this->load->view('charts/chart_stat_monthly',$data);
		}
	}
//---------------------------------------------------------------------------------------------------------------------------------
	function flash_chart_stat_monthly_uniq($id=null, $type=3, $month = 1, $year = 2008)
	{
		//miesieczne
		include_once('files/charts.class.php');
		
		if($id!=null)
		{
			include_once('files/charts.class.php');
			$this->load->model('baza','','default');
			$this->load->model('bazapg', '', 'pg');
			
			$domain_name = $this->baza->get_doamin_name($id);	
			$domain_name = $domain_name['0']['domain'];
			
			
			for($i=6;$i>=0;$i--)
			{
				$start_date = mktime (0,0,0,($month-$i),1,$year);
				$elemx[] = strftime("20%y-%m", $start_date);
				$end_date = mktime (0,0,0,($month-($i-1)),1,$year);
				$elemx_go[] = strftime("20%y-%m-%d", $start_date);
				$elemx_end[] = strftime("20%y-%m-%d", $end_date);
			}
			
			//print_r($elemx);
			//print_r($elemx_go);
			//print_r($elemx_end);
			
			// #X ELEMENTS
			// #Y ELEMENTS
		
			$elemy = Array(0,0,0,0,0,0,0);
			
			foreach($elemx as $key => $value)
			{
				$stats = $this->bazapg->get_stats_wykres_monthly_uniq($id,str_replace('-','',$elemx_go[$key]),str_replace('-','',$elemx_end[$key]));
				//print_r($stats);
				$elemy[$key] = @$stats[0]['rows'];	
			}
			
			$ymax = ceil(max($elemy));
			if($ymax==0)
			{
				$ymax = 1;			
			}
			// #FINDING A CONVENIENT SCALE FOR Y AXIS
			if ($ymax > 8)
			{
			    do
			    {
			        $div = $this->factors($ymax);
					$ymax++;
			    } while (!($scale = $this->hasAconvenientDiv($div)));
			
			    $ymax--;
			}else $scale=5;
	
			$data['domain_name'] = ' ';
			$data['elemx'] = $elemx;				
			$data['elemy'] = $elemy;
			$data['scale'] = $scale;
			$data['ymax'] = $ymax;				
			
			$main_title = $domain_name." - ilość unikatowych odsłon";
			$x_title = "Liczba unikatowych odsłon z 7 miesięcy :".array_sum($elemy);
			$y_title = "Liczba odsłon";
			
			$data['chart'] = $this->getBarChart($elemy,$elemx,$ymax,$main_title,$x_title,$y_title);			
			$this->load->view('charts/chart_flash',$data);	
		}
	}
//---------------------------------------------------------------------------------------------------------------------------------	
	function chart_stat_monthly_uniq($id=null, $type=3, $month = 1, $year = 2008)
	{
		//miesieczne
		include_once('files/charts.class.php');
		
		if($id!=null)
		{
			$this->load->model('bazapg', '', 'pg');
			
			for($i=6;$i>=0;$i--)
			{
				$start_date = mktime (0,0,0,($month-$i),1,$year);
				$elemx[] = strftime("20%y-%m", $start_date);
				$end_date = mktime (0,0,0,($month-($i-1)),1,$year);
				$elemx_go[] = strftime("20%y-%m-%d", $start_date);
				$elemx_end[] = strftime("20%y-%m-%d", $end_date);
			}
			
			//print_r($elemx);
			//print_r($elemx_go);
			//print_r($elemx_end);
			
			// #X ELEMENTS
			// #Y ELEMENTS
		
			$elemy = Array(0,0,0,0,0,0,0);
			
			foreach($elemx as $key => $value)
			{
				$stats = $this->bazapg->get_stats_wykres_monthly_uniq($id,str_replace('-','',$elemx_go[$key]),str_replace('-','',$elemx_end[$key]));
				//print_r($stats);
				$elemy[$key] = @$stats[0]['rows'];	
			}
			
			$ymax = ceil(max($elemy));
			if($ymax==0)
			{
				$ymax = 1;			
			}
			// #FINDING A CONVENIENT SCALE FOR Y AXIS
			if ($ymax > 8)
			{
			    do
			    {
			        $div = $this->factors($ymax);
					$ymax++;
			    } while (!($scale = $this->hasAconvenientDiv($div)));
			
			    $ymax--;
			}else $scale=5;
	
			$data['domain_name'] = ' ';
			$data['elemx'] = $elemx;				
			$data['elemy'] = $elemy;
			$data['scale'] = $scale;
			$data['ymax'] = $ymax;				
			$this->load->view('charts/chart_stat_monthly_uniq',$data);
		}
	}
//---------------------------------------------------------------------------------------------------------------------------------
	function flash_chart_stat_yearly($id=null, $type=4, $year = 2008)
	{
		//miesieczne
		include_once('files/charts.class.php');
		$this->load->model('baza','','default');
		$this->load->model('bazapg', '', 'pg');
		
		$domain_name = $this->baza->get_doamin_name($id);	
		$domain_name = $domain_name['0']['domain'];
		
		if($id!=null)
		{
			$this->load->model('bazapg', '', 'pg');
			
			for($i=6;$i>=0;$i--)
			{
				$start_date = mktime (0,0,0,1,1,($year-$i));
				$elemx[] = strftime("20%y", $start_date);
			}
			
			// #X ELEMENTS
			// #Y ELEMENTS
		
			$elemy = Array(0,0,0,0,0,0,0);
			
			foreach($elemx as $key => $value)
			{
				$stats = $this->bazapg->get_stats_wykres_yearly($id,str_replace('-','',$value));
				//print_r($stats);
				$elemy[$key] = @$stats[0]['rows'];	
			}
			
			$ymax = ceil(max($elemy));
			if($ymax==0)
			{
				$ymax = 1;			
			}
			// #FINDING A CONVENIENT SCALE FOR Y AXIS
			if ($ymax > 8)
			{
			    do
			    {
			        $div = $this->factors($ymax);
					$ymax++;
			    } while (!($scale = $this->hasAconvenientDiv($div)));
			
			    $ymax--;
			}else $scale=5;
	
			$data['domain_name'] = ' ';
			$data['elemx'] = $elemx;				
			$data['elemy'] = $elemy;
			$data['scale'] = $scale;
			$data['ymax'] = $ymax;	
						
						
			$main_title = $domain_name." - ilość odsłon strony";
			$x_title 	= "Liczba odsłon z 7 lat: ".array_sum($elemy);
			$y_title 	= "Liczba odsłon";
						
			$data['chart'] = $this->getBarChart($elemy,$elemx,$ymax,$main_title,$x_title,$y_title);			
			$this->load->view('charts/chart_flash',$data);
		}
	}
//---------------------------------------------------------------------------------------------------------------------------------	
	function chart_stat_yearly($id=null, $type=4, $year = 2008)
	{
		//miesieczne
		include_once('files/charts.class.php');
		
		if($id!=null)
		{
			$this->load->model('bazapg', '', 'pg');
			
			for($i=6;$i>=0;$i--)
			{
				$start_date = mktime (0,0,0,1,1,($year-$i));
				$elemx[] = strftime("20%y", $start_date);
			}
			
			// #X ELEMENTS
			// #Y ELEMENTS
		
			$elemy = Array(0,0,0,0,0,0,0);
			
			foreach($elemx as $key => $value)
			{
				$stats = $this->bazapg->get_stats_wykres_yearly($id,str_replace('-','',$value));
				//print_r($stats);
				$elemy[$key] = @$stats[0]['rows'];	
			}
			
			$ymax = ceil(max($elemy));
			if($ymax==0)
			{
				$ymax = 1;			
			}
			// #FINDING A CONVENIENT SCALE FOR Y AXIS
			if ($ymax > 8)
			{
			    do
			    {
			        $div = $this->factors($ymax);
					$ymax++;
			    } while (!($scale = $this->hasAconvenientDiv($div)));
			
			    $ymax--;
			}else $scale=5;
	
			$data['domain_name'] = ' ';
			$data['elemx'] = $elemx;				
			$data['elemy'] = $elemy;
			$data['scale'] = $scale;
			$data['ymax'] = $ymax;				
			$this->load->view('charts/chart_stat_yearly',$data);
		}
	}
//---------------------------------------------------------------------------------------------------------------------------------
	function flash_chart_stat_yearly_uniq($id=null, $type=3, $month = 1, $year = 2008)
	{
		//miesieczne
		include_once('files/charts.class.php');
		$this->load->model('baza','','default');
		$this->load->model('bazapg', '', 'pg');
		
		$domain_name = $this->baza->get_doamin_name($id);	
		$domain_name = $domain_name['0']['domain'];
		
		if($id!=null)
		{
			$this->load->model('bazapg', '', 'pg');
			
			for($i=6;$i>=0;$i--)
			{
				$start_date = mktime (0,0,0,1,1,($year-$i));
				$elemx[] = strftime("20%y", $start_date);
				$end_date = mktime (0,0,0,1,1,($year-($i-1)));
				$elemx_go[] = strftime("20%y-%m-%d", $start_date);
				$elemx_end[] = strftime("20%y-%m-%d", $end_date);
			}
			
			/*print_r($elemx);
			print_r($elemx_go);
			print_r($elemx_end);
			*/
			// #X ELEMENTS
			// #Y ELEMENTS
		
			$elemy = Array(0,0,0,0,0,0,0);
			
			foreach($elemx as $key => $value)
			{
				$stats = $this->bazapg->get_stats_wykres_yearly_uniq($id,str_replace('-','',$elemx_go[$key]),str_replace('-','',$elemx_end[$key]));
				//print_r($stats);
				$elemy[$key] = @$stats[0]['rows'];	
			}
			
			$ymax = ceil(max($elemy));
			if($ymax==0)
			{
				$ymax = 1;			
			}
			// #FINDING A CONVENIENT SCALE FOR Y AXIS
			if ($ymax > 8)
			{
			    do
			    {
			        $div = $this->factors($ymax);
					$ymax++;
			    } while (!($scale = $this->hasAconvenientDiv($div)));
			
			    $ymax--;
			}else $scale=5;
	
			$data['domain_name'] = ' ';
			$data['elemx'] = $elemx;				
			$data['elemy'] = $elemy;
			$data['scale'] = $scale;
			$data['ymax'] = $ymax;				
			
			
			$main_title = $domain_name." - ilość unikatowych odsłon strony";
			$x_title = "Liczba unikatowych odsłon z 7 lat: ".array_sum($elemy);
			$y_title = "Liczba unikatowych odsłon";
			
			$data['chart'] = $this->getBarChart($elemy,$elemx,$ymax,$main_title,$x_title,$y_title);			
			$this->load->view('charts/chart_flash',$data);
		}
	}
//---------------------------------------------------------------------------------------------------------------------------------	
	function chart_stat_yearly_uniq($id=null, $type=3, $month = 1, $year = 2008)
	{
		//miesieczne
		include_once('files/charts.class.php');
		
		if($id!=null)
		{
			$this->load->model('bazapg', '', 'pg');
			
			for($i=6;$i>=0;$i--)
			{
				$start_date = mktime (0,0,0,1,1,($year-$i));
				$elemx[] = strftime("20%y", $start_date);
				$end_date = mktime (0,0,0,1,1,($year-($i-1)));
				$elemx_go[] = strftime("20%y-%m-%d", $start_date);
				$elemx_end[] = strftime("20%y-%m-%d", $end_date);
			}
			
			/*print_r($elemx);
			print_r($elemx_go);
			print_r($elemx_end);
			*/
			// #X ELEMENTS
			// #Y ELEMENTS
		
			$elemy = Array(0,0,0,0,0,0,0);
			
			foreach($elemx as $key => $value)
			{
				$stats = $this->bazapg->get_stats_wykres_yearly_uniq($id,str_replace('-','',$elemx_go[$key]),str_replace('-','',$elemx_end[$key]));
				//print_r($stats);
				$elemy[$key] = @$stats[0]['rows'];	
			}
			
			$ymax = ceil(max($elemy));
			if($ymax==0)
			{
				$ymax = 1;			
			}
			// #FINDING A CONVENIENT SCALE FOR Y AXIS
			if ($ymax > 8)
			{
			    do
			    {
			        $div = $this->factors($ymax);
					$ymax++;
			    } while (!($scale = $this->hasAconvenientDiv($div)));
			
			    $ymax--;
			}else $scale=5;
	
			$data['domain_name'] = ' ';
			$data['elemx'] = $elemx;				
			$data['elemy'] = $elemy;
			$data['scale'] = $scale;
			$data['ymax'] = $ymax;				
			$this->load->view('charts/chart_stat_yearly_uniq',$data);
		}
	}
	function chart_flash()
	{
		include 'files/php-ofc-library/open-flash-chart.php';
		
		srand((double)microtime()*1000000);
		
		$data_1 = array();
		$data_2 = array();
		$data_3 = array();
		for( $i=0; $i<9; $i++ )
		{
		    $data_1[] = rand(1,6);
		    $data_2[] = rand(7,13);
		    $data_3[] = rand(14,19);
		}
		
		$default_dot = new hollow_dot();
		$default_dot->size(5)->halo_size(0)->colour('#3D5C56');
		
		$line_dot = new line();
		$line_dot->set_default_dot_style($default_dot);
		$line_dot->set_width( 2 );
		$line_dot->set_colour( '#3D5C56' );
		$line_dot->set_values( $data_1 );
		$line_dot->set_key( "Line 1", 10 );
		
		
		$default_hollow_dot = new hollow_dot();
		$default_hollow_dot->size(4)->halo_size(1)->colour('#668053');
		
		$line_hollow = new line();
		$line_hollow->set_default_dot_style($default_hollow_dot);
		$line_hollow->set_width( 2 );
		$line_hollow->set_colour( '#668053' );
		$line_hollow->set_values( $data_2 );
		$line_hollow->set_key( "Line 2", 10 );
		
		$d = new hollow_dot();
		$d->size(4)->halo_size(1)->colour('#C25030');
		
		$line = new line();
		$line->set_default_dot_style($d);
		$line->set_width( 2 );
		$line->set_colour( '#C25030' );
		$line->set_values( $data_3 );
		$line->set_key( "Line 3", 10 );
		
		$y = new y_axis();
		$y->set_range( 0, 20, 5 ); 
		
		
		$x_labels = new x_axis_labels();
		$x_labels->set_steps( 2 );
		$x_labels->set_vertical();
		
		$x = new x_axis();
		$x->set_range( 0, 8, 1 );
		$x->set_labels( $x_labels );
		
		
		
		$chart = new open_flash_chart();
		$chart->set_title( new title( 'Wykres pozycji w google' ) );
		$chart->set_y_axis( $y );
		$chart->set_x_axis( $x );
		
		//
		$y_legend = new y_legend('Pozycja w google, im mniejsza tym lepiej');
		$y_legend->set_style( '{font-size: 12px; color: #000000}' );
		$chart->set_y_legend( $y_legend );
		
		//
		// here we add our data sets to the chart:
		//
		$chart->add_element( $line_dot );
		$chart->add_element( $line_hollow );
		$chart->add_element( $line );
		$chart->set_bg_colour('#FFFFFF');
		
		//
		// This is the VIEW section:
		//

		
		$data['chart'] = $chart;
		
		$this->load->view('charts/chart_flash',$data);		
	}
	
}
?>