<?php

class Admin extends Controller {

	function Admin()
	{
		parent::Controller();
		$this->load->library('session');	
		$this->load->helper(array('form', 'url','html'));
		$this->load->model('baza','',TRUE);
				
		$this->config->load('global_settings');	
		$this->global_settings = $this->config->item('global_settings');		
	}
	
	function _check_domain_owner($user_id, $domain_id)
	{
		$domain = $this->baza->check_domain_owner($user_id, $domain_id);
		
		if($domain!=null)
		{
			return true;
		}
		else
		{
			return redirect('/admin','location');	
		}
	}
	
	/*function test()
	{	
	 		$this->load->library('platnosci_pl',array('typ'=>'sem'));
		    $this->platnosci_pl->dodajLog(print_r($_POST,TRUE));   
		    $raport = $this->platnosci_pl->pobierzRaport();
		    $this->platnosci_pl->dodajLog(print_r($raport,TRUE));
		    
		    if (is_array($raport))
		    {
		     if ($raport['status'] == '99')
		     {		          
		     	 $id_transakcji = $this->platnosci_pl->pobierzIdTransakcji($raport['session_id']);		     
		    	 $this->load->model('baza_payments','',TRUE);
			  	 $this->baza_payments->zaplacono_platnosci_pl_sem($id_transakcji);		
		     }	     
		    }
	}*/
	
	function index($ticket_id = null)
	{
		
		if(isset($this->session->userdata['user_zalogowany']) and isset($this->session->userdata['di']))
		{	
			$user_data = $this->baza->get_user_login($this->session->userdata['user_zalogowany'], $this->session->userdata['di']);
			
			if($user_data==null)	
			{
				redirect('/admin/logout','location');
			}
			else 
			{
					redirect('/admin/start','location');
			}
		}
		else
		{
			$this->load->library('validation');
			$this->validation->set_error_delimiters('<span style="color:red;">', '<br /></span>');
			$fields['login_form'] = 'login_form';
			$fields['pass'] = 'pass';
			$this->validation->set_fields($fields);
			
			$login_form = $this->validation->login_form;
			$pass_form = $this->validation->pass;
			$rules['login_form'] = "callback_login_form_check|required";
			$rules['pass'] = "callback_pass_check[$login_form]|required";
			$this->validation->set_rules($rules);
		
			//reset sesji
			$this->session->sess_destroy();
			
			if ($this->validation->run() == FALSE)
			{
				$this->load->view('/layout/home');
			}
			else
			{	
				$haslo_md5 = md5($pass_form);
				$uzyt = $this->baza->user($login_form);
				$di = $uzyt[0]['id'];
				$this->session->set_userdata('user_zalogowany',$haslo_md5);
				$this->session->set_userdata('di',$di);
				
				if($ticket_id != null)
					redirect('/tickets/show/'.$ticket_id,'location');
				else					
					redirect('/admin/start','location');
			}
		}
	}
	function problem()
	{
		if(isset($this->session->userdata['user_zalogowany']) and isset($this->session->userdata['di']))
		{	
			$user_data = $this->baza->get_user_login($this->session->userdata['user_zalogowany'], $this->session->userdata['di']);
			
			if($user_data!=null)	
			{
				$data['user']  = $user_data[0]['name'];
				$this->load->view('/layout/problem_form',$data);
				return;
			}
		}
		$this->load->view('/layout/problem_form');
		
	}

	function start()
	{
		
		if(isset($this->session->userdata['user_zalogowany']) and isset($this->session->userdata['di']))
		{	
			$user_data = $this->baza->get_user_login($this->session->userdata['user_zalogowany'], $this->session->userdata['di']);
			
			if($user_data!=null)	
			{
                $this->load->model('ticket','',TRUE);
                $this->load->model('baza_payments','',TRUE);

				$data['user']       = $user_data[0]['name'];
                $data['messages']   = array();

                //liczba niedobranych wiadomości
                $user_account       = $this->baza->get_user_account($this->session->userdata['di']);
                $unreaded_tickets_msg   =   $this->ticket->get_info_about_unreaded_tickets($user_account['id']); //niedebrane tickety
                if(!empty($unreaded_tickets_msg))
                    $data['messages'][] = $unreaded_tickets_msg;

                //stan konta linkow sponsorowanych
                $stan_konta = $this->baza_payments->get_stan_konta_linkow_sponosrownych($this->session->userdata['di']);
                if($stan_konta <= $this->global_settings['klient']['ilosc_pieniedzy_na_adwords_do_alarmu']) $data['messages'][] = 'Niski stan konta linków sponsorowanych, proszę <a href="/admin/linki_sponsorowane"><b>doładować konto</b></a>';

                //brak dokumentów
                $stan_umow = $this->baza_payments->get_umowa_domains_status($this->session->userdata['di']);
                $stan_tmp = array();

                if(!empty($stan_umow))
                {                   
                   foreach($stan_umow as $domain)
                       $stan_tmp[] = $domain['domain'];
                }

                $stan_umow = array_unique($stan_tmp);
               // print_r($stan_umow);

                if(!empty($stan_umow))
                {                   
                   foreach($stan_umow as $domain)
                   {
                        $data['messages'][] = 'Brak wymaganych dokumentów dla domeny: '.$domain;
                   }
                }

                $data['content']    = $this->load->view('admin/start',$data,true);
                $this->load->view('/layout/default',$data);

				//$this->load->view('/layout/start_page',$data);
			}
			else
			{
				redirect('/admin/logout','location');	
			}		
		}
		else
		{
			redirect('/admin/','location');		
		}
	}
	
	//dodac do crona zeby sie wykonywalo, funckaj pobiera raport z mial i wklada go do bazy
	function linki_sponsorowane_add_to_database()
	{				
		//nie kasowac obsluga maila
		$this->load->library('zip');
		include_once('files/recieve_mail/receive_mail.php');
		$mail = new receiveMail;
		$mail->connect($mail->username,$mail->password);
		$mail->getTotalMails();
		
		$ilosc_maili = $mail->getTotalMails();
		
		if($ilosc_maili > 0)
		{
			for($i=1;$i<=$ilosc_maili;$i++)
			{		
				$header = $mail->getHeaders($i);
				
				if($header['from']=='adwords-noreply@google.com')
				{	
					$zip = $mail->GetAttech($i);
					 
					$fp = fopen('/home/networds/public_html/panel/files/report.zip', 'w');
					fwrite($fp, $zip);
					fclose($fp);
					
					$zip = zip_open("/home/networds/public_html/panel/files/report.zip");
					$buf = null;
					
					if ($zip) {
					    while ($zip_entry = zip_read($zip)) {
					        if (zip_entry_open($zip, $zip_entry, "r")) {
					          
					            $buf = zip_entry_read($zip_entry, zip_entry_filesize($zip_entry));					          
					            zip_entry_close($zip_entry);
					        }
					    }
					    zip_close($zip);
					}
					
					//dodanie gotowego raporu w xml do bazy
					if ($buf!=null) 
					{
				    	$xml = simplexml_load_string($buf);
				    	$stats = $xml->table->rows->row;
			
					    foreach($stats as $stat)
					    {					    	
					    	$this->baza->add_adwords_stats($stat);					    
					    }
					    unlink('/home/networds/public_html/panel/files/report.zip');
					}
				}
				$mail->deleteMails($i);
			}
		}
	}
	
	function linki_sponsorowane()
	{
		if(isset($this->session->userdata['user_zalogowany']) and isset($this->session->userdata['di']))
		{	
			$user_login_data = $this->baza->get_user_login($this->session->userdata['user_zalogowany'], $this->session->userdata['di']);
			$user_data = $this->baza->get_user_data($this->session->userdata['di']);
			
			if($user_login_data!=null and $user_data!=null)	
			{
				// pobranie i wyliczenie stanu konta linków sponsorowancyh
				$this->load->library('table');				 
				$this->load->model('baza_payments','',TRUE);
				$data_form['stan_konta'] = $this->baza_payments->get_stan_konta_linkow_sponosrownych($this->session->userdata['di']);
				$data_form['adwords_stats'] = $this->baza->get_adwords_last_7_days($this->session->userdata['di']);
				$data_form['total_adwords_stats'] = $this->baza->get_adwords_total($this->session->userdata['di']);

				//koniec pobrania i wyliczenia stanu konta linkow sponsorowancyh
								
				//$user_adwords_data = $this->baza->get_adwords_data($this->session->userdata['di']);
				//$user_adwords_faktury_data = $this->baza->get_adwords_factures_data($this->session->userdata['di']);	
				//print_r($user_adwords_data);
				//print_r($user_adwords_faktury_data);
							
				$data_form['kwota_poprawna'] = '';
				$data_form['vat']            = $this->baza_payments->get_vat();
				
				if(array_key_exists('kwota', $_POST))
				{
					if(!empty($_POST['kwota']))
					{	
						$kwota = (float) round(str_replace(',','.',$_POST['kwota']),2);	
						//echo $kwota;
						if(is_float($kwota))
						{
							if($kwota<50)
								$data_form['kwota_poprawna']  = '<br />Minimalna kwota doładowania wynosi 50 zł netto';
							else
							{
								$data_form['kwota_poprawna']  = 'next';
								$data_form['do_zaplaty_netto'] = $kwota;
								
								//dane do platnosci_pl
								$data_form['platnosci_pl_form_data'] = 'paltnosci_pl';
								$this->load->model('platnosci_pl_model','',TRUE);
								$data['user']  = $user_login_data[0]['name'];
										
								  $this->config->load('platnosci_pl_sem');
								  $testowe = $this->config->item('testowe_platnosci','platnosci_pl');
								  $typ_platnosci = $this->config->item('typ_platnosci','platnosci_pl');
								 
								  $this->load->library('platnosci_pl',array('typ'=>'sem'));
								  $this->platnosci_pl->ustaw_pay_type($typ_platnosci);
								  
								  if ($testowe)
								  {
								    $this->platnosci_pl->ustaw_pay_type('t');
								  }				 
								  			
								  $data_form['kodowanie'] = $this->platnosci_pl->kodowanie();
								  $data_form['procedura'] = $this->platnosci_pl->procedura_new();
								  $data_form['pay_type'] = $this->platnosci_pl->pay_type();
								  $data_form['first_name'] = trim($user_data[0]['company_name']);
								  $data_form['last_name'] =  trim($user_data[0]['contact_name']);
								  $data_form['email'] = trim($user_data[0]['email']);
								  $data_form['pos_id'] = $this->platnosci_pl->pos_id();
								  $data_form['pos_auth_key'] = $this->platnosci_pl->pos_auth_key();
								  $data_form['session_id'] = time();

                                  $vat =$this->baza_payments->get_vat();

								  //$data_form['amount'] = ($kwota*1.22)*100;
                                  $data_form['amount'] = ($kwota*(1 + $vat))*100;

								  $data_form['desc'] = 'Sem: '.trim($user_data[0]['company_name']);
								  $data_form['desc2'] = $user_data[0]['user_id'];// user_id w systemie ktory dokonywal doladowania sem przez platnosc.pl
								  $data_form['client_ip'] = $_SERVER['REMOTE_ADDR'];
								  $data_form['ts'] = time();
				
								   $data_form['sig'] = $this->platnosci_pl->sig(
								   $data_form['session_id'],
								   $data_form['amount'],
								   $data_form['desc'],
								   $data_form['desc2'],
								   "",
								   "",
								   $data_form['first_name'],
								   $data_form['last_name'],
								   "",
								   "",
								   "",
								   "",
								   "",
								   "",
								   "",
								   $data_form['email'],
								   "",
								   "",
								   $data_form['client_ip'],
								   $data_form['ts']
								  );
								  
								$this->platnosci_pl->dodajNowaTransakcjeDoSystemu($data_form['session_id']);				  				
								
								//koniec dancyh do platnosci_pl
							}
						}
						else
						{
							$data_form['kwota_poprawna']  = '<br />Kwota nie poprawna';
						}					
					}
					else
					{
						$data_form['kwota_poprawna']  = '<br />Nie podano kwoty doładowania';
					}
				}	
		
				//$this->load->model('baza_payments','',TRUE);
				$data['user']  = $user_login_data[0]['name'];
				//$data_f['faktury']  = $this->baza_payments->get_factures($this->session->userdata['di']);		
				$data['content']  = $this->load->view('admin/linki_sponsorowane',$data_form,true);
				$this->load->view('/layout/default',$data);
			}
			else
			{
				redirect('/admin/logout','location');	
			}		
		}
		else
		{
			redirect('/admin/','location');		
		}
	}

    function linki_sponsorowane_doladowano()
	{
        if(isset($this->session->userdata['user_zalogowany']) and isset($this->session->userdata['di']))
		{	
			$user_data = $this->baza->get_user_login($this->session->userdata['user_zalogowany'], $this->session->userdata['di']);
			
			if($user_data!=null)	
			{
                $data['user']  = $user_data[0]['name'];
                $data['content']  = $this->load->view('admin/linki_sponsorowne_doladowano',null,true);
                $this->load->view('/layout/default',$data);
            }
			else
			{
				redirect('/admin/logout','location');
			}
		}
		else
		{
			redirect('/admin/','location');
		}
    }
	function newcampaign()
    {
  
		if(isset($this->session->userdata['user_zalogowany']) and isset($this->session->userdata['di']))
		{
			$user_data = $this->baza->get_user_login($this->session->userdata['user_zalogowany'], $this->session->userdata['di']);


			if($user_data!=null)
			{
                $data['user']  = $user_data[0]['name'];
             
                $this->config->load('alerts');
                $alerts           =  $this->config->item('alerts');
                $values           = null;
                $errors           = null;

                if(!empty($_POST))
                {
                    if(!empty($_POST['form']) && ($_POST['form']=='tab1'))
                    {
                        $values['tab1']['website']  =   trim(strip_tags($_POST['website']));
                        $values['tab1']['keywords'] =   trim(strip_tags($_POST['keywords']));
                        $values['tab1']['notes']    =   trim(strip_tags($_POST['notes']));

                        if(empty($values['tab1']['website']))
                            $errors['tab1']['website']  =   $alerts['field_required'];

                    }
                    elseif(!empty($_POST['form']) && ($_POST['form']=='tab2'))
                    {
                        $values['tab2']['website']                  =   trim(strip_tags($_POST['website']));
                        $values['tab2']['start_date']               =   trim(strip_tags($_POST['start_date']));
                        $values['tab2']['cele_biznesowe']           =   trim(strip_tags($_POST['cele_biznesowe']));
                        $values['tab2']['najwazniejsze_produkty']   =   trim(strip_tags($_POST['najwazniejsze_produkty']));
                        $values['tab2']['czynniki_wyrozniajace']    =   trim(strip_tags($_POST['czynniki_wyrozniajace']));
                        $values['tab2']['dostepnosc_ofert']         =   trim(strip_tags($_POST['dostepnosc_ofert']));
                        $values['tab2']['obszar_dzialalnosci']      =   trim(strip_tags($_POST['obszar_dzialalnosci']));
                        $values['tab2']['docelowi_odbiorcy']        =   trim(strip_tags($_POST['docelowi_odbiorcy']));
                        $values['tab2']['pozadane_dzialania']       =   trim(strip_tags($_POST['pozadane_dzialania']));
                        $values['tab2']['wysokosc_budzetu']         =   trim(strip_tags($_POST['wysokosc_budzetu']));

                        if(empty($values['tab2']['website']))
                            $errors['tab2']['website']  =   $alerts['field_required'];

                    }
                    if(empty($errors['tab1']['website']) && empty($errors['tab2']['website']))
                    {
                        $this->load->model('ticket','',TRUE);

                        $manager_id 		= $this->baza->get_admin_manager_id($this->session->userdata['di']);
                        $superadmin_account = $this->baza->get_super_admin_account($manager_id);
                        $superadmin_data    = $this->baza->get_superadmin_data($manager_id);
                        $admin_account 		= $this->baza->get_admin_account($this->session->userdata['di']);

                        if(empty($superadmin_account) || empty($superadmin_data) || empty($admin_account) || empty($manager_id))
                            $data['info'] = $alerts['operation_fail'];
                        else
                        {
                                $temat 		= 'Zgłoszenie nowej kampanii adwords';
                                $wiadomosc 	= '';

                                if($_POST['form']=='tab1')
                                {
                                    $wiadomosc .= 'Reklamowana strona www: '.$values['tab1']['website']."\n";
                                    $wiadomosc .= "Słowa kluczowe: ".$values['tab1']['keywords']."\n";
                                    $wiadomosc .= "Uwagi: ".$values['tab1']['notes']."\n";
                                }
                                elseif($_POST['form']=='tab2')
                                {
                                    $wiadomosc .= 'Reklamowana strona www: '.$values['tab2']['website']."\n";
                                    $wiadomosc .= 'Data rozpoczęcia kampanii: '.$values['tab2']['start_date']."\n";
                                    $wiadomosc .= 'Cele biznesowe i model działania firmy: '.$values['tab2']['cele_biznesowe']."\n";
                                    $wiadomosc .= 'Najważniejsze produkty i/lub usługi: '.$values['tab2']['najwazniejsze_produkty']."\n";
                                    $wiadomosc .= 'Czynniki wyróżniające firmę na tle konkurencji: '.$values['tab2']['czynniki_wyrozniajace']."\n";
                                    $wiadomosc .= 'Dostępność ofert specjalnych lub promocji: '.$values['tab2']['dostepnosc_ofert']."\n";
                                    $wiadomosc .= 'Obszar działalności firmy: '.$values['tab2']['obszar_dzialalnosci']."\n";
                                    $wiadomosc .= 'Docelowi odbiorcy: '.$values['tab2']['docelowi_odbiorcy']."\n";
                                    $wiadomosc .= 'Pożądane działania użytkownika Google po dotarciu do witryny firmy w wyniku kliknięcia reklamy: '.$values['tab2']['pozadane_dzialania']."\n";
                                    $wiadomosc .= 'Wysokość budżetu na reklamę: '.$values['tab2']['wysokosc_budzetu']."\n";
                                }

                                    $ticket_id 		  = $this->ticket->add($admin_account['id'],$superadmin_account['id'],3,1,2,$temat,$wiadomosc,null,0);
                                    $ticket_status 	  = $this->ticket->get_status_name_by_id(1);
                                    $ticket_kategoria = 3;
                                    $do				  = $superadmin_data[0]['email'];
                                    $user_type     	  = $this->ticket->get_user_type_by_account_id($superadmin_account['id']);

                                    if($ticket_id)
                                    {
                                        $this->ticket->send_email($ticket_id,$ticket_status,$ticket_kategoria,$do,$user_type);
                                        $data['info']       = $alerts['operation_success'];
                                        $values     		= null;
                                    }
                                    else
                                        $data['info'] = $alerts['operation_fail'];
                        }
                    }
                }
               
                $data['errors']     = $errors;
                $data['values']     = $values;
                $data['content']    = $this->load->view('admin/new_campaign',$data,true);
				$this->load->view('/layout/default',$data);
			}
			else
			{
				redirect('/admin/logout','location');
			}
		}
		else
		{
			redirect('/admin/','location');
		}
    }

	function faktury()
	{
		
		if(isset($this->session->userdata['user_zalogowany']) and isset($this->session->userdata['di']))
		{	
			$user_data = $this->baza->get_user_login($this->session->userdata['user_zalogowany'], $this->session->userdata['di']);
			
			if($user_data!=null)	
			{
				$this->load->model('baza_payments','',TRUE);
				$data['user']  = $user_data[0]['name'];
				$data_f['faktury'] = $this->baza_payments->get_factures($this->session->userdata['di']);
				$data_f['faktury_sem'] = $this->baza_payments->get_factures_sem($this->session->userdata['di']);
				$data_f['faktury_sem_proforma'] = $this->baza_payments->get_factures_sem_proforma($this->session->userdata['di']);		
				$data['content'] = $this->load->view('admin/faktury',$data_f,true);
				$this->load->view('/layout/default',$data);
				
			}
			else
			{
				redirect('/admin/logout','location');	
			}		
		}
		else
		{
			redirect('/admin/','location');		
		}
	}

    function show_contract($contract_id)
	{
		$contract = $this->baza->get_user_contract_authorized($contract_id,$this->session->userdata['di']);
		if($contract)
		{
			$file_handle 	= fopen($contract['sciezka'],"r");
			$file_name      = basename($contract['sciezka']);

			header('Content-Type: application/pdf');
			header('Content-Disposition: inline; filename="'.$file_name.'"');
			//header('Cache-Control: private, max-age=0, must-revalidate');
			echo file_get_contents($contract['sciezka']);
		}
		else
			echo 'error';
	}
	
	function domain()
	{
		if(isset($this->session->userdata['user_zalogowany']) and isset($this->session->userdata['di']))
		{	
			$user_data = $this->baza->get_user_login($this->session->userdata['user_zalogowany'], $this->session->userdata['di']);
			
			if($user_data!=null)	
			{
				$data['user']  = $user_data[0]['name'];
				$domains = $this->baza->get_domains($this->session->userdata['di']);
				$data['domains'] = $domains;
				
				
				//$this->load->view('/layout/domain_page',$data);
                $data['content']    =   null;
                if($this->uri->segment(1)=='master')
                    $data['content']    =   $this->load->view('domains/domain_table',$data,true);

                if($this->uri->segment(1)=='superadmin')
                    $data['content']    =   $this->load->view('domains/domain_table_superadmin',$data,true);

                if($this->uri->segment(1)=='admin')
                    $data['content']    =   $this->load->view('domains/domain_table_admin',$data,true);

                $this->load->view('/layout/default',$data);
				
			}
			else
			{
				redirect('/admin/logout','location');	
			}		
		}
		else
		{
			redirect('/admin/','location');		
		}
	}
	function newdomain()
	{
		if(isset($this->session->userdata['user_zalogowany']) and isset($this->session->userdata['di']))
		{	
			$user_data = $this->baza->get_user_login($this->session->userdata['user_zalogowany'], $this->session->userdata['di']);
			
			if($user_data!=null)	
			{
				$data['user']  = $user_data[0]['name'];
				if(isset($_POST['newdomain']))
				{
					$errors 			= null;
					$values     		= null;
					
					$domena 			= $_POST['domena'];
					$keywords 			= $_POST['keywords'];
					$uwagi      		= $_POST['uwagi'];
					
					$values['domena'] 	= strip_tags($domena);
					$values['keywords'] = strip_tags($keywords);
					$values['uwagi'] 	= strip_tags($uwagi);
										
					if(empty($domena))
						$errors['domena'] = 'Pole wymagane';
					
					if($errors == null)
					{
						$this->load->model('ticket','',TRUE);
						
						$manager_id 		= $this->baza->get_admin_manager_id($this->session->userdata['di']);
						$superadmin_account = $this->baza->get_super_admin_account($manager_id); 
						$superadmin_data    = $this->baza->get_superadmin_data($manager_id);
						$admin_account 		= $this->baza->get_admin_account($this->session->userdata['di']);


						if(empty($superadmin_account) || empty($superadmin_data) || empty($admin_account) || empty($manager_id))
                            $data['info'] = $alerts['operation_fail'];
                        else
                        {
                            $temat 		= 'Zgłoszenie nowej domeny';
                            $wiadomosc 	= 'Domena: '.$domena.'<br/>Keywords: '.$keywords.'<br/>Uwagi: '.$uwagi;

                            $ticket_id 		  = $this->ticket->add($admin_account['id'],$superadmin_account['id'],3,1,2,$temat,$wiadomosc,null,0);
                            $ticket_status 	  = $this->ticket->get_status_name_by_id(1);
                            $ticket_kategoria = 3;
                            $do				  = $superadmin_data[0]['email'];

                            $user_type     	  = $this->ticket->get_user_type_by_account_id($superadmin_account['id']);
                            
                            if($ticket_id)
                            {
                                if($this->ticket->send_email($ticket_id,$ticket_status,$ticket_kategoria,$do,$user_type))
                                    $data['info']       = 'Formularz został wysłany';
                                $errors 			= null;
                                $values     		= null;
                            }
                            else
                                $data['info'] = 'Wystapił błąd. Formularz nie został wysłany';
                        }
					}
					
					$data['values'] = $values;
					$data['errors']	= $errors;	
					
				}
				$data['content'] = $this->load->view('/admin/new_domain',$data,true);
                $this->load->view('/layout/default',$data);
				
			}
			else
			{
				redirect('/admin/logout','location');	
			}		
		}
		else
		{
			redirect('/admin/','location');		
		}		
	}
	
	function show_domain_stat($id=null)
	{
		if(isset($this->session->userdata['user_zalogowany']) and isset($this->session->userdata['di']))
		{	
			$user_data = $this->baza->get_user_login($this->session->userdata['user_zalogowany'], $this->session->userdata['di']);
			
			if($user_data!=null)	
			{
				$data['user']  = $user_data[0]['name'];
				
				if($id!=null)
				{
					$this->_check_domain_owner($this->session->userdata['di'], $id);
					$keywords               = $this->baza->get_domain($id);
					$data['pozycja']        = $this->baza->get_domain_key_position($id);
					$data['keywords']       = $keywords;
					$data['colors']         = $this->global_settings['chart_line_colors'];
                    $data['google_region']	= $this->baza->google_region($id);
					
					//$this->load->view('/layout/show_domain_page',$data);
                    $data['mainContent']    = $this->load->view('domains/show_domain_table',$data,true);
                    $this->load->view('/layout/show_chart_domain_page',$data);
				}
				else{
					$this->load->view('blad',$data);
				}
			}
			else
			{
				redirect('/admin/logout','location');	
			}		
		}
		else
		{
			redirect('/admin/','location');		
		}
	}
	
	function show_domain_chart($id=null,$type = 1,$elem_start = 0)
	{
		if(isset($this->session->userdata['user_zalogowany']) and isset($this->session->userdata['di']))
		{	
			$user_data = $this->baza->get_user_login($this->session->userdata['user_zalogowany'], $this->session->userdata['di']);
			
			if($user_data!=null)	
			{
				$data['user']  = $user_data[0]['name'];
				
				if($id!=null)
				{	
					$this->_check_domain_owner($this->session->userdata['di'], $id);
					$keywords = $this->baza->get_keyword_position($id);
					$data['keywords']=$keywords;
					
					$data['colors']	  	    = $this->global_settings['chart_line_colors'];
					$data['domain_id']	    = $id;			
					$data['google_region']	= $this->baza->google_region($id);

                            switch($type)
                            {
                                case 1: {
                                            // "Dzienne";
                                            $data['name_of_type'] = "Dzienne";
                                            $prefs = array (
                                                            'show_next_prev'  => TRUE,
                                                            'next_prev_url'   => '/admin/show_domain_chart/'.$id.'/'.$type.'',
                                                            'month_type'   => 'long',
                                                            'day_type'     => 'short'
                                                            );

                                        /*$prefs['template'] = '

                                                           {table_open}<table border="1" cellpadding="0" cellspacing="0" class="tablesorter" style="width:140px !important;">{/table_open}

                                                           {heading_row_start}<tr>{/heading_row_start}

                                                           {heading_previous_cell}<th ><a href="{previous_url}/01">&lt;&lt;</a></th>{/heading_previous_cell}
                                                           {heading_title_cell}<th colspan="{colspan}">{heading}</th>{/heading_title_cell}
                                                           {heading_next_cell}<th><a href="{next_url}/01">&gt;&gt;</a></th>{/heading_next_cell}

                                                           {heading_row_end}</tr>{/heading_row_end}

                                                           {week_row_start}<tr>{/week_row_start}
                                                           {week_day_cell}<td width="20">{week_day}</td>{/week_day_cell}
                                                           {week_row_end}</tr>{/week_row_end}

                                                           {cal_row_start}<tr>{/cal_row_start}
                                                           {cal_cell_start}<td width="20">{/cal_cell_start}

                                                           {cal_cell_content}<a href="{content}">{day}</a>{/cal_cell_content}
                                                           {cal_cell_content_today}<div class="highlight"><a href="{content}">{day}</a></div>{/cal_cell_content_today}

                                                           {cal_cell_no_content}{day}{/cal_cell_no_content}
                                                           {cal_cell_no_content_today}<div class="highlight">{day}</div>{/cal_cell_no_content_today}

                                                           {cal_cell_blank}&nbsp;{/cal_cell_blank}

                                                           {cal_cell_end}</td>{/cal_cell_end}
                                                           {cal_row_end}</tr>{/cal_row_end}

                                                           {table_close}</table>{/table_close}';*/

                                           $prefs['template'] = $this->global_settings['calendar_template'];
                                           $this->load->library('calendar', $prefs);

                                            break;
                                        }
                                case 2: {
                                            // "Tygodniowe";
                                            $data['name_of_type'] = "Tygodniowe";
                                            //include_once('files/dateclass.php');
                                            break;
                                        }
                                case 3: {
                                            // "Miesieczne";
                                            $data['name_of_type'] = "Miesieczne";
                                            break;
                                        }
                                case 4: {
                                            // "Roczne";
                                            $data['name_of_type'] = "Roczne";
                                            break;
                                        }
                            }
								
					//$this->load->view('/layout/show_chart_domain_page',$data);

                    $data['mainContent'] = $this->load->view('domains/show_domain_chart',$data,true);
                    $this->load->view('/layout/show_chart_domain_page',$data);
				}
				else{
					$this->load->view('blad',$data);
				}
			}
			else
			{
				redirect('/admin/logout','location');	
			}		
		}
		else
		{
			redirect('/admin/','location');		
		}
	}
	
	
	function show_domain_keyword_activity($id = null, $elem_start = 0)
	{
		if(isset($this->session->userdata['user_zalogowany']) and isset($this->session->userdata['di']))
		{	
			$user_data = $this->baza->get_user_login($this->session->userdata['user_zalogowany'], $this->session->userdata['di']);
			
			if($user_data!=null)	
			{
				$this->load->model('bazapg','','pg');
				$data['user']  = $user_data[0]['name'];
				$data['stats'] = $this->bazapg->get_stats_pagination($id,$elem_start,15);
				$this->load->library('pagination');
				$number_of_rows = $this->bazapg->count_stats($id);
				if(empty($number_of_rows[0]['ile'])) $number_of_rows[0]['ile']=0;
				
				$config['base_url'] = "/admin/show_domain_keyword_activity/$id/";
				$config['url_extention']= '';
				$config['total_rows'] = $number_of_rows[0]['ile'];
				$config['per_page'] = '15';
				$config['num_links'] = '9';
				$config['uri_segment'] = 4;
				$config['first_link'] = '<<';
				$config['last_link'] = '>>';
				
				$this->pagination->initialize($config);
				$data['paginacja'] = $this->pagination->create_links();					
				$data['domain_id']=$id;						
				//$this->load->view('/layout/show_domain_search_term',$data);
                
                $data['mainContent'] = $this->load->view('domains/show_domain_keyword_activity',$data,true);
                $this->load->view('/layout/show_chart_domain_page',$data);
	
			}
			else
			{
				redirect('/admin/logout','location');	
			}
		}		
		else
		{
			redirect('/admin/','location');		
		}
	}
	
	function show_domain_statcounter($id = null, $type = 1, $elem_start = 0)
	{
		if(isset($this->session->userdata['user_zalogowany']) and isset($this->session->userdata['di']))
		{	
			$user_data = $this->baza->get_user_login($this->session->userdata['user_zalogowany'], $this->session->userdata['di']);
			
			if($user_data!=null)	
			{
				$data['user']  = $user_data[0]['name'];
				
				if($id!=null)
				{	
					$this->load->library('pagination');
					$this->_check_domain_owner($this->session->userdata['di'], $id);
		
					switch($type)
					{
					    case 1: {
					    			// "Dzienne"; 
									$data['name_of_type'] = "Dzienne"; 
									$prefs = array (
           					    					'show_next_prev'  => TRUE,
               										'next_prev_url'   => '/admin/show_domain_statcounter/'.$id.'/'.$type.'',
							    					'month_type'   => 'long',
							    					'day_type'     => 'short'
             										);
								
								/*$prefs['template'] = '
			
												   {table_open}<table border="0" cellpadding="0" cellspacing="0" class="tablesorter" style="width:140px !important;">{/table_open}
												
												   {heading_row_start}<tr>{/heading_row_start}
												
												   {heading_previous_cell}<th><a href="{previous_url}/01">&lt;&lt;</a></th>{/heading_previous_cell}
												   {heading_title_cell}<th colspan="{colspan}">{heading}</th>{/heading_title_cell}
												   {heading_next_cell}<th><a href="{next_url}/01">&gt;&gt;</a></th>{/heading_next_cell}
												
												   {heading_row_end}</tr>{/heading_row_end}
												
												   {week_row_start}<tr>{/week_row_start}
												   {week_day_cell}<td>{week_day}</td>{/week_day_cell}
												   {week_row_end}</tr>{/week_row_end}
												
												   {cal_row_start}<tr>{/cal_row_start}
												   {cal_cell_start}<td>{/cal_cell_start}
												
												   {cal_cell_content}<a href="{content}">{day}</a>{/cal_cell_content}
												   {cal_cell_content_today}<div class="highlight"><a href="{content}">{day}</a></div>{/cal_cell_content_today}
												
												   {cal_cell_no_content}{day}{/cal_cell_no_content}
												   {cal_cell_no_content_today}<div class="highlight">{day}</div>{/cal_cell_no_content_today}
												
												   {cal_cell_blank}&nbsp;{/cal_cell_blank}
												
												   {cal_cell_end}</td>{/cal_cell_end}
												   {cal_row_end}</tr>{/cal_row_end}
												
												   {table_close}</table>{/table_close}';*/
                                    
								   $prefs['template'] = $this->global_settings['calendar_template'];
								   $this->load->library('calendar', $prefs);
									
									break;
								}
					    case 2: {
					    			// "Tygodniowe"; 
									$data['name_of_type'] = "Tygodniowe";
									//include_once('files/dateclass.php');
									break;
								}
					    case 3: {
					    			// "Miesieczne";
									$data['name_of_type'] = "Miesieczne";
									break;
								}
					    case 4: {
					    			// "Roczne";
									$data['name_of_type'] = "Roczne";
									break;
								}
					}
					
					
					//$this->load->model('bazapg','','pg');
					
					//$data['selected']=$selected_category;
					//$data['stats'] = $this->bazapg->get_stats_pagination($id,$elem_start,50);
					//$counter=$this->gallery->count_category_pictures($selected_category);
					//$this->load->library('pagination');
					//$number_of_rows = $this->bazapg->count_stats($id);

					/*
					$config['base_url'] = "/admin/show_domain_statcounter/$id/$type/$elem_start/";
					$config['url_extention']= '';
					$config['total_rows'] = $number_of_rows[0]['ile'];
					$config['per_page'] = '50';
					$config['num_links'] = '9';
					$config['uri_segment'] = 6;
					$config['first_link'] = '<<';
					$config['last_link'] = '>>';
					
					$this->pagination->initialize($config);
					$data['paginacja'] = $this->pagination->create_links();	
					*/
					$data['domain_id']=$id;
					//$data['stats'] = $this->bazapg->get_stats($id, $elem_start, 12);
					$data['type'] = $type;						
					$this->load->view('/layout/show_stats_chart_domain_page',$data);
				}
				else{
					$this->load->view('blad',$data);
				}
				
			}
			else
			{
				redirect('/admin/logout','location');	
			}		
		}
		else
		{
			redirect('/admin/','location');		
		}
	}
	
	function profile()
	{
		if(isset($this->session->userdata['user_zalogowany']) and isset($this->session->userdata['di']))
		{	
			$user_data = $this->baza->get_user_login($this->session->userdata['user_zalogowany'], $this->session->userdata['di']);
		
			if($user_data!=null)	
			{
				$data['user']  = $user_data[0]['name'];
		
				if(!empty($_POST['id']))
				{
							$this->load->library('walidacja');
							$this->config->load('alerts');
								
							$alerts		=  $this->config->item('alerts');
							$values 	=	null;
							$errors     =   null;
							
							$values['id']				=	(int)$_POST['id'];
							$values['user_id']			=	(int)$_POST['user_id'];
							$values['company_name']		=	trim(strip_tags($_POST['company_name']));
							$values['contact_name']		=	trim(strip_tags($_POST['contact_name']));
							$values['tax_id']			=	trim(strip_tags($_POST['tax_id']));
							$values['website']			=   trim(strip_tags($_POST['website']));
							$values['email']			=   trim(strip_tags($_POST['email']));
							$values['city']				=	trim(strip_tags($_POST['city']));
							$values['post_code']		=	trim(strip_tags($_POST['post_code']));
							$values['street']			=	trim(strip_tags($_POST['street']));
							$values['b_no']				=	trim(strip_tags($_POST['b_no']));
							$values['a_no']				=	trim(strip_tags($_POST['a_no']));		//nullable
							$values['dk_miasto']		=	trim(strip_tags($_POST['dk_miasto']));		//nullable
							$values['dk_ulica']			=	trim(strip_tags($_POST['dk_ulica']));		//nullable
							$values['dk_kod_pocztowy']	=	trim(strip_tags($_POST['dk_kod_pocztowy']));		//nullable
							$values['dk_nr_domu']		=	trim(strip_tags($_POST['dk_nr_domu']));			//nullable
							$values['dk_nr_mieszkania']	=	trim(strip_tags($_POST['dk_nr_mieszkania']));	//nullable
							$values['dk_telefon']		=	trim(strip_tags($_POST['dk_telefon']));			//nullable
							
							
							//walidacja
							if(empty($values['id']))
								$errors['id']					=	$alerts['field_required'];
							if(empty($values['user_id']))
								$errors['user_id']				=	$alerts['field_required'];
								

							if(empty($values['contact_name']))
								$errors['contact_name']			=	$alerts['field_required'];
								
							if(empty($values['tax_id']))
								$errors['tax_id']				=	$alerts['field_required'];
							elseif(!$this->walidacja->CheckNIP(str_replace('-', '', $values['tax_id'])))
								$errors['tax_id']				=	$alerts['field_invalid'];	
							
							//website	
							$website = str_replace(array("http",":","/"),"",$values['website']);
							if(!empty($values['website']) && !$this->walidacja->CheckURL("http://".$website."/"))
								$errors['website']				=	$alerts['field_invalid'];
							
							//email
							if(empty($values['email']))
								$errros['email']				=	$alerts['field_required'];
							elseif(!$this->walidacja->CheckEmail($values['email']))
								$errors['email']				=	$alerts['field_invalid'];
							
							//city						
							if(empty($values['city']))
								$errors['city']					=	$alerts['field_required'];
							//kod pocztowy
							if(empty($values['post_code']))
								$errors['post_code']			=	$alerts['field_required'];
							//ulica
							if(empty($values['street']))
								$errors['street']				=	$alerts['field_required'];
							//nr budynku
							if(empty($values['b_no']))
								$errors['b_no']					=	$alerts['field_required'];
								
							//dane korespondencyjne	- jeśli ktoś podał chociaż jedno pole to walidacja
							if(!empty($values['dk_miasto']) || !empty($values['dk_ulica']) || !empty($values['dk_kod_pocztowy']) || !empty($values['dk_nr_domu']) || !empty($values['dk_nr_mieszkania']) || !empty($values['dk_telefon']))
							{
								if(empty($values['dk_miasto']))
									$errors['dk_miasto']			=	$alerts['field_required'];
								
								if(empty($values['dk_ulica']))
									$errors['dk_ulica']				=	$alerts['field_required'];
									
								if(empty($values['dk_kod_pocztowy']))
									$errors['dk_kod_pocztowy']		=	$alerts['field_required'];
									
								if(empty($values['dk_nr_domu']))
									$errors['dk_nr_domu']		=	$alerts['field_required'];																											
							}	
							
														
							if (is_null($errors))							
							{						
								if($this->baza->update_user_data($values['id'],$values['user_id'],$values['company_name'],$values['contact_name'],$values['tax_id'],$values['website'],$values['email'],$values['city'],$values['post_code'],$values['street'],$values['b_no'],$values['a_no'],$values['dk_miasto'],$values['dk_ulica'],$values['dk_kod_pocztowy'],$values['dk_nr_domu'],$values['dk_nr_mieszkania'],$values['dk_telefon']))
								{
									$data['info'] = $alerts['operation_success'];
									$errors 	  = null;
									$values       = null;
								}
								else
								{
									$data['info'] = $alerts['operation_fail'];
								}
							}
							else
							{
								$data['info'] = $alerts['operation_fail'];
							}
							
							$data['values']			=	$values;
							$data['errors']			=	$errors;
									
							$data['user_data'] 		= $this->baza->get_user_data($this->session->userdata['di']);
							//$data['user_data'][0] 	+= $this->baza->get_user_account($_POST['user_id']);
							//$this->load->view('/layout/profile_page',$data);
                           
                            $data['content'] = $this->load->view('admin/profile',$data,true);
                            $this->load->view('/layout/default',$data);
				}
				else
				{
                    
                    
					$data['user_data']      =  $this->baza->get_user_data($this->session->userdata['di']);
					//$data['user_data'][0]   += $this->baza->get_user_account($this->session->userdata['di']);
					//$this->load->view('/layout/profile_page',$data);
                    
                    $data['content'] = $this->load->view('admin/profile',$data,true);
                    $this->load->view('/layout/default',$data);
				}	
				
			}
			else
			{
				redirect('/admin/logout','location');	
			}		
		}
		else
		{
			redirect('/admin/','location');		
		}
	}
	
	function login_form_check($str)
	{
		$user=$this->baza->user($str); 
		
		if ($user==null or $str==null)
		{
				$this->validation->set_message('login_form_check', 'Błędny login');
				return FALSE;
		}
		else
		{
				return TRUE;
		}
	}

	function pass_check($pass,$login)
	{
		if($pass==null or $login==null)
		{
			$password = null; 	
		}
		else	
		{
			$haslo = md5($pass);
			$password = $this->baza->check_user_pass($haslo, $login); 	
		}
		
		if ($password == null)
		{
			$this->validation->set_message('pass_check', 'Błędne hasło');
			return FALSE;
		}
		else
		{	
			return TRUE;
		}
	}
	
	function change_pass()
	{	
		if(isset($this->session->userdata['user_zalogowany']) and isset($this->session->userdata['di']))
		{	
			$user_data = $this->baza->get_user_login($this->session->userdata['user_zalogowany'], $this->session->userdata['di']);
			
			if($user_data!=null)	
			{
				$user  = $user_data[0]['name'];
				$data['user']=	$user_data[0]['name'];
				$this->load->helper(array('form', 'url'));
				$this->load->library('validation');
				$this->validation->set_error_delimiters('<span style="color:red;">', '<br /></span>');
				
				$fields['old_pass'] = 'old_pass';
				$fields['new_pass'] = 'new_pass';
				$fields['new_pass_repeat'] = 'new_pass_repeat';
				$this->validation->set_fields($fields);
				
				$new_pass = $this->validation->new_pass;
				$new_pass_repeat = $this->validation->new_pass_repeat;
				
				$rules['old_pass'] = "callback_old_pass_check[$user]|required";
				$rules['new_pass'] = "callback_new_pass_check[$new_pass_repeat]|required";
				$rules['new_pass_repeat'] = "callback_new_pass_repeat_check[$new_pass]|required";
				$this->validation->set_rules($rules);
				
				if ($this->validation->run() == FALSE)
				{
					$this->load->view('/layout/change_pass_page',$data);
				}
				else
				{		
					if($new_pass!=null)
					{
						$haslo = md5($new_pass);
	
						if($this->baza->user_new_pass($user,$haslo))
						{			
							$data['nowe_haslo'] = $new_pass;
							redirect('/admin/logout','location');
							
							
						}else $this->load->view('blad',$data);
					}else $this->load->view('blad',$data);
				}
			}
			else
			{
				redirect('/admin/logout','location');
			}	
		}
		else
		{
			redirect('/admin/','location');
		}
	}
	
	
	function old_pass_check($str,$user)
	{
		$password_baza=$this->baza->user($user); 
		$pass =  md5($str);
		
		if($password_baza==null)
		{
			$password_baza[0]['password']='1';
		}
		
		if ($password_baza[0]['password']!=$pass or $pass==null)
		{
				$this->validation->set_message('old_pass_check', 'Błędne hasło');
				return FALSE;
		}
		else
		{
				return TRUE;
		}
	}
	
	function new_pass_check($str,$pass_repeat)
	{	
		if ($str!=$pass_repeat or $str==null or $pass_repeat==null )
		{
				$this->validation->set_message('new_pass_check', 'Hasło nowe i hasło nowe powtórzopne muszą być takie same');
				return FALSE;
		}
		else
		{
				return TRUE;
		}
	}
	
	function new_pass_repeat_check($str,$new_pass)
	{	
		if ($str!=$new_pass or $new_pass==null or $str=null)
		{
				$this->validation->set_message('new_pass_repeat_check', 'Hasło nowe i hasło nowe powtórzopne muszą być takie same');
				return FALSE;
		}
		else
		{
				return TRUE;
		}
	}
	
	function logout()
	{
		$this->session->sess_destroy();
		redirect('','location');
	}
	
	function forgotten_pass()
	{
		$this->load->helper(array('form', 'url'));
		$this->load->library('validation');
        $this->load->library('wyslij_email');
		$this->validation->set_error_delimiters('<span style="color:red;">', '<br /></span>');
		
		$fields['email'] = 'email';
		$this->validation->set_fields($fields);
		
		$rules['email'] = "callback_email_check|required";
		$this->validation->set_rules($rules);
		$email = $this->validation->email;
		
		if ($this->validation->run() == FALSE)
		{
			$data['content'] = $this->load->view('new_pass',null,true);
		}
		else
		{	
			$pass = substr ( md5 ( uniqid ( rand(), true ) ), 0, 5 );
			$haslo = md5($pass);

			if($email!=null)
			{
				//zmienna email zawiera login a nie jak nazwawskazuje email 
				$is_user = $this->baza->user_get_email($email);
				
				if($is_user!=null)
				{
					if($this->baza->user_new_pass($email,$haslo))
					{	
						$tresc = 'Twoje nowe hasło to:<br /><br />
									'.$pass.'<br /><br />
									<a href="http://panel.networds.pl" >Zaloguj się</a>
							';	
							
							if($this->wyslij_email->send_mail('Przypomnienie hasła', $tresc, $is_user[0]['email']))
							{
								$data['content'] = $this->load->view('new_pass_created',null,true);
							}	
					}else $data['content'] = $this->load->view('blad');
				}else	$data['content'] = $this->load->view('blad');
			}else $data['content'] = $this->load->view('blad');
		}
        $this->load->view('/layout/forgotten_pass_page',$data);
	}
	
	function email_check($str)
	{
		$user=$this->baza->user($str); 
		
		if ($user==null or $str==null)
		{
				$this->validation->set_message('email_check', 'Błędny login');
				return FALSE;
		}
		else
		{
				return TRUE;
		}
	}

    //funkcja do wysylania faktur SEO w zalaczniku
    //faktury seo nalezy wyslac zawsze do klienta i tylko inforamcje do ksiegowej ze zosta
    function send_facture_by_mail_seo($user_id=null,$facture_id=null)
	{
        $this->load->library('wyslij_email');

        $tytul = "Networds - nowa faktura za SEO";
        $tresc = "Została wystawiona nowa faktura w systemie Networds za SEO, jest ona dołączona w załączniku w formacie pdf.";
        $email = $this->baza->get_user_email($user_id);
        $url_pdf_attach = 'http://panel.networds.pl/payments/faktura_ksiegowosc_seo_pdf/'.$facture_id.'/a76i43x2/1';
       // print_r($email);
        $this->wyslij_email->send_mail_with_attach($tytul, $tresc, $email[0]['email'], $url_pdf_attach);
	}

    //funkcja do wysylania faktur SEM proforma w zalaczniku
    //faktury seo nalezy wyslac zawsze do klienta i tylko inforamcje do ksiegowej ze zosta
    function send_facture_by_mail_sem_pro($user_id=null,$facture_id=null)
	{
        $this->load->library('wyslij_email');

        $tytul = "Networds - nowa faktura proforma za SEM ";
        $tresc = "Została wystawiona nowa faktura proforma SEM w systemie Networds, jest ona dołączona w załączniku w formacie pdf.";
        $email = $this->baza->get_user_email($user_id);
        $url_pdf_attach = 'http://panel.networds.pl/payments/faktura_pdf_ksiegowosc_sem/'.$facture_id.'/pf/a76i43x2/1';
       // print_r($email);
        $this->wyslij_email->send_mail_with_attach($tytul, $tresc, $email[0]['email'], $url_pdf_attach);

        $this->config->load('global_settings');
		$global_settings = $this->config->item('global_settings');
        $url_pdf_attach = 'http://panel.networds.pl/payments/faktura_pdf_ksiegowosc_sem/'.$facture_id.'/fv/a76i43x2/0';
        $this->wyslij_email->send_mail_with_attach($tytul, $tresc, $global_settings['ksiegowosc']['email'], $url_pdf_attach);
	}

    //funkcja do wysylania faktur SEM w zalaczniku
    //faktury seo nalezy wyslac zawsze do klienta i tylko inforamcje do ksiegowej ze zosta
    function send_facture_by_mail_sem($user_id=null,$facture_id=null)
	{
        $this->load->library('wyslij_email');

        $tytul = "Networds - nowa faktura za SEM ";
        $tresc = "Została wystawiona nowa faktura SEM w systemie Networds, jest ona dołączona w załączniku w formacie pdf.";
        $email = $this->baza->get_user_email($user_id);
        $url_pdf_attach = 'http://panel.networds.pl/payments/faktura_pdf_ksiegowosc_sem/'.$facture_id.'/fv/a76i43x2/1';
       // print_r($email);
        $this->wyslij_email->send_mail_with_attach($tytul, $tresc, $email[0]['email'], $url_pdf_attach);

        $this->config->load('global_settings');
		$global_settings = $this->config->item('global_settings');
        $url_pdf_attach = 'http://panel.networds.pl/payments/faktura_pdf_ksiegowosc_sem/'.$facture_id.'/fv/a76i43x2/0';
        $this->wyslij_email->send_mail_with_attach($tytul, $tresc, $global_settings['ksiegowosc']['email'], $url_pdf_attach);
	}

    //funkcja do wysylania wyplat afilianta do ksiegowej w zalaczniku    
    function send_facture_by_mail_afiliant($afiliant_id=null,$facture_id=null,$type=null,$dostarczenie=null)
	{
        $this->load->library('wyslij_email');
        $this->config->load('global_settings');

        $tytul = "Networds - nowa wypłata afilianta";
        $tresc = "Została zgłoszona nowa wypłata przez afilianta w systemie Networds, jest ona dołączona w załączniku w formacie pdf.";
               
		$global_settings = $this->config->item('global_settings');

        if($type=='Firma')
            $url_pdf_attach = 'http://panel.networds.pl/payments/faktura_ksiegowosc_pdf_afiliant/'.$facture_id.'/'.$afiliant_id.'/a76i43x2';
        else
            $url_pdf_attach = 'http://panel.networds.pl/payments/rachunek_ksiegowosc_pdf_afiliant/'.$facture_id.'/'.$afiliant_id.'/a76i43x2';

        $this->wyslij_email->send_mail_with_attach($tytul, $tresc, $global_settings['ksiegowosc']['email'], $url_pdf_attach);
	}
}
?>