<?php

class Baza_payments extends Model
{	
	function Baza_payments()
    {
        parent::Model();
		$this->db = $this->load->database('default', TRUE);	
    }
	
	function google_region($domain_id)
	{
		$sql = "SELECT google_region from user_domain where id = ".$domain_id." limit 1";			
		$data = $this->db->query($sql);	
		$domain = $data->result_array();
		
		if(!empty($domain[0]['google_region']))
			return $domain[0]['google_region'];
		else
			return 'pl';
	}
	
	function test_platnosci_pl($raport)
	{
		$data['id'] = '';
		$data['raport'] = $raport;				
		$this->db->insert('test_platnosci ', $data);
	}
	
	function get_stan_konta_linkow_sponosrownych($user_id)
	{		
		$sql = "SELECT adwords_customer_id from user_data where user_id = ".$user_id." limit 1";			
		$data = $this->db->query($sql);	
		$adwords_id = $data->result_array();
		unset($data);
		//print_r($adwords_id);
		
		if(!empty($adwords_id[0]['adwords_customer_id']))
		{
			$stan_konta_doladowany = 0;
			$stan_konta_wykorzystany = 0;
			$aktualny_stan_konta = 0;
			
			//wyliczenie wykorzystanych kwot linkow sponsorowanych
			$sql = "SELECT ROUND((sum(cost)/1000000),2) as costs from adwords_stats where adwords_customer_id = ".$adwords_id[0]['adwords_customer_id']."";			
			$data = $this->db->query($sql);	
			$stan_konta_wykorzystany = $data->result_array();
			$stan_konta_wykorzystany = $stan_konta_wykorzystany[0]['costs'];
			unset($data);
			
			if(empty($stan_konta_wykorzystany)) 
				$stan_konta_wykorzystany = 0;
			
			//wyliczenie doladowanych kwot linkow sponsorowanych	
			$sql = "SELECT ROUND(sum(netto),2) as costs from faktury_sem where user_id = ".$user_id."";			
			$data = $this->db->query($sql);	
			$stan_konta_doladowany = $data->result_array();
			$stan_konta_doladowany = $stan_konta_doladowany[0]['costs'];
			unset($data);
			
			if(empty($stan_konta_doladowany))  
				$stan_konta_doladowany = 0;
				
			//sprawdzenie czy juz jakas kwota zostala wykorzystana na reklamy, 
			//jezeli nie to pokaz kientowi cala wlaną kasę 
			//jezeli tak to pokaz klientowi kase pomnijeszona o wykorzytana i z odliczona prowizja dla networds

			if($stan_konta_wykorzystany==0)
			{
				return $stan_konta_doladowany;
			}
			else
			{
				//prowizja od adwords 
				$prowizja = 0.15; 
				//echo '<br /><br />prowizja networds:'.($prowizja*100).'% <br />';		
				//echo 'doladowano:'.$stan_konta_doladowany.'<br />';
				//echo 'wykorzystano:'.$stan_konta_wykorzystany.'<br />';
										
				$aktualny_stan_konta = round(($stan_konta_doladowany/(1+$prowizja)),2) - $stan_konta_wykorzystany;
				
				//zabezpieczenie jakby cos poszlo nie tak zby klient nie zobaczyl ujemnej kwoty
				if($aktualny_stan_konta<0)$aktualny_stan_konta = 0; 				
				
				return $aktualny_stan_konta;
			}	
								
			//print_r($stan_konta_doladowany);			
		}
		else
		{
			return 0;
		}		
	}
	
	function wystaw_fakture_sem_proforma($post)
	{
		include_once('files/slownie.php');
		include_once('files/functions.php');
				
		$day = date('d');
		$month = date('m');
		$year = date('Y');
		
		$termin_platnosci = strftime("20%y-%m-%d",mktime(0, 0, 0,$month, $day+7, $year));
		
		//numer faktury proforma
		$nr = 1;
		$sql = "SELECT nr from faktury_sem_proforma where month = '".$month."' and year = '".$year."' order by nr desc limit 1";			
		$data = $this->db->query($sql);	
		$nr_tmp =  $data->result_array();	
		//print_r($nr_tmp);
		unset($data);
		
		if(!empty($nr_tmp))
		{
			$nr = ($nr_tmp[0]['nr'] + 1);
		}
		//koniec wyliczania numeru faktury proforma
		
		//pobranie danych nabywcy				
		
		$sql = "SELECT * from user_data where user_id=".$post['desc2']." limit 1";			
		$data = $this->db->query($sql);	
		$user_data =  $data->result_array();					
		unset($data);
		
		//koniec pobrania danych nabywcy
		
		$sprzedawca = "Labmatic - Jakub Kurbiel\nul.Reymonta 2 /3\n43-300 Bielsko-Biała\nNIP: 5471795303\nKonto: 26 1060 0076 0000 3260 0153 8938\nBank BPH o./Bielsko-Biała";	
		$nabywca = "".$user_data[0]['company_name']."\n".$user_data[0]['street'].$user_data[0]['b_no'].$user_data[0]['a_no']."\n".$user_data[0]['post_code']." ".$user_data[0]['city']."\nNIP: ".$user_data[0]['tax_id']."";
		
		//dodanie 0 do groszy np 1.6 zamieni na 1.60
		$brutto  = round(($post['amount']/100),2);
		$netto  =  round((($post['amount']/1.22)/100),2);
		
		$brutto_tmp  =  d_gr($brutto);					
		$slowa = Array('minus',Array('zero', 'jeden', 'dwa', 'trzy', 'cztery', 'pięć', 'sześć', 'siedem', 'osiem', 'dziewięć'), Array( 'dziesięć', 'jedenaście', 'dwanaście', 'trzynaście', 'czternaście', 'piętnaście', 'szesnaście', 'siedemnaście', 'osiemnaście', 'dziewiętnaście'), Array( 'dziesięć', 'dwadzieścia', 'trzydzieści', 'czterdzieści', 'pięćdziesiąt', 'sześćdziesiąt', 'siedemdziesiąt', 'osiemdziesiąt', 'dziewięćdziesiąt'), Array( 'sto', 'dwieście', 'trzysta', 'czterysta', 'pięćset', 'sześćset', 'siedemset', 'osiemset', 'dziewięćset'), Array( 'tysiąc', 'tysiące', 'tysięcy'), Array( 'milion', 'miliony', 'milionów'), Array( 'miliard', 'miliardy', 'miliardów'), Array( 'bilion', 'biliony', 'bilionów'), Array( 'biliard', 'biliardy', 'biliardów'), Array( 'trylion', 'tryliony', 'trylionów'), Array( 'tryliard', 'tryliardy', 'tryliardów'), Array( 'kwadrylion', 'kwadryliony', 'kwadrylionów'), Array( 'kwintylion', 'kwintyliony', 'kwintylionów'), Array( 'sekstylion', 'sekstyliony', 'sekstylionów'), Array( 'septylion', 'septyliony', 'septylionów'), Array( 'oktylion', 'oktyliony', 'oktylionów'), Array( 'nonylion', 'nonyliony', 'nonylionów'), Array( 'decylion', 'decyliony', 'decylionów') );					
		$slownie_do_zaplaty = slownie($brutto_tmp[0],$slowa).' '.odmiana(array('złoty','złote','złotych'),$brutto_tmp[0]).' i '.slownie($brutto_tmp[1],$slowa).' '.odmiana(array('grosz','grosze','groszy'),$brutto_tmp[1]);
		
		
		//dodanie 0 do groszy np 1.6 zamieni na 1.60
		$netto_tmp = $post['amount']/1.22/100;
		$netto_gr = d_gr($netto_tmp); 
		$netto_gr_z_vat = d_gr(round((1.22*$netto_tmp),2));
		$netto_gr_vat = d_gr(round((0.22*$netto_tmp),2));
		$netto_z_vat = d_gr(round((1.22*$netto_tmp),2));  
		 	
		$facture_payments[] = array(1,'Doładowanie konta SEM','szt',1,$netto_gr[0].'.'.$netto_gr[1],$netto_gr[0].'.'.$netto_gr[1],'22%',$netto_gr_vat[0].'.'.$netto_gr_vat[1],$netto_gr_z_vat[0].'.'.$netto_gr_z_vat[1]);
		$facture_payments[] = array('','','','','RAZEM',$netto_gr[0].'.'.$netto_gr[1],'',$netto_gr_vat[0].'.'.$netto_gr_vat[1],$netto_z_vat[0].'.'.$netto_z_vat[1]);
		$facture_payments[] = array('','','','','w tym',$netto_gr[0].'.'.$netto_gr[1],'22%',$netto_gr_vat[0].'.'.$netto_gr_vat[1],$netto_z_vat[0].'.'.$netto_z_vat[1]);
				
		//wyliczone pozycje platnosci serializowane dane
		$naliczone_uslugi = serialize($facture_payments);
		
		//wyliczone pozycje platnosci w formacie txt
		$naliczone_uslugi_txt = '';
		
		foreach($facture_payments as $f)
		{
			$naliczone_uslugi_txt .= "Lp. ".$f[0]." | usługa: ".$f[1]." | jednostka ".$f[2]." | ilość: ".$f[3]." | cena jednostkowa: ".$f[4]." | netto: ".$f[5]." | stawka VAT: ".$f[6]." | kwota VAT: ".$f[7]." | brutto: ".$f[8]."\n";
		}
		
		$brutto = round((1.22*$netto),2);
		$naliczone_uslugi_txt .= "netto: ".$netto."\n";
		$naliczone_uslugi_txt .= "brutto: ".$brutto."\n";
		
		$data['nr'] = $nr;
		$data['month'] = $month;
		$data['year'] = $year;
		$data['miejsce_wystawienia'] = 'Bielsko - Biała';
		$data['data_wystawienia'] = date('Y-m-d');
		$data['data_sprzedazy'] = date('Y-m-d');
		$data['sposob_zaplaty'] = 'przelew';
		$data['termin_platnosci'] = $termin_platnosci;
		$data['sprzedawca'] = $sprzedawca;
		$data['nabywca'] = $nabywca;
		$data['naliczone_uslugi'] = $naliczone_uslugi;
		$data['naliczone_uslugi_txt'] = $naliczone_uslugi_txt;
		$data['netto'] = $netto;
		$data['brutto'] = $brutto;
		$data['slownie_do_zaplaty'] = $slownie_do_zaplaty;
		$data['os_upowaz_do_wyst_faktury'] = 'Jakub Kurbiel';
		$data['uwagi'] = '';
		$data['user_id'] = $user_data[0]['user_id'];
		$data['zaplacono'] = 0;
		$data['zatwierdzono'] = 0;		
				
		$this->db->insert('faktury_sem_proforma', $data);
	}
	
	function zaplacono_platnosci_pl_sem($id_transakcji=null)
	{
		if($id_transakcji!=null)
		{
			$sql = "SELECT * FROM platnosci_pl_transakcje WHERE id_transakcji = ".$id_transakcji."";			
			$data = $this->db->query($sql);	
			$transaction_data = $data->result_array();
			unset($data);
			
			$sql = "SELECT * FROM faktury_sem WHERE id_transakcji = ".$id_transakcji."";			
			$data = $this->db->query($sql);	
			$fak_data = $data->result_array();
			unset($data);
			
			if(!empty($transaction_data) and empty($fak_data))
			{
				include_once('files/slownie.php');
				include_once('files/functions.php');
						
				$month = date('m');
				$year = date('Y');
				
				/*numer faktury*/
				$nr = 1;
				$sql = "SELECT nr from faktury_sem where month = '".$month."' and year = '".$year."' order by nr desc limit 1";			
				$data = $this->db->query($sql);	
				$nr_tmp =  $data->result_array();	
				//print_r($nr_tmp);
				unset($data);
				if(!empty($nr_tmp))
				{
					$nr = ($nr_tmp[0]['nr'] + 1);
				}
				/*koniec wyliczania numeru faktury*/
				
				/*pobranie danych nabywcy*/				
				
				$sql = "SELECT * from user_data where user_id=".$transaction_data[0]['desc2']." limit 1";			
				$data = $this->db->query($sql);	
				$user_data =  $data->result_array();					
				unset($data);
				
				/*koniec pobrania danych nabywcy*/
				
				$sprzedawca = "Labmatic - Jakub Kurbiel\nul.Reymonta 2 /3\n43-300 Bielsko-Biała\nNIP: 5471795303\nKonto: 26 1060 0076 0000 3260 0153 8938\nBank BPH o./Bielsko-Biała";	
				$nabywca = "".$user_data[0]['company_name']."\n".$user_data[0]['street'].$user_data[0]['b_no'].$user_data[0]['a_no']."\n".$user_data[0]['post_code']." ".$user_data[0]['city']."\nNIP: ".$user_data[0]['tax_id']."";
				
				//dodanie 0 do groszy np 1.6 zamieni na 1.60
				$brutto  = round(($transaction_data[0]['amount']/100),2);
				$netto  =  round((($transaction_data[0]['amount']/1.22)/100),2);
				
				$brutto_tmp  =  d_gr($brutto);					
				$slowa = Array('minus',Array('zero', 'jeden', 'dwa', 'trzy', 'cztery', 'pięć', 'sześć', 'siedem', 'osiem', 'dziewięć'), Array( 'dziesięć', 'jedenaście', 'dwanaście', 'trzynaście', 'czternaście', 'piętnaście', 'szesnaście', 'siedemnaście', 'osiemnaście', 'dziewiętnaście'), Array( 'dziesięć', 'dwadzieścia', 'trzydzieści', 'czterdzieści', 'pięćdziesiąt', 'sześćdziesiąt', 'siedemdziesiąt', 'osiemdziesiąt', 'dziewięćdziesiąt'), Array( 'sto', 'dwieście', 'trzysta', 'czterysta', 'pięćset', 'sześćset', 'siedemset', 'osiemset', 'dziewięćset'), Array( 'tysiąc', 'tysiące', 'tysięcy'), Array( 'milion', 'miliony', 'milionów'), Array( 'miliard', 'miliardy', 'miliardów'), Array( 'bilion', 'biliony', 'bilionów'), Array( 'biliard', 'biliardy', 'biliardów'), Array( 'trylion', 'tryliony', 'trylionów'), Array( 'tryliard', 'tryliardy', 'tryliardów'), Array( 'kwadrylion', 'kwadryliony', 'kwadrylionów'), Array( 'kwintylion', 'kwintyliony', 'kwintylionów'), Array( 'sekstylion', 'sekstyliony', 'sekstylionów'), Array( 'septylion', 'septyliony', 'septylionów'), Array( 'oktylion', 'oktyliony', 'oktylionów'), Array( 'nonylion', 'nonyliony', 'nonylionów'), Array( 'decylion', 'decyliony', 'decylionów') );					
				$slownie_do_zaplaty = slownie($brutto_tmp[0],$slowa).' '.odmiana(array('złoty','złote','złotych'),$brutto_tmp[0]).' i '.slownie($brutto_tmp[1],$slowa).' '.odmiana(array('grosz','grosze','groszy'),$brutto_tmp[1]);
				
				//dodanie 0 do groszy np 1.6 zamieni na 1.60
				$netto_tmp = $transaction_data[0]['amount']/1.22/100;
				$netto_gr = d_gr($netto_tmp); 
				$netto_gr_z_vat = d_gr(round((1.22*$netto_tmp),2));
				$netto_gr_vat = d_gr(round((0.22*$netto_tmp),2));
				$netto_z_vat = d_gr(round((1.22*$netto_tmp),2));  
				 	
				$facture_payments[] = array(1,'Doładowanie konta SEM','szt',1,$netto_gr[0].'.'.$netto_gr[1],$netto_gr[0].'.'.$netto_gr[1],'22%',$netto_gr_vat[0].'.'.$netto_gr_vat[1],$netto_gr_z_vat[0].'.'.$netto_gr_z_vat[1]);
				$facture_payments[] = array('','','','','RAZEM',$netto_gr[0].'.'.$netto_gr[1],'',$netto_gr_vat[0].'.'.$netto_gr_vat[1],$netto_z_vat[0].'.'.$netto_z_vat[1]);
				$facture_payments[] = array('','','','','w tym',$netto_gr[0].'.'.$netto_gr[1],'22%',$netto_gr_vat[0].'.'.$netto_gr_vat[1],$netto_z_vat[0].'.'.$netto_z_vat[1]);
						
				//wyliczone pozycje platnosci serializowane dane
				$naliczone_uslugi = serialize($facture_payments);
				
				//wyliczone pozycje platnosci w formacie txt
				$naliczone_uslugi_txt = '';
				
				foreach($facture_payments as $f)
				{
					$naliczone_uslugi_txt .= "Lp. ".$f[0]." | usługa: ".$f[1]." | jednostka ".$f[2]." | ilość: ".$f[3]." | cena jednostkowa: ".$f[4]." | netto: ".$f[5]." | stawka VAT: ".$f[6]." | kwota VAT: ".$f[7]." | brutto: ".$f[8]."\n";
				}
				
				$brutto = round((1.22*$netto),2);
				$naliczone_uslugi_txt .= "netto: ".$netto."\n";
				$naliczone_uslugi_txt .= "brutto: ".$brutto."\n";
				
				$data['nr'] = $nr;
				$data['month'] = $month;
				$data['year'] = $year;
				$data['miejsce_wystawienia'] = 'Bielsko - Biała';
				$data['data_wystawienia'] = date('Y-m-d');
				$data['data_sprzedazy'] = date('Y-m-d');
				$data['sposob_zaplaty'] = 'przelew';
				$data['termin_platnosci'] = date('Y-m-d');
				$data['sprzedawca'] = $sprzedawca;
				$data['nabywca'] = $nabywca;
				$data['naliczone_uslugi'] = $naliczone_uslugi;
				$data['naliczone_uslugi_txt'] = $naliczone_uslugi_txt;
				$data['netto'] = $netto;
				$data['brutto'] = $brutto;
				$data['slownie_do_zaplaty'] = $slownie_do_zaplaty;
				$data['os_upowaz_do_wyst_faktury'] = 'Jakub Kurbiel';
				$data['uwagi'] = '';
				$data['user_id'] = $user_data[0]['user_id'];
				$data['zaplacono'] = 0;
				$data['zatwierdzono'] = 0;
				$data['id_transakcji'] = $id_transakcji;
						
				$this->db->insert('faktury_sem', $data);
			}
		}
	}	
	
	function zaplacono_platnosci_pl($id_faktury=null,$zatwierdzono=null)
	{
		if($id_faktury!=null)
		{
			if($zatwierdzono!=null)$data['zatwierdzono'] = 1;
			
			$data['zaplacono'] = 1;
	        $this->db->WHERE('id', $id_faktury);
	        $this->db->update('faktury_seo', $data);
		}
	}
	
	function get_facture_platnosci_pl($user_id,$id_faktury)
	{
		$sql = "SELECT * FROM faktury_seo WHERE user_id = ".$user_id." AND id='".$id_faktury."' and zaplacono=0";			
		$data = $this->db->query($sql);	
		return $data->result_array();
	}
	
	function get_user_facture($user_id,$month,$year)
	{
		$sql = "SELECT id FROM faktury_seo WHERE user_id = ".$user_id." AND year='".$year."' AND month='".$month."'";			
		$data = $this->db->query($sql);	
		return $data->result_array();
	}
	
	function get_facture($user_id,$month,$year)
	{
		$sql = "SELECT * from faktury_seo where month = '".$month."' and year = '".$year."' and user_id = '".$user_id."'";		 			
		$data = $this->db->query($sql);	
		return $data->result_array();
	}
	
	function get_factures($user_id)
	{
		$sql = "SELECT id,month,year,zaplacono from faktury_seo where user_id = '".$user_id."' order by year,month ";		 			
		$data = $this->db->query($sql);	
		return $data->result_array();
	}
	
	function get_factures_sem($user_id)
	{
		$sql = "SELECT id,nr,month,year,zaplacono from faktury_sem where user_id = '".$user_id."' order by year,month ";		 			
		$data = $this->db->query($sql);	
		return $data->result_array();
	}
	
	function get_factures_sem_proforma($user_id)
	{
		$sql = "SELECT id,nr,month,year,zaplacono from faktury_sem_proforma where user_id = '".$user_id."' order by year,month ";		 			
		$data = $this->db->query($sql);	
		return $data->result_array();
	}
	
	function get_facture_sem_proforam_to_pdf($nr,$user_id,$month,$year)
	{
		$sql = "SELECT * from faktury_sem_proforma where nr = '".$nr."' and user_id = '".$user_id."' and year = '".$year."' and month = '".$month."' ";		 			
		$data = $this->db->query($sql);	
		return $data->result_array();
	}
	
	function get_facture_sem_fv_to_pdf($nr,$user_id,$month,$year)
	{
		$sql = "SELECT * from faktury_sem where nr = '".$nr."' and user_id = '".$user_id."' and year = '".$year."' and month = '".$month."' ";		 			
		$data = $this->db->query($sql);	
		return $data->result_array();
	}
	
	function zloty_check($keys,$week,$year)
	{
		$this->db->where('week', $week);
		$this->db->where('year', $year);
		$this->db->where_in('keyword_id', $keys);		
		$data = $this->db->get('keyword_price_per_week',1);	
		return $data->result_array();
	}
	
	function get_data_to_fakcture_payments($keyword_id,$month,$year)
	{		
		set_time_limit(60);	
		$sql = "SELECT count(*) ilosc_tyg_platnych, price cena_za_tydz, sum(price) oplata_za_miesaic, keyword_id, year, month, week week_rozpocz_mies, max(week) ostatni_week FROM keyword_price_per_week WHERE keyword_id = '".$keyword_id."' AND year='".$year."' AND month='".$month."' group by keyword_id asc";			
		$data = $this->db->query($sql);	
		return $data->result_array();
	}
	
	function update_keyword_dojscie($keyword_id)
	{
		$data['naliczona_oplata_za_dojscie'] = 1;
        $this->db->WHERE('id', $keyword_id);
        return $this->db->update('user_domain_keyword', $data);
	}
	
	function get_domains_and_keywords($user_id)
	{
		$this->db->select('*');
		$this->db->from('user_domain');
		$this->db->join('user_domain_keyword', 'user_domain.id = user_domain_keyword.domain_id');
		$this->db->where('user_domain.user_id', $user_id);
		//$this->db->group_by("user_domain_keyword.id"); 
		//$this->db->order_by("user_domain_keyword.id"); 
		$data = $this->db->get();
		return $data->result_array(); 
	}
	
	function add_facture($month,$year,$facture_period,$payments,$user_data)
	{
		include_once('files/slownie.php');	
	
		/*miejsce wystawienia, data wystawienia, sprzedarzy, termin platnosci*/
		
		//wyliczenie miesiaca nastepujacego po miesiacu za ktory jest wystawiana faktura
		$data_wystawienia_tmp = strftime("20%y-%m-%d",mktime(0, 0, 0, $month+1, 1, $year));
		
		//wyliczenie roku wystawienia faktury		 
		$fw_year = substr($data_wystawienia_tmp,0,4);

		//wyliczenie miesiaca wystwienia faktury
		$fw_month = substr($data_wystawienia_tmp,5,2);

		//wyliczenia 1 dnia nastepnego okresu rolziczeniowego, ktory jest zarazem dniem wystawienia faktury
		$day_of_facturing = $fw_year.'-'.$fw_month.'-'.date_from_nameday(1, 1, $fw_month,$fw_year);
		
		//wyciecie numeru wyliczonego dnia nastepnego okresub rozliczeniowego aby go urzyc do wyliczenia terminu platnosci
		$fw_day = substr($day_of_facturing,8,2);
		
		$data_wystawienia = $day_of_facturing;   				
		$miejsce_wystawienia = 'Bielsko-Biała';		
		$sposob_zaplaty = 'przelew';

		//wyliczenie terminu platnosci
		$termin_platnosci = strftime("20%y-%m-%d",mktime(0, 0, 0,$fw_month, $fw_day+7, $fw_year));
		
		
		/*numer faktury*/
		$nr = 1;
		$sql = "SELECT nr from faktury_seo where month = '".$month."' and year = '".$year."' order by nr desc limit 1";			
		$data = $this->db->query($sql);	
		$nr_tmp =  $data->result_array();	
		//print_r($nr_tmp);
		unset($data);
		if(!empty($nr_tmp))
		{
			$nr = ($nr_tmp[0]['nr'] + 1);
		}
		
		/*sprzedawca, nabywca*/
		$sprzedawca = "Labmatic - Jakub Kurbiel\nul.Reymonta 2 /3\n43-300 Bielsko-Biała\nNIP: 5471795303\nKonto: 26 1060 0076 0000 3260 0153 8938\nBank BPH o./Bielsko-Biała";	
		$nabywca = "".$user_data[0]['company_name']."\n".$user_data[0]['street'].$user_data[0]['b_no'].$user_data[0]['a_no']."\n".$user_data[0]['post_code']." ".$user_data[0]['city']."\nNIP: ".$user_data[0]['tax_id']."";

		/*naliczone uslugi*/
		
		$facture_payments = array(); //zmienna trzymajaca tablice z wyliczonymi pozycjami platnosci
		$netto = 0; //zmienna trzymajaca cala wartosc netto faktury
		$uwagi = null; //zmienna trzymajaca slowa ktore byly na pozycjach
		$utrzymanie = 0; //tmp zmienna pomocnicza		
		$i = 1;	 // tmp zmienna pomocnicza
		$last_week_of_year = last_week_of_year($year); //tab z inf o ostatnim tygodniu roku
				
		foreach($payments as $domain => $value)
		{
			if(!empty($value))
			{
				$utrzymanie = 0;
					
				foreach($value as $d)
				{				
					if($d[0]=='dojscie')
					{
						//dodanie 0 do groszy np 1.6 zamieni na 1.60
						$d3 = d_gr($d[3]); 
						$d3_vat = d_gr(round((0.22*$d[3]),2));
						$d3_z_vat = d_gr(round((1.22*$d[3]),2));
												
						//$facture_payments[] = array($i,'Opłata za dojście słowa kluczowego \''.$d[2].'\' z domeny \''.$d[1].'\' na płatną pozycję','szt',1,$d[3],$d[3],'22%',round((0.22*$d[3]),2),round((1.22*$d[3]),2));
						$facture_payments[] = array($i,'Opłata za dojście słowa kluczowego \''.$d[2].'\' z domeny \''.$d[1].'\' na płatną pozycję','szt',1,$d3[0].'.'.$d3[1],$d3[0].'.'.$d3[1],'22%',$d3_vat[0].'.'.$d3_vat[1],$d3_z_vat[0].'.'.$d3_z_vat[1]);
						$netto += round($d[3],2);
						$i++;
					}
					
					if($d[0]=='tydzien')
					{																
						///jezeli w tablicy jest pole zawierajace '1zl' to znak ze nalezy w grudniu odjac opate za ostatni tydzein i dodac 1 zl a jezeli styczen to tylko dodac 1 zl 
						
						if($month==12)
						{
							if(in_array('1zl',$value))
							{																
								//zlotowka grudzien - odejmujemy ostatni platny tydzien z grudnia												
								if($last_week_of_year[0]['week_number']==$d[8])
								{									
									$netto += round(($d[3]-$d[7]),2);
									$utrzymanie += $d[3]-$d[7];
									$uwagi[trim($d[1])][]= $d[2]."\n";
								}
								else
								{
									$netto += round($d[3],2);
									$utrzymanie += $d[3];
									$uwagi[trim($d[1])][]= $d[2]."\n";
								}																
							}
							else
							{
								$netto += round($d[3],2);
								$utrzymanie += $d[3];
								$uwagi[trim($d[1])][]= $d[2]."\n";
							}
							
						}
						else
						{
							$netto += round($d[3],2);
							$utrzymanie += $d[3];
							$uwagi[trim($d[1])][]= $d[2]."\n";
						}
						//
						
						//orginal	bez rozpoznawania okresow zlotowkowcyh 
						/*$netto += round($d[3],2);
						$utrzymanie += $d[3];
						$uwagi[trim($d[1])][]= $d[2]."\n";*/
					}												
				}								
				
				//zlotowka styczen i grudzien - ddoajemy zlotowke do platnosci
				if($month==1 or $month==12)
				{
					if(in_array('1zl',$value))
					{						
						$netto += 1;
						$utrzymanie += 1;										
					}					
				}
				
				//dodanie 0 do groszy np 1.6 zamieni na 1.60
				$utrzymanie_gr = d_gr($utrzymanie); 
				$utrzymanie_gr_vat = d_gr(round((0.22*$utrzymanie),2));
				$utrzymanie_gr_z_vat = d_gr(round((1.22*$utrzymanie),2)); 
				
				if($month==1)
					$facture_payments[] = array($i,'Opłata SEO za okres od '.$year.'-'.$month.'-01 do '.$facture_period['end'].' dla domeny: \''.$value[0][1].'\'','szt',1,$utrzymanie_gr[0].'.'.$utrzymanie_gr[1],$utrzymanie_gr[0].'.'.$utrzymanie_gr[1],'22%',$utrzymanie_gr_vat[0].'.'.$utrzymanie_gr_vat[1],$utrzymanie_gr_z_vat[0].'.'.$utrzymanie_gr_z_vat[1]);
				elseif($month==12)
					$facture_payments[] = array($i,'Opłata SEO za okres od '.$facture_period['start'].' do '.$year.'-'.$month.'-31 dla domeny: \''.$value[0][1].'\'','szt',1,$utrzymanie_gr[0].'.'.$utrzymanie_gr[1],$utrzymanie_gr[0].'.'.$utrzymanie_gr[1],'22%',$utrzymanie_gr_vat[0].'.'.$utrzymanie_gr_vat[1],$utrzymanie_gr_z_vat[0].'.'.$utrzymanie_gr_z_vat[1]);
				else
					$facture_payments[] = array($i,'Opłata SEO za okres od '.$facture_period['start'].' do '.$facture_period['end'].' dla domeny: \''.$value[0][1].'\'','szt',1,$utrzymanie_gr[0].'.'.$utrzymanie_gr[1],$utrzymanie_gr[0].'.'.$utrzymanie_gr[1],'22%',$utrzymanie_gr_vat[0].'.'.$utrzymanie_gr_vat[1],$utrzymanie_gr_z_vat[0].'.'.$utrzymanie_gr_z_vat[1]);
				
				/*if($month==1)
					$facture_payments[] = array($i,'Opłata SEO za okres od '.$year.'-'.$month.'-01 do '.$facture_period['end'].' dla domeny: \''.$value[0][1].'\'','szt',1,$utrzymanie,$utrzymanie,'22%',round((0.22*$utrzymanie),2),round((1.22*$utrzymanie),2));
				elseif($month==12)
					$facture_payments[] = array($i,'Opłata SEO za okres od '.$facture_period['start'].' do '.$year.'-'.$month.'-31 dla domeny: \''.$value[0][1].'\'','szt',1,$utrzymanie,$utrzymanie,'22%',round((0.22*$utrzymanie),2),round((1.22*$utrzymanie),2));
				else
					$facture_payments[] = array($i,'Opłata SEO za okres od '.$facture_period['start'].' do '.$facture_period['end'].' dla domeny: \''.$value[0][1].'\'','szt',1,$utrzymanie,$utrzymanie,'22%',round((0.22*$utrzymanie),2),round((1.22*$utrzymanie),2));	
				*/
				$i++;
			}						
		}
		
		//dodanie 0 do groszy np 1.6 zamieni na 1.60
		$netto_gr = d_gr($netto); 
		$netto_gr_vat = d_gr(round((0.22*$netto),2));
		$netto_z_vat = d_gr(round((1.22*$netto),2));  
		
		$facture_payments[] = array('','','','','RAZEM',$netto_gr[0].'.'.$netto_gr[1],'',$netto_gr_vat[0].'.'.$netto_gr_vat[1],$netto_z_vat[0].'.'.$netto_z_vat[1]);
		$facture_payments[] = array('','','','','w tym',$netto_gr[0].'.'.$netto_gr[1],'22%',$netto_gr_vat[0].'.'.$netto_gr_vat[1],$netto_z_vat[0].'.'.$netto_z_vat[1]);
		
		//$facture_payments[] = array('','','','','RAZEM',$netto,'',round((0.22*$netto),2),round((1.22*$netto),2));
		//$facture_payments[] = array('','','','','w tym',$netto,'22%',round((0.22*$netto),2),round((1.22*$netto),2));
		
		
		//wyliczone pozycje platnosci serializowane dane
		$naliczone_uslugi = serialize($facture_payments);
		
		//wyliczone pozycje platnosci w formacie txt
		$naliczone_uslugi_txt = '';
		
		foreach($facture_payments as $f)
		{
			$naliczone_uslugi_txt .= "Lp. ".$f[0]." | usługa: ".$f[1]." | jednostka ".$f[2]." | ilość: ".$f[3]." | cena jednostkowa: ".$f[4]." | netto: ".$f[5]." | stawka VAT: ".$f[6]." | kwota VAT: ".$f[7]." | brutto: ".$f[8]."\n";
		}
		
		$brutto = round((1.22*$netto),2);
		$naliczone_uslugi_txt .= "netto: ".$netto."\n";
		$naliczone_uslugi_txt .= "brutto: ".$brutto."\n";
		
		//dodanie 0 do groszy np 1.6 zamieni na 1.60
		$brutto_tmp  =  d_gr($brutto);		
		
		$slowa = Array('minus',Array('zero', 'jeden', 'dwa', 'trzy', 'cztery', 'pięć', 'sześć', 'siedem', 'osiem', 'dziewięć'), Array( 'dziesięć', 'jedenaście', 'dwanaście', 'trzynaście', 'czternaście', 'piętnaście', 'szesnaście', 'siedemnaście', 'osiemnaście', 'dziewiętnaście'), Array( 'dziesięć', 'dwadzieścia', 'trzydzieści', 'czterdzieści', 'pięćdziesiąt', 'sześćdziesiąt', 'siedemdziesiąt', 'osiemdziesiąt', 'dziewięćdziesiąt'), Array( 'sto', 'dwieście', 'trzysta', 'czterysta', 'pięćset', 'sześćset', 'siedemset', 'osiemset', 'dziewięćset'), Array( 'tysiąc', 'tysiące', 'tysięcy'), Array( 'milion', 'miliony', 'milionów'), Array( 'miliard', 'miliardy', 'miliardów'), Array( 'bilion', 'biliony', 'bilionów'), Array( 'biliard', 'biliardy', 'biliardów'), Array( 'trylion', 'tryliony', 'trylionów'), Array( 'tryliard', 'tryliardy', 'tryliardów'), Array( 'kwadrylion', 'kwadryliony', 'kwadrylionów'), Array( 'kwintylion', 'kwintyliony', 'kwintylionów'), Array( 'sekstylion', 'sekstyliony', 'sekstylionów'), Array( 'septylion', 'septyliony', 'septylionów'), Array( 'oktylion', 'oktyliony', 'oktylionów'), Array( 'nonylion', 'nonyliony', 'nonylionów'), Array( 'decylion', 'decyliony', 'decylionów') );					
		$slownie_do_zaplaty = slownie($brutto_tmp[0],$slowa).' '.odmiana(array('złoty','złote','złotych'),$brutto_tmp[0]).' i '.slownie($brutto_tmp[1],$slowa).' '.odmiana(array('grosz','grosze','groszy'),$brutto_tmp[1]);
		 
		$uwagi_txt = '';
		
		foreach($uwagi as $k => $v)
		{
			$uwagi_txt .= $k.": ";
			foreach($v as $s )
			{				
					$uwagi_txt .= trim($s).', ';
			}
			$uwagi_txt .= "\n\n";
		}
		
		$data['nr'] = $nr;
		$data['month'] = $month;
		$data['year'] = $year;
		$data['miejsce_wystawienia'] = $miejsce_wystawienia;
		$data['data_wystawienia'] = $data_wystawienia;
		$data['data_sprzedazy'] = $data_wystawienia;
		$data['sposob_zaplaty'] = $sposob_zaplaty;
		$data['termin_platnosci'] = $termin_platnosci;
		$data['sprzedawca'] = $sprzedawca;
		$data['nabywca'] = $nabywca;
		$data['naliczone_uslugi'] = $naliczone_uslugi;
		$data['naliczone_uslugi_txt'] = $naliczone_uslugi_txt;
		$data['netto'] = $netto;
		$data['brutto'] = $brutto;
		$data['slownie_do_zaplaty'] = $slownie_do_zaplaty;
		$data['os_upowaz_do_wyst_faktury'] = 'Jakub Kurbiel';
		$data['uwagi'] = $uwagi_txt;
		$data['user_id'] = $user_data[0]['user_id'];
				
		$this->db->insert('faktury_seo', $data);
		return true;
	}
	
	function count_all_keywords_payments_per_week()
	{
		include_once('files/functions.php');				  		
		$weeks = weeks_start_end_array(2008);		  		  							
		
		//pobierz wszystkie domeny
		$sql = "SELECT * from user_domain";		 			
		$data = $this->db->query($sql);	
		$domains = $data->result_array();	
		
		foreach($domains as $d)
		{
			//pobierz wszystkie slowa kluczowe dla danej domeny oraz ich cene
			$sql = "SELECT * from user_domain_keyword where domain_id=".$d['id']."";			
			$data = $this->db->query($sql);	
			$keywords = $data->result_array();
			
			//dla danego slowa kluczowego sprawdz pozycje w google dla danego tygodnia od roku zdefiniowanego w $year do daty roku aktualnego
			foreach($keywords as $k)
			{
				foreach($weeks as $w)
				{
					//pobierz liczbe dni danego keywordsa ktorego pozycja w gogle byla nie wieksza niz 10
					$sql = "SELECT count(*) as days, keyword_id, date from user_domain_keywords_stats_".$d['google_region']." where keyword_id=".$k['id']." and position <= 10 and (date >= '".$w['start']."' AND date <= '".$w['end']."') group by keyword_id ";			
					$data = $this->db->query($sql);	
					$kstats = $data->result_array();					
					
					foreach($kstats as $s)
					{																	
						if($s['days']==7)
						{
							$all_price = 0;							
							$percent = $k['percent']/100;							
							$price = $k['price'];							
							$num_of_weeks_in_months = $w['weeks_in_months'];							
							$all_price = ($percent * $price) / $num_of_weeks_in_months;
							
							$data_insert['keyword_id'] = $s['keyword_id'];														
							$data_insert['year'] = substr($w['start'],0,4);
							$data_insert['month'] = substr($w['start'],5,2);														
							$data_insert['week'] = $w['week_number'];
							$data_insert['google_region'] = $d['google_region'];
							$data_insert['price'] = $all_price;
							
							//sprawdzenie czy juz jakims cudem ktos kiedys nie wyliczyl ceny dla tego slowa kluczowego w tym roku i wtym tyg  
							$sql = "SELECT * from keyword_price_per_week where keyword_id = ".$s['keyword_id']." and year = ".substr($s['date'],0,4)." and week = ".$w['week_number']." ";			
							$data_check = $this->db->query($sql);	
							
							if($data_check->result_array()==null)
							{					        
					        	$this->db->insert('keyword_price_per_week', $data_insert);
							}
							else
							{
								echo 'juz to masz dodane <br />';
							}														
						}
					}	
				}												
			}
		}
	}
	
	function count_all_keywords_payments_last_week()
	{
		include_once('files/functions.php');				  
		
		$w = last_week_start_end_pn_nd();		   							
		
		//pobierz wszystkie domeny
		$sql = "SELECT * from user_domain";		 			
		$data = $this->db->query($sql);	
		$domains = $data->result_array();
		
		foreach($domains as $d)
		{
			//pobierz wszystkie slowa kluczowe dla danej domeny oraz ich cene
			$sql = "SELECT * from user_domain_keyword where domain_id=".$d['id']."";			
			$data = $this->db->query($sql);	
			$keywords = $data->result_array();		
			
			//dla danego slowa kluczowego sprawdz pozycje w google dla danego tygodnia od roku zdefiniowanego w $year do daty roku aktualnego
			foreach($keywords as $k)
			{			
				//pobierz liczbe dni danego keywordsa ktorego pozycja w gogle byla nie wieksza niz 10
				$sql = "SELECT count(*) as days, keyword_id, date from user_domain_keywords_stats_".$d['google_region']." where keyword_id=".$k['id']." and position <= 10 and (date >= '".$w['start']."' AND date <= '".$w['end']."') group by keyword_id ";			
				$data = $this->db->query($sql);	
				$kstats = $data->result_array();				
				
				foreach($kstats as $s)
				{											
					if($s['days']==7)
					{
						$all_price = 0;						
						$percent = $k['percent']/100;
						$price = $k['price'];						
						$num_of_weeks_in_months = $w['weeks_in_months'];						
						$all_price = ($percent * $price) / $num_of_weeks_in_months;
						
						$data_insert['keyword_id'] = $s['keyword_id'];
						$data_insert['year'] = substr($w['start'],0,4);
						$data_insert['month'] = substr($w['start'],5,2);
						$data_insert['week'] = $w['week_number'];
						$data_insert['google_region'] = $d['google_region'];
						$data_insert['price'] = $all_price;
						
						//sprawdzenie czy juz jakims cudem ktos kiedys nie wyliczyl ceny dla tego slowa kluczowego w tym roku i wtym tyg  
						$sql = "SELECT * from keyword_price_per_week where keyword_id = ".$s['keyword_id']." and year = ".substr($s['date'],0,4)." and week = ".$w['week_number']." ";			
						$data_check = $this->db->query($sql);	
						
						if($data_check->result_array()==null)
						{					        
				        	$this->db->insert('keyword_price_per_week', $data_insert);
						}
						else
						{
							echo 'juz to masz dodane <br />';
						}														
					}
				}	
			}												
		
		}
	}
}

?>