<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
/*
 * DESCRIPTION: Klasa z funkcjami do walidacji danych
 */
class Walidacja
{
	function Walidacja()
	{}
	
	//walidacja numeru nip-----------------------------------------------------------------------------
	function CheckNIP($str)
	{
		if (strlen($str) != 10)
		{
			return false;
		}
	 
		$arrSteps = array(6, 5, 7, 2, 3, 4, 5, 6, 7);
		$intSum=0;
		for ($i = 0; $i < 9; $i++)
		{
			$intSum += $arrSteps[$i] * $str[$i];
		}
		$int = $intSum % 11;
	 
		$intControlNr=($int == 10)?0:$int;
		if ($intControlNr == $str[9])
		{
			return true;
		}
		return false;
	}
	//walidacja pesela------------------------------------------------------------------------
	function CheckPESEL($str)
	{
		if (!preg_match('/^[0-9]{11}$/',$str)) //sprawdzamy czy ciąg ma 11 cyfr
		{
			return false;
		}
	 
		$arrSteps = array(1, 3, 7, 9, 1, 3, 7, 9, 1, 3); // tablica z odpowiednimi wagami
		$intSum = 0;
		for ($i = 0; $i < 10; $i++)
		{
			$intSum += $arrSteps[$i] * $str[$i]; //mnożymy każdy ze znaków przez wagć i sumujemy wszystko
		}
		$int = 10 - $intSum % 10; //obliczamy sumć kontrolną
		$intControlNr = ($int == 10)?0:$int;
		if ($intControlNr == $str[10]) //sprawdzamy czy taka sama suma kontrolna jest w ciągu
		{
			return true;
		}
		return false;
	} 	
	//walidacja regonu------------------------------------------------------------------------
	function CheckREGON($str)
	{
		if (preg_match('/^[0-9]{14}$/',$str))
		{
			return true;
		}

		if (strlen($str) != 9)
		{
			return false;
		}
	 
		$arrSteps = array(8, 9, 2, 3, 4, 5, 6, 7);
		$intSum=0;
		for ($i = 0; $i < 8; $i++)
		{
			$intSum += $arrSteps[$i] * $str[$i];
		}
		$int = $intSum % 11;
		$intControlNr=($int == 10)?0:$int;
		if ($intControlNr == $str[8]) 
		{
			return true;
		}
		return false;
	}	
	//walidacja emaila-----------------------------------------------------------------------------
	function CheckEmail($email)
	{
		$isValid = true;
		$atIndex = strrpos($email, "@");
		if (is_bool($atIndex) && !$atIndex)
		{
		   $isValid = false;
		}
		else
		{
		   $domain = substr($email, $atIndex+1);
		   $local = substr($email, 0, $atIndex);
		   $localLen = strlen($local);
		   $domainLen = strlen($domain);
		   if ($localLen < 1 || $localLen > 64)
		   {
		      // local part length exceeded
		      $isValid = false;
		   }
		   else if ($domainLen < 1 || $domainLen > 255)
		   {
		      // domain part length exceeded
		      $isValid = false;
		   }
		   else if ($local[0] == '.' || $local[$localLen-1] == '.')
		   {
		      // local part starts or ends with '.'
		      $isValid = false;
		   }
		   else if (preg_match('/\\.\\./', $local))
		   {
		      // local part has two consecutive dots
		      $isValid = false;
		   }
		   else if (!preg_match('/^[A-Za-z0-9\\-\\.]+$/', $domain))
		   {
		      // character not valid in domain part
		      $isValid = false;
		   }
		   else if (preg_match('/\\.\\./', $domain))
		   {
		      // domain part has two consecutive dots
		      $isValid = false;
		   }
		   else if(!preg_match('/^(\\\\.|[A-Za-z0-9!#%&`_=\\/$\'*+?^{}|~.-])+$/',
		              str_replace("\\\\","",$local)))
		   {
		      // character not valid in local part unless 
		      // local part is quoted
		      if (!preg_match('/^"(\\\\"|[^"])+"$/',
		          str_replace("\\\\","",$local)))
		      {
		         $isValid = false;
		      }
		   }
		   if ($isValid && !(checkdnsrr($domain,"MX") || checkdnsrr($domain,"A")))
		   {
		      // domain not found in DNS
		      $isValid = false;
		   }
		}
		return $isValid;
	}	
	//walidacja kodu pocztowego--------------------------------------------------------------------
	function CheckKodPocztowy($postcode)
	{
		return preg_match('/^[0-9]{2}-?[0-9]{3}$/Du', $postcode);
	}
	//walidacja liczby calkowitej------------------------------------------------------------------
	function CheckLiczbaCalkowita($param)
	{
	    return ereg('^[+-]?[0-9]+$', $param);
	}
	//walidacja liczby zmiennoprzecinkowej--------------------------------------------------------
	function CheckLiczbaZmiennoprzecinkowa($param) 
	{
	    return ereg('^[+-]?[0-9]*\.?[0-9]+$', $param);
	}	
	//walidacja adresu url------------------------------------------------------------------------
	function CheckURL($url)
	{
		if (preg_match('/^(http|https|ftp):\/\/([A-Z0-9][A-Z0-9_-]*(?:\.[A-Z0-9][A-Z0-9_-]*)+):?(\d+)?\/?/i', $url)) {
		    return TRUE;
		} else {
		    return FALSE;
		}		
	}
	//walidacja numer rachunku bankowego---------------------------------------------------------
	//source: http://phpedia.pl/wiki/Walidacja_numeru_NRB
	//desc: Sprawdzenie poprawności numeru rachunku (konta) bankowego w standardzie NRB
	//		Od dnia 1 lipca 2004 w rozliczeniach krajowych stosowany jest wyłącznie numer NRB.
	function CheckNRB2($p_iNRB)
	{
	  // Usuniecie spacji
	  $iNRB = str_replace(' ', '', $p_iNRB);
	  // Sprawdzenie czy przekazany numer zawiera 26 znaków
	  if(strlen($iNRB) != 26)
	    return false;
	 
	  // Zdefiniowanie tablicy z wagami poszczególnych cyfr				
	  $aWagiCyfr = array(1, 10, 3, 30, 9, 90, 27, 76, 81, 34, 49, 5, 50, 15, 53, 45, 62, 38, 89, 17, 73, 51, 25, 56, 75, 71, 31, 19, 93, 57);
	 
	  // Dodanie kodu kraju (w tym przypadku dodajemy kod PL)		
	  $iNRB = $iNRB.'2521';
	  $iNRB = substr($iNRB, 2).substr($iNRB, 0, 2); 
	 
	  // Wyzerowanie zmiennej
	  $iSumaCyfr = 0;
	 
	  // Pćtla obliczająca sumć cyfr w numerze konta
	  for($i = 0; $i < 30; $i++) 
	    $iSumaCyfr += $iNRB[29-$i] * $aWagiCyfr[$i];
	 
	  // Sprawdzenie czy modulo z sumy wag poszczegolnych cyfr jest rowne 1
	  return ($iSumaCyfr % 97 == 1);
	}
	//-------------------------------------------------------------------------------------------
    //NRB - poprawność numeru konta
    //source: http://szewo.com/php/nrb.phtml
    function CheckNRB($nrb) {

	  // Usuniecie spacji
	  $nrb = str_replace(' ', '', $nrb);

      if (strlen($nrb)!=26)
       return 0;
      $W = array(1,10,3,30,9,90,27,76,81,34,49,5,50,15,53,45,62,38,89,17,
                       73,51,25,56,75,71,31,19,93,57);

      $nrb .= "2521";
      $nrb = substr($nrb,2).substr($nrb,0,2);
      $Z =0;
      for ($i=0;$i<30;$i++)
        $Z += $nrb[29-$i] * $W[$i];
      if ($Z % 97 == 1)
        return 1;
      else
        return 0;
    }
    //-------------------------------------------------------------------------------------------
}
?>