<?php
class Memberwscv extends Controller {
    function __construct() {
        parent::Controller();
        
        require_once('files/nusoap/nusoap.php');
		$this->load->library('session');	
		$this->load->helper(array('url'));
        
        $this->nusoap_server = new soap_server();
        $this->nusoap_server->configureWSDL("MemberWSDL", "urn:MemberWSDL");
        
        $this->nusoap_server->wsdl->addComplexType(
            "MemberRecordset",
            "complexType",
            "array",
            "",
            "SOAP-ENC:Array",
            array(
                "id"=>array("name"=>"id", "type"=>"xsd:int"),
                "firstname"=>array("name"=>"firstname", "type"=>"xsd:string"),
                "lastname"=>array("name"=>"lastname", "type"=>"xsd:string")
            )
        );    
        
        $this->nusoap_server->register(
            "selectMemberInfo",
            array(
                "id" => "xsd:int",
            ),
            array("return"=>"tns:MemberRecordset"),
            "urn:MemberWSDL",
            "urn:MemberWSDL#selectMemberInfo",
            "rpc",
            "encoded",
            "Get member's info"
        );
    }
    function index() {
        // this just expose webservice's methods. if you put this in every method of the webservice to describe it you won't get it to work because of some post/get issues i guess


        // this is a workaround for not having get params enabled in ci
        // usually you get the nusoap webservice's wsdl by appending "?wsdl" at the end of its url

        if($this->uri->segment(3) == "wsdl") {
            $_SERVER['QUERY_STRING'] = "wsdl";
        } else {
            $_SERVER['QUERY_STRING'] = "";
        }
        
        $this->nusoap_server->service(file_get_contents("php://input"));
    }
    
    function select_member_info() {
        function selectMemberInfo($member_id) {
            return array('id'=>'','firstname'=>'','lastname'=>'');
        }
        
        $this->nusoap_server->service(file_get_contents("php://input"));
    }	
}
?>