<?php
	error_reporting(0);
	require_once('files/nusoap/nusoap.php');
 	require_once('files/lib/DB.config.php');
 	require_once('files/lib/DBManager.class.php');
 	
	$NAMESPACE = 'http://networds.datatask.net/';
	
	
	 
	$server = new soap_server;
	$server->configureWSDL('ticketsWSDL', $NAMESPACE);
	$server->wsdl->schemaTargetNamespace = $NAMESPACE;
	$ini = ini_set("soap.wsdl_cache_enabled", 0);
	$server->soap_defencoding = 'UTF-8';
	$server->decode_utf8 = false;
	
	login('admin','admin');
	
	$server->wsdl->addComplexType(
	    'Admin',
	    'complexType',
	    'struct',
	    'all',
	    '',
	    array(
	        'id' => array('name'=>'id'				,'type'=>'xsd:string'),
	        'name' => array('name'=>'name'			,'type'=>'xsd:string'),
	        'password' => array('name'=>'password'	,'type'=>'xsd:string'),
	        'email' => array('name'=>'email'		,'type'=>'xsd:string')
	    )
	);
	
	$server->wsdl->addComplexType('Admins',
					'complexType',
					'array',
					'',
					'SOAP-ENC:Array',
					array(),
					array(
						array('ref'=>'SOAP-ENC:arrayType',
						'wsdl:arrayType'=>'tns:Admin[]')
					),
					'tns:Admin'
				);	

	//Kategorie
	$server->wsdl->addComplexType(
	    'Kategoria',
	    'complexType',
	    'struct',
	    'all',
	    '',
	    array(
	        'id' 	=> array('name'=>'id'			,'type'=>'xsd:string'),
	        'nazwa' => array('name'=>'nazwa'		,'type'=>'xsd:string')
	    )
	);
	
	$server->wsdl->addComplexType('Kategorie',
					'complexType',
					'array',
					'',
					'SOAP-ENC:Array',
					array(),
					array(
						array('ref'=>'SOAP-ENC:arrayType',
						'wsdl:arrayType'=>'tns:Kategoria[]')
					),
					'tns:Kategoria'
				);
	//end of kategorie
	
	//Zalacznik
	$server->wsdl->addComplexType(
	    'Zalacznik',
	    'complexType',
	    'struct',
	    'all',
	    '',
	    array(
	        'id' 			=> array('name'=>'id'			,'type'=>'xsd:int'),
	        'sciezka' 		=> array('name'=>'sciezka'		,'type'=>'xsd:string')
	    )
	);	
	
	$server->wsdl->addComplexType('Zalaczniki',
					'complexType',
					'array',
					'',
					'SOAP-ENC:Array',
					array(),
					array(
						array('ref'=>'SOAP-ENC:arrayType',
						'wsdl:arrayType'=>'tns:Zalacznik[]')
					),
					'tns:Zalacznik'
				);	
	//end of zalacznik
	
	
	//ticket
	$server->wsdl->addComplexType(
	    'Ticket',
	    'complexType',
	    'struct',
	    'all',
	    '',
	    array(
	        'id' 				=> array('name'=>'id'			,'type'=>'xsd:int'),
	        'parent_id' 		=> array('name'=>'nazwa'		,'type'=>'xsd:int'),
			'kategoria_id' 		=> array('name'=>'nazwa'		,'type'=>'xsd:int'),
			'status_id' 		=> array('name'=>'nazwa'		,'type'=>'xsd:int'),
			'priorytet_id' 		=> array('name'=>'nazwa'		,'type'=>'xsd:int'),
			'nadawca_id' 		=> array('name'=>'nazwa'		,'type'=>'xsd:int'),
			'odbiorca_id' 		=> array('name'=>'nazwa'		,'type'=>'xsd:int'),
			'temat' 			=> array('name'=>'nazwa'		,'type'=>'xsd:string'),
			'wiadomosc' 		=> array('name'=>'nazwa'		,'type'=>'xsd:string'),
			'data_wyslania' 	=> array('name'=>'nazwa'		,'type'=>'xsd:string'),
			'data_odebranie' 	=> array('name'=>'nazwa'		,'type'=>'xsd:string'),
	    )
	);
	
	$server->wsdl->addComplexType('Tickets',
					'complexType',
					'array',
					'',
					'SOAP-ENC:Array',
					array(),
					array(
						array('ref'=>'SOAP-ENC:arrayType',
						'wsdl:arrayType'=>'tns:Tickets[]')
					),
					'tns:Tickets'
				);	
	//end of ticket
	
					
	//ticket list item
	$server->wsdl->addComplexType(
	    'ticket_list_item',
	    'complexType',
	    'struct',
	    'all',
	    '',
	    array(
	        'id' 				=> array('name'=>'id'					,'type'=>'xsd:string'),
	        'parent_id' 		=> array('name'=>'parent_id'			,'type'=>'xsd:string'),
	        'kategoria_id' 		=> array('name'=>'kategoria_id'			,'type'=>'xsd:string'),
	        'status_id' 		=> array('name'=>'status_id'			,'type'=>'xsd:string'),
			'priorytet_id' 		=> array('name'=>'priorytet_id'			,'type'=>'xsd:string'),
			'nadawca_id' 		=> array('name'=>'nadawca_id'			,'type'=>'xsd:string'),
			'odbiorca_id' 		=> array('name'=>'odbiorca_id'			,'type'=>'xsd:string'),
			'temat' 			=> array('name'=>'temat'				,'type'=>'xsd:string'),
			'wiadomosc' 		=> array('name'=>'wiadomosc'			,'type'=>'xsd:string'),
			'data_wyslania' 	=> array('name'=>'data_wyslania'		,'type'=>'xsd:string'),
			'data_odebrania' 	=> array('name'=>'data_odebrania'		,'type'=>'xsd:string'),
			'odebrano' 			=> array('name'=>'odebrano'				,'type'=>'xsd:string'),
			'kategoria' 		=> array('name'=>'kategoria'			,'type'=>'xsd:string'),
			'liczba_odpowiedzi' => array('name'=>'liczba_odpowiedzi'	,'type'=>'xsd:string'),
			'status' 			=> array('name'=>'status'				,'type'=>'xsd:string'),
			'priorytet' 		=> array('name'=>'priorytet'			,'type'=>'xsd:string'),
			'zalaczniki' 		=> array('name'=>'zalaczniki'			,'type'=>'xsd:string'),
			'nadawca' 			=> array('name'=>'nadawca'				,'type'=>'xsd:string'),
			'odbiorca' 			=> array('name'=>'odbiorca'				,'type'=>'xsd:string')
	    )
	);	
	
	$server->wsdl->addComplexType('ticket_list_items',
					'complexType',
					'array',
					'',
					'SOAP-ENC:Array',
					array(),
					array(
						array('ref'=>'SOAP-ENC:arrayType',
						'wsdl:arrayType'=>'tns:ticket_list_item[]')
					),
					'tns:ticket_list_item'
				);
	
	$server->register(
	    'hello_world',
	    array('name'=>'xsd:string'),
	    array('return'=>'xsd:string'),
	    $NAMESPACE);			

	$server->register(
	    'getAdmins',
	    array(),
	    array('return'=>'tns:Admins'),
	    $NAMESPACE);
	
	$server->register(
		'getOdebrane',
	    array('accountId'=>'xsd:int','condition'=>'xsd:int'),
	    array('return'=>'tns:ticket_list_items'),
	    $NAMESPACE);
		
	$server->register(
		'getWyslane',
	    array('accountId'=>'xsd:int','condition'=>'xsd:int'),
	    array('return'=>'tns:ticket_list_items'),
	    $NAMESPACE);	
		
	$server->register(
	    'getKategorie',
	    array(),
	    array('return'=>'tns:Kategorie'),
	    $NAMESPACE);
		
	$server->register(
		'addTicket',
		 array('ticket'=>'tns:Ticket','zalaczniki'=>'tns:Zalaczniki'),
		 array('return'=>'xsd:boolean'),
		 $NAMESPACE);
	
	$server->register(
		'addResponse',
		 array('ticket'=>'tns:Ticket','zalaczniki'=>'tns:Zalaczniki'),
		 array('return'=>'xsd:boolean'),
		 $NAMESPACE);			
	    	    
	function hello_world($name)
	{
		
	    return 'Hello '.$name;
	}
	function getAdmins()
	{
		
		//if(!checkLogin())
		//	return FALSE;	
	
		try{
				$mysqli = DBManager::getConnection();
				$sql    = 'SELECT * FROM admin';
				$result = $mysqli->query($sql);
					if($mysqli->error)
						throw new Exception($mysqli->error);
				$data;	
					    while ($row = $result->fetch_assoc()) {
						       $data[] = $row;
						    }					
						
						return $data;
			}
		catch(Exception $e)
			{
				//echo 'Wystąpił błąd: '.$e->getMessage().'<br />';
			}
		return FALSE;
	}
	/*----------------------------------------------------------------------------------------------------------------*/
	function login($user,$password)
	{
			
		try
		{
			$mysqli = DBManager::getConnection();
			$sql    = 'SELECT k.id AS id_konta,a.id AS id,a.name AS name,a.password AS password ,a.email AS email
			           FROM konta k JOIN admin a ON k.origin_id=a.id
			           WHERE a.name=\''.$user.'\' AND a.password=md5(\''.$password.'\')';
					   
					   
			$result = $mysqli->query($sql);
			if($mysqli->error)
				throw new Exception($mysqli->error);
			if($result->num_rows == 1)
			{
				$user 				= $result->fetch_assoc();
				$_SESSION['user']	= $user;
				return TRUE;				
			}
			$result->close();
		}	
		catch(Exception $e)
		{
			//echo 'Error'.$e->getMessage().'<br />';							
		}	
		return FALSE;
	}
	/*----------------------------------------------------------------------------------------------------------------*/
	function getOdebrane($accountId=22,$condition=null)
	{
		$condition=null;
		try
		{
			$ids = get_received_list_of_ticket_id($accountId,$condition);
			$data = null;
			
			for($i=0;$i<count($ids);$i++)
			{
				$data[] = get_received_ticket_list_item((int)$ids[$i],$condition);		
			}
			
			return $data;
		}
		catch(Exception $e)
		{
			//echo 'Error'.$e->getMessage().'<br />';							
		}	
		return FALSE;		
	}
	/*----------------------------------------------------------------------------------------------------------------*/			
	function getWyslane($accountId=22,$condition=null)
	{
		$condition = null;
		try		
		{
			$ids 	= get_sended_list_of_ticket_id($accountId,$condition);
			$data 	= null;
			
			for($i=0;$i<count($ids);$i++)
			{
				if($i<count($ids))
					$data[] = get_received_ticket_list_item((int)$ids[$i]);		
			}
			return $data;			
		}
		catch(Exception $e)
		{
			//echo 'Error'.$e->getMessage().'<br />';							
		}	
		return FALSE;			
	}
	/*----------------------------------------------------------------------------------------------------------------*/
	function showTicket($id)
	{}
	
	function addTicket($ticket,$zalaczniki)
	{
		//add($nadawca,$odbiorca,$kategoria,$status,$priorytet,$temat,$wiadomosc,$files,$parent_id=0)
		//print_r($ticket);
		try
		{
			if(!add($ticket['nadawca_id'],$ticket['odbiorca_id'],$ticket['kategoria_id'],$ticket['status_id'],$ticket['priorytet_id'],$ticket['temat'],$ticket['wiadomosc'],$zalaczniki))
				throw new Exception();
			/*
			//nadawca
			$status_name 		= get_status_name_by_id($form_data['status']);
			$nadawca_email		= get_user_email_by_account_id($nadawca);
			$nadawca_type   	= get_user_type_by_account_id($nadawca);
			send_email($ticket_id,$status_name,$form_data['kategoria'],$nadawca_email,$nadawca_type); //do nadawcy
			
			//odbiorca					
			$odbiorca_email		= get_user_email_by_account_id($form_data['odbiorca']);
			$odbiorca_type   	= get_user_type_by_account_id($form_data['odbiorca']);
			send_email($ticket_id,$status_name,$form_data['kategoria'],$odbiorca_email,$odbiorca_type);					
			*/
		}
		catch(Exception $e)
		{
			return FALSE;				
		}
		return TRUE;
		
	}
	function addResponse($ticket,$zalaczniki)
	{
		try
		{
			if(add($ticket->nadawca,$ticket->odbiorca,$ticket->kategoria,$ticket->status,$ticket->priorytet,$ticket->temat,$ticket->wiadomosc,$zalaczniki,$ticket->parent_id))		
				return TRUE;
			else
				return FALSE;
		}
		catch(Exception $e)
		{
						
		}
		return FALSE;		
	}
	function startResponse()
	{}
	
	
	// Use the request to (try to) invoke the service
	$HTTP_RAW_POST_DATA = isset($HTTP_RAW_POST_DATA) ? $HTTP_RAW_POST_DATA : '';
	$server->service($HTTP_RAW_POST_DATA);
	//print_r('login '.login('admin','admin'));
	//print_r(add(22,23,1,1,1,'XoX','Xcxc',null,0));
	//var_dump(getOdebrane());
	//logout();
	
	
	/*---------------------------------------------------------------------*/
	//PRIVATE FUNCTIONS:
	/*---------------------------------------------------------------------*/

	/*----------------------------------------------------------------------------------------------------------------*/
	function get_received_list_of_ticket_id($accountId,$monthCondition = null)
	{
		$data 	 = null;
		$sql  	 = null;
		$result  = null;
		
		$mysqli = DBManager::getConnection();
		
			if($monthCondition == null)
			{
				$sql  = "(SELECT t0.id FROM tickety AS t0 WHERE t0.odbiorca_id = $accountId AND t0.parent_id IS NULL)
		 				 UNION
						 (SELECT t0.id FROM tickety AS t0 WHERE t0.odbiorca_id = $accountId AND t0.parent_id IS NOT NULL
		                 AND t0.parent_id NOT IN (SELECT t1.id FROM tickety AS t1 WHERE t1.odbiorca_id = $accountId AND t1.parent_id IS NULL)
						 GROUP BY t0.parent_id)
						 ORDER BY id DESC";
				//$query = $this->default->query($sql,array($accountId,$accountId,$accountId));
				$mysqli->query("SET NAMES 'utf8'");
				$result = $mysqli->query($sql);
			}
			else
			{
				
 			$current_year  = (int)date('o');
			$current_month = (int)date('m');
			
			$yearCondition = $current_year; 
			if($current_month < $monthCondition)
				$yearCondition--; 

				$sql  = "(SELECT t0.id FROM tickety AS t0 WHERE t0.odbiorca_id= $accountId AND t0.parent_id IS NULL AND MONTH(t0.data_wyslania) = $monthCondition AND YEAR(t0.data_wyslania) = $yearCondition)
		 				 UNION
						 (SELECT t0.id FROM tickety AS t0 WHERE t0.odbiorca_id= $accountId AND t0.parent_id IS NOT NULL  AND MONTH(t0.data_wyslania) = $monthCondition AND YEAR(t0.data_wyslania) = $yearCondition
		                 AND t0.parent_id NOT IN (SELECT t1.id FROM tickety AS t1 WHERE t1.odbiorca_id= $accountId AND t1.parent_id IS NULL)
						 GROUP BY t0.parent_id)
						 ORDER BY id DESC";
				//$query = $this->default->query($sql,array($accountId,$monthCondition,$yearCondition,$accountId,$monthCondition,$yearCondition,$accountId));
				$result = $mysqli->query($sql);

			}
		/*		 
		foreach ($result->result() as $row)
		{
			$data[] = $row->id;			
		}
		*/
		$data = null;
	    while ($row = $result->fetch_assoc()) {
		       $data[] = $row['id'];
		    }			
			
		return $data;					 
	}	
	/*----------------------------------------------------------------------------------------------------------------*/
	function get_sended_list_of_ticket_id($accountId,$monthCondition=null)
	{
		$row 		= null;
		$sql  		= null;
		$result  	= null;
		$mysqli = DBManager::getConnection();
		$monthCondition = null;
		
		try
		{
			if($monthCondition == null)
			{
				
				$sql  = "(SELECT t0.id FROM tickety AS t0 WHERE t0.nadawca_id= $accountId AND t0.parent_id IS NULL )
		 				 UNION
						 (SELECT t0.id FROM tickety AS t0 WHERE t0.nadawca_id= $accountId AND t0.parent_id IS NOT NULL
		                 AND t0.parent_id NOT IN (SELECT t1.id FROM tickety AS t1 WHERE t1.nadawca_id= $accountId AND t1.parent_id IS NULL)
						 GROUP BY t0.parent_id)
						 ORDER BY id DESC";
				//$query = $this->default->query($sql,array($accountId,$accountId,$accountId));
				$mysqli->query("SET NAMES 'utf8'");
				$result = $mysqli->query($sql);
			}
			else
			{
	
				$current_year  = (int)date('o');
				$current_month = (int)date('m');
				
				$yearCondition = $current_year; 
				if($current_month < $monthCondition)
					$yearCondition--; 
								
				$sql  = "(SELECT t0.id FROM tickety AS t0 WHERE t0.nadawca_id= ? AND t0.parent_id IS NULL AND MONTH(t0.data_wyslania) = ? AND YEAR(t0.data_wyslania) = ?)
		 				 UNION
						 (SELECT t0.id FROM tickety AS t0 WHERE t0.nadawca_id= ? AND t0.parent_id IS NOT NULL AND MONTH(t0.data_wyslania) = ? AND YEAR(t0.data_wyslania) = ? 
		                 AND t0.parent_id NOT IN (SELECT t1.id FROM tickety AS t1 WHERE t1.nadawca_id= ? AND t1.parent_id IS NULL)
						 GROUP BY t0.parent_id)
						 ORDER BY id DESC";
				//$query = $this->default->query($sql,array($accountId,$monthCondition,$yearCondition,$accountId,$monthCondition,$yearCondition,$accountId));
				$mysqli->query("SET NAMES 'utf8'");
				$result = $mysqli->query($sql);		
			}
			
			/*
			foreach ($query->result() as $row)
			{
				$data[] = $row->id;			
			}
			
			$query->free_result();
			return $data;
			*/
			$row = $result->fetch_assoc();
			return $row;		
		}
		catch(Exception $e)
		{
			//echo 'Error'.$e->getMessage().'<br />';							
		}	
		return FALSE;		
	}
		
	/*----------------------------------------------------------------------------------------------------------------*/	

	function get_received_ticket_list_item($ticket_id,$monthCondition = null)
	{
		try		
		{
			$row 	= null;
			$sql  	= null;
			$result  = null;
			$mysqli = DBManager::getConnection();
			
			if($monthCondition == null)
			{
				$sql   = "SELECT t.id,t.parent_id,t.kategoria_id,t.status_id,t.priorytet_id,t.nadawca_id,t.odbiorca_id,t.temat,t.wiadomosc,t.data_wyslania,t.data_odebrania,
										IS_NOT_NULL(t.data_odebrania) AS odebrano,
									   (SELECT k.nazwa FROM kategorie k WHERE k.id = t.kategoria_id) AS kategoria,
									   (SELECT COUNT(t1.id) FROM tickety t1 WHERE t1.parent_id=t.id) AS liczba_odpowiedzi,
									   (SELECT s.nazwa FROM statusy s WHERE s.id = t.status_id) AS status,
									   (SELECT p.nazwa FROM priorytety p WHERE p.id = t.priorytet_id) AS priorytet,
									   (SELECT COUNT(zal0.id) FROM zalaczniki zal0 WHERE zal0.ticket_id = t.id) as zalaczniki,
									   GET_USER_NAME_BY_ID(t.nadawca_id) AS nadawca,
									   GET_USER_NAME_BY_ID(t.odbiorca_id) AS odbiorca
								FROM tickety AS t 
								WHERE t.id = $ticket_id";
				$mysqli->query("SET NAMES 'utf8'");				
				$result = $mysqli->query($sql);
						
			}
			else
			{
				$current_year  = (int)date('o');
				$current_month = (int)date('m');
				
				$yearCondition = $current_year; 
				if($current_month < $monthCondition)
					$yearCondition--; 
				
				$sql   = "SELECT t.id,t.parent_id,t.kategoria_id,t.status_id,t.priorytet_id,t.nadawca_id,t.odbiorca_id,t.temat,t.wiadomosc,t.data_wyslania,t.data_odebrania,
										IS_NOT_NULL(t.data_odebrania) AS odebrano,
									   (SELECT k.nazwa FROM kategorie k WHERE k.id = t.kategoria_id) AS kategoria,
									   (SELECT COUNT(t1.id) FROM tickety t1 WHERE t1.parent_id=t.id) AS liczba_odpowiedzi,
									   (SELECT s.nazwa FROM statusy s WHERE s.id = t.status_id) AS status,
									   (SELECT p.nazwa FROM priorytety p WHERE p.id = t.priorytet_id) AS priorytet,
									   (SELECT COUNT(zal0.id) FROM zalaczniki zal0 WHERE zal0.ticket_id = t.id) as zalaczniki,
									   GET_USER_NAME_BY_ID(t.nadawca_id) AS nadawca,
									   GET_USER_NAME_BY_ID(t.odbiorca_id) AS odbiorca
								FROM tickety AS t 
								WHERE t.id= $ticket_id AND MONTH(t.data_wyslania) = $monthCondition AND YEAR(t.data_wyslania) = $yearCondition";
				$mysqli->query("SET NAMES 'utf8'");				
				$result = $mysqli->query($sql);			
				
			}
			
			if($mysqli->error)
				throw new Exception($mysqli->error);	
				
			$row = $result->fetch_assoc();
			return $row;						
			/*
			$row = $query->result();
			
			if(isset($row[0]))
				return $row[0];
			else
				return null;			
			*/
			
		}
		catch(Exception $e)
		{
			//echo 'Error'.$e->getMessage().'<br />';							
		}	
		return FALSE;		
	}	
	
	/*----------------------------------------------------------------------------------------------------------------*/
	function add($nadawca,$odbiorca,$kategoria,$status,$priorytet,$temat,$wiadomosc,$files,$parent_id=0)
	{
		
			try
			{
				$mysqli = DBManager::getConnection();
				
				// turn off auto-commit
				$sql1;
				
					$mysqli->autocommit(FALSE);
					if($parent_id == 0)
						$sql1 = "INSERT INTO tickety(nadawca_id,odbiorca_id,kategoria_id,status_id,priorytet_id,temat,wiadomosc,data_wyslania)
						         VALUES($nadawca,$odbiorca,$kategoria,$status,$priorytet,'$temat','$wiadomosc','".date('Y:m:d H:i:s')."')";
					else
						$sql1 = "INSERT INTO tickety(nadawca_id,parent_id,odbiorca_id,kategoria_id,status_id,priorytet_id,temat,wiadomosc,data_wyslania)
						         VALUES($nadawca,$parent_id,$odbiorca,$kategoria,$status,$priorytet,'$temat','$wiadomosc','".date('Y:m:d H:i:s')."')";
					
					$mysqli->query($sql1);
					if($mysqli->affected_rows!=1)
						throw new Exception('TICKET INSERT ERROR');
					
					$ticket_id = $mysqli->insert_id;
					if($files != null)
					{
						foreach($files as $key=>$value)
						{
							$sql2 = "INSERT INTO zalaczniki(ticket_id,sciezka) VALUES($ticket_id,'/files/uploads/'".$value.")";
							$mysqli->query($sql2);							
						}
					}					
					
			}
			catch(Exception $e)
			{
				
				$mysqli->rollback();
				$mysqli->autocommit(TRUE);
				$mysqli->close();
				return FALSE;	
			}
		$mysqli->autocommit(TRUE);
		$mysqli->close();
		return TRUE;	
	}	

	/*----------------------------------------------------------------------------------------------------------------*/
	function get_status_name_by_id($ticketId)
	{
		try
		{
				$data = null;
				$sql  = "SELECT nazwa FROM statusy WHERE id = ?";
					
				$query = $this->default->query($sql,array($ticketId)); 
				foreach ($query->result() as $row)
				{
					$data[] = $row;			
				}
				$query->free_result();
				
				if(isset($data[0]))
					return $data[0]->nazwa;
				else
					return null;		
		}
		catch(Exception $ex)
		{
			return FALSE;			
		}
		return TRUE;
	}
	
	/*----------------------------------------------------------------------------------------------------------------*/
	function get_user_email_by_account_id($account_id)
	{
		try
		{
			//get origin id, table
			$data  = null;
			$sql   = "SELECT * FROM konta WHERE id = ?";
			$query = $this->default->query($sql,array($account_id));
			
			$rows = $query->result();
			if(isset($rows[0]))
				$account = $rows[0]; 
			
			
			//switch and select correct email
			$sql2 = '';
			switch($account->origin_table)
			{
				case 'user'			: $sql2='SELECT email FROM user_data WHERE user_id =?'; break;
				case 'afilianci'	: $sql2='SELECT email FROM afilianci WHERE id =?'; break;
				case 'admin'		: $sql2='SELECT email FROM admin WHERE id= ?'; break;
				default				: return FALSE; 
			} 		
			
			//return data
			$query = $this->default->query($sql2,array($account->origin_id));
			$rows = $query->result();
			
			
			if(isset($rows[0]))
				return $rows[0]->email;
			else
				return FALSE;	 	
		}
		catch(Exception $e)
		{
						
		}
		return TRUE;
	}	
	/*----------------------------------------------------------------------------------------------------------------*/
	function get_user_type_by_account_id($account_id)
	{
		try
		{
			$data 	= null;
			$sql  	= 'SELECT origin_table FROM konta WHERE id=?';
			$query 	= $this->default->query($sql,array($account_id));
			
			$rows = $query->result();
	
			if(isset($rows))
			{
				switch($rows[0]->origin_table)
				{
					case 'user'			 : $data = 'user'; break; 
					case 'afilianci'	 : $data = 'afiliant'; break;
					case 'admin'		 : $data = 'admin'; break;	
					default				 : return FALSE;			
				}
				return $data;
			}
			else
				return FALSE;
		}
		catch(Exception $ex)
		{
			
			
		}
	}	
	/*----------------------------------------------------------------------------------------------------------------*/
	function send_email($ticket_id,$ticket_status,$ticket_kategoria,$do,$user_type)
	{
		//$do 			- tablica maili do których zostanie wyslana wiadomosc 
		//$user_type	- nazwa okreslajaca nadawce [user | afiliant | admin]
	
		require_once 'files/swift-4.0.5/lib/swift_required.php';
		
		$this->config->load('global_settings');	
		$global_settings 		=  $this->config->item('global_settings');
				
		//filtr .. jesli admin wyslij na alias 
		if($user_type == 'admin')
			$do = $global_settings['alias_emails'][$ticket_kategoria];
		


		
		
		 $transport = Swift_SmtpTransport::newInstance($global_settings['smtp']['smtp_serwer'],587)
		  ->setUsername($global_settings['smtp']['smtp_user'])
		  ->setPassword($global_settings['smtp']['smtp_password']);
		
		$mailer = Swift_Mailer::newInstance($transport);
		
		
		$user_controller = null;
		switch($user_type)
		{
			case 'user'  		: $user_controller = 'admin'; break;
			case 'afiliant'		: $user_controller = 'afiliant'; break;
			case 'admin'		: $user_controller = 'superadmin'; break;		
		}
		
			//kodowanie parametrow
			$user_controller_encoded = $this->ticket->encode($user_controller);
			$ticket_id_encoded 		 = $this->ticket->encode($ticket_id);
		
		
		//Create a message
		$body =  'Wiadomość w systemie networds została '.substr($ticket_status,0,strlen($ticket_status)-1).'a.'.'<br/>'; 
		//$body .= 'Nadawca: '.'<br/>';
		
		if($user_controller != null)
			$body .= 'Wiadomość jest dostępna pod adresem: <br/><a href="'.base_url().'tickets/show/'.$ticket_id_encoded.'/'.$user_controller_encoded.'">'.base_url().'tickets/show/'.$ticket_id_encoded.'/'.$user_controller_encoded.'</a><br/><br/>';
			 
		$body .= 'Email został automatycznie wygenerowany przez system Networds.';
		
	
		$message = Swift_Message::newInstance('Wiadomość Networds: '.$ticket_id)
		  ->setFrom(array($global_settings['smtp']['smtp_user'] => 'Networds System'))
		  ->setTo($do)
		  ->setBody($body, 'text/html', 'utf-8');
		  ;
		
		$headers = $message->getHeaders();
		$headers->addTextHeader('Reply-To',$global_settings['smtp']['smtp_user']);
		     
		//Send the message
		$result = $mailer->send($message);
		return $result; 		
	}	
?>