<?php

class Admin extends Controller {

	function Admin()
	{
		parent::Controller();
		$this->load->library('session');	
		$this->load->helper(array('form', 'url','html'));
		$this->load->model('baza','',TRUE);
				
		$this->config->load('global_settings');	
		$this->global_settings = $this->config->item('global_settings');		
	}
	
	function _check_domain_owner($user_id, $domain_id)
	{
		$domain = $this->baza->check_domain_owner($user_id, $domain_id);
		
		if($domain!=null)
		{
			return true;
		}
		else
		{
			return redirect('/admin','location');	
		}
	}
	
	function index($ticket_id = null)
	{
		
		if(isset($this->session->userdata['user_zalogowany']) and isset($this->session->userdata['di']))
		{	
			$user_data = $this->baza->get_user_login($this->session->userdata['user_zalogowany'], $this->session->userdata['di']);
			
			if($user_data==null)	
			{
				redirect('/admin/logout','location');
			}
			else
			{
					redirect('/admin/start','location');
			}
		}
		else
		{
			$this->load->library('validation');
			$this->validation->set_error_delimiters('<span style="color:red;">', '<br /></span>');
			$fields['login_form'] = 'login_form';
			$fields['pass'] = 'pass';
			$this->validation->set_fields($fields);
			
			$login_form = $this->validation->login_form;
			$pass_form = $this->validation->pass;
			$rules['login_form'] = "callback_login_form_check|required";
			$rules['pass'] = "callback_pass_check[$login_form]|required";
			$this->validation->set_rules($rules);
		
			
			if ($this->validation->run() == FALSE)
			{
				$this->load->view('/layout/home');
			}
			else
			{	
				$haslo_md5 = md5($pass_form);
				$uzyt = $this->baza->user($login_form);
				$di = $uzyt[0]['id'];
				$this->session->set_userdata('user_zalogowany',$haslo_md5);
				$this->session->set_userdata('di',$di);
				
				if($ticket_id != null)
					redirect('/tickets/show/'.$ticket_id,'location');
				else					
					redirect('/admin/start','location');
			}
		}
	}
	function problem()
	{
		if(isset($this->session->userdata['user_zalogowany']) and isset($this->session->userdata['di']))
		{	
			$user_data = $this->baza->get_user_login($this->session->userdata['user_zalogowany'], $this->session->userdata['di']);
			
			if($user_data!=null)	
			{
				$data['user']  = $user_data[0]['name'];
				$this->load->view('/layout/problem_form',$data);
				return;
			}
		}
		$this->load->view('/layout/problem_form');
		
	}
	function start()
	{
		
		if(isset($this->session->userdata['user_zalogowany']) and isset($this->session->userdata['di']))
		{	
			$user_data = $this->baza->get_user_login($this->session->userdata['user_zalogowany'], $this->session->userdata['di']);
			
			if($user_data!=null)	
			{
				$data['user']  = $user_data[0]['name'];
				$this->load->view('/layout/start_page',$data);
				
			}
			else
			{
				redirect('/admin/logout','location');	
			}		
		}
		else
		{
			redirect('/admin/','location');		
		}
	}
	
	function faktury()
	{
		
		if(isset($this->session->userdata['user_zalogowany']) and isset($this->session->userdata['di']))
		{	
			$user_data = $this->baza->get_user_login($this->session->userdata['user_zalogowany'], $this->session->userdata['di']);
			
			if($user_data!=null)	
			{
				$this->load->model('baza_payments','',TRUE);
				$data['user']  = $user_data[0]['name'];
				$data_f['faktury']  = $this->baza_payments->get_factures($this->session->userdata['di']);		
				$data['content']  = $this->load->view('admin/faktury',$data_f,true);
				$this->load->view('/layout/default',$data);
				
			}
			else
			{
				redirect('/admin/logout','location');	
			}		
		}
		else
		{
			redirect('/admin/','location');		
		}
	}
	
	function domain()
	{
		if(isset($this->session->userdata['user_zalogowany']) and isset($this->session->userdata['di']))
		{	
			$user_data = $this->baza->get_user_login($this->session->userdata['user_zalogowany'], $this->session->userdata['di']);
			
			if($user_data!=null)	
			{
				$data['user']  = $user_data[0]['name'];
				$domains = $this->baza->get_domains($this->session->userdata['di']);
				$data['domains'] = $domains;
				
				
				$this->load->view('/layout/domain_page',$data);
				
			}
			else
			{
				redirect('/admin/logout','location');	
			}		
		}
		else
		{
			redirect('/admin/','location');		
		}
	}
	
	function show_domain_stat($id=null)
	{
		if(isset($this->session->userdata['user_zalogowany']) and isset($this->session->userdata['di']))
		{	
			$user_data = $this->baza->get_user_login($this->session->userdata['user_zalogowany'], $this->session->userdata['di']);
			
			if($user_data!=null)	
			{
				$data['user']  = $user_data[0]['name'];
				
				if($id!=null)
				{
					$this->_check_domain_owner($this->session->userdata['di'], $id);
					$keywords = $this->baza->get_domain($id);
					$data['pozycja']    = $this->baza->get_domain_key_position($id);
					$data['keywords']   = $keywords;
					$data['colors']	  	= $this->global_settings['chart_line_colors'];
					
					$this->load->view('/layout/show_domain_page',$data);
				}
				else{
					$this->load->view('blad',$data);
				}
			}
			else
			{
				redirect('/admin/logout','location');	
			}		
		}
		else
		{
			redirect('/admin/','location');		
		}
	}
	
	function show_domain_chart($id=null)
	{
		if(isset($this->session->userdata['user_zalogowany']) and isset($this->session->userdata['di']))
		{	
			$user_data = $this->baza->get_user_login($this->session->userdata['user_zalogowany'], $this->session->userdata['di']);
			
			if($user_data!=null)	
			{
				$data['user']  = $user_data[0]['name'];
				
				if($id!=null)
				{	
					$this->_check_domain_owner($this->session->userdata['di'], $id);
					$keywords = $this->baza->get_keyword_position($id);
					$data['keywords']=$keywords;
					
					$data['colors']	  	    = $this->global_settings['chart_line_colors'];
					$data['domain_id']	    = $id;			
					$data['google_region']	= $this->baza->google_region($id);
								
					$this->load->view('/layout/show_chart_domain_page',$data);
				}
				else{
					$this->load->view('blad',$data);
				}
			}
			else
			{
				redirect('/admin/logout','location');	
			}		
		}
		else
		{
			redirect('/admin/','location');		
		}
	}
	
	
	function show_domain_keyword_activity($id = null, $elem_start = 0)
	{
		if(isset($this->session->userdata['user_zalogowany']) and isset($this->session->userdata['di']))
		{	
			$user_data = $this->baza->get_user_login($this->session->userdata['user_zalogowany'], $this->session->userdata['di']);
			
			if($user_data!=null)	
			{
				$this->load->model('bazapg','','pg');
				$data['user']  = $user_data[0]['name'];
				$data['stats'] = $this->bazapg->get_stats_pagination($id,$elem_start,15);
				$this->load->library('pagination');
				$number_of_rows = $this->bazapg->count_stats($id);
				if(empty($number_of_rows[0]['ile'])) $number_of_rows[0]['ile']=0;
				
				$config['base_url'] = "/admin/show_domain_keyword_activity/$id/";
				$config['url_extention']= '';
				$config['total_rows'] = $number_of_rows[0]['ile'];
				$config['per_page'] = '15';
				$config['num_links'] = '9';
				$config['uri_segment'] = 4;
				$config['first_link'] = '<<';
				$config['last_link'] = '>>';
				
				$this->pagination->initialize($config);
				$data['paginacja'] = $this->pagination->create_links();					
				$data['domain_id']=$id;						
				$this->load->view('/layout/show_domain_search_term',$data);
	
			}
			else
			{
				redirect('/admin/logout','location');	
			}
		}		
		else
		{
			redirect('/admin/','location');		
		}
	}
	
	function show_domain_statcounter($id = null, $type = 1, $elem_start = 0)
	{
		if(isset($this->session->userdata['user_zalogowany']) and isset($this->session->userdata['di']))
		{	
			$user_data = $this->baza->get_user_login($this->session->userdata['user_zalogowany'], $this->session->userdata['di']);
			
			if($user_data!=null)	
			{
				$data['user']  = $user_data[0]['name'];
				
				if($id!=null)
				{	
					$this->load->library('pagination');
					$this->_check_domain_owner($this->session->userdata['di'], $id);
		
					switch($type)
					{
					    case 1: {
					    			// "Dzienne"; 
									$data['name_of_type'] = "Dzienne"; 
									$prefs = array (
           					    					'show_next_prev'  => TRUE,
               										'next_prev_url'   => '/admin/show_domain_statcounter/'.$id.'/'.$type.'',
							    					'month_type'   => 'long',
							    					'day_type'     => 'short'
             										);
								
								$prefs['template'] = '
			
												   {table_open}<table border="0" cellpadding="0" cellspacing="0">{/table_open}
												
												   {heading_row_start}<tr>{/heading_row_start}
												
												   {heading_previous_cell}<th><a href="{previous_url}/01">&lt;&lt;</a></th>{/heading_previous_cell}
												   {heading_title_cell}<th colspan="{colspan}">{heading}</th>{/heading_title_cell}
												   {heading_next_cell}<th><a href="{next_url}/01">&gt;&gt;</a></th>{/heading_next_cell}
												
												   {heading_row_end}</tr>{/heading_row_end}
												
												   {week_row_start}<tr>{/week_row_start}
												   {week_day_cell}<td>{week_day}</td>{/week_day_cell}
												   {week_row_end}</tr>{/week_row_end}
												
												   {cal_row_start}<tr>{/cal_row_start}
												   {cal_cell_start}<td>{/cal_cell_start}
												
												   {cal_cell_content}<a href="{content}">{day}</a>{/cal_cell_content}
												   {cal_cell_content_today}<div class="highlight"><a href="{content}">{day}</a></div>{/cal_cell_content_today}
												
												   {cal_cell_no_content}{day}{/cal_cell_no_content}
												   {cal_cell_no_content_today}<div class="highlight">{day}</div>{/cal_cell_no_content_today}
												
												   {cal_cell_blank}&nbsp;{/cal_cell_blank}
												
												   {cal_cell_end}</td>{/cal_cell_end}
												   {cal_row_end}</tr>{/cal_row_end}
												
												   {table_close}</table>{/table_close}';
											
								   $this->load->library('calendar', $prefs);
									
									break;
								}
					    case 2: {
					    			// "Tygodniowe"; 
									$data['name_of_type'] = "Tygodniowe";
									//include_once('files/dateclass.php');
									break;
								}
					    case 3: {
					    			// "Miesieczne";
									$data['name_of_type'] = "Miesieczne";
									break;
								}
					    case 4: {
					    			// "Roczne";
									$data['name_of_type'] = "Roczne";
									break;
								}
					}
					
					
					//$this->load->model('bazapg','','pg');
					
					//$data['selected']=$selected_category;
					//$data['stats'] = $this->bazapg->get_stats_pagination($id,$elem_start,50);
					//$counter=$this->gallery->count_category_pictures($selected_category);
					//$this->load->library('pagination');
					//$number_of_rows = $this->bazapg->count_stats($id);

					/*
					$config['base_url'] = "/admin/show_domain_statcounter/$id/$type/$elem_start/";
					$config['url_extention']= '';
					$config['total_rows'] = $number_of_rows[0]['ile'];
					$config['per_page'] = '50';
					$config['num_links'] = '9';
					$config['uri_segment'] = 6;
					$config['first_link'] = '<<';
					$config['last_link'] = '>>';
					
					$this->pagination->initialize($config);
					$data['paginacja'] = $this->pagination->create_links();	
					*/
					$data['domain_id']=$id;
					//$data['stats'] = $this->bazapg->get_stats($id, $elem_start, 12);
					$data['type'] = $type;						
					$this->load->view('/layout/show_stats_chart_domain_page',$data);
				}
				else{
					$this->load->view('blad',$data);
				}
				
			}
			else
			{
				redirect('/admin/logout','location');	
			}		
		}
		else
		{
			redirect('/admin/','location');		
		}
	}
	
	function profile()
	{
		if(isset($this->session->userdata['user_zalogowany']) and isset($this->session->userdata['di']))
		{	
			$user_data = $this->baza->get_user_login($this->session->userdata['user_zalogowany'], $this->session->userdata['di']);
		
			if($user_data!=null)	
			{
				$data['user']  = $user_data[0]['name'];
		
				if(isset($_POST['id']))
				{
					if($_POST['id']!='')
					{
						$this->baza->update_user_data($_POST['id'],$_POST['user_id'],$_POST['company_name'],$_POST['contact_name'],$_POST['tax_id'],$_POST['website'],$_POST['email'],$_POST['city'],$_POST['post_code'],$_POST['street'],$_POST['b_no'],$_POST['a_no']);						
						$data['user_data'] = $this->baza->get_user_data($this->session->userdata['di']);
						$data['user_data'][0] += $this->baza->get_user_account($_POST['user_id']);
						$this->load->view('/layout/profile_page',$data);
					}
					else
					{
						$data['user_data'] = $this->baza->get_user_data($this->session->userdata['di']);
						$data['user_data'][0] += $this->baza->get_user_account($this->session->userdata['di']);
						$this->load->view('/layout/profile_page',$data);
					}
				}
				else
				{
					
					$data['user_data'] = $this->baza->get_user_data($this->session->userdata['di']);
					$data['user_data'][0] += $this->baza->get_user_account($this->session->userdata['di']);
					$this->load->view('/layout/profile_page',$data);
				}	
				
			}
			else
			{
				redirect('/admin/logout','location');	
			}		
		}
		else
		{
			redirect('/admin/','location');		
		}
	}
	
	function login_form_check($str)
	{
		$user=$this->baza->user($str); 
		
		if ($user==null or $str==null)
		{
				$this->validation->set_message('login_form_check', 'Błędny login');
				return FALSE;
		}
		else
		{
				return TRUE;
		}
	}

	function pass_check($pass,$login)
	{
		if($pass==null or $login==null)
		{
			$password = null; 	
		}
		else	
		{
			$haslo = md5($pass);
			$password = $this->baza->check_user_pass($haslo, $login); 	
		}
		
		if ($password == null)
		{
			$this->validation->set_message('pass_check', 'Błędne hasło');
			return FALSE;
		}
		else
		{	
			return TRUE;
		}
	}
	
	function change_pass()
	{	
		if(isset($this->session->userdata['user_zalogowany']) and isset($this->session->userdata['di']))
		{	
			$user_data = $this->baza->get_user_login($this->session->userdata['user_zalogowany'], $this->session->userdata['di']);
			
			if($user_data!=null)	
			{
				$user  = $user_data[0]['name'];
				$data['user']=	$user_data[0]['name'];
				$this->load->helper(array('form', 'url'));
				$this->load->library('validation');
				$this->validation->set_error_delimiters('<span style="color:red;">', '<br /></span>');
				
				$fields['old_pass'] = 'old_pass';
				$fields['new_pass'] = 'new_pass';
				$fields['new_pass_repeat'] = 'new_pass_repeat';
				$this->validation->set_fields($fields);
				
				$new_pass = $this->validation->new_pass;
				$new_pass_repeat = $this->validation->new_pass_repeat;
				
				$rules['old_pass'] = "callback_old_pass_check[$user]|required";
				$rules['new_pass'] = "callback_new_pass_check[$new_pass_repeat]|required";
				$rules['new_pass_repeat'] = "callback_new_pass_repeat_check[$new_pass]|required";
				$this->validation->set_rules($rules);
				
				if ($this->validation->run() == FALSE)
				{
					$this->load->view('/layout/change_pass_page',$data);
				}
				else
				{		
					if($new_pass!=null)
					{
						$haslo = md5($new_pass);
	
						if($this->baza->user_new_pass($user,$haslo))
						{			
							$data['nowe_haslo'] = $new_pass;
							redirect('/admin/logout','location');
							
							
						}else $this->load->view('blad',$data);
					}else $this->load->view('blad',$data);
				}
			}
			else
			{
				redirect('/admin/logout','location');
			}	
		}
		else
		{
			redirect('/admin/','location');
		}
	}
	
	
	function old_pass_check($str,$user)
	{
		$password_baza=$this->baza->user($user); 
		$pass =  md5($str);
		
		if($password_baza==null)
		{
			$password_baza[0]['password']='1';
		}
		
		if ($password_baza[0]['password']!=$pass or $pass==null)
		{
				$this->validation->set_message('old_pass_check', 'Błędne hasło');
				return FALSE;
		}
		else
		{
				return TRUE;
		}
	}
	
	function new_pass_check($str,$pass_repeat)
	{	
		if ($str!=$pass_repeat or $str==null or $pass_repeat==null )
		{
				$this->validation->set_message('new_pass_check', 'Hasło nowe i hasło nowe powtórzopne muszą być takie same');
				return FALSE;
		}
		else
		{
				return TRUE;
		}
	}
	
	function new_pass_repeat_check($str,$new_pass)
	{	
		if ($str!=$new_pass or $new_pass==null or $str=null)
		{
				$this->validation->set_message('new_pass_repeat_check', 'Hasło nowe i hasło nowe powtórzopne muszą być takie same');
				return FALSE;
		}
		else
		{
				return TRUE;
		}
	}
	
	function logout()
	{
		$this->session->sess_destroy();
		redirect('','location');
	}
	
	function forgotten_pass()
	{
		$this->load->helper(array('form', 'url'));
		$this->load->library('validation');
		$this->validation->set_error_delimiters('<span style="color:red;">', '<br /></span>');
		
		$fields['email'] = 'email';
		$this->validation->set_fields($fields);
		
		$rules['email'] = "callback_email_check|required";
		$this->validation->set_rules($rules);
		$email = $this->validation->email;
		
		if ($this->validation->run() == FALSE)
		{
			$this->load->view('layout/forgotten_pass_page');
		}
		else
		{	
			$pass = substr ( md5 ( uniqid ( rand(), true ) ), 0, 5 );
			$haslo = md5($pass);

			if($email!=null)
			{
				//zmienna email zawiera login a nie jak nazwawskazuje email 
				$is_user = $this->baza->user_get_email($email);
				
				if($is_user!=null)
				{
					if($this->baza->user_new_pass($email,$haslo))
					{	
						$tresc = 'Twoje nowe hasło to:<br /><br />
									'.$pass.'<br /><br />
									<a href="http://admin.networds.mariusz.jrchosting.com" >Zaloguj się</a>
							';	
							
							if($this->send_mail('Przypomnienie hasła', $tresc, $is_user[0]['email'])) 
							{
								$this->load->view('/new_pass_created');
							}	
					}else $this->load->view('/blad');
				}else	$this->load->view('/blad');
			}else $this->load->view('/blad');
		}
	}
	
	function email_check($str)
	{
		$user=$this->baza->user($str); 
		
		if ($user==null or $str==null)
		{
				$this->validation->set_message('email_check', 'Błędny login');
				return FALSE;
		}
		else
		{
				return TRUE;
		}
	}
	
	function send_mail($title=null, $content_email=null, $email=null)
	{			
		require_once "swift_mailer/Swift.php";
		require_once "swift_mailer/Swift/Connection/SMTP.php";
		require_once "swift_mailer/Swift/Authenticator/LOGIN.php";

		$conn =& new Swift_Connection_SMTP("ubieranki.jrchosting.com");
		$conn->setUsername("mailer@ubieranki.org");
		$conn->setPassword("mailer0987");
		$swift =& new Swift($conn);
		$message =& new Swift_Message($title, $content_email, 'text/html');
		return $swift->send($message, $email, "mailer@ubieranki.org");
		
	}
	
	/*
	function games($id_cat=1,$elem=0){
		
		$this->output->cache(5);
		$this->load->helper('url');
	    $this->load->database();
	    $this->load->library('pagination');
		
		if(isset($_POST['sort']) and $_POST['sort']!=null)
		{
			$this->session->set_userdata('sort',$_POST['sort']);
		}
		elseif(!isset($this->session->userdata['sort']))
		{
			
				$this->session->set_userdata('sort','1');
		}
		
		$sort = $this->session->userdata('sort');
		
		$sql = "SELECT id_game, title, description FROM games WHERE id_category='".$id_cat."' ";
		$count_games = $this->db->query($sql);
	    $config['total_rows'] = $count_games->num_rows();
		$config['per_page'] = '9';
		$config['num_links'] = 13;
	    $config['full_tag_open'] = '<span>';
	    $config['full_tag_close'] = '</span>';
		$config['url_extention'] = '.html';
		$this->load->model('categories');		
    	$data['results'] = $this->categories->get_games($config['per_page'],$elem,$id_cat,$sort);
		$data['id_category'] = $id_cat;
		$data['elem'] = $elem; 
		
		
		$categotydata = $data['results']->result_array();
		
		if (!isset($categotydata['0']['name']))
		{
    	 redirect('', 'location');
		}
		
		$data['page_main_title'] = $categotydata['0']['name'];
		
		$data['categories'] = $this->categories->get_all_category();
		
		$config['base_url'] = base_url().url_title($categotydata['0']['name']).'-'.$id_cat.'-';
	    
		
	    $this->pagination->initialize($config);
		$this->pagination->cur_page = $elem;
						
	   
		$this->load->view('layout/sub_page',$data);
	}
	*/
}
?>