<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Platnosci_pl 
{
	private $CI;
	private $pay_type = '';
	private $kodowanie;
	private $platnosci_pl_url;
	
	function __construct()
	{
		$this->CI = & get_instance();
		$this->CI->config->load('platnosci_pl');
		$this->kodowanie = $this->CI->config->item('kodowanie', 'platnosci_pl');
		$this->platnosci_pl_url = $this->CI->config->item('platnosci_pl_url', 'platnosci_pl');
    }
	
	// SELEKTORY
	
	function kodowania()
	{
		return $this->CI->config->item('kodowania', 'platnosci_pl');
	}
	
	function kodowanie()
	{
		return $this->CI->config->item('kodowanie', 'platnosci_pl');
	}
	
	function procedury()
	{
		return $this->CI->config->item('procedury', 'platnosci_pl');
	}
	
	function kodyBledow()
	{
		return $this->CI->config->item('kody_bledow', 'platnosci_pl');
	}
	
	function kodBledu($key=null)
	{
		$kody_bledow = $this->kodyBledow();
		return $kody_bledow[$key];
	}
	
	function statusyTransakcji()
	{
		return $this->CI->config->item('statusy_transakcji', 'platnosci_pl');
	}
	
	function statusTransakcji($key=null)
	{
		$statusy_transakcji = $this->statusyTransakcji();
		return $statusy_transakcji[$key];
	}

	function pos_id()
	{
		return $this->CI->config->item('pos_id', 'platnosci_pl');
	}

	function key1()
	{
		return $this->CI->config->item('key1', 'platnosci_pl');
	}

	function key2()
	{
		return $this->CI->config->item('key2', 'platnosci_pl');
	}
	
	function pos_auth_key()
	{
		return $this->CI->config->item('pos_auth_key', 'platnosci_pl');
	}

	function pay_type()
	{
		return $this->pay_type;
	}	

	private function procedura($key="new")
	{
		$procedury = $this->procedury();
		if (array_key_exists($key,$procedury))
		{
			return $procedury[$key];	
		}		
		else
		{
			return $procedury["new"];
		}
	}
	
	function procedura_new()
	{
		return $this->procedura("new");
	}

	function procedura_get()
	{
		return $this->procedura("get");
	}
	
	function procedura_confirm()
	{
		return $this->procedura("confirm");
	}
	
	function procedura_cancel()
	{
		return $this->procedura("cancel");
	}

	// MODYFIKATORY
	
	function ustaw_pay_type($type)
	{
		$this->pay_type = $type;
	}
	
	function ustaw_kodowanie()
	{
		
	}
	
	// GENERATORY
	
	function sig($session_id="",$amount="",$desc="",$desc2="",$trsDesc="",$order_id="",$first_name="",$last_name="",$payback_login="",$street="",$street_hn="",$street_an="",$city="",$post_code="",$country="",$email="",$phone="",$language="",$client_ip="",$ts="")
	{
		$string = $this->pos_id().$this->pay_type().$session_id.$this->pos_auth_key().$amount;
		$string .= $desc.$desc2.$trsDesc.$order_id.$first_name.$last_name;
		$string .= $payback_login.$street.$street_hn.$street_an.$city.$post_code;
		$string .= $country.$email.$phone.$language.$client_ip.$ts.$this->key1();
		return md5($string);
	}
	
	function sig1($pos_id="",$session_id="",$ts="")
	{
		return md5($pos_id.$session_id.$ts.$this->key1());
	}
	
	function sig2($pos_id="",$session_id="",$ts="")
	{
		return md5($pos_id.$session_id.$ts.$this->key2());
	}
	
	function sprawdz_odebrany_sig($sig=null,$pos_id=null,$session_id=null,$ts=null)
	{
		$right_sig = $this->sig2($pos_id,$session_id,$ts);
		if($right_sig == $sig)
		{
			return true;
		}
		else
		{
			return false;
		}
	}
	
	function sprawdz_odebrany_sig2($sig=null,$pos_id=null,$session_id=null,$order_id=null,$status=null,$amount=null,$desc=null,$ts=null)
	{
		$right_sig = md5($pos_id.$session_id.$order_id.$status.$amount.$desc.$ts.$this->key2());
		if($right_sig == $sig)
		{
			return true;
		}
		else
		{
			return false;
		}
	}
	
	// METODY
	
	function index()
	{
		return print_r($this->KodyBledow(),TRUE);
	}
	
	function sprawdzStatusTransakcji($session_id="")
	{

		function createPostString($aPostFields) {
			foreach ($aPostFields as $key => $value) {
				$aPostFields[$key] = urlencode($key) . '=' . urlencode($value);
			}
			return implode('&', $aPostFields);
		}

		$postFields['pos_id'] = $this->pos_id();
		$postFields['session_id'] = $session_id;
		$postFields['ts'] = time();
		$postFields['sig'] = $this->sig1($postFields['pos_id'],$postFields['session_id'],$postFields['ts']);
		
		$ch = curl_init($this->platnosci_pl_url.'/'.$this->kodowanie().'/'.$this->procedura_get());
		curl_setopt($ch, CURLOPT_POSTFIELDS, createPostString($postFields));
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		$xml = curl_exec($ch);
		curl_close($ch);
		return $xml;
	}
	
	function parsujXML($xml=null)
	{
		$xml_object = simplexml_load_string($xml);
		
		//print_r($xml_object);
		if ($xml_object->status == "OK")
		{
			$daneTransakcji = null;
			$daneTransakcji['id'] = "".$xml_object->trans->id;
			$daneTransakcji['pos_id'] = "".$xml_object->trans->pos_id;
			$daneTransakcji['session_id'] = "".$xml_object->trans->session_id;
			$daneTransakcji['order_id'] = "".$xml_object->trans->order_id;
			$daneTransakcji['amount'] = "".$xml_object->trans->amount;
			$daneTransakcji['status'] = "".$xml_object->trans->status;
			$daneTransakcji['pay_type'] = "".$xml_object->trans->pay_type;
			$daneTransakcji['pay_gw_name'] = "".$xml_object->trans->pay_gw_name;
			$daneTransakcji['desc'] = "".$xml_object->trans->desc;
			$daneTransakcji['desc2'] = "".$xml_object->trans->desc2;
			$daneTransakcji['create'] = "".$xml_object->trans->create;
			$daneTransakcji['init'] = "".$xml_object->trans->init;
			$daneTransakcji['sent'] = "".$xml_object->trans->sent;
			$daneTransakcji['recv'] = "".$xml_object->trans->recv;
			$daneTransakcji['cancel'] = "".$xml_object->trans->cancel;
			$daneTransakcji['auth_fraud'] = "".$xml_object->trans->auth_fraud;
			$daneTransakcji['ts'] = "".$xml_object->trans->ts;
			$daneTransakcji['sig'] = "".$xml_object->trans->sig;
			
			if($this->sprawdz_odebrany_sig2($xml_object->trans->sig,$xml_object->trans->pos_id,$xml_object->trans->session_id,$xml_object->trans->order,$xml_object->trans->status,$xml_object->trans->amount,$xml_object->trans->desc,$xml_object->trans->ts))
			{
				return $daneTransakcji;
			}
			else
			{
				return false;
			}
		}
		else
		{
			return false;
		}
	}
	
	function zmienStatusTransakcjiWSystemie($dane_transakcji = null)
	{
		$this->CI->load->model('platnosci_pl_model','platnosciModel',TRUE);
		if($this->CI->platnosciModel->transakcjaIstnieje($dane_transakcji['session_id']))
		{
			$this->CI->platnosciModel->zmienTransakcje($dane_transakcji);			
		}
		else
		{
			$this->CI->platnosciModel->dodajTransakcje($dane_transakcji);
		}
	}
	
	function dodajTransakcjeDoSystemu($dane_transakcji = null)
	{
		$this->CI->load->model('platnosci_pl_model','platnosciModel',TRUE);
		if(!$this->CI->platnosciModel->transakcjaIstnieje($dane_transakcji['session_id']))
		{
			return $this->CI->platnosciModel->dodajTransakcje($dane_transakcji);
		}
	}
	
	function dodajNowaTransakcjeDoSystemu($session_id = null)
	{
		$this->CI->load->model('platnosci_pl_model','platnosciModel',TRUE);
		if(!$this->CI->platnosciModel->transakcjaIstnieje($session_id))
		{
			return $this->CI->platnosciModel->dodajNowaTransakcje($session_id);
		}
	}
	
	function usunTransakcjeZSystemu($session_id = null)
	{
		$this->CI->load->model('platnosci_pl_model','platnosciModel',TRUE);
		if($this->CI->platnosciModel->transakcjaIstnieje($session_id))
		{
			$this->CI->platnosciModel->usunTransakcje($session_id);
		}
	}
	
	function pobierzRaport($post=null)
	{
		//print_r($post);
		//print_r($_POST);
		
		/*$this->CI->load->library('form_validation');
		
		$this->CI->form_validation->set_rules('pos_id', 'POS_ID', "required");
		$this->CI->form_validation->set_rules('session_id', 'SESSION_ID', "required");
		$this->CI->form_validation->set_rules('ts', 'TS', "required");
		$this->CI->form_validation->set_rules('sig', 'SIG', "required");
				
		if ($this->CI->form_validation->run() == FALSE)
		{	
			//print ("KAPA: ".validation_errors());
			
			return false;
		}
		
		else
		{*/	
			if(isset($post))
			{
				$sig = $post['sig'];
				$pos_id = $post['pos_id'];
				$session_id = $post['session_id'];
				$ts = $post['ts'];	
			}
			else
			{
				$sig = $_POST['sig'];
				$pos_id = $_POST['pos_id'];
				$session_id = $_POST['session_id'];
				$ts = $_POST['ts'];					
			}
		
			
			if($this->sprawdz_odebrany_sig($sig,$pos_id,$session_id,$ts))
			{
				if ($dane_transakcji = $this->parsujXML($this->sprawdzStatusTransakcji($session_id)))
				{
					//print ("JEST OK!");
					$this->zmienStatusTransakcjiWSystemie($dane_transakcji);
					return array('session_id'=>$dane_transakcji['session_id'],'status'=>$dane_transakcji['status'],'kod_produktu'=>$dane_transakcji['desc2']);
				}
				else
				{
					return false;
				}
			}
			else
			{
				return false;
			}			
		//}
	}
	
	function dodajLog($log="")
	{
		$this->CI->load->model('platnosci_pl_model','platnosciModel',TRUE);
		$this->CI->platnosciModel->dodajLog($log);
	}
	
	function pobierzIdTransakcji($session_id=null)
	{
		$this->CI->load->model('platnosci_pl_model','platnosciModel',TRUE);
		return $this->CI->platnosciModel->pobierzIdTransakcji($session_id);
	}
	
	function pobierzIdFaktury($session_id=null)
	{
		if(!empty($session_id))
		{
			$this->CI->load->model('platnosci_pl_model','platnosciModel',TRUE);
			return $this->CI->platnosciModel->pobierzIdFaktury($session_id);
		}
	}
}

/* End of file platnosci_pl.php */
/* Location: ./system/application/libraries/platnosci_pl.php */ 
?>