<?php

class Baza_payments extends Model
{	
	function Baza_payments()
    {
        parent::Model();
		$this->db = $this->load->database('default', TRUE);	
    }
	
	function google_region($domain_id)
	{
		$sql = "SELECT google_region from user_domain where id = ".$domain_id." limit 1";			
		$data = $this->db->query($sql);	
		$domain = $data->result_array();
		
		if(!empty($domain[0]['google_region']))
			return $domain[0]['google_region'];
		else
			return 'pl';
	}
	
	function test_platnosci_pl($raport)
	{
		$data['id'] = '';
		$data['raport'] = $raport;				
		$this->db->insert('test_platnosci ', $data);
	}
	
	function zaplacono_platnosci_pl($id_faktury=null,$zatwierdzono=null)
	{
		if($id_faktury!=null)
		{
			if($zatwierdzono!=null)$data['zatwierdzono'] = 1;
			
			$data['zaplacono'] = 1;
	        $this->db->WHERE('id', $id_faktury);
	        $this->db->update('faktury_seo', $data);
		}
	}
	
	function get_facture_platnosci_pl($user_id,$id_faktury)
	{
		$sql = "SELECT * FROM faktury_seo WHERE user_id = ".$user_id." AND id='".$id_faktury."' and zaplacono=0";			
		$data = $this->db->query($sql);	
		return $data->result_array();
	}
	
	function get_user_facture($user_id,$month,$year)
	{
		$sql = "SELECT id FROM faktury_seo WHERE user_id = ".$user_id." AND year='".$year."' AND month='".$month."'";			
		$data = $this->db->query($sql);	
		return $data->result_array();
	}
	
	function get_facture($user_id,$month,$year)
	{
		$sql = "SELECT * from faktury_seo where month = '".$month."' and year = '".$year."' and user_id = '".$user_id."'";		 			
		$data = $this->db->query($sql);	
		return $data->result_array();
	}
	
	function get_factures($user_id)
	{
		$sql = "SELECT id,month,year,zaplacono from faktury_seo where user_id = '".$user_id."' order by year,month ";		 			
		$data = $this->db->query($sql);	
		return $data->result_array();
	}
	
	function zloty_check($keys,$week,$year)
	{
		$this->db->where('week', $week);
		$this->db->where('year', $year);
		$this->db->where_in('keyword_id', $keys);		
		$data = $this->db->get('keyword_price_per_week',1);	
		return $data->result_array();
	}
	
	function get_data_to_fakcture_payments($keyword_id,$month,$year)
	{		
		set_time_limit(60);	
		$sql = "SELECT count(*) ilosc_tyg_platnych, price cena_za_tydz, sum(price) oplata_za_miesaic, keyword_id, year, month, week week_rozpocz_mies, max(week) ostatni_week FROM keyword_price_per_week WHERE keyword_id = '".$keyword_id."' AND year='".$year."' AND month='".$month."' group by keyword_id asc";			
		$data = $this->db->query($sql);	
		return $data->result_array();
	}
	
	function update_keyword_dojscie($keyword_id)
	{
		$data['naliczona_oplata_za_dojscie'] = 1;
        $this->db->WHERE('id', $keyword_id);
        return $this->db->update('user_domain_keyword', $data);
	}
	
	function get_domains_and_keywords($user_id)
	{
		$this->db->select('*');
		$this->db->from('user_domain');
		$this->db->join('user_domain_keyword', 'user_domain.id = user_domain_keyword.domain_id');
		$this->db->where('user_domain.user_id', $user_id);
		//$this->db->group_by("user_domain_keyword.id"); 
		//$this->db->order_by("user_domain_keyword.id"); 
		$data = $this->db->get();
		return $data->result_array(); 
	}
	
	function add_facture($month,$year,$facture_period,$payments,$user_data)
	{
		include_once('files/slownie.php');	
	
		/*miejsce wystawienia, data wystawienia, sprzedarzy, termin platnosci*/
		
		//wyliczenie miesiaca nastepujacego po miesiacu za ktory jest wystawiana faktura
		$data_wystawienia_tmp = strftime("20%y-%m-%d",mktime(0, 0, 0, $month+1, 1, $year));
		
		//wyliczenie roku wystawienia faktury		 
		$fw_year = substr($data_wystawienia_tmp,0,4);

		//wyliczenie miesiaca wystwienia faktury
		$fw_month = substr($data_wystawienia_tmp,5,2);

		//wyliczenia 1 dnia nastepnego okresu rolziczeniowego, ktory jest zarazem dniem wystawienia faktury
		$day_of_facturing = $fw_year.'-'.$fw_month.'-'.date_from_nameday(1, 1, $fw_month,$fw_year);
		
		//wyciecie numeru wyliczonego dnia nastepnego okresub rozliczeniowego aby go urzyc do wyliczenia terminu platnosci
		$fw_day = substr($day_of_facturing,8,2);
		
		$data_wystawienia = $day_of_facturing;   				
		$miejsce_wystawienia = 'Bielsko-Biała';		
		$sposob_zaplaty = 'przelew';

		//wyliczenie terminu platnosci
		$termin_platnosci = strftime("20%y-%m-%d",mktime(0, 0, 0,$fw_month, $fw_day+7, $fw_year));
		
		
		/*numer faktury*/
		$nr = 1;
		$sql = "SELECT nr from faktury_seo where month = '".$month."' and year = '".$year."' order by nr desc limit 1";			
		$data = $this->db->query($sql);	
		$nr_tmp =  $data->result_array();	
		//print_r($nr_tmp);
		unset($data);
		if(!empty($nr_tmp))
		{
			$nr = ($nr_tmp[0]['nr'] + 1);
		}
		
		/*sprzedawca, nabywca*/
		$sprzedawca = "Labmatic - Jakub Kurbiel\nul.Reymonta 2 /3\n43-300 Bielsko-Biała\nNIP: 5471795303\nKonto: 26 1060 0076 0000 3260 0153 8938\nBank BPH o./Bielsko-Biała";	
		$nabywca = "".$user_data[0]['company_name']."\n".$user_data[0]['street'].$user_data[0]['b_no'].$user_data[0]['a_no']."\n".$user_data[0]['post_code']." ".$user_data[0]['city']."\nNIP: ".$user_data[0]['tax_id']."";

		/*naliczone uslugi*/
		
		$facture_payments = array(); //zmienna trzymajaca tablice z wyliczonymi pozycjami platnosci
		$netto = 0; //zmienna trzymajaca cala wartosc netto faktury
		$uwagi = null; //zmienna trzymajaca slowa ktore byly na pozycjach
		$utrzymanie = 0; //tmp zmienna pomocnicza		
		$i = 1;	 // tmp zmienna pomocnicza
		$last_week_of_year = last_week_of_year($year); //tab z inf o ostatnim tygodniu roku
				
		foreach($payments as $domain => $value)
		{
			if(!empty($value))
			{
				$utrzymanie = 0;
					
				foreach($value as $d)
				{				
					if($d[0]=='dojscie')
					{
						//dodanie 0 do groszy np 1.6 zamieni na 1.60
						$d3 = d_gr($d[3]); 
						$d3_vat = d_gr(round((0.22*$d[3]),2));
						$d3_z_vat = d_gr(round((1.22*$d[3]),2));
												
						//$facture_payments[] = array($i,'Opłata za dojście słowa kluczowego \''.$d[2].'\' z domeny \''.$d[1].'\' na płatną pozycję','szt',1,$d[3],$d[3],'22%',round((0.22*$d[3]),2),round((1.22*$d[3]),2));
						$facture_payments[] = array($i,'Opłata za dojście słowa kluczowego \''.$d[2].'\' z domeny \''.$d[1].'\' na płatną pozycję','szt',1,$d3[0].'.'.$d3[1],$d3[0].'.'.$d3[1],'22%',$d3_vat[0].'.'.$d3_vat[1],$d3_z_vat[0].'.'.$d3_z_vat[1]);
						$netto += round($d[3],2);
						$i++;
					}
					
					if($d[0]=='tydzien')
					{																
						///jezeli w tablicy jest pole zawierajace '1zl' to znak ze nalezy w grudniu odjac opate za ostatni tydzein i dodac 1 zl a jezeli styczen to tylko dodac 1 zl 
						
						if($month==12)
						{
							if(in_array('1zl',$value))
							{																
								//zlotowka grudzien - odejmujemy ostatni platny tydzien z grudnia												
								if($last_week_of_year[0]['week_number']==$d[8])
								{									
									$netto += round(($d[3]-$d[7]),2);
									$utrzymanie += $d[3]-$d[7];
									$uwagi[trim($d[1])][]= $d[2]."\n";
								}
								else
								{
									$netto += round($d[3],2);
									$utrzymanie += $d[3];
									$uwagi[trim($d[1])][]= $d[2]."\n";
								}																
							}
							else
							{
								$netto += round($d[3],2);
								$utrzymanie += $d[3];
								$uwagi[trim($d[1])][]= $d[2]."\n";
							}
							
						}
						else
						{
							$netto += round($d[3],2);
							$utrzymanie += $d[3];
							$uwagi[trim($d[1])][]= $d[2]."\n";
						}
						//
						
						//orginal	bez rozpoznawania okresow zlotowkowcyh 
						/*$netto += round($d[3],2);
						$utrzymanie += $d[3];
						$uwagi[trim($d[1])][]= $d[2]."\n";*/
					}												
				}								
				
				//zlotowka styczen i grudzien - ddoajemy zlotowke do platnosci
				if($month==1 or $month==12)
				{
					if(in_array('1zl',$value))
					{						
						$netto += 1;
						$utrzymanie += 1;										
					}					
				}
				
				//dodanie 0 do groszy np 1.6 zamieni na 1.60
				$utrzymanie_gr = d_gr($utrzymanie); 
				$utrzymanie_gr_vat = d_gr(round((0.22*$utrzymanie),2));
				$utrzymanie_gr_z_vat = d_gr(round((1.22*$utrzymanie),2)); 
				
				if($month==1)
					$facture_payments[] = array($i,'Opłata SEO za okres od '.$year.'-'.$month.'-01 do '.$facture_period['end'].' dla domeny: \''.$value[0][1].'\'','szt',1,$utrzymanie_gr[0].'.'.$utrzymanie_gr[1],$utrzymanie_gr[0].'.'.$utrzymanie_gr[1],'22%',$utrzymanie_gr_vat[0].'.'.$utrzymanie_gr_vat[1],$utrzymanie_gr_z_vat[0].'.'.$utrzymanie_gr_z_vat[1]);
				elseif($month==12)
					$facture_payments[] = array($i,'Opłata SEO za okres od '.$facture_period['start'].' do '.$year.'-'.$month.'-31 dla domeny: \''.$value[0][1].'\'','szt',1,$utrzymanie_gr[0].'.'.$utrzymanie_gr[1],$utrzymanie_gr[0].'.'.$utrzymanie_gr[1],'22%',$utrzymanie_gr_vat[0].'.'.$utrzymanie_gr_vat[1],$utrzymanie_gr_z_vat[0].'.'.$utrzymanie_gr_z_vat[1]);
				else
					$facture_payments[] = array($i,'Opłata SEO za okres od '.$facture_period['start'].' do '.$facture_period['end'].' dla domeny: \''.$value[0][1].'\'','szt',1,$utrzymanie_gr[0].'.'.$utrzymanie_gr[1],$utrzymanie_gr[0].'.'.$utrzymanie_gr[1],'22%',$utrzymanie_gr_vat[0].'.'.$utrzymanie_gr_vat[1],$utrzymanie_gr_z_vat[0].'.'.$utrzymanie_gr_z_vat[1]);
				
				/*if($month==1)
					$facture_payments[] = array($i,'Opłata SEO za okres od '.$year.'-'.$month.'-01 do '.$facture_period['end'].' dla domeny: \''.$value[0][1].'\'','szt',1,$utrzymanie,$utrzymanie,'22%',round((0.22*$utrzymanie),2),round((1.22*$utrzymanie),2));
				elseif($month==12)
					$facture_payments[] = array($i,'Opłata SEO za okres od '.$facture_period['start'].' do '.$year.'-'.$month.'-31 dla domeny: \''.$value[0][1].'\'','szt',1,$utrzymanie,$utrzymanie,'22%',round((0.22*$utrzymanie),2),round((1.22*$utrzymanie),2));
				else
					$facture_payments[] = array($i,'Opłata SEO za okres od '.$facture_period['start'].' do '.$facture_period['end'].' dla domeny: \''.$value[0][1].'\'','szt',1,$utrzymanie,$utrzymanie,'22%',round((0.22*$utrzymanie),2),round((1.22*$utrzymanie),2));	
				*/
				$i++;
			}						
		}
		
		//dodanie 0 do groszy np 1.6 zamieni na 1.60
		$netto_gr = d_gr($netto); 
		$netto_gr_vat = d_gr(round((0.22*$netto),2));
		$netto_z_vat = d_gr(round((1.22*$netto),2));  
		
		$facture_payments[] = array('','','','','RAZEM',$netto_gr[0].'.'.$netto_gr[1],'',$netto_gr_vat[0].'.'.$netto_gr_vat[1],$netto_z_vat[0].'.'.$netto_z_vat[1]);
		$facture_payments[] = array('','','','','w tym',$netto_gr[0].'.'.$netto_gr[1],'22%',$netto_gr_vat[0].'.'.$netto_gr_vat[1],$netto_z_vat[0].'.'.$netto_z_vat[1]);
		
		//$facture_payments[] = array('','','','','RAZEM',$netto,'',round((0.22*$netto),2),round((1.22*$netto),2));
		//$facture_payments[] = array('','','','','w tym',$netto,'22%',round((0.22*$netto),2),round((1.22*$netto),2));
		
		
		//wyliczone pozycje platnosci serializowane dane
		$naliczone_uslugi = serialize($facture_payments);
		
		//wyliczone pozycje platnosci w formacie txt
		$naliczone_uslugi_txt = '';
		
		foreach($facture_payments as $f)
		{
			$naliczone_uslugi_txt .= "Lp. ".$f[0]." | usługa: ".$f[1]." | jednostka ".$f[2]." | ilość: ".$f[3]." | cena jednostkowa: ".$f[4]." | netto: ".$f[5]." | stawka VAT: ".$f[6]." | kwota VAT: ".$f[7]." | brutto: ".$f[8]."\n";
		}
		
		$brutto = round((1.22*$netto),2);
		$naliczone_uslugi_txt .= "netto: ".$netto."\n";
		$naliczone_uslugi_txt .= "brutto: ".$brutto."\n";
		
		//dodanie 0 do groszy np 1.6 zamieni na 1.60
		$brutto_tmp  =  d_gr($brutto);		
		
		$slowa = Array('minus',Array('zero', 'jeden', 'dwa', 'trzy', 'cztery', 'pięć', 'sześć', 'siedem', 'osiem', 'dziewięć'), Array( 'dziesięć', 'jedenaście', 'dwanaście', 'trzynaście', 'czternaście', 'piętnaście', 'szesnaście', 'siedemnaście', 'osiemnaście', 'dziewiętnaście'), Array( 'dziesięć', 'dwadzieścia', 'trzydzieści', 'czterdzieści', 'pięćdziesiąt', 'sześćdziesiąt', 'siedemdziesiąt', 'osiemdziesiąt', 'dziewięćdziesiąt'), Array( 'sto', 'dwieście', 'trzysta', 'czterysta', 'pięćset', 'sześćset', 'siedemset', 'osiemset', 'dziewięćset'), Array( 'tysiąc', 'tysiące', 'tysięcy'), Array( 'milion', 'miliony', 'milionów'), Array( 'miliard', 'miliardy', 'miliardów'), Array( 'bilion', 'biliony', 'bilionów'), Array( 'biliard', 'biliardy', 'biliardów'), Array( 'trylion', 'tryliony', 'trylionów'), Array( 'tryliard', 'tryliardy', 'tryliardów'), Array( 'kwadrylion', 'kwadryliony', 'kwadrylionów'), Array( 'kwintylion', 'kwintyliony', 'kwintylionów'), Array( 'sekstylion', 'sekstyliony', 'sekstylionów'), Array( 'septylion', 'septyliony', 'septylionów'), Array( 'oktylion', 'oktyliony', 'oktylionów'), Array( 'nonylion', 'nonyliony', 'nonylionów'), Array( 'decylion', 'decyliony', 'decylionów') );					
		$slownie_do_zaplaty = slownie($brutto_tmp[0],$slowa).' '.odmiana(array('złoty','złote','złotych'),$brutto_tmp[0]).' i '.slownie($brutto_tmp[1],$slowa).' '.odmiana(array('grosz','grosze','groszy'),$brutto_tmp[1]);
		 
		$uwagi_txt = '';
		
		foreach($uwagi as $k => $v)
		{
			$uwagi_txt .= $k.": ";
			foreach($v as $s )
			{				
					$uwagi_txt .= trim($s).', ';
			}
			$uwagi_txt .= "\n\n";
		}
		
		$data['nr'] = $nr;
		$data['month'] = $month;
		$data['year'] = $year;
		$data['miejsce_wystawienia'] = $miejsce_wystawienia;
		$data['data_wystawienia'] = $data_wystawienia;
		$data['data_sprzedazy'] = $data_wystawienia;
		$data['sposob_zaplaty'] = $sposob_zaplaty;
		$data['termin_platnosci'] = $termin_platnosci;
		$data['sprzedawca'] = $sprzedawca;
		$data['nabywca'] = $nabywca;
		$data['naliczone_uslugi'] = $naliczone_uslugi;
		$data['naliczone_uslugi_txt'] = $naliczone_uslugi_txt;
		$data['netto'] = $netto;
		$data['brutto'] = $brutto;
		$data['slownie_do_zaplaty'] = $slownie_do_zaplaty;
		$data['os_upowaz_do_wyst_faktury'] = 'Jakub Kurbiel';
		$data['uwagi'] = $uwagi_txt;
		$data['user_id'] = $user_data[0]['user_id'];
				
		$this->db->insert('faktury_seo', $data);
		return true;
	}
	
	function count_all_keywords_payments_per_week()
	{
		include_once('files/functions.php');				  		
		$weeks = weeks_start_end_array(2008);		  		  							
		
		//pobierz wszystkie domeny
		$sql = "SELECT * from user_domain";		 			
		$data = $this->db->query($sql);	
		$domains = $data->result_array();	
		
		foreach($domains as $d)
		{
			//pobierz wszystkie slowa kluczowe dla danej domeny oraz ich cene
			$sql = "SELECT * from user_domain_keyword where domain_id=".$d['id']."";			
			$data = $this->db->query($sql);	
			$keywords = $data->result_array();
			
			//dla danego slowa kluczowego sprawdz pozycje w google dla danego tygodnia od roku zdefiniowanego w $year do daty roku aktualnego
			foreach($keywords as $k)
			{
				foreach($weeks as $w)
				{
					//pobierz liczbe dni danego keywordsa ktorego pozycja w gogle byla nie wieksza niz 10
					$sql = "SELECT count(*) as days, keyword_id, date from user_domain_keywords_stats_".$d['google_region']." where keyword_id=".$k['id']." and position <= 10 and (date >= '".$w['start']."' AND date <= '".$w['end']."') group by keyword_id ";			
					$data = $this->db->query($sql);	
					$kstats = $data->result_array();					
					
					foreach($kstats as $s)
					{																	
						if($s['days']==7)
						{
							$all_price = 0;							
							$percent = $k['percent']/100;							
							$price = $k['price'];							
							$num_of_weeks_in_months = $w['weeks_in_months'];							
							$all_price = ($percent * $price) / $num_of_weeks_in_months;
							
							$data_insert['keyword_id'] = $s['keyword_id'];														
							$data_insert['year'] = substr($w['start'],0,4);
							$data_insert['month'] = substr($w['start'],5,2);														
							$data_insert['week'] = $w['week_number'];
							$data_insert['google_region'] = $d['google_region'];
							$data_insert['price'] = $all_price;
							
							//sprawdzenie czy juz jakims cudem ktos kiedys nie wyliczyl ceny dla tego slowa kluczowego w tym roku i wtym tyg  
							$sql = "SELECT * from keyword_price_per_week where keyword_id = ".$s['keyword_id']." and year = ".substr($s['date'],0,4)." and week = ".$w['week_number']." ";			
							$data_check = $this->db->query($sql);	
							
							if($data_check->result_array()==null)
							{					        
					        	$this->db->insert('keyword_price_per_week', $data_insert);
							}
							else
							{
								echo 'juz to masz dodane <br />';
							}														
						}
					}	
				}												
			}
		}
	}
	
	function count_all_keywords_payments_last_week()
	{
		include_once('files/functions.php');				  
		
		$w = last_week_start_end_pn_nd();		   							
		
		//pobierz wszystkie domeny
		$sql = "SELECT * from user_domain";		 			
		$data = $this->db->query($sql);	
		$domains = $data->result_array();
		
		foreach($domains as $d)
		{
			//pobierz wszystkie slowa kluczowe dla danej domeny oraz ich cene
			$sql = "SELECT * from user_domain_keyword where domain_id=".$d['id']."";			
			$data = $this->db->query($sql);	
			$keywords = $data->result_array();		
			
			//dla danego slowa kluczowego sprawdz pozycje w google dla danego tygodnia od roku zdefiniowanego w $year do daty roku aktualnego
			foreach($keywords as $k)
			{			
				//pobierz liczbe dni danego keywordsa ktorego pozycja w gogle byla nie wieksza niz 10
				$sql = "SELECT count(*) as days, keyword_id, date from user_domain_keywords_stats_".$d['google_region']." where keyword_id=".$k['id']." and position <= 10 and (date >= '".$w['start']."' AND date <= '".$w['end']."') group by keyword_id ";			
				$data = $this->db->query($sql);	
				$kstats = $data->result_array();				
				
				foreach($kstats as $s)
				{											
					if($s['days']==7)
					{
						$all_price = 0;						
						$percent = $k['percent']/100;
						$price = $k['price'];						
						$num_of_weeks_in_months = $w['weeks_in_months'];						
						$all_price = ($percent * $price) / $num_of_weeks_in_months;
						
						$data_insert['keyword_id'] = $s['keyword_id'];
						$data_insert['year'] = substr($w['start'],0,4);
						$data_insert['month'] = substr($w['start'],5,2);
						$data_insert['week'] = $w['week_number'];
						$data_insert['google_region'] = $d['google_region'];
						$data_insert['price'] = $all_price;
						
						//sprawdzenie czy juz jakims cudem ktos kiedys nie wyliczyl ceny dla tego slowa kluczowego w tym roku i wtym tyg  
						$sql = "SELECT * from keyword_price_per_week where keyword_id = ".$s['keyword_id']." and year = ".substr($s['date'],0,4)." and week = ".$w['week_number']." ";			
						$data_check = $this->db->query($sql);	
						
						if($data_check->result_array()==null)
						{					        
				        	$this->db->insert('keyword_price_per_week', $data_insert);
						}
						else
						{
							echo 'juz to masz dodane <br />';
						}														
					}
				}	
			}												
		
		}
	}
}

?>