<?php

class Baza_payments extends Model
{	
	private $vat;
	
	function Baza_payments()
    {
        parent::Model();
		$this->db = $this->load->database('default', TRUE);	
		
		$this->config->load('global_settings');
		$this->global_settings  = $this->config->item('global_settings');
        $this->vat              = $this->global_settings['vat'];		
    }
	
	function get_vat()
    {
        return $this->vat;
    }
	
	function google_region($domain_id)
	{
		$sql = "SELECT google_region from user_domain where id = ".$domain_id." limit 1";			
		$data = $this->db->query($sql);	
		$domain = $data->result_array();
		
		if(!empty($domain[0]['google_region']))
			return $domain[0]['google_region'];
		else
			return 'pl';

	}
	
	function test_platnosci_pl($raport)
	{
		$data['id'] = '';
		$data['raport'] = $raport;				
		$this->db->insert('test_platnosci ', $data);
	}

    function get_users()
	{
		$sql = "SELECT user.id,company_name name,active FROM user,user_data where user.id=user_data.user_id order by company_name";
		$data = $this->db->query($sql);
		$user = $data->result_array();
		return $user;
	}
	
	function afiliant_wyplac_srodki_wlasne($afiliant_id,$afiliant_data,$netto_razem,$all_factures,$typ_rozliczenia)
	{
		include_once('files/slownie.php');
		include_once('files/functions.php');
			
		$nazwa = '';
		$sprzedawca = '';
		if($typ_rozliczenia=='Firma')
		{ 
			$nazwa = $afiliant_data[0]['nazwa'];
			$sprzedawca = "".$nazwa."\n".$afiliant_data[0]['ulica'].' '.$afiliant_data[0]['numer_domu'].' '.$afiliant_data[0]['nr_mieszkania']."\n".$afiliant_data[0]['kod_pocztowy']." ".$afiliant_data[0]['miasto']."\nNIP: ".$afiliant_data[0]['nip']."\nKonto: ".$afiliant_data[0]['nr_konta']."";
		}
		else 
		{
			$data['nr'] = $this->afiliant_get_document_nr($afiliant_id);			
			
			$nazwa = $afiliant_data[0]['imie'].' '.$afiliant_data[0]['nazwisko'];
			$sprzedawca = "".$nazwa."\n".$afiliant_data[0]['ulica'].' '.$afiliant_data[0]['numer_domu'].' '.$afiliant_data[0]['nr_mieszkania']."\n".$afiliant_data[0]['kod_pocztowy']." ".$afiliant_data[0]['miasto']."\nPESEL: ".$afiliant_data[0]['pesel']."\nNIP: ".$afiliant_data[0]['nip']."\n";
		}
		

        /*dane nabywca*/
        $networds = $this->get_networds_data();
        $nabywca = trim($networds[0]['nazwa'])."\nul. ".$networds[0]['ulica']." ".$networds[0]['nr_budynku']." ".$networds[0]['nr_lokalu']."\n".$networds[0]['kod_pocztowy']." ".$networds[0]['miasto']."\nNIP: ".$networds[0]['nip']."\nKonto: ".$networds[0]['nr_konta']."\n".$networds[0]['bank']."";
        /*koniec pobrania danych sprzedawcy*/
        //$nabywca = "Labmatic - Jakub Kurbiel\nul.Reymonta 2 /3\n43-300 Bielsko-Biała\nNIP: 5471795303\n";
		
		//dodanie 0 do groszy np 1.6 zamieni na 1.60

        //bo  w przypadku osoby fizycznej bez dzialalnosci wypalcamy kwoty netto
        if($typ_rozliczenia=='Firma')
		{ 
			$netto  =  $netto_razem;        
            //$brutto  = round(($netto*1.22),2);
			$brutto  = round(($netto*(1 + $this->vat)),2);
		}
        else
        {
            $netto  =  $netto_razem;        
            $brutto  = round($netto,2);
        }
		
		$brutto_tmp  =  d_gr($brutto);					
		$slowa = Array('minus',Array('zero', 'jeden', 'dwa', 'trzy', 'cztery', 'pięć', 'sześć', 'siedem', 'osiem', 'dziewięć'), Array( 'dziesięć', 'jedenaście', 'dwanaście', 'trzynaście', 'czternaście', 'piętnaście', 'szesnaście', 'siedemnaście', 'osiemnaście', 'dziewiętnaście'), Array( 'dziesięć', 'dwadzieścia', 'trzydzieści', 'czterdzieści', 'pięćdziesiąt', 'sześćdziesiąt', 'siedemdziesiąt', 'osiemdziesiąt', 'dziewięćdziesiąt'), Array( 'sto', 'dwieście', 'trzysta', 'czterysta', 'pięćset', 'sześćset', 'siedemset', 'osiemset', 'dziewięćset'), Array( 'tysiąc', 'tysiące', 'tysięcy'), Array( 'milion', 'miliony', 'milionów'), Array( 'miliard', 'miliardy', 'miliardów'), Array( 'bilion', 'biliony', 'bilionów'), Array( 'biliard', 'biliardy', 'biliardów'), Array( 'trylion', 'tryliony', 'trylionów'), Array( 'tryliard', 'tryliardy', 'tryliardów'), Array( 'kwadrylion', 'kwadryliony', 'kwadrylionów'), Array( 'kwintylion', 'kwintyliony', 'kwintylionów'), Array( 'sekstylion', 'sekstyliony', 'sekstylionów'), Array( 'septylion', 'septyliony', 'septylionów'), Array( 'oktylion', 'oktyliony', 'oktylionów'), Array( 'nonylion', 'nonyliony', 'nonylionów'), Array( 'decylion', 'decyliony', 'decylionów') );					
		$slownie_do_zaplaty = slownie($brutto_tmp[0],$slowa).' '.odmiana(array('złoty','złote','złotych'),$brutto_tmp[0]).' i '.slownie($brutto_tmp[1],$slowa).' '.odmiana(array('grosz','grosze','groszy'),$brutto_tmp[1]);
		
		//dodanie 0 do groszy np 1.6 zamieni na 1.60
		$netto_tmp = $netto;
		$netto_gr = d_gr($netto_tmp); 
		/*
		$netto_gr_z_vat = d_gr(round((1.22*$netto_tmp),2));
		$netto_gr_vat = d_gr(round((0.22*$netto_tmp),2));
		$netto_z_vat = d_gr(round((1.22*$netto_tmp),2));  
		 */
		$netto_gr_z_vat = d_gr(round(((1 + $this->vat)*$netto_tmp),2));
		$netto_gr_vat   = d_gr(round(($this->vat*$netto_tmp),2));
		$netto_z_vat    = d_gr(round(((1 + $this->vat)*$netto_tmp),2));

        $vat_procent = $this->vat*100;
		
		$facture_payments[] = array(1,'Pozyskanie klientów do '.date('Y-m-d'),'szt',1,$netto_gr[0].'.'.$netto_gr[1],$netto_gr[0].'.'.$netto_gr[1],$vat_procent.'%',$netto_gr_vat[0].'.'.$netto_gr_vat[1],$netto_gr_z_vat[0].'.'.$netto_gr_z_vat[1]);
		$facture_payments[] = array('','','','','RAZEM',$netto_gr[0].'.'.$netto_gr[1],'',$netto_gr_vat[0].'.'.$netto_gr_vat[1],$netto_z_vat[0].'.'.$netto_z_vat[1]);
		$facture_payments[] = array('','','','','w tym',$netto_gr[0].'.'.$netto_gr[1],$vat_procent.'%',$netto_gr_vat[0].'.'.$netto_gr_vat[1],$netto_z_vat[0].'.'.$netto_z_vat[1]);
				
		//wyliczone pozycje platnosci serializowane dane
		$naliczone_uslugi = serialize($facture_payments);
		
		//wyliczone pozycje platnosci w formacie txt
		$naliczone_uslugi_txt = '';
		
		foreach($facture_payments as $f)
		{
			$naliczone_uslugi_txt .= "Lp. ".$f[0]." | usługa: ".$f[1]." | jednostka ".$f[2]." | ilość: ".$f[3]." | cena jednostkowa: ".$f[4]." | netto: ".$f[5]." | stawka VAT: ".$f[6]." | kwota VAT: ".$f[7]." | brutto: ".$f[8]."\n";
		}
		
		$naliczone_uslugi_txt .= "netto: ".$netto."\n";
		$naliczone_uslugi_txt .= "brutto: ".$brutto."\n";
		
		//termin platnosci
		$this->config->load('global_settings');	
		$global_settings = $this->config->item('global_settings');
		
		$day = date('d');
		$month = date('m');
		$year = date('Y');
		
		$termin_platnosci = strftime("20%y-%m-%d",mktime(0, 0, 0,$month, ($day+$global_settings['afiliant']['ilosc_dni_na_wypalte_pieniedzy']), $year));
		
		$data['year'] = $year;
		$data['month'] = $month;
		$data['miejsce_wystawienia'] = $afiliant_data[0]['miasto'];
		$data['afiliant_id'] = $afiliant_id;
		$data['typ'] = $typ_rozliczenia; //firma, osobaprywatna		
		$data['typ_dostarczenia'] = 'osobiscie'; //dostarczy wystawiona fakture/rachunek przez siebie
		$data['data_wystawienia'] = date('Y-m-d');
		
		if($typ_rozliczenia=='Firma')
		{ 
			$data['data_sprzedazy'] = date('Y-m-d');
		}
			
		$data['sposob_zaplaty'] = 'przelew';
		$data['termin_platnosci'] = $termin_platnosci;
		$data['sprzedawca'] = $sprzedawca;
		$data['nabywca'] = $nabywca;
		$data['naliczone_uslugi'] = $naliczone_uslugi;
		$data['naliczone_uslugi_txt'] = $naliczone_uslugi_txt;		
		$data['netto'] = $netto;
		$data['brutto'] = $brutto;		
		$data['slownie_do_zaplaty'] = $slownie_do_zaplaty;
		$data['os_upowaz_do_wyst_faktury'] = $afiliant_data[0]['imie'].' '.$afiliant_data[0]['nazwisko'];
		$data['nr_konta'] = $afiliant_data[0]['nr_konta'];
		
		//print_r($data);
		$this->db->insert('afilianci_rozliczenia', $data);		
		$afilianci_rolziczenia_id = $this->db->insert_id();

         //wyslanie maila z faktura
         @$url = 'http://panel.networds.pl/admin/send_facture_by_mail_afiliant/'.$data['afiliant_id'].'/'.$afilianci_rolziczenia_id.'/'.urlencode($data['typ']).'/'.$data['typ_dostarczenia'];
         @file_get_contents($url);
				
		//faktury seo
		if(!empty($all_factures['seo']))
		{
			foreach($all_factures['seo'] as $mon)
			{
				foreach($mon as $m)
				{
					//$netto_seo += $m['netto'];
					$seo['afilianci_rozliczenia_id'] = $afilianci_rolziczenia_id;
					$seo['faktura_id'] = $m['id'];
					$seo['typ'] = 'SEO';
					$this->db->insert('afilianci_faktury_rozliczone', $seo);  
				}			
			}
		}
		
		//faktury sem		
		if(!empty($all_factures['sem']))
		{
			foreach($all_factures['sem'] as $mon)
			{
				foreach($mon as $m)
				{
					//$netto_sem += $m['netto'];
					$sem['afilianci_rozliczenia_id'] = $afilianci_rolziczenia_id;
					$sem['faktura_id'] = $m['id'];
					$sem['typ'] = 'SEM'; 
					$this->db->insert('afilianci_faktury_rozliczone', $sem); 
				}
			}
		}
	}
	
	function afiliant_get_document_nr($afiliant_id)
	{
		$month = date('m');
		$year = date('Y');
		
		//numer faktury/rachunku
		$nr = 1;
		$sql = "SELECT nr from afilianci_rozliczenia where month = '".$month."' and year = '".$year."' and afiliant_id='".$afiliant_id."' and nr IS NOT NULL";			
		$data = $this->db->query($sql);	
		$nr_tmp =  $data->result_array();	
		
		$nr_tmp = count($nr_tmp);
		//print_r($nr_tmp);
		unset($data);
		
		if($nr_tmp > 0)
		{
			$nr = ($nr_tmp + 1);
		}
		//koniec wyliczania numeru faktury proforma
		
		$caly_numer = 'networds/'.$nr.'/'.$month.'/'.$year;
				
		return $caly_numer;		
	}
	
	function afiliant_wyplac_srodki_online($afiliant_id,$afiliant_data,$netto_razem,$all_factures,$typ_rozliczenia,$form)
	{
		/*echo "\n".$afiliant_id."\n";
		print_r($afiliant_data);
		echo $netto_razem."\n";
		print_r($all_factures);		
		echo $typ_rozliczenia."\n";
		print_r($form);*/
		
		////////////////////////////////////////////
		include_once('files/slownie.php');
		include_once('files/functions.php');
			
		$nazwa = '';
		$sprzedawca = '';
		
		if($typ_rozliczenia=='Firma') 
		{
			$nazwa = $afiliant_data[0]['nazwa'];
			$sprzedawca = "".$nazwa."\n".$afiliant_data[0]['ulica']." ".$afiliant_data[0]['numer_domu']." ".$afiliant_data[0]['nr_mieszkania']."\n".$afiliant_data[0]['kod_pocztowy']." ".$afiliant_data[0]['miasto']."\nNIP: ".$afiliant_data[0]['nip']."\nKonto: ".$afiliant_data[0]['nr_konta']."";
		}
		else 
		{
			$nazwa = $afiliant_data[0]['imie'].' '.$afiliant_data[0]['nazwisko'];
			$sprzedawca = "".$nazwa."\n".$afiliant_data[0]['ulica']." ".$afiliant_data[0]['numer_domu']." ".$afiliant_data[0]['nr_mieszkania']."\n".$afiliant_data[0]['kod_pocztowy']." ".$afiliant_data[0]['miasto']."\nPESEL: ".$afiliant_data[0]['pesel']."\nNIP: ".$afiliant_data[0]['nip']."\n";
		}
				
		  /*dane nabywca*/
        $networds = $this->get_networds_data();
        $nabywca = trim($networds[0]['nazwa'])."\nul. ".$networds[0]['ulica']." ".$networds[0]['nr_budynku']." ".$networds[0]['nr_lokalu']."\n".$networds[0]['kod_pocztowy']." ".$networds[0]['miasto']."\nNIP: ".$networds[0]['nip']."\nKonto: ".$networds[0]['nr_konta']."\n".$networds[0]['bank']."";
        /*koniec pobrania danych sprzedawcy*/
        //$nabywca = "Labmatic - Jakub Kurbiel\nul.Reymonta 2 /3\n43-300 Bielsko-Biała\nNIP: 5471795303\n";
		
		//dodanie 0 do groszy np 1.6 zamieni na 1.60

        //bo  w przypadku osoby fizycznej bez dzialalnosci wypalcamy kwoty netto
        if($typ_rozliczenia=='Firma')
		{
			$netto  =  $netto_razem;
            //$brutto  = round(($netto*1.22),2);
			$brutto  = round(($netto*(1+$this->vat)),2);
		}
        else
        {
            $netto  =  $netto_razem;
            $brutto  = round($netto,2);
        }
        
		$brutto_tmp  =  d_gr($brutto);					
		$slowa = Array('minus',Array('zero', 'jeden', 'dwa', 'trzy', 'cztery', 'pięć', 'sześć', 'siedem', 'osiem', 'dziewięć'), Array( 'dziesięć', 'jedenaście', 'dwanaście', 'trzynaście', 'czternaście', 'piętnaście', 'szesnaście', 'siedemnaście', 'osiemnaście', 'dziewiętnaście'), Array( 'dziesięć', 'dwadzieścia', 'trzydzieści', 'czterdzieści', 'pięćdziesiąt', 'sześćdziesiąt', 'siedemdziesiąt', 'osiemdziesiąt', 'dziewięćdziesiąt'), Array( 'sto', 'dwieście', 'trzysta', 'czterysta', 'pięćset', 'sześćset', 'siedemset', 'osiemset', 'dziewięćset'), Array( 'tysiąc', 'tysiące', 'tysięcy'), Array( 'milion', 'miliony', 'milionów'), Array( 'miliard', 'miliardy', 'miliardów'), Array( 'bilion', 'biliony', 'bilionów'), Array( 'biliard', 'biliardy', 'biliardów'), Array( 'trylion', 'tryliony', 'trylionów'), Array( 'tryliard', 'tryliardy', 'tryliardów'), Array( 'kwadrylion', 'kwadryliony', 'kwadrylionów'), Array( 'kwintylion', 'kwintyliony', 'kwintylionów'), Array( 'sekstylion', 'sekstyliony', 'sekstylionów'), Array( 'septylion', 'septyliony', 'septylionów'), Array( 'oktylion', 'oktyliony', 'oktylionów'), Array( 'nonylion', 'nonyliony', 'nonylionów'), Array( 'decylion', 'decyliony', 'decylionów') );					
		$slownie_do_zaplaty = slownie($brutto_tmp[0],$slowa).' '.odmiana(array('złoty','złote','złotych'),$brutto_tmp[0]).' i '.slownie($brutto_tmp[1],$slowa).' '.odmiana(array('grosz','grosze','groszy'),$brutto_tmp[1]);
		
		//dodanie 0 do groszy np 1.6 zamieni na 1.60
		$netto_tmp = $netto;
		$netto_gr = d_gr($netto_tmp); 
		/*
		$netto_gr_z_vat = d_gr(round((1.22*$netto_tmp),2));
		$netto_gr_vat = d_gr(round((0.22*$netto_tmp),2));
		$netto_z_vat = d_gr(round((1.22*$netto_tmp),2));  
		 */
		$netto_gr_z_vat = d_gr(round(((1+$this->vat)*$netto_tmp),2));
		$netto_gr_vat   = d_gr(round(($this->vat*$netto_tmp),2));
		$netto_z_vat    = d_gr(round(((1+$this->vat)*$netto_tmp),2));

        $vat_procent    =  ($this->vat * 100);
		
		$facture_payments[] = array(1,'Pozyskanie klientów do '.date('Y-m-d'),'szt',1,$netto_gr[0].'.'.$netto_gr[1],$netto_gr[0].'.'.$netto_gr[1],$vat_procent.'%',$netto_gr_vat[0].'.'.$netto_gr_vat[1],$netto_gr_z_vat[0].'.'.$netto_gr_z_vat[1]);
		$facture_payments[] = array('','','','','RAZEM',$netto_gr[0].'.'.$netto_gr[1],'',$netto_gr_vat[0].'.'.$netto_gr_vat[1],$netto_z_vat[0].'.'.$netto_z_vat[1]);
		$facture_payments[] = array('','','','','w tym',$netto_gr[0].'.'.$netto_gr[1],$vat_procent.'%',$netto_gr_vat[0].'.'.$netto_gr_vat[1],$netto_z_vat[0].'.'.$netto_z_vat[1]);
				
		//wyliczone pozycje platnosci serializowane dane
		$naliczone_uslugi = serialize($facture_payments);
		
		//wyliczone pozycje platnosci w formacie txt
		$naliczone_uslugi_txt = '';
		
		foreach($facture_payments as $f)
		{
			$naliczone_uslugi_txt .= "Lp. ".$f[0]." | usługa: ".$f[1]." | jednostka ".$f[2]." | ilość: ".$f[3]." | cena jednostkowa: ".$f[4]." | netto: ".$f[5]." | stawka VAT: ".$f[6]." | kwota VAT: ".$f[7]." | brutto: ".$f[8]."\n";
		}
		
		$naliczone_uslugi_txt .= "netto: ".$netto."\n";
		$naliczone_uslugi_txt .= "brutto: ".$brutto."\n";
		
		//termin platnosci
		$this->config->load('global_settings');	
		$global_settings = $this->config->item('global_settings');		
		
		$day = date('d');
		$month = date('m');
		$year = date('Y');
		
		$termin_platnosci = strftime("20%y-%m-%d",mktime(0, 0, 0,$month, ($day+$global_settings['afiliant']['ilosc_dni_na_wypalte_pieniedzy']), $year));
		
		if($form['nr']!=$form['nr_systemowy'])
		{
			$data['numer_wlasny'] = $form['nr'];
			$data['year'] = $year;
			$data['month'] = $month;
		}
		else
		{
			$data['nr'] = $form['nr'];
			$data['month'] = $month;
			$data['year'] = $year;
		}
		
		$data['miejsce_wystawienia'] = $afiliant_data[0]['miasto'];
		$data['afiliant_id'] = $afiliant_id;
		$data['typ'] = $typ_rozliczenia; //firma, osobaprywatna		
		$data['typ_dostarczenia'] = 'online'; //dostarczy wystawiona fakture/rachunek przez siebie
		$data['data_wystawienia'] = date('Y-m-d');
		$data['data_sprzedazy'] = date('Y-m-d');
		$data['sposob_zaplaty'] = 'przelew';
		$data['termin_platnosci'] = $termin_platnosci;
		$data['sprzedawca'] = $sprzedawca;
		$data['nabywca'] = $nabywca;
		$data['naliczone_uslugi'] = $naliczone_uslugi;
		$data['naliczone_uslugi_txt'] = $naliczone_uslugi_txt;		
		$data['netto'] = $netto;
		$data['brutto'] = $brutto;		
		$data['slownie_do_zaplaty'] = $slownie_do_zaplaty;
		$data['os_upowaz_do_wyst_faktury'] = $afiliant_data[0]['imie'].' '.$afiliant_data[0]['nazwisko'];
		$data['nr_konta'] = $afiliant_data[0]['nr_konta'];
		
		//print_r($data);
		$this->db->insert('afilianci_rozliczenia', $data);		
		$afilianci_rolziczenia_id = $this->db->insert_id();

         //wyslanie maila z faktura
         @$url = 'http://panel.networds.pl/admin/send_facture_by_mail_afiliant/'.$data['afiliant_id'].'/'.$afilianci_rolziczenia_id.'/'.urlencode($data['typ']).'/'.$data['typ_dostarczenia'];
         @file_get_contents($url);

				
		//faktury seo
		if(!empty($all_factures['seo']))
		{
			foreach($all_factures['seo'] as $mon)
			{
				foreach($mon as $m)
				{
					//$netto_seo += $m['netto'];
					$seo['afilianci_rozliczenia_id'] = $afilianci_rolziczenia_id;
					$seo['faktura_id'] = $m['id'];
					$seo['typ'] = 'SEO';
					$this->db->insert('afilianci_faktury_rozliczone', $seo);  
				}			
			}
		}
		
		//faktury sem		
		if(!empty($all_factures['sem']))
		{
			foreach($all_factures['sem'] as $mon)
			{
				foreach($mon as $m)
				{
					//$netto_sem += $m['netto'];
					$sem['afilianci_rozliczenia_id'] = $afilianci_rolziczenia_id;
					$sem['faktura_id'] = $m['id'];
					$sem['typ'] = 'SEM'; 
					$this->db->insert('afilianci_faktury_rozliczone', $sem); 
				}
			}
		}		
	}
	
	function get_stan_konta_linkow_sponosrownych($user_id)
	{		
		$sql = "SELECT adwords_customer_id,adwords_prowizja from user_data where user_id = ".$user_id." limit 1";
		$data = $this->db->query($sql);	
		$adwords_id = $data->result_array();
		unset($data);
		//print_r($adwords_id);
		
		if(!empty($adwords_id[0]['adwords_customer_id']))
		{
			$stan_konta_doladowany = 0;
			$stan_konta_wykorzystany = 0;
			$aktualny_stan_konta = 0;
			
			//wyliczenie wykorzystanych kwot linkow sponsorowanych
			$sql = "SELECT ROUND((sum(cost)/1000000),2) as costs from adwords_stats where adwords_customer_id = ".$adwords_id[0]['adwords_customer_id']."";			
			$data = $this->db->query($sql);	
			$stan_konta_wykorzystany = $data->result_array();
			$stan_konta_wykorzystany = $stan_konta_wykorzystany[0]['costs'];
			unset($data);
			
			if(empty($stan_konta_wykorzystany)) 
				$stan_konta_wykorzystany = 0;
			
			//wyliczenie doladowanych kwot linkow sponsorowanych	
			$sql = "SELECT ROUND(sum(netto),2) as costs from faktury_sem where user_id = ".$user_id."";			
			$data = $this->db->query($sql);	
			$stan_konta_doladowany = $data->result_array();
			$stan_konta_doladowany = $stan_konta_doladowany[0]['costs'];
			unset($data);
			
			if(empty($stan_konta_doladowany))  
				$stan_konta_doladowany = 0;
				
			//sprawdzenie czy juz jakas kwota zostala wykorzystana na reklamy, 
			//jezeli nie to pokaz kientowi cala wlaną kasę 
			//jezeli tak to pokaz klientowi kase pomnijeszona o wykorzytana i z odliczona prowizja dla networds

			if($stan_konta_wykorzystany==0)
			{
				return $stan_konta_doladowany;
			}
			else
			{
				//prowizja od adwords 
				$prowizja = $adwords_id[0]['adwords_prowizja']/100;
				//echo '<br /><br />prowizja networds:'.($prowizja*100).'% <br />';		
				//echo 'doladowano:'.$stan_konta_doladowany.'<br />';
				//echo 'wykorzystano:'.$stan_konta_wykorzystany.'<br />';
										
				$aktualny_stan_konta = round(($stan_konta_doladowany/(1+$prowizja)),2) - $stan_konta_wykorzystany;
				
				//zabezpieczenie jakby cos poszlo nie tak zby klient nie zobaczyl ujemnej kwoty
				if($aktualny_stan_konta<0)$aktualny_stan_konta = 0; 				
				
				return $aktualny_stan_konta;
			}	
								
			//print_r($stan_konta_doladowany);			
		}
		else
		{
			return 0;
		}		
	}
	
	function wystaw_fakture_sem_proforma($post)
	{
		include_once('files/slownie.php');
		include_once('files/functions.php');
				
		$day = date('d');
		$month = date('m');
		$year = date('Y');
		
		
		$this->config->load('global_settings');	
		$global_settings = $this->config->item('global_settings');
		
		$termin_platnosci = strftime("20%y-%m-%d",mktime(0, 0, 0,$month, ($day+$global_settings['faktury_sem_proforma']['ilosc_dni_na_zaplacenie_faktury']), $year));
		
		//numer faktury proforma
		$nr = 1;
		$sql = "SELECT nr from faktury_sem_proforma where month = '".$month."' and year = '".$year."' order by nr desc limit 1";			
		$data = $this->db->query($sql);	
		$nr_tmp =  $data->result_array();	
		//print_r($nr_tmp);
		unset($data);
		
		if(!empty($nr_tmp))
		{
			$nr = ($nr_tmp[0]['nr'] + 1);
		}
		//koniec wyliczania numeru faktury proforma
		
		//pobranie danych nabywcy				
		
		$sql = "SELECT * from user_data where user_id=".$post['desc2']." limit 1";			
		$data = $this->db->query($sql);	
		$user_data =  $data->result_array();					
		unset($data);
		
		//koniec pobrania danych nabywcy
		
        /*dane sprzedawcy*/
        $networds = $this->get_networds_data();
        $miejsce_wystawienia = trim($networds[0]['miasto']);
        $sprzedawca = trim($networds[0]['nazwa'])."\nul. ".$networds[0]['ulica']." ".$networds[0]['nr_budynku']." ".$networds[0]['nr_lokalu']."\n".$networds[0]['kod_pocztowy']." ".$networds[0]['miasto']."\nNIP: ".$networds[0]['nip']."\nKonto: ".$networds[0]['nr_konta']."\n".$networds[0]['bank']."";	
        /*koniec pobrania danych sprzedawcy*/

		$nabywca = "".$user_data[0]['company_name']."\n".$user_data[0]['street']." ".$user_data[0]['b_no']." ".$user_data[0]['a_no']."\n".$user_data[0]['post_code']." ".$user_data[0]['city']."\nNIP: ".$user_data[0]['tax_id']."";
		
		//dodanie 0 do groszy np 1.6 zamieni na 1.60
		$brutto  = round(($post['amount']/100),2);
		//$netto  =  round((($post['amount']/1.22)/100),2);
		$netto  =  round((($post['amount']/(1 + $this->vat))/100),2);
		
		$brutto_tmp  =  d_gr($brutto);					
		$slowa = Array('minus',Array('zero', 'jeden', 'dwa', 'trzy', 'cztery', 'pięć', 'sześć', 'siedem', 'osiem', 'dziewięć'), Array( 'dziesięć', 'jedenaście', 'dwanaście', 'trzynaście', 'czternaście', 'piętnaście', 'szesnaście', 'siedemnaście', 'osiemnaście', 'dziewiętnaście'), Array( 'dziesięć', 'dwadzieścia', 'trzydzieści', 'czterdzieści', 'pięćdziesiąt', 'sześćdziesiąt', 'siedemdziesiąt', 'osiemdziesiąt', 'dziewięćdziesiąt'), Array( 'sto', 'dwieście', 'trzysta', 'czterysta', 'pięćset', 'sześćset', 'siedemset', 'osiemset', 'dziewięćset'), Array( 'tysiąc', 'tysiące', 'tysięcy'), Array( 'milion', 'miliony', 'milionów'), Array( 'miliard', 'miliardy', 'miliardów'), Array( 'bilion', 'biliony', 'bilionów'), Array( 'biliard', 'biliardy', 'biliardów'), Array( 'trylion', 'tryliony', 'trylionów'), Array( 'tryliard', 'tryliardy', 'tryliardów'), Array( 'kwadrylion', 'kwadryliony', 'kwadrylionów'), Array( 'kwintylion', 'kwintyliony', 'kwintylionów'), Array( 'sekstylion', 'sekstyliony', 'sekstylionów'), Array( 'septylion', 'septyliony', 'septylionów'), Array( 'oktylion', 'oktyliony', 'oktylionów'), Array( 'nonylion', 'nonyliony', 'nonylionów'), Array( 'decylion', 'decyliony', 'decylionów') );					
		$slownie_do_zaplaty = slownie($brutto_tmp[0],$slowa).' '.odmiana(array('złoty','złote','złotych'),$brutto_tmp[0]).' i '.slownie($brutto_tmp[1],$slowa).' '.odmiana(array('grosz','grosze','groszy'),$brutto_tmp[1]);
		
		
		//dodanie 0 do groszy np 1.6 zamieni na 1.60
		/*
		$netto_tmp = $post['amount']/1.22/100;
		$netto_gr = d_gr($netto_tmp); 
		$netto_gr_z_vat = d_gr(round((1.22*$netto_tmp),2));
		$netto_gr_vat = d_gr(round((0.22*$netto_tmp),2));
		$netto_z_vat = d_gr(round((1.22*$netto_tmp),2));  
		 */
		$netto_tmp      = $post['amount']/(1 + $this->vat)/100;
		$netto_gr       = d_gr($netto_tmp);
		$netto_gr_z_vat = d_gr(round((1+$this->vat)*$netto_tmp,2));
		$netto_gr_vat   = d_gr(round(($this->vat*$netto_tmp),2));
		$netto_z_vat    = d_gr(round(((1 + $this->vat)*$netto_tmp),2));

        $vat_procent    =  ($this->vat * 100);
		 
		$facture_payments[] = array(1,'Linki sponsorowane Google Adwords - doładowanie konta SEM','szt',1,$netto_gr[0].'.'.$netto_gr[1],$netto_gr[0].'.'.$netto_gr[1],$vat_procent.'%',$netto_gr_vat[0].'.'.$netto_gr_vat[1],$netto_gr_z_vat[0].'.'.$netto_gr_z_vat[1]);
		$facture_payments[] = array('','','','','RAZEM',$netto_gr[0].'.'.$netto_gr[1],'',$netto_gr_vat[0].'.'.$netto_gr_vat[1],$netto_z_vat[0].'.'.$netto_z_vat[1]);
		$facture_payments[] = array('','','','','w tym',$netto_gr[0].'.'.$netto_gr[1],$vat_procent.'%',$netto_gr_vat[0].'.'.$netto_gr_vat[1],$netto_z_vat[0].'.'.$netto_z_vat[1]);
				
		//wyliczone pozycje platnosci serializowane dane
		$naliczone_uslugi = serialize($facture_payments);
		
		//wyliczone pozycje platnosci w formacie txt
		$naliczone_uslugi_txt = '';
		
		foreach($facture_payments as $f)
		{
			$naliczone_uslugi_txt .= "Lp. ".$f[0]." | usługa: ".$f[1]." | jednostka ".$f[2]." | ilość: ".$f[3]." | cena jednostkowa: ".$f[4]." | netto: ".$f[5]." | stawka VAT: ".$f[6]." | kwota VAT: ".$f[7]." | brutto: ".$f[8]."\n";
		}
		
		//$brutto = round((1.22*$netto),2);
		$brutto = round(((1 + $this->vat)*$netto),2);
		
		$naliczone_uslugi_txt .= "netto: ".$netto."\n";
		$naliczone_uslugi_txt .= "brutto: ".$brutto."\n";
		
		$data['nr'] = $nr;
		$data['month'] = $month;
		$data['year'] = $year;
		$data['miejsce_wystawienia'] = $miejsce_wystawienia;
		$data['data_wystawienia'] = date('Y-m-d');
		$data['data_sprzedazy'] = date('Y-m-d');
		$data['sposob_zaplaty'] = 'przelew';
		$data['termin_platnosci'] = $termin_platnosci;
		$data['sprzedawca'] = $sprzedawca;
		$data['nabywca'] = $nabywca;
		$data['naliczone_uslugi'] = $naliczone_uslugi;
		$data['naliczone_uslugi_txt'] = $naliczone_uslugi_txt;
		$data['netto'] = $netto;
		$data['brutto'] = $brutto;
		$data['slownie_do_zaplaty'] = $slownie_do_zaplaty;
		$data['os_upowaz_do_wyst_faktury'] = 'Jakub Kurbiel';
		$data['uwagi'] = '';
		$data['user_id'] = $user_data[0]['user_id'];
		$data['zaplacono'] = 0;
		$data['zatwierdzono'] = 0;		
				
		$this->db->insert('faktury_sem_proforma', $data);

         //wyslanie maila z faktura
         @$url = 'http://panel.networds.pl/admin/send_facture_by_mail_sem_pro/'.$data['user_id'].'/'.$this->db->insert_id();
         @file_get_contents($url);

	}
	
	function zaplacono_platnosci_pl_sem($id_transakcji=null)
	{
		if($id_transakcji!=null)
		{
			$sql = "SELECT * FROM platnosci_pl_transakcje WHERE id_transakcji = ".$id_transakcji."";			
			$data = $this->db->query($sql);	
			$transaction_data = $data->result_array();
			unset($data);
			
			$sql = "SELECT * FROM faktury_sem WHERE id_transakcji = ".$id_transakcji."";			
			$data = $this->db->query($sql);	
			$fak_data = $data->result_array();
			unset($data);
			
			if(!empty($transaction_data) and empty($fak_data))
			{
				include_once('files/slownie.php');
				include_once('files/functions.php');
						
				$month = date('m');
				$year = date('Y');
				
				/*numer faktury*/
				$nr = 1;
				$sql = "SELECT nr from faktury_sem where month = '".$month."' and year = '".$year."' order by nr desc limit 1";			
				$data = $this->db->query($sql);	
				$nr_tmp =  $data->result_array();	
				//print_r($nr_tmp);
				unset($data);
				if(!empty($nr_tmp))
				{
					$nr = ($nr_tmp[0]['nr'] + 1);
				}
				/*koniec wyliczania numeru faktury*/
				
				/*pobranie danych nabywcy*/				
				
				$sql = "SELECT * from user_data where user_id=".$transaction_data[0]['desc2']." limit 1";			
				$data = $this->db->query($sql);	
				$user_data =  $data->result_array();					
				unset($data);
				
				/*koniec pobrania danych nabywcy*/
				
				//$sprzedawca = "Labmatic - Jakub Kurbiel\nul.Reymonta 2 /3\n43-300 Bielsko-Biała\nNIP: 5471795303\nKonto: 26 1060 0076 0000 3260 0153 8938\nBank BPH o./Bielsko-Biała";
				$nabywca = "".$user_data[0]['company_name']."\n".$user_data[0]['street']." ".$user_data[0]['b_no']." ".$user_data[0]['a_no']."\n".$user_data[0]['post_code']." ".$user_data[0]['city']."\nNIP: ".$user_data[0]['tax_id']."";
				
                /*dane sprzedawcy*/
                $networds = $this->get_networds_data();
                $miejsce_wystawienia = trim($networds[0]['miasto']);
                $sprzedawca = trim($networds[0]['nazwa'])."\nul. ".$networds[0]['ulica']." ".$networds[0]['nr_budynku']." ".$networds[0]['nr_lokalu']."\n".$networds[0]['kod_pocztowy']." ".$networds[0]['miasto']."\nNIP: ".$networds[0]['nip']."\nKonto: ".$networds[0]['nr_konta']."\n".$networds[0]['bank']."";	
                /*koniec pobrania danych sprzedawcy*/

				//dodanie 0 do groszy np 1.6 zamieni na 1.60
				$brutto  = round(($transaction_data[0]['amount']/100),2);
				//$netto  =  round((($transaction_data[0]['amount']/1.22)/100),2);
				$netto  =  round((($transaction_data[0]['amount']/(1 + $this->vat))/100),2);
				
				$brutto_tmp  =  d_gr($brutto);					
				$slowa = Array('minus',Array('zero', 'jeden', 'dwa', 'trzy', 'cztery', 'pięć', 'sześć', 'siedem', 'osiem', 'dziewięć'), Array( 'dziesięć', 'jedenaście', 'dwanaście', 'trzynaście', 'czternaście', 'piętnaście', 'szesnaście', 'siedemnaście', 'osiemnaście', 'dziewiętnaście'), Array( 'dziesięć', 'dwadzieścia', 'trzydzieści', 'czterdzieści', 'pięćdziesiąt', 'sześćdziesiąt', 'siedemdziesiąt', 'osiemdziesiąt', 'dziewięćdziesiąt'), Array( 'sto', 'dwieście', 'trzysta', 'czterysta', 'pięćset', 'sześćset', 'siedemset', 'osiemset', 'dziewięćset'), Array( 'tysiąc', 'tysiące', 'tysięcy'), Array( 'milion', 'miliony', 'milionów'), Array( 'miliard', 'miliardy', 'miliardów'), Array( 'bilion', 'biliony', 'bilionów'), Array( 'biliard', 'biliardy', 'biliardów'), Array( 'trylion', 'tryliony', 'trylionów'), Array( 'tryliard', 'tryliardy', 'tryliardów'), Array( 'kwadrylion', 'kwadryliony', 'kwadrylionów'), Array( 'kwintylion', 'kwintyliony', 'kwintylionów'), Array( 'sekstylion', 'sekstyliony', 'sekstylionów'), Array( 'septylion', 'septyliony', 'septylionów'), Array( 'oktylion', 'oktyliony', 'oktylionów'), Array( 'nonylion', 'nonyliony', 'nonylionów'), Array( 'decylion', 'decyliony', 'decylionów') );					
				$slownie_do_zaplaty = slownie($brutto_tmp[0],$slowa).' '.odmiana(array('złoty','złote','złotych'),$brutto_tmp[0]).' i '.slownie($brutto_tmp[1],$slowa).' '.odmiana(array('grosz','grosze','groszy'),$brutto_tmp[1]);
				
				//dodanie 0 do groszy np 1.6 zamieni na 1.60
				/*
				$netto_tmp = $transaction_data[0]['amount']/1.22/100;
				$netto_gr = d_gr($netto_tmp); 
				$netto_gr_z_vat = d_gr(round((1.22*$netto_tmp),2));
				$netto_gr_vat = d_gr(round((0.22*$netto_tmp),2));
				$netto_z_vat = d_gr(round((1.22*$netto_tmp),2));  
				 */
				$netto_tmp = $transaction_data[0]['amount']/(1 + $this->vat)/100;
				$netto_gr = d_gr($netto_tmp);
				$netto_gr_z_vat = d_gr(round(((1 + $this->vat)*$netto_tmp),2));
				$netto_gr_vat = d_gr(round(($this->vat*$netto_tmp),2));
				$netto_z_vat = d_gr(round(((1 + $this->vat)*$netto_tmp),2));
				
				$vat_procent    =  ($this->vat * 100);
				$facture_payments[] = array(1,'Linki sponsorowane Google Adwords - doładowanie konta SEM','szt',1,$netto_gr[0].'.'.$netto_gr[1],$netto_gr[0].'.'.$netto_gr[1],$vat_procent.'%',$netto_gr_vat[0].'.'.$netto_gr_vat[1],$netto_gr_z_vat[0].'.'.$netto_gr_z_vat[1]);
				$facture_payments[] = array('','','','','RAZEM',$netto_gr[0].'.'.$netto_gr[1],'',$netto_gr_vat[0].'.'.$netto_gr_vat[1],$netto_z_vat[0].'.'.$netto_z_vat[1]);
				$facture_payments[] = array('','','','','w tym',$netto_gr[0].'.'.$netto_gr[1],$vat_procent.'%',$netto_gr_vat[0].'.'.$netto_gr_vat[1],$netto_z_vat[0].'.'.$netto_z_vat[1]);
						
				//wyliczone pozycje platnosci serializowane dane
				$naliczone_uslugi = serialize($facture_payments);
				
				//wyliczone pozycje platnosci w formacie txt
				$naliczone_uslugi_txt = '';
				
				foreach($facture_payments as $f)
				{
					$naliczone_uslugi_txt .= "Lp. ".$f[0]." | usługa: ".$f[1]." | jednostka ".$f[2]." | ilość: ".$f[3]." | cena jednostkowa: ".$f[4]." | netto: ".$f[5]." | stawka VAT: ".$f[6]." | kwota VAT: ".$f[7]." | brutto: ".$f[8]."\n";
				}
				
				//$brutto = round((1.22*$netto),2);
				$brutto = round(((1 + $this->vat)*$netto),2);
				
				$naliczone_uslugi_txt .= "netto: ".$netto."\n";
				$naliczone_uslugi_txt .= "brutto: ".$brutto."\n";
				
				$data['nr'] = $nr;
				$data['month'] = $month;
				$data['year'] = $year;
				$data['miejsce_wystawienia'] = $miejsce_wystawienia;
				$data['data_wystawienia'] = date('Y-m-d');
				$data['data_sprzedazy'] = date('Y-m-d');
				$data['sposob_zaplaty'] = 'przelew';
				$data['termin_platnosci'] = date('Y-m-d');
				$data['sprzedawca'] = $sprzedawca;
				$data['nabywca'] = $nabywca;
				$data['naliczone_uslugi'] = $naliczone_uslugi;
				$data['naliczone_uslugi_txt'] = $naliczone_uslugi_txt;
				$data['netto'] = $netto;
				$data['brutto'] = $brutto;
				$data['slownie_do_zaplaty'] = $slownie_do_zaplaty;
				$data['os_upowaz_do_wyst_faktury'] = 'Jakub Kurbiel';
				$data['uwagi'] = '';
				$data['user_id'] = $user_data[0]['user_id'];
				$data['zaplacono'] = 1;
				$data['zatwierdzono'] = 1;
				$data['id_transakcji'] = $id_transakcji;
						
				$this->db->insert('faktury_sem', $data);

                 //wyslanie maila z faktura
                @$url = 'http://panel.networds.pl/admin/send_facture_by_mail_sem/'.$data['user_id'].'/'.$this->db->insert_id();
                @file_get_contents($url);
			}
		}
	}	
	
	function zaplacono_platnosci_pl($id_faktury=null,$zatwierdzono=null,$id_transakcji = null)
	{
		if($id_faktury!=null)
		{
			if($zatwierdzono!=null)$data['zatwierdzono'] = 1;
			
			$data['zaplacono'] = 1;
            $data['id_transakcji'] = $id_transakcji;
	        $this->db->WHERE('id', $id_faktury);
	        $this->db->update('faktury_seo', $data);
		}
	}
	
	function get_facture_platnosci_pl($user_id,$id_faktury)
	{
		$sql = "SELECT * FROM faktury_seo WHERE user_id = ".$user_id." AND id='".$id_faktury."' and zaplacono=0";			
		$data = $this->db->query($sql);	
		return $data->result_array();
	}
	
	function get_user_facture($user_id,$month,$year)
	{
		$sql = "SELECT id FROM faktury_seo WHERE user_id = ".$user_id." AND year='".$year."' AND month='".$month."'";			
		$data = $this->db->query($sql);	
		return $data->result_array();
	}
	
	function get_facture_seo($id)
	{
		$sql = "SELECT * from faktury_seo where id = '".$id."'";		 			
		$data = $this->db->query($sql);	
		return $data->result_array();
	}
	
	function get_facture($user_id,$month,$year)
	{
		$sql = "SELECT * from faktury_seo where month = '".$month."' and year = '".$year."' and user_id = '".$user_id."'";		 			
		$data = $this->db->query($sql);	
		return $data->result_array();
	}
	
	function get_afilint_facture($afiliant_id,$id)
	{
		$sql = "SELECT * from afilianci_rozliczenia where id = '".$id."' and afiliant_id = '".$afiliant_id."'";		 			
		$data = $this->db->query($sql);	
		return $data->result_array();
	}
	
	function get_factures($user_id)
	{
		$sql = "SELECT id,month,year,zaplacono,zatwierdzono,termin_platnosci,data_wystawienia,id_transakcji,nr,netto from faktury_seo where user_id = '".$user_id."' order by data_wystawienia desc,nr desc ";
		$data = $this->db->query($sql);	
		return $data->result_array();
	}
	
	function get_factures_sem($user_id)
	{
		$sql = "SELECT id,nr,month,year,zaplacono,zatwierdzono,termin_platnosci,data_wystawienia,id_transakcji,netto from faktury_sem where user_id = '".$user_id."' order by data_wystawienia desc,nr desc ";
		$data = $this->db->query($sql);	
		return $data->result_array();
	}
	
	function get_factures_sem_proforma($user_id)
	{
		$sql = "SELECT id,nr,month,year,zaplacono,zatwierdzono,termin_platnosci,data_wystawienia,netto from faktury_sem_proforma where user_id = '".$user_id."' order by data_wystawienia desc,nr desc ";
		$data = $this->db->query($sql);	
		return $data->result_array();
	}
	
	function check_proforma_data($data)
	{
		$month = (int) substr($data,5,2);
		
		$sql = "SELECT data_wystawienia from faktury_sem where data_wystawienia > '".trim($data)."' and month = ".$month." order by data_wystawienia desc limit 1";		 			
		$data = $this->db->query($sql);	
		return $data->result_array();	
	}
	
	function get_facture_sem_proforam_to_pdf($nr,$user_id,$month,$year)
	{
		$sql = "SELECT * from faktury_sem_proforma where nr = '".$nr."' and user_id = '".$user_id."' and year = '".$year."' and month = '".$month."' ";		 			
		$data = $this->db->query($sql);	
		return $data->result_array();
	}
	
	function get_facture_sem_proforam_to_pdf_by_id($id)
	{
		$sql = "SELECT * from faktury_sem_proforma where id = '".$id."'";		 			
		$data = $this->db->query($sql);	
		return $data->result_array();
	}
	
	function get_facture_sem_fv_to_pdf($nr,$user_id,$month,$year)
	{
		$sql = "SELECT * from faktury_sem where nr = '".$nr."' and user_id = '".$user_id."' and year = '".$year."' and month = '".$month."' ";		 			
		$data = $this->db->query($sql);	
		return $data->result_array();
	}
	
	function get_facture_sem_fv_to_pdf_by_id($id)
	{
		$sql = "SELECT * from faktury_sem where id = '".$id."'";		 			
		$data = $this->db->query($sql);	
		return $data->result_array();
	}
	
	function zloty_check($keys,$week,$year)
	{
		$this->db->where('week', $week);
		$this->db->where('year', $year);
		$this->db->where_in('keyword_id', $keys);		
		$data = $this->db->get('keyword_price_per_week',1);	
		return $data->result_array();
	}
	
	function get_data_to_fakcture_payments($keyword_id,$month,$year)
	{		
		set_time_limit(60);	
		$sql = "SELECT * FROM keyword_price_per_week WHERE keyword_id = '".$keyword_id."' AND year='".$year."' AND month='".$month."' order by id";			
		$data = $this->db->query($sql);	
		return $data->result_array();
	}
	
	function update_keyword_dojscie($keyword_id)
	{
		$data['naliczona_oplata_za_dojscie'] = 1;
        $this->db->WHERE('id', $keyword_id);
        return $this->db->update('user_domain_keyword', $data);
	}
	
	function insert_keyword_dojscie_keyword_price_per_week($keyword_id,$google_region,$price,$data_dojscia)
	{
		$data['keyword_id'] = $keyword_id;
		$data['year'] = substr($data_dojscia,0,4);
		$data['month'] = substr($data_dojscia,5,2);
		$data['google_region'] = $google_region;
		$data['price'] = $price;
		$data['days'] = NULL;
		$data['doszlo_na_pozycje'] = $data_dojscia;
        return $this->db->insert('keyword_price_per_week', $data);
	}
	
    function get_umowa_domains_status($user_id)
    {
        $this->db->select('domain');
		$this->db->from('users_umowy');
		$this->db->join('user_domain', 'users_umowy.domain_id = user_domain.id');
		$this->db->where('users_umowy.user_id', $user_id);
        $this->db->where('users_umowy.active', 0);
        $this->db->where('user_domain.umowa', 0);
				 
		$data = $this->db->get();
		return $data->result_array(); 
    }

	function get_domains_and_keywords($user_id)
	{
		$this->db->select('*');
		$this->db->from('user_domain');
		$this->db->join('user_domain_keyword', 'user_domain.id = user_domain_keyword.domain_id');
		$this->db->where('user_domain.user_id', $user_id);
		
		// ograniczenie dodane przy zmianie naliczania seo z tygodniowego na dzienne
		$this->db->where('user_domain_keyword.naliczona_oplata_za_dojscie', 1);
		 
		$data = $this->db->get();
		return $data->result_array(); 
	}
	
	function get_networds_data()
	{
		$sql = "SELECT * from networds";			
		$data = $this->db->query($sql);	
		return $data->result_array();	
	}
	
	function add_facture($month,$year,$platne_keywords,$user_data,$user_id,$networds,$dni_na_platnosc)
	{	
		//tylko do testow, wywalic po testach
		/*if($month==12 and $year==2009 and $user_id==9)
			echo '';
		else 
			return;
		*/
		
		/*miejsce wystawienia, data wystawienia, sprzedarzy, termin platnosci*/
		
		//wyliczenie miesiaca nastepujacego po miesiacu za ktory jest wystawiana faktura
		//$data_wystawienia_tmp = strftime("20%y-%m-%d",mktime(0, 0, 0, $month+1, 1, $year));
		$dni_w_miesiacu = MonthDays($month,$year);
		$data_wystawienia =  $year.'-'.$month.'-'.$dni_w_miesiacu;   				
		$miejsce_wystawienia = trim($networds[0]['miasto']);		
		$sposob_zaplaty = 'przelew';		
		$termin_platnosci = strftime("20%y-%m-%d",mktime(0, 0, 0,$month, ($dni_w_miesiacu+$dni_na_platnosc), $year));
				
		/*numer faktury*/
		$nr = 1;
		$sql = "SELECT nr from faktury_seo where month = '".$month."' and year = '".$year."' order by nr desc limit 1";			
		$data = $this->db->query($sql);	
		$nr_tmp =  $data->result_array();	
		
		unset($data);
		if(!empty($nr_tmp))
		{			
			$nr = ($nr_tmp[0]['nr'] + 1);
		}
		
		/*sprzedawca, nabywca*/
		$sprzedawca = trim($networds[0]['nazwa'])."\nul. ".$networds[0]['ulica']." ".$networds[0]['nr_budynku']." ".$networds[0]['nr_lokalu']."\n".$networds[0]['kod_pocztowy']." ".$networds[0]['miasto']."\nNIP: ".$networds[0]['nip']."\nKonto: ".$networds[0]['nr_konta']."\n".$networds[0]['bank']."";	
		$nabywca = "".$user_data[0]['company_name']."\n".$user_data[0]['street']." ".$user_data[0]['b_no']." ".$user_data[0]['a_no']."\n".$user_data[0]['post_code']." ".$user_data[0]['city']."\nNIP: ".$user_data[0]['tax_id']."";

		/*naliczone uslugi*/		
		$facture_payments = array(); //zmienna trzymajaca tablice z wyliczonymi pozycjami platnosci
		$netto = 0; //zmienna trzymajaca cala wartosc netto faktury
		$brutto = 0; //zmienna trzymajaca cala wartosc brutto faktury
		$vat = 0; //zmienna trzymajaca cala wartosc vat faktury
		$uwagi = array(); //zmienna trzymajaca slowa ktore byly na pozycjach									
		
		$dane_do_faktury = array();
		
		foreach($platne_keywords as $k=>$v)
		{
			$keywords = implode(",", $v);			
			$sql = "SELECT keyword_id,keyword_price_per_week.price,days,doszlo_na_pozycje,domain,keyword from keyword_price_per_week,user_domain,user_domain_keyword where user_domain_keyword.id=keyword_price_per_week.keyword_id and user_domain.id='".$k."' and month=".$month." and year=".$year." and keyword_id IN (".$keywords.")";			
			$data = $this->db->query($sql);	
			$dane_do_faktury[$k] =  $data->result_array();	
			unset($data);
		}		
		
		/*lista oplat na fakturze*/		
		$utrzymanie = 0;								
		$domena = '';
		$i=1;
		
		foreach($dane_do_faktury as $domains)
		{								
			foreach($domains as $v)
			{
				if(empty($v['days']) and !empty($v['doszlo_na_pozycje']))
				{
					//dojscie
					//dodanie 0 do groszy np 1.6 zamieni na 1.60
					$price_round = round($v['price'],2);
					$d3 = d_gr($price_round); 
					//$d3_vat = d_gr(round((0.22*$price_round),2));
					//$d3_z_vat = d_gr(round((1.22*$price_round),2));											
					
                        $d3_vat = d_gr(round(($this->vat*$price_round),2));
                        $d3_z_vat = d_gr(round(((1 + $this->vat)*$price_round),2));
					$vat_procent    =  ($this->vat * 100);
					
					$facture_payments[] = array($i,'Wynagrodzenie jednorazowe dla słowa kluczowego \''.$v['keyword'].'\' za dojście witryny \''.$v['domain'].'\' do pozycji 1-10','szt',1,$d3[0].'.'.$d3[1],$d3[0].'.'.$d3[1],$vat_procent.'%',$d3_vat[0].'.'.$d3_vat[1],$d3_z_vat[0].'.'.$d3_z_vat[1]);
					$i++;
				}
				elseif(!empty($v['days']) and empty($v['doszlo_na_pozycje']))
				{
					//utrzymanie
					//dodanie 0 do groszy np 1.6 zamieni na 1.60
					$uwagi[trim($v['domain'])][] = $v['keyword'];
					$utrzymanie += round($v['price']*$v['days'],2);				
					$utrzymanie_gr = d_gr($utrzymanie); 
					//$utrzymanie_gr_vat = d_gr(round((0.22*$utrzymanie),2));
					//$utrzymanie_gr_z_vat = d_gr(round((1.22*$utrzymanie),2));
					
                        $utrzymanie_gr_vat = d_gr(round(($this->vat*$utrzymanie),2));
                        $utrzymanie_gr_z_vat = d_gr(round(((1 + $this->vat)*$utrzymanie),2));
						
					$domena = $v['domain']; 					
				}							
			}
						
			if(!empty($domena))
			{
				$vat_procent    =  ($this->vat * 100);
				$facture_payments[] = array($i,'Opłata za pozycjonowanie witryny \''.$v['domain'].'\' w okresie od '.$year.'-'.$month.'-01 do '.$year.'-'.$month.'-'.MonthDays($month,$year).'','szt',1,$utrzymanie_gr[0].'.'.$utrzymanie_gr[1],$utrzymanie_gr[0].'.'.$utrzymanie_gr[1],$vat_procent.'%',$utrzymanie_gr_vat[0].'.'.$utrzymanie_gr_vat[1],$utrzymanie_gr_z_vat[0].'.'.$utrzymanie_gr_z_vat[1]);
				$i++;
			}
						
			$domena = '';
			$utrzymanie = 0;
		}
				
		//dodanie 0 do groszy np 1.6 zamieni na 1.60
		
		foreach($facture_payments as $f)		
		{
			//print_r($f);
			$netto += $f[5];
			$brutto += $f[8];
			$vat += $f[7];
		}

        $netto_okragle = d_gr($netto);
        $brutto_okragle = d_gr($brutto);
        $vat_okragle = d_gr($vat);

        $netto_okragle = $netto_okragle[0].'.'.$netto_okragle[1];
        $brutto_okragle = $brutto_okragle[0].'.'.$brutto_okragle[1];
        $vat_okragle = $vat_okragle[0].'.'.$vat_okragle[1];

		$vat_procent    =  ($this->vat * 100);
		$facture_payments[] = array('','','','','RAZEM',$netto_okragle,'',$vat_okragle,$brutto_okragle);
		$facture_payments[] = array('','','','','w tym',$netto_okragle,$vat_procent.'%',$vat_okragle,$brutto_okragle);
		
		//wyliczone pozycje platnosci serializowane dane
		$naliczone_uslugi = serialize($facture_payments);
		
		//wyliczone pozycje platnosci w formacie txt
		$naliczone_uslugi_txt = '';
		
		foreach($facture_payments as $f)
		{
			$naliczone_uslugi_txt .= "Lp. ".$f[0]." | usługa: ".$f[1]." | jednostka ".$f[2]." | ilość: ".$f[3]." | cena jednostkowa: ".$f[4]." | netto: ".$f[5]." | stawka VAT: ".$f[6]." | kwota VAT: ".$f[7]." | brutto: ".$f[8]."\n";
		}
		
		$naliczone_uslugi_txt .= "netto: ".$netto."\n";
		$naliczone_uslugi_txt .= "brutto: ".$brutto."\n";
		
		//dodanie 0 do groszy np 1.6 zamieni na 1.60
		$brutto_tmp  =  d_gr($brutto);		
		
		$slowa = Array('minus',Array('zero', 'jeden', 'dwa', 'trzy', 'cztery', 'pięć', 'sześć', 'siedem', 'osiem', 'dziewięć'), Array( 'dziesięć', 'jedenaście', 'dwanaście', 'trzynaście', 'czternaście', 'piętnaście', 'szesnaście', 'siedemnaście', 'osiemnaście', 'dziewiętnaście'), Array( 'dziesięć', 'dwadzieścia', 'trzydzieści', 'czterdzieści', 'pięćdziesiąt', 'sześćdziesiąt', 'siedemdziesiąt', 'osiemdziesiąt', 'dziewięćdziesiąt'), Array( 'sto', 'dwieście', 'trzysta', 'czterysta', 'pięćset', 'sześćset', 'siedemset', 'osiemset', 'dziewięćset'), Array( 'tysiąc', 'tysiące', 'tysięcy'), Array( 'milion', 'miliony', 'milionów'), Array( 'miliard', 'miliardy', 'miliardów'), Array( 'bilion', 'biliony', 'bilionów'), Array( 'biliard', 'biliardy', 'biliardów'), Array( 'trylion', 'tryliony', 'trylionów'), Array( 'tryliard', 'tryliardy', 'tryliardów'), Array( 'kwadrylion', 'kwadryliony', 'kwadrylionów'), Array( 'kwintylion', 'kwintyliony', 'kwintylionów'), Array( 'sekstylion', 'sekstyliony', 'sekstylionów'), Array( 'septylion', 'septyliony', 'septylionów'), Array( 'oktylion', 'oktyliony', 'oktylionów'), Array( 'nonylion', 'nonyliony', 'nonylionów'), Array( 'decylion', 'decyliony', 'decylionów') );					
		$slownie_do_zaplaty = slownie($brutto_tmp[0],$slowa).' '.odmiana(array('złoty','złote','złotych'),$brutto_tmp[0]).' i '.slownie($brutto_tmp[1],$slowa).' '.odmiana(array('grosz','grosze','groszy'),$brutto_tmp[1]);
		 
		$uwagi_txt = '';				
		
		foreach($uwagi as $k => $v)
		{
			$uwagi_txt .= $k.": ";
			foreach($v as $s )
			{				
					$uwagi_txt .= trim($s).', ';
			}
			$uwagi_txt .= "\n\n";
		}		
		
		$data['nr'] = $nr;
		$data['month'] = $month;
		$data['year'] = $year;
		$data['miejsce_wystawienia'] = $miejsce_wystawienia;
		$data['data_wystawienia'] = $data_wystawienia;
		$data['data_sprzedazy'] = $data_wystawienia;
		$data['sposob_zaplaty'] = $sposob_zaplaty;
		$data['termin_platnosci'] = $termin_platnosci;
		$data['sprzedawca'] = $sprzedawca;
		$data['nabywca'] = $nabywca;
		$data['naliczone_uslugi'] = $naliczone_uslugi;
		$data['naliczone_uslugi_txt'] = $naliczone_uslugi_txt;
		$data['netto'] = $netto;
		$data['brutto'] = $brutto;
		$data['slownie_do_zaplaty'] = $slownie_do_zaplaty;
		$data['os_upowaz_do_wyst_faktury'] = 'Jakub Kurbiel';
		$data['uwagi'] = $uwagi_txt;
		$data['user_id'] = $user_data[0]['user_id'];
		
		if($netto > 0) 
        {
            $this->db->insert('faktury_seo', $data);

            //wyslanie maila z faktura
            @$url = 'http://panel.networds.pl/admin/send_facture_by_mail_seo/'.$data['user_id'].'/'.$this->db->insert_id();
            @file_get_contents($url);
                
        }
		
		return true;
	}
	
	//nalicza wszystkie oplaty za dojcie slowa na pozoycje
	function sprawdz_nalicz_oplaty_za_dojscie()
	{				  			
		$this->config->load('global_settings');	
		$global_settings = $this->config->item('global_settings');		
										 	  			
		//pobierz wszystkie domeny
		$sql = "SELECT * from user_domain";		 			
		$data = $this->db->query($sql);	
		$domains = $data->result_array();	
		
		foreach($domains as $d)
		{
			//pobierz wszystkie slowa kluczowe dla danej domeny dla ktorych nie zostala naliczona oplata za dojscie
			$sql = "SELECT * from user_domain_keyword where domain_id=".$d['id']." and naliczona_oplata_za_dojscie = 0";			
			$data = $this->db->query($sql);	
			$keywords = $data->result_array();
						
			foreach($keywords as $k)
			{										
				//pobierz wszystkie statystyki slow kluczowych ktorcyh pozycja byla mniejsza badz rowna 10
				$sql = "SELECT date, position from user_domain_keywords_stats_".$d['google_region']." where keyword_id=".$k['id']." and position <= 10 order by date asc";			
				$data = $this->db->query($sql);	
				$dni_na_dobrej_pozycji = $data->result_array();								
				
				foreach($dni_na_dobrej_pozycji as $p)
				{
					//sprawdz czy dane slowo byo przez 7 dni na pzoycji jezlei nie to wez koeljny dzien i sprawdz to samo
					$sql = "SELECT * from user_domain_keywords_stats_".$d['google_region']." where keyword_id=".$k['id']." and position <= 10 and (date >= '".$p['date']."' AND date <= ADDDATE('".$p['date']."', 6)) order by date asc";			
					$data = $this->db->query($sql);					 
					$dni = $data->result_array();
															
					if(count($dni)>=$global_settings['faktury_seo']['ilosc_dni_po_ktorych_zostaje_naliczona_opalta_za_dojscie'])
					{											
						$this->baza_payments->update_keyword_dojscie($k['id']);
						$this->baza_payments->insert_keyword_dojscie_keyword_price_per_week($k['id'],$d['google_region'],$k['price'],$dni[6]['date']);						
						break;						
					}													
				}																															
			}
		}		
	}
	
	//zlicza wszstkie nalzenosci za utrzymanie slow kluczowych
	function count_all_keywords_payments_per_month()
	{
		include_once('files/functions.php');

        $current_year_check = (int) date('Y');
        $current_month_check = (int) date('m');
        //$current_day_check = date('d');
        //$current_month_days_check = MonthDays($current_month_check,$current_year_check);
        //$aktualny_miesiac = $current_year_check+$current_month_check;
		
		//$days = MonthDays(month,year);
		/*dane startowe*/
		$years = array();
				
		for($i=2008;$i<=date('Y');$i++)
		{
			$years[]=$i;
		}
		
		$current_year = date('Y');
		$months = array(1,2,3,4,5,6,7,8,9,10,11,12);
		
		//pobierz wszystkie domeny
		$sql = "SELECT * from user_domain";		 			
		$data = $this->db->query($sql);	
		$domains = $data->result_array();	
		
		foreach($domains as $d)
		{
			//pobierz wszystkie slowa kluczowe dla danej domeny oraz ich cene
			$sql = "SELECT * from user_domain_keyword where domain_id=".$d['id']."";			
			$data = $this->db->query($sql);	
			$keywords = $data->result_array();
			
			//dla danego slowa kluczowego sprawdz pozycje w google dla danego tygodnia od roku zdefiniowanego w $year do daty roku aktualnego
			foreach($keywords as $k)
			{
				if($k['naliczona_oplata_za_dojscie'] == 1)
				{					
					//pobranie daty od ktorej nalezy rozpoczac naliczanie pieniedzy za utrzymanie
					$sql = "SELECT ADDDATE(doszlo_na_pozycje, 1) pozycja from keyword_price_per_week where keyword_id=".$k['id']." and doszlo_na_pozycje IS NOT NULL";			
					$data = $this->db->query($sql);	
					$data_rozpoczecia_utrzymania = $data->result_array();
					//print_r($data_rozpoczecia_utrzymania);
										
					foreach($years as $y)
					{
						foreach($months as $m)
						{
							if(($y<$current_year_check) or ($y==$current_year_check and $m<$current_month_check))
                            {
                                //print_r($k);

                                //pobierz liczbe dni danego keywordsa ktorego pozycja w gogle byla nie wieksza niz 10
                                $sql = "SELECT count(*) as days, keyword_id, date from user_domain_keywords_stats_".$d['google_region']." where keyword_id=".$k['id']." and position <= 10 and (date >= '".$y."-".$m."-01' AND date <= '".$y."-".$m."-".MonthDays($m,$y)."') and date >= '".$data_rozpoczecia_utrzymania[0]['pozycja']."' group by keyword_id ";
                                $data = $this->db->query($sql);
                                $kstats = $data->result_array();

                                //print_r($kstats);
														
                                if(!empty($kstats))
                                {
                                    //cena za 1 dzien keywordsa na pozycji od 1-10
                                    $all_price = 0;
                                    $percent = $k['percent']/100;
                                    $price = $k['price'];
                                    $days_in_month = MonthDays($m,$y);
                                    //$num_of_weeks_in_months = $w['weeks_in_months'];
                                    $all_price = ($percent * $price) / $days_in_month;

                                    $data_insert['keyword_id'] = $kstats[0]['keyword_id'];
                                    $data_insert['year'] = substr($kstats[0]['date'],0,4);
                                    $data_insert['month'] = substr($kstats[0]['date'],5,2);
                                    $data_insert['google_region'] = $d['google_region'];
                                    $data_insert['price'] = $all_price;
                                    $data_insert['days'] = $kstats[0]['days'];
                                    $data_insert['doszlo_na_pozycje'] = NULL;

                                    //sprawdzenie czy juz jakims cudem ktos kiedys nie wyliczyl ceny dla tego slowa kluczowego w tym roku i wtym tyg
                                    $sql = "SELECT * from keyword_price_per_week where keyword_id = ".$data_insert['keyword_id']." and year = ".$data_insert['year']." and month = ".$data_insert['month']." and doszlo_na_pozycje IS NULL";
                                    $data_check = $this->db->query($sql);

                                    if($data_check->result_array()==null)
                                    {
                                        $this->db->insert('keyword_price_per_week', $data_insert);
                                    }
                                    else
                                    {
                                        //echo 'juz to masz dodane <br />';
                                    }
                                }
                            }
						}
					}
				}													
			}
		}
	}
	
	//zlicza wszstkie nalzenosci za utrzymanie slow kluczowych za aktualny miesiac i rok
	function count_all_keywords_payments_last_month($month,$year)
	{
		include_once('files/functions.php');				  		
		
		//$days = MonthDays(month,year);
		/*dane startowe*/		
		//$y = date('Y');
		//$m = date('m');
		$y = $year;
		$m = $month;				 	  						
		
		//pobierz wszystkie domeny
		$sql = "SELECT * from user_domain";		 			
		$data = $this->db->query($sql);	
		$domains = $data->result_array();	
		
		foreach($domains as $d)
		{
			//pobierz wszystkie slowa kluczowe dla danej domeny oraz ich cene
			$sql = "SELECT * from user_domain_keyword where domain_id=".$d['id']."";			
			$data = $this->db->query($sql);	
			$keywords = $data->result_array();
			
			//dla danego slowa kluczowego sprawdz pozycje w google dla danego tygodnia od roku zdefiniowanego w $year do daty roku aktualnego
			foreach($keywords as $k)
			{
				if($k['naliczona_oplata_za_dojscie'] == 1)
				{					
					//pobranie daty od ktorej nalezy rozpoczac naliczanie pieniedzy za utrzymanie
					$sql = "SELECT ADDDATE(doszlo_na_pozycje, 1) pozycja from keyword_price_per_week where keyword_id=".$k['id']." and doszlo_na_pozycje IS NOT NULL";			
					$data = $this->db->query($sql);	
					$data_rozpoczecia_utrzymania = $data->result_array();												
																												
					//pobierz liczbe dni danego keywordsa ktorego pozycja w gogle byla nie wieksza niz 10
					$sql = "SELECT count(*) as days, keyword_id, date from user_domain_keywords_stats_".$d['google_region']." where keyword_id=".$k['id']." and position <= 10 and (date >= '".$y."-".$m."-01' AND date <= '".$y."-".$m."-".MonthDays($m,$y)."') and date >= '".$data_rozpoczecia_utrzymania[0]['pozycja']."' group by keyword_id ";			
					$data = $this->db->query($sql);	
					$kstats = $data->result_array();
					
					//print_r($kstats);
												
					if(!empty($kstats))
					{							
						//cena za 1 dzien keywordsa na pozycji od 1-10
						$all_price = 0;							
						$percent = $k['percent']/100;							
						$price = $k['price'];
						$days_in_month = MonthDays($m,$y);							
						//$num_of_weeks_in_months = $w['weeks_in_months'];							
						$all_price = ($percent * $price) / $days_in_month;
						
						$data_insert['keyword_id'] = $kstats[0]['keyword_id'];														
						$data_insert['year'] = substr($kstats[0]['date'],0,4);
						$data_insert['month'] = substr($kstats[0]['date'],5,2);																					
						$data_insert['google_region'] = $d['google_region'];
						$data_insert['price'] = $all_price;								
						$data_insert['days'] = $kstats[0]['days'];
						$data_insert['doszlo_na_pozycje'] = NULL;
						
						//sprawdzenie czy juz jakims cudem ktos kiedys nie wyliczyl ceny dla tego slowa kluczowego w tym roku i wtym tyg  
						$sql = "SELECT * from keyword_price_per_week where keyword_id = ".$data_insert['keyword_id']." and year = ".$data_insert['year']." and month = ".$data_insert['month']." and doszlo_na_pozycje IS NULL";			
						$data_check = $this->db->query($sql);	
						
						if($data_check->result_array()==null)
						{					        
				        	$this->db->insert('keyword_price_per_week', $data_insert);
						}
						else
						{
							//echo 'juz to masz dodane <br />';
						}																					
					}												
				}													
			}
		}
	}
	
	function get_affiliant_rozliczenia($id)
	{
		$sql = "SELECT id,year,month,termin_platnosci,zaplacono,zatwierdzono,typ,typ_dostarczenia,data_wystawienia,nr,numer_wlasny FROM afilianci_rozliczenia WHERE afiliant_id ='".$id."' order by data_wystawienia desc, id desc";
		$data = $this->db->query($sql);	
		return $data->result_array();
	}
	
	//--------------- funkcje do ksiegowosci -----------------------------\\
	
	function user_get_data($id)
	{
		$sql = "SELECT * FROM user, user_data WHERE user.id='".$id."' and user.id = user_data.user_id";			
		$data = $this->db->query($sql);	
		return $data->result_array();
	}
	
	function get_afiliants()
	{
		$sql = "SELECT * FROM afilianci";			
		$data = $this->db->query($sql);	
		return $data->result_array();
	}
	
	function afiliant_get_data($id)
	{
		$sql = "SELECT * FROM afilianci where id='".$id."'";			
		$data = $this->db->query($sql);	
		return $data->result_array();
	}
	
	function afiliant_get_factures($afiliant_id)
	{
		$sql = "SELECT id,year,month,termin_platnosci,zaplacono,zatwierdzono,typ,typ_dostarczenia,data_wystawienia,nr,numer_wlasny,netto FROM afilianci_rozliczenia where afiliant_id='".$afiliant_id."' order by data_wystawienia desc, id desc";
		$data = $this->db->query($sql);	
		return $data->result_array();
	}
	
	function potwierdz_dok_firmowe_afilianta($id)
	{
		$sql = "SELECT * FROM afilianci where id='".$id."'";			
		$data = $this->db->query($sql);	
		$af = $data->result_array();
        unset($data);

        if($af[0]['dokumenty_firma']==0)
            $data['dokumenty_firma'] = 1;
        else
            $data['dokumenty_firma'] = 0;

        $data['dokumenty_osoba_prywatna'] = 0;
        $this->db->WHERE('id', $id);
        return $this->db->update('afilianci', $data);
	}
	
	function potwierdz_dok_rachunek_afilianta($id)
	{
		$sql = "SELECT * FROM afilianci where id='".$id."'";			
		$data = $this->db->query($sql);	
		$af = $data->result_array();
        unset($data);
        
        if($af[0]['dokumenty_osoba_prywatna']==0)
            $data['dokumenty_osoba_prywatna'] = 1;
        else
            $data['dokumenty_osoba_prywatna'] = 0;
                
        $data['dokumenty_firma'] = 0;
        $this->db->WHERE('id', $id);
        return $this->db->update('afilianci', $data);
	}
	
	function potwierdz_wyplate_afilianta($id,$post)
	{
		$data['zaplacono'] = 1;
		$data['zatwierdzono'] = 1;
		
		if(!empty($post['data'])) 
			$data['data_sprzedazy'] = trim($post['data']);
		
        $this->db->WHERE('id', $id);
        return $this->db->update('afilianci_rozliczenia', $data);
	}
	
	function potwierdz_fakture_seo($id)
	{
		$data['zaplacono'] = 1;
		$data['zatwierdzono'] = 1;
        $this->db->WHERE('id', $id);
        return $this->db->update('faktury_seo', $data);	
	}
	
	//	potwierdzenie sem proforma i wystawienie sem faktury na podstawie danej proformy
	function potwierdz_fakture_proforma_sem($pf_id,$data_faktury)
	{
		$data['zaplacono'] = 1;
		$data['zatwierdzono'] = 1;
        $this->db->WHERE('id', $pf_id);
        $this->db->update('faktury_sem_proforma', $data);
        unset($data);
        
        $sql = 'select * from faktury_sem_proforma where id = "'.$pf_id.'"';
        $data = $this->db->query($sql);	
		$proforma = $data->result_array();
		
		//sprawdzenie czy nie ma juz fv dla danej proformy, jezeli jest to nie dodawaj drugi raz
		$sql = "SELECT * from faktury_sem where faktury_sem_proforma_id='".$pf_id."'";			
		$data = $this->db->query($sql);	
		$istnieje =  $data->result_array();	
		
		if(!empty($istnieje)) return false;
		unset($istnieje);
		unset($data);
				
		//dodanie faktury vat za sem platne przelewem
								
		$year = substr($data_faktury,0,4);
		$month = substr($data_faktury,5,2);
		$day = substr($data_faktury,8,2);
		
		/*echo '-----<br />';
		echo $day.'<br />';
		echo $month.'<br />';
		echo $year.'<br />';
		echo '-----';*/  
		
		/*numer faktury*/
		$nr = 1;
		$sql = "SELECT nr from faktury_sem where month = '".$month."' and year = '".$year."' order by nr desc limit 1";			
		$data = $this->db->query($sql);	
		$nr_tmp =  $data->result_array();	
		//print_r($nr_tmp);
		unset($data);
		if(!empty($nr_tmp))
		{
			$nr = ($nr_tmp[0]['nr'] + 1);
		}
		/*koniec wyliczania numeru faktury*/
					
		$data['nr'] = $nr;
		$data['month'] = $month;
		$data['year'] = $year;
		$data['miejsce_wystawienia'] = $proforma[0]['miejsce_wystawienia'];
		$data['data_wystawienia'] = $data_faktury;
		$data['data_sprzedazy'] = $data_faktury;
		$data['sposob_zaplaty'] = $proforma[0]['sposob_zaplaty'];
		$data['termin_platnosci'] = $data_faktury;
		$data['sprzedawca'] = $proforma[0]['sprzedawca'];
		$data['nabywca'] = $proforma[0]['nabywca'];
		$data['naliczone_uslugi'] = $proforma[0]['naliczone_uslugi'];
		$data['naliczone_uslugi_txt'] = $proforma[0]['naliczone_uslugi_txt'];
		$data['netto'] = $proforma[0]['netto'];
		$data['brutto'] = $proforma[0]['brutto'];
		$data['slownie_do_zaplaty'] = $proforma[0]['slownie_do_zaplaty'];
		$data['os_upowaz_do_wyst_faktury'] = $proforma[0]['os_upowaz_do_wyst_faktury'];
		$data['uwagi'] = $proforma[0]['uwagi'];
		$data['user_id'] = $proforma[0]['user_id'];
		$data['zaplacono'] = 1;
		$data['zatwierdzono'] = 1;
		$data['faktury_sem_proforma_id'] = $proforma[0]['id'];		
				
		$this->db->insert('faktury_sem', $data);

         //wyslanie maila z faktura
         @$url = 'http://panel.networds.pl/admin/send_facture_by_mail_sem/'.$data['user_id'].'/'.$this->db->insert_id();
         @file_get_contents($url);
	    
	}

    function get_all_seo_factures_period($month,$year)
    {
        $sql = "SELECT faktury_seo.id faktura_id,company_name,email,dk_telefon,contact_name,nr,month,year,netto from faktury_seo,user_data where month='".$month."' and year='".$year."' and user_data.user_id=faktury_seo.user_id order by data_wystawienia desc,nr desc";
		$data = $this->db->query($sql);
		return $data->result_array();
    }

    function  get_all_sem_factures_period($month,$year)
    {
        $sql = "SELECT faktury_sem.id faktura_id,company_name,email,dk_telefon,contact_name,nr,month,year,netto from faktury_sem,user_data where month='".$month."' and year='".$year."' and user_data.user_id=faktury_sem.user_id order by data_wystawienia desc,nr desc";
		$data = $this->db->query($sql);
		return $data->result_array();
    }

    function  get_all_afiliant_factures_period($month,$year)
    {
        $sql = "SELECT afilianci_rozliczenia.id faktura_id,afilianci_rozliczenia.typ,nazwa,email,telefon,imie,nazwisko,numer_wlasny,nr,month,year,afiliant_id,typ_dostarczenia,netto from afilianci_rozliczenia,afilianci where month='".$month."' and year='".$year."' and afilianci.id=afilianci_rozliczenia.afiliant_id order by data_wystawienia desc,nr desc";
		$data = $this->db->query($sql);
		return $data->result_array();
    }

    function get_all_seo_factures2()
	{
		$sql = "SELECT month,year,netto from faktury_seo order by data_wystawienia desc,nr desc";
		$data = $this->db->query($sql);
		return $data->result_array();
	}
	
    function get_all_sem_factures2()
	{
		$sql = "SELECT month,year from faktury_sem order by data_wystawienia desc,nr desc";
		$data = $this->db->query($sql);
		return $data->result_array();
	}

    function get_all_afiliant_factures2()
	{
		$sql = "SELECT month,year from afilianci_rozliczenia order by data_wystawienia desc";
		$data = $this->db->query($sql);
		return $data->result_array();
	}

	function get_all_seo_factures()
	{
		$sql = "SELECT faktury_seo.id faktura_id, data_wystawienia, termin_platnosci, company_name, contact_name, user_data.user_id, (TO_DAYS(CURDATE())-TO_DAYS(data_wystawienia)) ile_uplynelo_dni,nr,month,year,netto from faktury_seo,user_data where faktury_seo.user_id=user_data.user_id and zaplacono=0 and zatwierdzono=0 order by data_wystawienia desc,nr desc";
		$data = $this->db->query($sql);	
		return $data->result_array();	
	}
	
	function get_all_factures_sem_proforma()
	{
		$sql = "SELECT faktury_sem_proforma.id faktura_id, data_wystawienia, termin_platnosci, company_name, contact_name, user_data.user_id, (TO_DAYS(CURDATE())-TO_DAYS(data_wystawienia)) ile_uplynelo_dni,nr,month,year,netto from faktury_sem_proforma,user_data where faktury_sem_proforma.user_id=user_data.user_id and zaplacono=0 and zatwierdzono=0 order by data_wystawienia desc,nr desc";
		$data = $this->db->query($sql);	
		return $data->result_array();	
	}

    function get_all_factures_afiliant()
	{		
        $sql = "SELECT afilianci_rozliczenia.typ_dostarczenia,afilianci_rozliczenia.typ,afilianci_rozliczenia.id faktura_id, data_wystawienia, termin_platnosci, nazwa, imie,nazwisko, afilianci.id, (TO_DAYS(CURDATE())-TO_DAYS(data_wystawienia)) ile_uplynelo_dni,nr,numer_wlasny,month,year,netto from afilianci_rozliczenia,afilianci where afilianci_rozliczenia.afiliant_id=afilianci.id and zaplacono=0 and zatwierdzono=0 order by data_wystawienia desc,id desc";
		$data = $this->db->query($sql);
		return $data->result_array();
	}
}

?>