<?php

class Payments extends Controller {
	
	function Payments()
	{
		parent::Controller();
		$this->load->library('session');	
		$this->load->helper(array('form', 'url','html'));
		$this->load->model('baza_payments','',TRUE);
		$this->load->model('baza','',TRUE);
	}
			
	function index()
	{
		redirect('', 'location');		
	}
	
	function doladuj_linki_sponosrowane_przelewem()
	{
		if(isset($this->session->userdata['user_zalogowany']) and isset($this->session->userdata['di']))
		{	
			$user_login_data = $this->baza->get_user_login($this->session->userdata['user_zalogowany'], $this->session->userdata['di']);
			$user_data = $this->baza->get_user_data($this->session->userdata['di']);
			
			if($user_login_data!=null and $user_data!=null)	
			{				
				if(!empty($_POST['amount']) and !empty($_POST['desc']) and !empty($_POST['desc2']))
				{
					$this->baza_payments->wystaw_fakture_sem_proforma($_POST);
					redirect('/admin/faktury#tabs-3','location');
				}
				else
				{
					redirect('/admin/','location');
				}
			
			}
			else
			{
				redirect('/admin/logout','location');	
			}
		}
		else
		{
			redirect('/admin/','location');		
		}		
	}
	
	//wylicza wszystkie opłaty miesieczne, jest wywolywana w funkcji faktura_all()
	function count_all_keywords_payments_per_month()
	{
		//sprawdza i nalicza oplaty za dojscie
		$this->baza_payments->sprawdz_nalicz_oplaty_za_dojscie();		
		
		//sprawdza i nalicza oplaty za utrzymania slow kluczowych
		$this->baza_payments->count_all_keywords_payments_per_month();
		//echo 'zliczono wszystkie okresy oplat za keywordsy';	
	}
	
	//wylicza wszystkie opłaty miesieczne, jest wywolywana w funkcji faktura()
	function count_all_keywords_payments_last_month($month,$year)
	{	
		//sprawdza i nalicza oplaty za dojscie
		$this->baza_payments->sprawdz_nalicz_oplaty_za_dojscie();		

		//sprawdza i nalicza oplaty za utrzymania slow kluczowych
		$this->baza_payments->count_all_keywords_payments_last_month($month,$year);
		//echo '<br />zliczono aktualny miesiac oplat za keywordsy';	
	}
	
	//funkcja wystawiajaca fakture za miesiac poprzedzajacy aktualny miesiac
	//jezeli okres rozliczeniowy miesiaca poprzedzajacego aktualny miesiac nie dobiegl konca faktura nie zostanie wystawiona		
	function faktura()
	{ 	
		include_once('files/functions.php');
		include_once('files/slownie.php');
		//$data_wystawienia_tmp = strftime("20%y-%m-%d",mktime(0, 0, 0, $month+1, 1, $year));
		
		$m = date('m');
		$y = date('Y');
		$today = date('Ymd');		
		
		$wyliczony_dzien = MonthDays($m,$y);
							
		if($m<=9)
			$faktura_za_miesiac = $y.'0'.$m.$wyliczony_dzien;
		else	
			$faktura_za_miesiac = $y.$m.$wyliczony_dzien;													
		
		//sprawdzenie czy nie zawczesnie na wystawienie faktury		
		if($faktura_za_miesiac == $today)
		{
			//wyliczenie platnosci dla danego keywordsa za miesaic
			$this->count_all_keywords_payments_last_month($m,$y);			
	
			//pobranie id wszystkich uzytkownikow
			$users = $this->baza->get_all_users();
			$user_id = null;		
			//print_r($users);
					
			if(!empty($users))
			{
				//pobranie danych sprzedawcy na fakture pdf
				$networds = $this->baza_payments->get_networds_data();
				
				//pobranie liczby dni na oplacenie faktury
				$this->config->load('global_settings');	
				$global_settings = $this->config->item('global_settings');	
				$dni_na_platnosc = $global_settings['faktury_seo']['ilosc_dni_na_zaplacenie_faktury'];
				
				foreach($users as $u)
				{
					$platne_keywords = array();									
					$user_id = $u['id'];
					$user_data	= $this->baza->get_user_data($user_id);
					//$user_domins = $this->baza->get_domains($user_id);
					$domains_and_keywords = $this->baza_payments->get_domains_and_keywords($user_id);
					
					foreach($domains_and_keywords as $dk)
					{																																			
						$platne_keywords[$dk['domain_id']][] = $dk['id'];																				
					}				
																																						
					//sprawdzenie czy juz nie zostala wystawiona faktura za ten rok i miesiac			
					$facture_data = $this->baza_payments->get_user_facture($user_id,$m,$y);
					
					if(empty($facture_data) and !empty($platne_keywords))
					{
						//wystawienie faktury
						$this->baza_payments->add_facture($m,$y,$platne_keywords,$user_data,$user_id,$networds,$dni_na_platnosc);
					}					
				}
			}
			else
			{
				//echo 'brak klientow w systemie';			
			}
			//echo 'wszystkie fakltury seo do dzis zostaly wystawione';
		}
		else
		{
			//echo 'za wczesnie na wystawienie faktury za ten miesiac';
		}						
	}	
	
	//funkcja wystawia wszystkie nie istniejace faktury seo od 2008 roku az do dzis
	function faktura_all()
	{ 
		include_once('files/functions.php');
		include_once('files/slownie.php');
		$this->count_all_keywords_payments_per_month();
		
		$today = date('Ymd');
		$years = array();
				
		for($i=2008;$i<=date('Y');$i++)
		{
			$years[]=$i;
		}
				
		$months = array(1,2,3,4,5,6,7,8,9,10,11,12);

		//pobranie id wszystkich uzytkownikow
		$users = $this->baza->get_all_users();
		$user_id = null;		
		//print_r($users);
				
		if(!empty($users))
		{
			//pobranie danych sprzedawcy na fakture pdf
			$networds = $this->baza_payments->get_networds_data();
			
			//pobranie liczby dni na oplacenie faktury
			$this->config->load('global_settings');	
			$global_settings = $this->config->item('global_settings');	
			$dni_na_platnosc = $global_settings['faktury_seo']['ilosc_dni_na_zaplacenie_faktury'];
			
			foreach($users as $u)
			{
				$platne_keywords = array();									
				$user_id = $u['id'];
				$user_data	= $this->baza->get_user_data($user_id);
				//$user_domins = $this->baza->get_domains($user_id);
				$domains_and_keywords = $this->baza_payments->get_domains_and_keywords($user_id);
				
				foreach($domains_and_keywords as $dk)
				{																																			
					$platne_keywords[$dk['domain_id']][] = $dk['id'];																				
				}				
								
				foreach($years as $y)
				{
					foreach($months as $m)
					{												
						$wyliczony_dzien = MonthDays($m,$y);
						
						if($m<=9)
							$faktura_za_miesiac = $y.'0'.$m.$wyliczony_dzien;
						else	
							$faktura_za_miesiac = $y.$m.$wyliczony_dzien;													
						
						//sprawdzenie czy nie zawczesnie na wystawienie faktury
						if($faktura_za_miesiac <= $today)
						{							
							//sprawdzenie czy juz nie zostala wystawiona faktura za ten rok i miesiac			
							$facture_data = $this->baza_payments->get_user_facture($user_id,$m,$y);
							
							if(empty($facture_data) and !empty($platne_keywords))
							{
								//wystawienie faktury
								$this->baza_payments->add_facture($m,$y,$platne_keywords,$user_data,$user_id,$networds,$dni_na_platnosc);
							}
						}
					}
				}
			}
		}
		else
		{
			echo 'brak klientow w systemie';			
		}
		
		echo 'wszystkie fakltury seo do dzis zostaly wystawione';
	}	
	
	//pdf dla klientow
	function faktura_pdf($month=null,$year=null)
	{ 
		if(isset($this->session->userdata['user_zalogowany']) and isset($this->session->userdata['di']))
		{	
			$user_data = $this->baza->get_user_login($this->session->userdata['user_zalogowany'], $this->session->userdata['di']);
			$dane = $this->baza_payments->get_facture($this->session->userdata['di'],$month,$year);			
			
			if($user_data!=null and $dane!=null)	
			{									
				require_once('files/faktura_template.php');
				require_once('files/functions.php');				
				$faktura = $dane[0];
				
				$pdf=new PDF();		
				$pdf->SetUTF8(true); 
				$pdf->AliasNbPages();
				$pdf->AddPage();
				$pdf->SetDisplayMode('real'); 
				$pdf->AddFont('Trebuchet','','trebucpl.php');
				$pdf->SetFont('Trebuchet','',12);
				   
				//informacje o numerze faktury
				$faktura_info = "Faktura VAT\nnr: FV ".$faktura['nr']."/SEO/".$faktura['month']."/".$faktura['year']."\nOryginał";
				$pdf->MultiCell(90,7,$faktura_info,1,'L');
				
				//nazwy informacji o datach i sposobie przelewu
				$pdf->SetFont('Trebuchet','',10);
				$pdf->SetXY(115, 20);
				$payment_info = "Miejsce wystawienia:\nData wystawienia:\nData sprzedaży:\nSposób zapłaty:\nTermin płatności:";
				$pdf->MultiCell(37,5,$payment_info,0,'L');
		 
				//informacje o datach i sposobie przelewu
				$pdf->SetFont('Trebuchet','',10);
				$pdf->SetXY(152, 20);
				$payment_info_data = "".$faktura['miejsce_wystawienia']."\n".$faktura['data_wystawienia']."\n".$faktura['data_sprzedazy']."\n".$faktura['sposob_zaplaty']."\n".$faktura['termin_platnosci']."";
				$pdf->MultiCell(35,5,$payment_info_data,0,'L');		
				$pdf->Ln(5);
				   
				//informacje o sprzedawcy    
				$pdf->SetFont('Trebuchet','',14);
				$pdf->Cell(0,5,'Sprzedawca:',0,1);
				$pdf->SetFont('Trebuchet','',10);
				$seller_info = $faktura['sprzedawca'];
				$pdf->MultiCell(90,5,$seller_info,0,'L');
				
		        //informacje o nabywcy  
		        $pdf->SetXY(115, 50); 
				$pdf->SetFont('Trebuchet','',14);
				$pdf->Cell(0,5,'Nabywca:',0,1);
				$pdf->SetXY(115, 55);
				$pdf->SetFont('Trebuchet','',10);
		        $buyer_info = $faktura['nabywca'];
				$pdf->MultiCell(85,5,$buyer_info,0,'L');
				
				$pdf->Ln(20);
				
				//tabela z naliczonymi platnosciami
				$table_header = array("Lp.","Nazwa usługi","J.m","Ilość","Cena jedn.","Wartość netto","Stawka VAT","Kwota VAT","Wartość brutto");
				//$line = "1;Opłata za pozycjonowanie;szt;1;1000,00;1000,00;22%;220,00;1220,00";
				//$dane_platnosci_faktury[]=explode(';',chop($line));

				$naliczone_uslugi = unserialize($faktura['naliczone_uslugi']);
								
				//tabela z 9 kolumnami 
				$pdf->SetWidths(array(8,58,8,10,20,25,14,20,26));
				//ustawia pozycje tekstu w kazdej kolumnie
				$pdf->SetAligns(array('C','L','C','C','R','R','C','R','R'));
				//header tabeli
				$pdf->Row($table_header);								
				
				foreach($naliczone_uslugi as $u)
				{
					$pdf->Row(array($u[0],$u[1],$u[2],$u[3],$u[4],$u[5],$u[6],$u[7],$u[8]));
				}
												
				//dopelnienie groszy jezeli po przecinku jest 1 miejsce zamiast 2
				$brutto_tmp  =  d_gr($faktura['brutto']);
				
				//do zaplaty
				$pdf->Ln(10); 
				$pdf->SetFont('Trebuchet','',14);				
				$pdf->Cell(0,5,'Do zapłaty: '.$brutto_tmp[0].'.'.$brutto_tmp[1].' zł',0,1);
				$pdf->Ln(1);
				$pdf->SetFont('Trebuchet','',12);
				$pdf->Cell(0,5,'Słownie: '.$faktura['slownie_do_zaplaty'],0,1);
				$pdf->Ln(30); 
				
				//miejsce na podpisy
				$pdf->SetX(125);
				$pdf->SetFont('Trebuchet','',12);
				$pdf->Cell(72,7,$faktura['os_upowaz_do_wyst_faktury'],0,0,'C');
				$pdf->Ln(7); 
				$pdf->SetFont('Trebuchet','',10);
				$pdf->Cell(72,7,'Osoba upoważniona do odbioru faktury.','T',0);
				$pdf->SetX(127);
				$pdf->Cell(72,7,'Osoba upoważniona do wystawienia faktury.','T',0);
		
				//nowa strona
				//$pdf->AddPage();
				//uwagi
				$pdf->Ln(30);				
				$pdf->SetFont('Trebuchet','',14);
				$pdf->Cell(0,5,'Uwagi:',0,1);
				$pdf->Ln(10);
				$pdf->SetFont('Trebuchet','',12);
				$pdf->MultiCell(0,5,$faktura['uwagi'],0,'L');
				 
			
				$pdf->Output();
				
				}
			else
			{
				//redirect('/admin/logout','location');
				//return false;
				echo 'Brak oplat za ten miesiac';	
			}		
		}
		else
		{
			//redirect('/admin/','location');
			//return false;
			echo 'Brak autoryzacji';		
		}	
	}

	//pdf dla klientow	
	function faktura_pdf_sem($nr=null, $month=null,$year=null, $type=null)
	{ 
		if(!empty($nr) and !empty($month) and !empty($year) and !empty($type))
		{		
			if(isset($this->session->userdata['user_zalogowany']) and isset($this->session->userdata['di']))
			{	
				$user_data = $this->baza->get_user_login($this->session->userdata['user_zalogowany'], $this->session->userdata['di']);
				$faktura_typ = null;
				$faktura_typ_skrot = null;
				
				if($type=='pf')
				{
					$dane = $this->baza_payments->get_facture_sem_proforam_to_pdf($nr,$this->session->userdata['di'],$month,$year);
					$faktura_typ = 'Proforma';
					$faktura_typ_skrot = 'FP';
				}
				elseif($type=='fv')
				{
					$dane = $this->baza_payments->get_facture_sem_fv_to_pdf($nr,$this->session->userdata['di'],$month,$year);
					$faktura_typ = 'VAT';
					$faktura_typ_skrot = 'FV';
				}
				else
				{
					echo 'Nieprawidłowy parametr';
					exit;
				}

				//print_r($dane);
				//$dane=null;
				
				if($user_data!=null and $dane!=null)	
				{									
					require_once('files/faktura_template.php');
					require_once('files/functions.php');				
					$faktura = $dane[0];
					
					$pdf=new PDF();		
					$pdf->SetUTF8(true); 
					$pdf->AliasNbPages();
					$pdf->AddPage();
					$pdf->SetDisplayMode('real'); 
					$pdf->AddFont('Trebuchet','','trebucpl.php');
					$pdf->SetFont('Trebuchet','',12);
					   
					//informacje o numerze faktury
					$faktura_info = "Faktura ".$faktura_typ."\nnr: ".$faktura_typ_skrot." ".$faktura['nr']."/SEM/".$faktura['month']."/".$faktura['year']."\nOryginał";
					$pdf->MultiCell(90,7,$faktura_info,1,'L');
					
					//nazwy informacji o datach i sposobie przelewu
					$pdf->SetFont('Trebuchet','',10);
					$pdf->SetXY(115, 20);
					$payment_info = "Miejsce wystawienia:\nData wystawienia:\nData sprzedaży:\nSposób zapłaty:\nTermin płatności:";
					$pdf->MultiCell(37,5,$payment_info,0,'L');
			 
					//informacje o datach i sposobie przelewu
					$pdf->SetFont('Trebuchet','',10);
					$pdf->SetXY(152, 20);
					$payment_info_data = "".$faktura['miejsce_wystawienia']."\n".$faktura['data_wystawienia']."\n".$faktura['data_sprzedazy']."\n".$faktura['sposob_zaplaty']."\n".$faktura['termin_platnosci']."";
					$pdf->MultiCell(35,5,$payment_info_data,0,'L');		
					$pdf->Ln(5);
					   
					//informacje o sprzedawcy    
					$pdf->SetFont('Trebuchet','',14);
					$pdf->Cell(0,5,'Sprzedawca:',0,1);
					$pdf->SetFont('Trebuchet','',10);
					$seller_info = $faktura['sprzedawca'];
					$pdf->MultiCell(90,5,$seller_info,0,'L');
					
			        //informacje o nabywcy  
			        $pdf->SetXY(115, 50); 
					$pdf->SetFont('Trebuchet','',14);
					$pdf->Cell(0,5,'Nabywca:',0,1);
					$pdf->SetXY(115, 55);
					$pdf->SetFont('Trebuchet','',10);
			        $buyer_info = $faktura['nabywca'];
					$pdf->MultiCell(85,5,$buyer_info,0,'L');
					
					$pdf->Ln(20);
					
					//tabela z naliczonymi platnosciami
					$table_header = array("Lp.","Nazwa usługi","J.m","Ilość","Cena jedn.","Wartość netto","Stawka VAT","Kwota VAT","Wartość brutto");
					//$line = "1;Opłata za pozycjonowanie;szt;1;1000,00;1000,00;22%;220,00;1220,00";
					//$dane_platnosci_faktury[]=explode(';',chop($line));
	
					$naliczone_uslugi = unserialize($faktura['naliczone_uslugi']);
									
					//tabela z 9 kolumnami 
					$pdf->SetWidths(array(8,58,8,10,20,25,14,20,26));
					//ustawia pozycje tekstu w kazdej kolumnie
					$pdf->SetAligns(array('C','L','C','C','R','R','C','R','R'));
					//header tabeli
					$pdf->Row($table_header);								
					
					foreach($naliczone_uslugi as $u)
					{
						$pdf->Row(array($u[0],$u[1],$u[2],$u[3],$u[4],$u[5],$u[6],$u[7],$u[8]));
					}
													
					//dopelnienie groszy jezeli po przecinku jest 1 miejsce zamiast 2
					$brutto_tmp  =  d_gr($faktura['brutto']);
					
					//do zaplaty
					$pdf->Ln(10); 
					$pdf->SetFont('Trebuchet','',14);				
					$pdf->Cell(0,5,'Do zapłaty: '.$brutto_tmp[0].'.'.$brutto_tmp[1].' zł',0,1);
					$pdf->Ln(1);
					$pdf->SetFont('Trebuchet','',12);
					$pdf->Cell(0,5,'Słownie: '.$faktura['slownie_do_zaplaty'],0,1);
					$pdf->Ln(30); 
					
					//miejsce na podpisy
					$pdf->SetX(125);
					$pdf->SetFont('Trebuchet','',12);
					$pdf->Cell(72,7,$faktura['os_upowaz_do_wyst_faktury'],0,0,'C');
					$pdf->Ln(7); 
					$pdf->SetFont('Trebuchet','',10);
					$pdf->Cell(72,7,'Osoba upoważniona do odbioru faktury.','T',0);
					$pdf->SetX(127);
					$pdf->Cell(72,7,'Osoba upoważniona do wystawienia faktury.','T',0);
			
					//nowa strona
					//$pdf->AddPage();
					//uwagi
					$pdf->Ln(30);				
					$pdf->SetFont('Trebuchet','',14);
					$pdf->Cell(0,5,'Uwagi:',0,1);
					$pdf->Ln(10);
					$pdf->SetFont('Trebuchet','',12);
					$pdf->MultiCell(0,5,$faktura['uwagi'],0,'L');
					 
				
					$pdf->Output();
					
					}
				else
				{
					//redirect('/admin/logout','location');
					//return false;
					echo 'Brak oplat za ten miesiac';	
				}		
			}
			else
			{
				//redirect('/admin/','location');
				//return false;
				echo 'Brak autoryzacji';		
			}
		}	
	}
	function show_contract($contract_id=null,$key=null)
    {
		//$key  - zmienna zabezpieczajaca dla programu w c#
		$key_org = 'a76i43x2';

		$contract = $this->baza->get_user_contract($contract_id);
		if(($key == $key_org) && $contract)
		{
			$file_handle 	= fopen($contract['sciezka'],"r");
			$file_name      = basename($contract['sciezka']);

			header('Content-Type: application/pdf');
			header('Content-Disposition: inline; filename="'.$file_name.'"');
			//header('Cache-Control: private, max-age=0, must-revalidate');
			echo file_get_contents($contract['sciezka']);
		}
		else
			echo 'Brak autoryzacji';
    }
	//pdf dla ksiegowej i c#
	function faktura_ksiegowosc_seo_pdf($id=null,$key=null)
	{ 
		//$key  - zmienna zabezpieczajaca dla programu w c#
		$key_org = 'a76i43x2';
		
		if((isset($this->session->userdata['user_ksiegowosc_zalogowany']) and isset($this->session->userdata['ksiegowosc_id'])) or $key==$key_org)
		{				
			$dane = $this->baza_payments->get_facture_seo($id);			
			
			if($dane!=null)	
			{									
				require_once('files/faktura_template.php');
				require_once('files/functions.php');				
				$faktura = $dane[0];
				
				$pdf=new PDF();		
				$pdf->SetUTF8(true); 
				$pdf->AliasNbPages();
				$pdf->AddPage();
				$pdf->SetDisplayMode('real'); 
				$pdf->AddFont('Trebuchet','','trebucpl.php');
				$pdf->SetFont('Trebuchet','',12);
				   
				//informacje o numerze faktury
				$faktura_info = "Faktura VAT\nnr: FV ".$faktura['nr']."/SEO/".$faktura['month']."/".$faktura['year']."\nKopia";
				$pdf->MultiCell(90,7,$faktura_info,1,'L');
				
				//nazwy informacji o datach i sposobie przelewu
				$pdf->SetFont('Trebuchet','',10);
				$pdf->SetXY(115, 20);
				$payment_info = "Miejsce wystawienia:\nData wystawienia:\nData sprzedaży:\nSposób zapłaty:\nTermin płatności:";
				$pdf->MultiCell(37,5,$payment_info,0,'L');
		 
				//informacje o datach i sposobie przelewu
				$pdf->SetFont('Trebuchet','',10);
				$pdf->SetXY(152, 20);
				$payment_info_data = "".$faktura['miejsce_wystawienia']."\n".$faktura['data_wystawienia']."\n".$faktura['data_sprzedazy']."\n".$faktura['sposob_zaplaty']."\n".$faktura['termin_platnosci']."";
				$pdf->MultiCell(35,5,$payment_info_data,0,'L');		
				$pdf->Ln(5);
				   
				//informacje o sprzedawcy    
				$pdf->SetFont('Trebuchet','',14);
				$pdf->Cell(0,5,'Sprzedawca:',0,1);
				$pdf->SetFont('Trebuchet','',10);
				$seller_info = $faktura['sprzedawca'];
				$pdf->MultiCell(90,5,$seller_info,0,'L');
				
		        //informacje o nabywcy  
		        $pdf->SetXY(115, 50); 
				$pdf->SetFont('Trebuchet','',14);
				$pdf->Cell(0,5,'Nabywca:',0,1);
				$pdf->SetXY(115, 55);
				$pdf->SetFont('Trebuchet','',10);
		        $buyer_info = $faktura['nabywca'];
				$pdf->MultiCell(85,5,$buyer_info,0,'L');
				
				$pdf->Ln(20);
				
				//tabela z naliczonymi platnosciami
				$table_header = array("Lp.","Nazwa usługi","J.m","Ilość","Cena jedn.","Wartość netto","Stawka VAT","Kwota VAT","Wartość brutto");
				//$line = "1;Opłata za pozycjonowanie;szt;1;1000,00;1000,00;22%;220,00;1220,00";
				//$dane_platnosci_faktury[]=explode(';',chop($line));

				$naliczone_uslugi = unserialize($faktura['naliczone_uslugi']);
								
				//tabela z 9 kolumnami 
				$pdf->SetWidths(array(8,58,8,10,20,25,14,20,26));
				//ustawia pozycje tekstu w kazdej kolumnie
				$pdf->SetAligns(array('C','L','C','C','R','R','C','R','R'));
				//header tabeli
				$pdf->Row($table_header);								
				
				foreach($naliczone_uslugi as $u)
				{
					$pdf->Row(array($u[0],$u[1],$u[2],$u[3],$u[4],$u[5],$u[6],$u[7],$u[8]));
				}
												
				//dopelnienie groszy jezeli po przecinku jest 1 miejsce zamiast 2
				$brutto_tmp  =  d_gr($faktura['brutto']);
				
				//do zaplaty
				$pdf->Ln(10); 
				$pdf->SetFont('Trebuchet','',14);				
				$pdf->Cell(0,5,'Do zapłaty: '.$brutto_tmp[0].'.'.$brutto_tmp[1].' zł',0,1);
				$pdf->Ln(1);
				$pdf->SetFont('Trebuchet','',12);
				$pdf->Cell(0,5,'Słownie: '.$faktura['slownie_do_zaplaty'],0,1);
				$pdf->Ln(30); 
				
				//miejsce na podpisy
				$pdf->SetX(125);
				$pdf->SetFont('Trebuchet','',12);
				$pdf->Cell(72,7,$faktura['os_upowaz_do_wyst_faktury'],0,0,'C');
				$pdf->Ln(7); 
				$pdf->SetFont('Trebuchet','',10);
				$pdf->Cell(72,7,'Osoba upoważniona do odbioru faktury.','T',0);
				$pdf->SetX(127);
				$pdf->Cell(72,7,'Osoba upoważniona do wystawienia faktury.','T',0);
		
				//nowa strona
				//$pdf->AddPage();
				//uwagi
				$pdf->Ln(30);				
				$pdf->SetFont('Trebuchet','',14);
				$pdf->Cell(0,5,'Uwagi:',0,1);
				$pdf->Ln(10);
				$pdf->SetFont('Trebuchet','',12);
				$pdf->MultiCell(0,5,$faktura['uwagi'],0,'L');
				 
			
				$pdf->Output();
				
				}
			else
			{
				//redirect('/admin/logout','location');
				//return false;
				echo 'Brak oplat za ten miesiac';	
			}		
		}
		else
		{
			//redirect('/admin/','location');
			//return false;
			echo 'Brak autoryzacji';		
		}	
	}
	
	//pdf dla ksiegowej i c#
	function faktura_pdf_ksiegowosc_sem($id=null,$type=null,$key=null)
	{ 
		//$key  - zmienna zabezpieczajaca dla programu w c#
		$key_org = 'a76i43x2';
		
		if(!empty($id) and !empty($type))
		{		
			if((isset($this->session->userdata['user_ksiegowosc_zalogowany']) and isset($this->session->userdata['ksiegowosc_id'])) or $key==$key_org)
			{					
				$faktura_typ = null;
				$faktura_typ_skrot = null;
				
				if($type=='pf')
				{
					$dane = $this->baza_payments->get_facture_sem_proforam_to_pdf_by_id($id);
					$faktura_typ = 'Proforma';
					$faktura_typ_skrot = 'FP';
				}
				elseif($type=='fv')
				{
					$dane = $this->baza_payments->get_facture_sem_fv_to_pdf_by_id($id);
					$faktura_typ = 'VAT';
					$faktura_typ_skrot = 'FV';
				}
				else
				{
					echo 'Nieprawidłowy parametr';
					exit;
				}

				//print_r($dane);
				//$dane=null;
				
				if($dane!=null)	
				{									
					require_once('files/faktura_template.php');
					require_once('files/functions.php');				
					$faktura = $dane[0];
					
					$pdf=new PDF();		
					$pdf->SetUTF8(true); 
					$pdf->AliasNbPages();
					$pdf->AddPage();
					$pdf->SetDisplayMode('real'); 
					$pdf->AddFont('Trebuchet','','trebucpl.php');
					$pdf->SetFont('Trebuchet','',12);
					   
					//informacje o numerze faktury
					$faktura_info = "Faktura ".$faktura_typ."\nnr: ".$faktura_typ_skrot." ".$faktura['nr']."/SEM/".$faktura['month']."/".$faktura['year']."\nKopia";
					$pdf->MultiCell(90,7,$faktura_info,1,'L');
					
					//nazwy informacji o datach i sposobie przelewu
					$pdf->SetFont('Trebuchet','',10);
					$pdf->SetXY(115, 20);
					$payment_info = "Miejsce wystawienia:\nData wystawienia:\nData sprzedaży:\nSposób zapłaty:\nTermin płatności:";
					$pdf->MultiCell(37,5,$payment_info,0,'L');
			 
					//informacje o datach i sposobie przelewu
					$pdf->SetFont('Trebuchet','',10);
					$pdf->SetXY(152, 20);
					$payment_info_data = "".$faktura['miejsce_wystawienia']."\n".$faktura['data_wystawienia']."\n".$faktura['data_sprzedazy']."\n".$faktura['sposob_zaplaty']."\n".$faktura['termin_platnosci']."";
					$pdf->MultiCell(35,5,$payment_info_data,0,'L');		
					$pdf->Ln(5);
					   
					//informacje o sprzedawcy    
					$pdf->SetFont('Trebuchet','',14);
					$pdf->Cell(0,5,'Sprzedawca:',0,1);
					$pdf->SetFont('Trebuchet','',10);
					$seller_info = $faktura['sprzedawca'];
					$pdf->MultiCell(90,5,$seller_info,0,'L');
					
			        //informacje o nabywcy  
			        $pdf->SetXY(115, 50); 
					$pdf->SetFont('Trebuchet','',14);
					$pdf->Cell(0,5,'Nabywca:',0,1);
					$pdf->SetXY(115, 55);
					$pdf->SetFont('Trebuchet','',10);
			        $buyer_info = $faktura['nabywca'];
					$pdf->MultiCell(85,5,$buyer_info,0,'L');
					
					$pdf->Ln(20);
					
					//tabela z naliczonymi platnosciami
					$table_header = array("Lp.","Nazwa usługi","J.m","Ilość","Cena jedn.","Wartość netto","Stawka VAT","Kwota VAT","Wartość brutto");
					//$line = "1;Opłata za pozycjonowanie;szt;1;1000,00;1000,00;22%;220,00;1220,00";
					//$dane_platnosci_faktury[]=explode(';',chop($line));
	
					$naliczone_uslugi = unserialize($faktura['naliczone_uslugi']);
									
					//tabela z 9 kolumnami 
					$pdf->SetWidths(array(8,58,8,10,20,25,14,20,26));
					//ustawia pozycje tekstu w kazdej kolumnie
					$pdf->SetAligns(array('C','L','C','C','R','R','C','R','R'));
					//header tabeli
					$pdf->Row($table_header);								
					
					foreach($naliczone_uslugi as $u)
					{
						$pdf->Row(array($u[0],$u[1],$u[2],$u[3],$u[4],$u[5],$u[6],$u[7],$u[8]));
					}
													
					//dopelnienie groszy jezeli po przecinku jest 1 miejsce zamiast 2
					$brutto_tmp  =  d_gr($faktura['brutto']);
					
					//do zaplaty
					$pdf->Ln(10); 
					$pdf->SetFont('Trebuchet','',14);				
					$pdf->Cell(0,5,'Do zapłaty: '.$brutto_tmp[0].'.'.$brutto_tmp[1].' zł',0,1);
					$pdf->Ln(1);
					$pdf->SetFont('Trebuchet','',12);
					$pdf->Cell(0,5,'Słownie: '.$faktura['slownie_do_zaplaty'],0,1);
					$pdf->Ln(30); 
					
					//miejsce na podpisy
					$pdf->SetX(125);
					$pdf->SetFont('Trebuchet','',12);
					$pdf->Cell(72,7,$faktura['os_upowaz_do_wyst_faktury'],0,0,'C');
					$pdf->Ln(7); 
					$pdf->SetFont('Trebuchet','',10);
					$pdf->Cell(72,7,'Osoba upoważniona do odbioru faktury.','T',0);
					$pdf->SetX(127);
					$pdf->Cell(72,7,'Osoba upoważniona do wystawienia faktury.','T',0);
			
					//nowa strona
					//$pdf->AddPage();
					//uwagi
					$pdf->Ln(30);				
					$pdf->SetFont('Trebuchet','',14);
					$pdf->Cell(0,5,'Uwagi:',0,1);
					$pdf->Ln(10);
					$pdf->SetFont('Trebuchet','',12);
					$pdf->MultiCell(0,5,$faktura['uwagi'],0,'L');
					 
				
					$pdf->Output();
					
					}
				else
				{
					//redirect('/admin/logout','location');
					//return false;
					echo 'Brak oplat za ten miesiac';	
				}		
			}
			else
			{
				//redirect('/admin/','location');
				//return false;
				echo 'Brak autoryzacji';		
			}
		}	
	}
	
	//	pdf dla afilianta
	function faktura_pdf_afiliant($id=null)
	{ 
		if(isset($this->session->userdata['login']) and isset($this->session->userdata['id']))
		{				
			$dane = $this->baza_payments->get_afilint_facture($this->session->userdata['id'],$id);			
			
			if($dane!=null)	
			{									
				require_once('files/faktura_template_afiliant.php');
				require_once('files/functions.php');				
				$faktura = $dane[0];
				
				$pdf=new PDF();		
				$pdf->SetUTF8(true); 
				$pdf->AliasNbPages();
				$pdf->AddPage();
				$pdf->SetDisplayMode('real'); 
				$pdf->AddFont('Trebuchet','','trebucpl.php');
				$pdf->SetFont('Trebuchet','',12);
				
				//numer faktury wystawianej online
				$faktura_info = '';
				
				if($faktura['typ_dostarczenia']=='online')
				{
					if(empty($faktura['nr']))
						$faktura_info = "Faktura VAT\nnr: FV ".$faktura['numer_wlasny']."\nOryginał / Kopia";
					else
						$faktura_info = "Faktura VAT\nnr: FV ".$faktura['nr']."\nOryginał / Kopia";
				}
								
				//jezeli osoba sama przesyla rachunek ma mozliwosc zobaczenia przykladowego rachunku				
				if($faktura['typ_dostarczenia']!='online')
				{					
					$faktura_info = "Faktura VAT\nnr: FV xxxx \nOryginał / Kopia";
					
					$pdf->SetFont('Trebuchet','',16);
					$pdf->Cell(0,5,"UWAGA!!",0,1);
					$pdf->SetFont('Trebuchet','',12);
					$pdf->Cell(0,5,"To jest przykładowy wzór faktury, która powinna do nas dotrzeć pocztą lub kurierem.",0,1);
					$pdf->Cell(0,5,"Podana kwota i dane Networds są poprawne",0,1);		
					$pdf->Ln(5);								
					
					//informacje o numerze faktury
				
					$pdf->MultiCell(90,7,$faktura_info,1,'L');
					
					//nazwy informacji o datach i sposobie przelewu
					$pdf->SetFont('Trebuchet','',10);
					$pdf->SetXY(115, 40);
					$payment_info = "Data wystawienia:\nData sprzedaży:\nSposób zapłaty:\nTermin płatności:";
					$pdf->MultiCell(37,5,$payment_info,0,'L');
			 
					//informacje o datach i sposobie przelewu
					$pdf->SetFont('Trebuchet','',10);
					$pdf->SetXY(152, 40);
					$payment_info_data = "".$faktura['data_wystawienia']."\n".substr($faktura['data_sprzedazy'],0,7)."\n".$faktura['sposob_zaplaty']."\n".$faktura['termin_platnosci']."";
					$pdf->MultiCell(40,5,$payment_info_data,0,'L');		
					$pdf->Ln(5);
					
					//informacje o sprzedawcy    
					$pdf->SetFont('Trebuchet','',14);
					$pdf->Cell(0,5,'Sprzedawca:',0,1);
					$pdf->SetFont('Trebuchet','',10);
					$seller_info = $faktura['sprzedawca'];
					$pdf->MultiCell(90,5,$seller_info,0,'L');
					
			        //informacje o nabywcy  
			        $pdf->SetXY(115, 70); 
					$pdf->SetFont('Trebuchet','',14);
					$pdf->Cell(0,5,'Nabywca:',0,1);
					$pdf->SetXY(115, 75);
					$pdf->SetFont('Trebuchet','',10);
			        $buyer_info = $faktura['nabywca'];
					$pdf->MultiCell(90,5,$buyer_info,0,'L');
				}
				else
				{					
					//informacje o numerze faktury
				
					$pdf->MultiCell(90,7,$faktura_info,1,'L');
					
					//nazwy informacji o datach i sposobie przelewu
					$pdf->SetFont('Trebuchet','',10);
					$pdf->SetXY(115, 20);
					$payment_info = "Data wystawienia:\nData sprzedaży:\nSposób zapłaty:\nTermin płatności:";
					$pdf->MultiCell(37,5,$payment_info,0,'L');
			 
					//informacje o datach i sposobie przelewu
					$pdf->SetFont('Trebuchet','',10);
					$pdf->SetXY(152, 20);
					$payment_info_data = "".$faktura['data_wystawienia']."\n".substr($faktura['data_sprzedazy'],0,7)."\n".$faktura['sposob_zaplaty']."\n".$faktura['termin_platnosci']."";
					$pdf->MultiCell(35,5,$payment_info_data,0,'L');		
					$pdf->Ln(5);
					
					//informacje o sprzedawcy    
					$pdf->SetFont('Trebuchet','',14);
					$pdf->Cell(0,5,'Sprzedawca:',0,1);
					$pdf->SetFont('Trebuchet','',10);
					$seller_info = $faktura['sprzedawca'];
					$pdf->MultiCell(90,5,$seller_info,0,'L');
					
			        //informacje o nabywcy  
			        $pdf->SetXY(115, 50); 
					$pdf->SetFont('Trebuchet','',14);
					$pdf->Cell(0,5,'Nabywca:',0,1);
					$pdf->SetXY(115, 55);
					$pdf->SetFont('Trebuchet','',10);
			        $buyer_info = $faktura['nabywca'];
					$pdf->MultiCell(85,5,$buyer_info,0,'L');
				}	
				
				$pdf->Ln(20);
				
				//tabela z naliczonymi platnosciami
				$table_header = array("Lp.","Nazwa usługi","J.m","Ilość","Cena jedn.","Wartość netto","Stawka VAT","Kwota VAT","Wartość brutto");
				//$line = "1;Opłata za pozycjonowanie;szt;1;1000,00;1000,00;22%;220,00;1220,00";
				//$dane_platnosci_faktury[]=explode(';',chop($line));

				$naliczone_uslugi = unserialize($faktura['naliczone_uslugi']);
								
				//tabela z 9 kolumnami 
				$pdf->SetWidths(array(8,58,8,10,20,25,14,20,26));
				//ustawia pozycje tekstu w kazdej kolumnie
				$pdf->SetAligns(array('C','L','C','C','R','R','C','R','R'));
				//header tabeli
				$pdf->Row($table_header);								
				
				foreach($naliczone_uslugi as $u)
				{
					$pdf->Row(array($u[0],$u[1],$u[2],$u[3],$u[4],$u[5],$u[6],$u[7],$u[8]));
				}
												
				//dopelnienie groszy jezeli po przecinku jest 1 miejsce zamiast 2
				$brutto_tmp  =  d_gr($faktura['brutto']);
				
				//do zaplaty
				$pdf->Ln(10); 
				$pdf->SetFont('Trebuchet','',14);				
				$pdf->Cell(0,5,'Do zapłaty: '.$brutto_tmp[0].'.'.$brutto_tmp[1].' zł',0,1);
				$pdf->Ln(1);
				$pdf->SetFont('Trebuchet','',12);
				$pdf->Cell(0,5,'Słownie: '.$faktura['slownie_do_zaplaty'],0,1);
				$pdf->Ln(30); 
				
				//miejsce na podpisy
				$pdf->SetX(125);
				$pdf->SetFont('Trebuchet','',12);
				$pdf->Cell(72,7,$faktura['os_upowaz_do_wyst_faktury'],0,0,'C');
				$pdf->Ln(7); 
				$pdf->SetFont('Trebuchet','',10);
				$pdf->Cell(72,7,'Osoba upoważniona do odbioru faktury.','T',0);
				$pdf->SetX(127);
				$pdf->Cell(72,7,'Osoba upoważniona do wystawienia faktury.','T',0);
		
				//nowa strona
				//$pdf->AddPage();
				//uwagi
				$pdf->Ln(30);				
				$pdf->SetFont('Trebuchet','',14);
				$pdf->Cell(0,5,'Uwagi:',0,1);
				$pdf->Ln(10);
				$pdf->SetFont('Trebuchet','',12);
				$pdf->MultiCell(0,5,$faktura['uwagi'],0,'L');
				 
			
				$pdf->Output();
				
				}
			else
			{
				//redirect('/admin/logout','location');
				//return false;
				echo 'Brak oplat za ten miesiac';	
			}		
		}
		else
		{
			//redirect('/admin/','location');
			//return false;
			echo 'Brak autoryzacji';		
		}	
	}
	
	function rachunek_pdf_afiliant($id=null)
	{ 
		if(isset($this->session->userdata['login']) and isset($this->session->userdata['id']))
		{				
			$dane = $this->baza_payments->get_afilint_facture($this->session->userdata['id'],$id);			
			
			if($dane!=null)	
			{									
				require_once('files/faktura_template_afiliant.php');
				require_once('files/functions.php');				
				$faktura = $dane[0];				
				
				$pdf=new PDF();		
				$pdf->SetUTF8(true); 
				$pdf->AliasNbPages();
				$pdf->AddPage();
				$pdf->SetDisplayMode('real'); 
				$pdf->AddFont('Trebuchet','','trebucpl.php');
				$pdf->SetFont('Trebuchet','',12);			
				
				//jezeli osoba sama przesyla rachunek ma mozliwosc zobaczenia przykladowego rachunku
				$rachunek = "Raport wypłaty pieniędzy nr: ".$faktura['nr']."";
				if($faktura['typ_dostarczenia']!='online')
				{					
					//$rachunek = "Raport wypłaty nr: xxxx";
					
					$pdf->SetFont('Trebuchet','',16);
					$pdf->Cell(0,5,"UWAGA!!",0,1);
					$pdf->SetFont('Trebuchet','',12);
					$pdf->Cell(0,5,"To jest tylko informacja.",0,1);
					$pdf->Cell(0,5,"Podana kwota, data zgłoszenia wypłaty pieniędzy, data wypłaty pieniędzy i dane Networds są poprawne",0,1);
					$pdf->Cell(0,5,"Networds są poprawne",0,1);										
					
					//informacje o datach i sposobie przelewu
					$pdf->SetFont('Trebuchet','',10);
					$pdf->SetXY(122, 60);
					$payment_info_data = "Data zgłoszenia wypłaty pieniędzy: ".$faktura['data_wystawienia']."\n";
					$pdf->MultiCell(95,5,$payment_info_data,0,'L');		
					$pdf->Ln(5);
					
					$pdf->SetFont('Trebuchet','',10);
					$pdf->SetXY(122, 65);
					$payment_info_data = "Data wypłaty pieniędzy: ".$faktura['data_sprzedazy']."\n";
					$pdf->MultiCell(95,5,$payment_info_data,0,'L');		
					$pdf->Ln(5);
					   
					//informacje o sprzedawcy    
					$pdf->SetXY(10, 60);
					$pdf->SetFont('Trebuchet','',12);
					$seller_info = $faktura['sprzedawca'];
					$pdf->MultiCell(110,5,$seller_info,0,'L');
					$pdf->Ln(20);
				}
				else
				{					
					//informacje o datach i sposobie przelewu
					$pdf->SetFont('Trebuchet','',10);
					$pdf->SetXY(152, 20);
					$payment_info_data = $faktura['miejsce_wystawienia'].", ".$faktura['data_wystawienia']."\n";
					$pdf->MultiCell(35,5,$payment_info_data,0,'L');		
					$pdf->Ln(5);
					   
					//informacje o sprzedawcy    
					$pdf->SetXY(10, 20);
					$pdf->SetFont('Trebuchet','',12);
					$seller_info = $faktura['sprzedawca'];
					$pdf->MultiCell(110,5,$seller_info,0,'L');
					$pdf->Ln(20);					
				}	
				
				//informacje o numerze rachunku
				$pdf->SetFont('Trebuchet','',18);
				$faktura_info = $rachunek;
				$pdf->MultiCell(190,7,$faktura_info,0,'C');
				$pdf->Ln(20);
				
		        //informacje o nabywcy  
				$pdf->SetFont('Trebuchet','',14);
				$pdf->Cell(0,5,'Dla:',0,1);			
				$pdf->SetFont('Trebuchet','',12);
		        $buyer_info = $faktura['nabywca'];
				$pdf->MultiCell(85,5,$buyer_info,0,'L');
				
				$pdf->Ln(10);
												
				//dopelnienie groszy jezeli po przecinku jest 1 miejsce zamiast 2
				$brutto_tmp  =  d_gr($faktura['brutto']);
				
				//tytulem
				$pdf->Ln(10); 
				$pdf->SetFont('Trebuchet','',12);				
				$pdf->Cell(0,5,'Za dochód z afiliacji zgodnie z postanowieniami Regulaminu',0,1);
				$pdf->Ln(1);
				
				//do zaplaty
				$pdf->Ln(10); 
				$pdf->SetFont('Trebuchet','',14);				
				$pdf->Cell(0,5,'Na kwotę brutto: '.$brutto_tmp[0].'.'.$brutto_tmp[1].' zł',0,1);
				$pdf->Ln(5);
				$pdf->SetFont('Trebuchet','',12);
				$pdf->Cell(0,5,'Słownie: '.$faktura['slownie_do_zaplaty'],0,1);
				$pdf->Ln(5);
				 
				//sposob zaplaty
				$pdf->SetFont('Trebuchet','',12);
				$pdf->Cell(0,5,'Sposób płatności: Przelew bankowy na rachunek '.$faktura['nr_konta'],0,1);
				$pdf->Ln(5);
			
				$pdf->Output();
				
				}
			else
			{
				//redirect('/admin/logout','location');
				//return false;
				echo 'Brak oplat za ten miesiac';	
			}		
		}
		else
		{
			//redirect('/admin/','location');
			//return false;
			echo 'Brak autoryzacji';		
		}	
	}
	
//	pdf dla afilianta
	function faktura_ksiegowosc_pdf_afiliant($id=null,$afiliant_id=null)
	{ 
		if(isset($this->session->userdata['user_ksiegowosc_zalogowany']) and isset($this->session->userdata['ksiegowosc_id']))
		{				
			$dane = $this->baza_payments->get_afilint_facture($afiliant_id,$id);			
			
			if($dane!=null)	
			{									
				require_once('files/faktura_template_afiliant.php');
				require_once('files/functions.php');				
				$faktura = $dane[0];
				
				$pdf=new PDF();		
				$pdf->SetUTF8(true); 
				$pdf->AliasNbPages();
				$pdf->AddPage();
				$pdf->SetDisplayMode('real'); 
				$pdf->AddFont('Trebuchet','','trebucpl.php');
				$pdf->SetFont('Trebuchet','',12);
				
				//	numer faktury wystawianej online
				$faktura_info = '';
				
				if($faktura['typ_dostarczenia']=='online')
				{
					if(empty($faktura['nr']))
						$faktura_info = "Faktura VAT\nnr: FV ".$faktura['numer_wlasny']."\nOryginał / Kopia";
					else
						$faktura_info = "Faktura VAT\nnr: FV ".$faktura['nr']."\nOryginał / Kopia";
				}
				
				//jezeli osoba sama przesyla rachunek ma mozliwosc zobaczenia przykladowego rachunku				
				if($faktura['typ_dostarczenia']!='online')
				{					
					$faktura_info = "Faktura VAT\nnr: FV xxxx \nOryginał / Kopia";
					
					$pdf->SetFont('Trebuchet','',16);
					$pdf->Cell(0,5,"UWAGA!!",0,1);
					$pdf->SetFont('Trebuchet','',12);
					$pdf->Cell(0,5,"To jest przykładowy wzór faktury, która powinna do nas dotrzeć pocztą lub kurierem.",0,1);
					$pdf->Cell(0,5,"Podana kwota i dane Networds są poprawne",0,1);		
					$pdf->Ln(5);								
					
					//informacje o numerze faktury
				
					$pdf->MultiCell(90,7,$faktura_info,1,'L');
					
					//nazwy informacji o datach i sposobie przelewu
					$pdf->SetFont('Trebuchet','',10);
					$pdf->SetXY(115, 40);
					$payment_info = "Data wystawienia:\nData sprzedaży:\nSposób zapłaty:\nTermin płatności:";
					$pdf->MultiCell(37,5,$payment_info,0,'L');
			 
					//informacje o datach i sposobie przelewu
					$pdf->SetFont('Trebuchet','',10);
					$pdf->SetXY(152, 40);
					$payment_info_data = "".$faktura['data_wystawienia']."\n".substr($faktura['data_sprzedazy'],0,7)."\n".$faktura['sposob_zaplaty']."\n".$faktura['termin_platnosci']."";
					$pdf->MultiCell(40,5,$payment_info_data,0,'L');		
					$pdf->Ln(5);
					
					//informacje o sprzedawcy    
					$pdf->SetFont('Trebuchet','',14);
					$pdf->Cell(0,5,'Sprzedawca:',0,1);
					$pdf->SetFont('Trebuchet','',10);
					$seller_info = $faktura['sprzedawca'];
					$pdf->MultiCell(90,5,$seller_info,0,'L');
					
			        //informacje o nabywcy  
			        $pdf->SetXY(115, 70); 
					$pdf->SetFont('Trebuchet','',14);
					$pdf->Cell(0,5,'Nabywca:',0,1);
					$pdf->SetXY(115, 75);
					$pdf->SetFont('Trebuchet','',10);
			        $buyer_info = $faktura['nabywca'];
					$pdf->MultiCell(90,5,$buyer_info,0,'L');
				}
				else
				{					
					//informacje o numerze faktury
				
					$pdf->MultiCell(90,7,$faktura_info,1,'L');
					
					//nazwy informacji o datach i sposobie przelewu
					$pdf->SetFont('Trebuchet','',10);
					$pdf->SetXY(115, 20);
					$payment_info = "Data wystawienia:\nData sprzedaży:\nSposób zapłaty:\nTermin płatności:";
					$pdf->MultiCell(37,5,$payment_info,0,'L');
			 
					//informacje o datach i sposobie przelewu
					$pdf->SetFont('Trebuchet','',10);
					$pdf->SetXY(152, 20);
					$payment_info_data = "".$faktura['data_wystawienia']."\n".substr($faktura['data_sprzedazy'],0,7)."\n".$faktura['sposob_zaplaty']."\n".$faktura['termin_platnosci']."";
					$pdf->MultiCell(35,5,$payment_info_data,0,'L');		
					$pdf->Ln(5);
					
					//informacje o sprzedawcy    
					$pdf->SetFont('Trebuchet','',14);
					$pdf->Cell(0,5,'Sprzedawca:',0,1);
					$pdf->SetFont('Trebuchet','',10);
					$seller_info = $faktura['sprzedawca'];
					$pdf->MultiCell(90,5,$seller_info,0,'L');
					
			        //informacje o nabywcy  
			        $pdf->SetXY(115, 50); 
					$pdf->SetFont('Trebuchet','',14);
					$pdf->Cell(0,5,'Nabywca:',0,1);
					$pdf->SetXY(115, 55);
					$pdf->SetFont('Trebuchet','',10);
			        $buyer_info = $faktura['nabywca'];
					$pdf->MultiCell(85,5,$buyer_info,0,'L');
				}	
				
				$pdf->Ln(20);
				
				//tabela z naliczonymi platnosciami
				$table_header = array("Lp.","Nazwa usługi","J.m","Ilość","Cena jedn.","Wartość netto","Stawka VAT","Kwota VAT","Wartość brutto");
				//$line = "1;Opłata za pozycjonowanie;szt;1;1000,00;1000,00;22%;220,00;1220,00";
				//$dane_platnosci_faktury[]=explode(';',chop($line));

				$naliczone_uslugi = unserialize($faktura['naliczone_uslugi']);
								
				//tabela z 9 kolumnami 
				$pdf->SetWidths(array(8,58,8,10,20,25,14,20,26));
				//ustawia pozycje tekstu w kazdej kolumnie
				$pdf->SetAligns(array('C','L','C','C','R','R','C','R','R'));
				//header tabeli
				$pdf->Row($table_header);								
				
				foreach($naliczone_uslugi as $u)
				{
					$pdf->Row(array($u[0],$u[1],$u[2],$u[3],$u[4],$u[5],$u[6],$u[7],$u[8]));
				}
												
				//dopelnienie groszy jezeli po przecinku jest 1 miejsce zamiast 2
				$brutto_tmp  =  d_gr($faktura['brutto']);
				
				//do zaplaty
				$pdf->Ln(10); 
				$pdf->SetFont('Trebuchet','',14);				
				$pdf->Cell(0,5,'Do zapłaty: '.$brutto_tmp[0].'.'.$brutto_tmp[1].' zł',0,1);
				$pdf->Ln(1);
				$pdf->SetFont('Trebuchet','',12);
				$pdf->Cell(0,5,'Słownie: '.$faktura['slownie_do_zaplaty'],0,1);
				$pdf->Ln(30); 
				
				//miejsce na podpisy
				$pdf->SetX(125);
				$pdf->SetFont('Trebuchet','',12);
				$pdf->Cell(72,7,$faktura['os_upowaz_do_wyst_faktury'],0,0,'C');
				$pdf->Ln(7); 
				$pdf->SetFont('Trebuchet','',10);
				$pdf->Cell(72,7,'Osoba upoważniona do odbioru faktury.','T',0);
				$pdf->SetX(127);
				$pdf->Cell(72,7,'Osoba upoważniona do wystawienia faktury.','T',0);
		
				//nowa strona
				//$pdf->AddPage();
				//uwagi
				$pdf->Ln(30);				
				$pdf->SetFont('Trebuchet','',14);
				$pdf->Cell(0,5,'Uwagi:',0,1);
				$pdf->Ln(10);
				$pdf->SetFont('Trebuchet','',12);
				$pdf->MultiCell(0,5,$faktura['uwagi'],0,'L');
				 
			
				$pdf->Output();
				
				}
			else
			{
				//redirect('/admin/logout','location');
				//return false;
				echo 'Brak oplat za ten miesiac';	
			}		
		}
		else
		{
			//redirect('/admin/','location');
			//return false;
			echo 'Brak autoryzacji';		
		}	
	}
	
	function rachunek_ksiegowosc_pdf_afiliant($id=null,$afiliant_id=null)
	{ 
		if(isset($this->session->userdata['user_ksiegowosc_zalogowany']) and isset($this->session->userdata['ksiegowosc_id']))
		{				
			$dane = $this->baza_payments->get_afilint_facture($afiliant_id,$id);			
			
			if($dane!=null)	
			{									
				require_once('files/faktura_template_afiliant.php');
				require_once('files/functions.php');				
				$faktura = $dane[0];
				
				$pdf=new PDF();		
				$pdf->SetUTF8(true); 
				$pdf->AliasNbPages();
				$pdf->AddPage();
				$pdf->SetDisplayMode('real'); 
				$pdf->AddFont('Trebuchet','','trebucpl.php');
				$pdf->SetFont('Trebuchet','',12);			
				
				//jezeli osoba sama przesyla rachunek ma mozliwosc zobaczenia przykladowego rachunku
				$rachunek = "Raport wypłaty pieniędzy nr: ".$faktura['nr']."";
				if($faktura['typ_dostarczenia']!='online')
				{					
					//$rachunek = "Rachunek nr: xxxx";
					
					$pdf->SetFont('Trebuchet','',16);
					$pdf->Cell(0,5,"UWAGA!!",0,1);
					$pdf->SetFont('Trebuchet','',12);
					$pdf->Cell(0,5,"To jest tylko informacja.",0,1);
					$pdf->Cell(0,5,"Podana kwota, data zgłoszenia wypłaty pieniędzy, data wypłaty pieniędzy i dane",0,1);
					$pdf->Cell(0,5,"Networds są poprawne",0,1);										
					
					//informacje o datach i sposobie przelewu
					$pdf->SetFont('Trebuchet','',10);
					$pdf->SetXY(122, 60);
					$payment_info_data = "Data zgłoszenia wypłaty pieniędzy: ".$faktura['data_wystawienia']."\n";
					$pdf->MultiCell(95,5,$payment_info_data,0,'L');		
					$pdf->Ln(5);
					
					$pdf->SetFont('Trebuchet','',10);
					$pdf->SetXY(122, 65);
					$payment_info_data = "Data wypłaty pieniędzy: ".$faktura['data_sprzedazy']."\n";
					$pdf->MultiCell(95,5,$payment_info_data,0,'L');		
					$pdf->Ln(5);
					   
					//informacje o sprzedawcy    
					$pdf->SetXY(10, 60);
					$pdf->SetFont('Trebuchet','',12);
					$seller_info = $faktura['sprzedawca'];
					$pdf->MultiCell(110,5,$seller_info,0,'L');
					$pdf->Ln(20);
				}
				else
				{					
					//informacje o datach i sposobie przelewu
					$pdf->SetFont('Trebuchet','',10);
					$pdf->SetXY(152, 20);
					$payment_info_data = "Data zgłoszenia wypłaty: ".$faktura['data_wystawienia']."\n";
					$pdf->MultiCell(35,5,$payment_info_data,0,'L');		
					$pdf->Ln(5);
					   
					//informacje o sprzedawcy    
					$pdf->SetXY(10, 20);
					$pdf->SetFont('Trebuchet','',12);
					$seller_info = $faktura['sprzedawca'];
					$pdf->MultiCell(110,5,$seller_info,0,'L');
					$pdf->Ln(20);					
				}	
				
				//informacje o numerze rachunku
				$pdf->SetFont('Trebuchet','',18);
				$faktura_info = $rachunek;
				$pdf->MultiCell(190,7,$faktura_info,0,'C');
				$pdf->Ln(20);
				
		        //informacje o nabywcy  
				$pdf->SetFont('Trebuchet','',14);
				$pdf->Cell(0,5,'Dla:',0,1);			
				$pdf->SetFont('Trebuchet','',12);
		        $buyer_info = $faktura['nabywca'];
				$pdf->MultiCell(85,5,$buyer_info,0,'L');
				
				$pdf->Ln(10);
												
				//dopelnienie groszy jezeli po przecinku jest 1 miejsce zamiast 2
				$brutto_tmp  =  d_gr($faktura['brutto']);
				
				//tytulem
				$pdf->Ln(10); 
				$pdf->SetFont('Trebuchet','',12);				
				$pdf->Cell(0,5,'Za dochód z afiliacji zgodnie z postanowieniami Regulaminu',0,1);
				$pdf->Ln(1);
				
				//do zaplaty
				$pdf->Ln(10); 
				$pdf->SetFont('Trebuchet','',14);				
				$pdf->Cell(0,5,'Na kwotę brutto: '.$brutto_tmp[0].'.'.$brutto_tmp[1].' zł',0,1);
				$pdf->Ln(5);
				$pdf->SetFont('Trebuchet','',12);
				$pdf->Cell(0,5,'Słownie: '.$faktura['slownie_do_zaplaty'],0,1);
				$pdf->Ln(5);
				 
				//sposob zaplaty
				$pdf->SetFont('Trebuchet','',12);
				$pdf->Cell(0,5,'Sposób płatności: Przelew bankowy na rachunek '.$faktura['nr_konta'],0,1);
				$pdf->Ln(5);
			
				$pdf->Output();
				
				}
			else
			{
				//redirect('/admin/logout','location');
				//return false;
				echo 'Brak oplat za ten miesiac';	
			}		
		}
		else
		{
			//redirect('/admin/','location');
			//return false;
			echo 'Brak autoryzacji';		
		}	
	}
}
?>